<?php
require_once('class/class.php');
$accesos = ['administradorG', 'administradorS', 'secretaria', 'cajero', 'vendedor'];
validarAccesos($accesos) or die();

$j = new Login();
$reg = $j->ProductosPorId();

$opcion      = $_GET['opcion'];
$mostrar     = $_GET['mostrar'] ?? '';
$tipo_codigo = strtoupper($_GET['tipo_codigo'] ?? 'CODE128');
$cantidad    = intval($_GET['cantidad'] ?? 1);
$ancho_mm    = floatval($_GET['ancho'] ?? 55);
$alto_mm     = floatval($_GET['alto'] ?? 44);

$formatos = [
    'CODE128' => 'CODE128',
    'EAN13'   => 'EAN13',
    'UPCA'   => 'UPC'
];

if (!array_key_exists($tipo_codigo, $formatos)) {
    die("Formato de código de barras no soportado.");
}

$js_format = $formatos[$tipo_codigo];

// Validación de la longitud del código de barras
$codigobarra = ($reg[0]["codigobarra"] == "" ? $reg[0]["codproducto"] : $reg[0]["codigobarra"]);
$longitud_codigo = strlen($codigobarra);
$mensaje_error = "";

if ($tipo_codigo == 'EAN13' && $longitud_codigo != 13) {
    $mensaje_error = "El código de barras debe tener 13 dígitos para el formato EAN13.";
} elseif ($tipo_codigo == 'UPCA' && $longitud_codigo != 12) {
    $mensaje_error = "El código de barras debe tener 12 dígitos para el formato UPCA.";
}

/*if ($mensaje_error != "") {
    echo "<script>alert('$mensaje_error'); window.location.href = window.location.href;</script>";
    die(); // Detiene la ejecución del script después de mostrar el mensaje
}*/
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="assets/images/favicon.png">
    <title></title>
    <!--<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">-->
    <script src="assets/script/JsBarcode.all.min.js"></script>
    <!--<script src="assets/script/JsBarcode.ean-upc.min.js"></script>
    <script src="assets/script/JsBarcode.code128.min.js"></script>-->
    <style>
        @media print {
            body {
                margin: 0;
                padding: 0;
            }
            .etiqueta {
                page-break-inside: avoid;
            }
        }

        body {
            background: #f8f9fa;
            padding: 10px;
            font-family: 'Segoe UI', sans-serif;
        }

        .contenedor-etiquetas {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 6px;
        }

        .etiqueta {
            width: <?= $ancho_mm ?>mm;
            height: <?= $alto_mm ?>mm;
            padding: 3mm;
            border: 1px dashed #030303;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            align-items: center;
            background: #fff;
        }

        .nombre {
            font-size: 9pt;
            text-align: center;
            font-weight: bold;
            /*font-weight: 600;*/
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            width: 100%;
            min-height: 6mm;
        }

        .nombre666 {
            font-size: 9pt;
            text-align: center;
            font-weight: bold;
            line-height: 1.1;
            max-height: 2.4em;
            overflow: hidden;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            white-space: normal;
            word-break: break-word;
        }

        .barcode-container {
            width: 100%;
            height: 15mm;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .precio {
            font-size: 13pt;
            font-weight: bold;
            margin-top: 1mm;
        }

        svg {
            width: 100%;
            height: 100%;
        }

        .mensaje-error {
            color: red;
            font-weight: bold;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>

    <?php if ($mensaje_error != ""): ?>
        <div class="mensaje-error"><?= htmlspecialchars($mensaje_error) ?></div>
    <?php endif; ?>

<main class="contenedor-etiquetas">
<?php for ($i = 0; $i < $cantidad; $i++): ?>
    <section class="etiqueta">
        <?php if (!empty($reg[0]['producto'])): ?>
            <div class="nombre"><?= htmlspecialchars($reg[0]['producto']); ?></div>
        <?php endif; ?>
        <div class="barcode-container">
            <svg id="barcode<?= $i ?>"></svg>
        </div>
        <?php if($mostrar == '1'){ ?><div class="precio"><?= $reg[0]['simbolo'].' '.number_format($reg[0]['precioxpublico'], 2, '.', ',') ?></div><?php } ?>
    </section>
<?php endfor; ?>
</main>

<script>
const opcion = "<?= $opcion ?>";
const formato = "<?= $js_format ?>";
const codigo  = "<?= $codigobarra = ($reg[0]["codigobarra"] == "" ? $reg[0]["codproducto"] : $reg[0]["codigobarra"]); ?>";
//const codigo  = "5901234123457";

for (let i = 0; i < <?= $cantidad ?>; i++){
   
    JsBarcode("#barcode" + i, codigo, {
        format: formato,
        flat: false,
        lineColor: "#000",
        width: 1.2,
        height: 40,
        fontSize: 10,
        font: "Segoe UI",
        displayValue: true,
        margin: 0
    }); 
}

if(opcion == 'pdf'){
    window.onload = () => {
    setTimeout(() => {
        window.print();
            //alert('La ventana de impresión se ha abierto. Después de imprimir, puede cerrar esta ventana.');
            window.close();
        }, 500);
    };
}
</script>

</body>
</html>
