<?php
require_once('class/class.php');
$accesos = ['administradorG', 'administradorS', 'secretaria', 'cajero', 'vendedor'];
validarAccesos($accesos) or die();

setlocale(LC_TIME, 'es_ES.UTF-8'); // Establecer el locale para español
$dia_actual  = date('d'); //Día del mes (ej: 01, 02, ..., 31)
$dia_actual2 = date('l'); //Día de la semana (ej: lunes, martes, etc.)
$mes_actual  = date('F');//Nombre completo del mes (ej: enero, febrero, etc.)
$mes_actual2 = date('M'); //Nombre abreviado del mes (ej: ene, feb, etc.)
$ano_actual  = date('Y');//Año (ej: 2024)

###################### DETALLE DE SESSION SUCURSAL ######################
$bod              = new Login();
$bod              = $bod->SucursalesSessionPorId();
$simbolo          = (empty($bod) || $_SESSION["acceso"] == "administradorG" ? "" : "<strong>".$bod[0]['simbolo']."</strong>");
$mostrar_pos      = (empty($bod) || $_SESSION["acceso"] == "administradorG" ? "0" : $bod[0]['mostrar_pos']);
$descsucursal     = (empty($bod) || $_SESSION["acceso"] == "administradorG" ? "0.00" : $bod[0]['descsucursal']);
###################### DETALLE DE SESSION SUCURSAL ######################

###################### DETALLE DE IMPUESTO ######################
$imp           = new Login();
$imp           = $imp->ImpuestosPorId();
$NomImpuesto   = (empty($imp) ? "Impuesto" : $imp[0]['nomimpuesto']);
$ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
###################### DETALLE DE IMPUESTO ######################

$new = new Login();
$con = $new->ContarRegistros();
?>
<!DOCTYPE html>
<html dir="ltr" lang="en">
<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="Ing. Ruben Chirinos">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="assets/images/favicon.png">
    <title></title>

    <!-- Menu CSS -->
    <link href="assets/plugins/bower_components/sidebar-nav/dist/sidebar-nav.min.css" rel="stylesheet">
    <!-- toast CSS -->
    <link href="assets/plugins/bower_components/toast-master/css/jquery.toast.css" rel="stylesheet">
    <!-- Datatables CSS -->
    <link rel="stylesheet" type="text/css" href="assets/plugins/datatables/datatables.css">
    <link rel="stylesheet" type="text/css" href="assets/plugins/datatables/custom_dt_html5.css">
    <link rel="stylesheet" type="text/css" href="assets/plugins/datatables/dt-global_style.css">
    <!-- Sweet-Alert -->
    <link rel="stylesheet" href="assets/css/sweetalert.css">
    <!-- animation CSS -->
    <link href="assets/css/animate.css" rel="stylesheet">
    <!-- needed css -->
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- color CSS -->
    <link href="assets/css/default.css" id="theme" rel="stylesheet">
    <!--Bootstrap Horizontal CSS -->
    <link href="assets/css/bootstrap-horizon.css" rel="stylesheet">
    <!--Detalles Productos CSS -->
    <link href="assets/css/style_all.css" rel="stylesheet">
    <!-- color alert -->
    <link rel="stylesheet" type="text/css" href="assets/css/alert.css">
    <!-- checkbox -->
    <link rel="stylesheet" type="text/css" href="assets/css/forms/theme-checkbox-radio.css">
    <link rel="stylesheet" type="text/css" href="assets/css/forms/switches.css">

    <!-- script jquery -->
    <script src="assets/script/jquery.min.js"></script> 
    <script type="text/javascript" src="assets/plugins/chart.js/chart.js"></script>
    <script type="text/javascript" src="assets/script/graficos.js"></script>
    <!-- script jquery -->

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
<![endif]-->

</head>

<body onLoad="muestraReloj(); getTime(); <?php if ($_SESSION["acceso"]=="cajero") { ?>document.getElementById('search_producto_barra').focus();<?php } ?>" class="fix-header">    
   <!-- ============================================================== -->
    <!-- Preloader - style you can find in spinners.css -->
    <!-- ============================================================== -->
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
        <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>

    <!-- ============================================================== -->
    <!-- Main wrapper - style you can find in pages.scss -->
    <!-- ============================================================== -->
    <!--<div id="main-wrapper" data-layout="horizontal" data-navbarbg="skin6" data-sidebartype="mini-sidebar" data-boxed-layout="boxed" data-header-position="fixed" data-sidebar-position="fixed" class="mini-sidebar">-->

    <div id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-boxed-layout="full" data-boxed-layout="boxed" data-header-position="fixed" data-sidebar-position="fixed" class="mini-sidebar">

    <!--############################## MODAL PARA VER DETALLE DE VENTA ######################################-->
    <div id="myModalDetalle" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header bg-danger">
                    <h4 class="modal-title text-white" id="myModalLabel"><i class="fa fa-align-justify"></i> Detalle de Venta</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><img src="assets/images/close.png"/></button>
                </div>
                <div class="modal-body">

                    <div id="muestraventamodal"></div> 
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->
    <!--############################## MODAL PARA VER DETALLE DE VENTA ######################################-->

        <!-- INICIO DE MENU -->
        <?php include('menu.php'); ?>
        <!-- FIN DE MENU -->

        <!-- ============================================================== -->
        <!-- Page wrapper  -->
        <!-- ============================================================== -->
        <div class="page-wrapper">
            <!-- ============================================================== -->
            <!-- Bread crumb and right sidebar toggle -->
            <!-- ============================================================== -->
            <div class="page-breadcrumb border-bottom">
                <div class="row">
                    <div class="col-lg-3 col-md-4 col-xs-12 align-self-center">
                    <h5 class="font-medium text-uppercase mb-0"><i class="fa fa-tasks"></i> Dashboard</h5>
                    </div>
                    <div class="col-lg-9 col-md-8 col-xs-12 align-self-center">
                        <nav aria-label="breadcrumb" class="mt-2 float-md-right float-left">
                            <ol class="breadcrumb mb-0 justify-content-end p-0">
                                <li class="breadcrumb-item"><a href="panel">Principal</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            <!-- ============================================================== -->
            <!-- End Bread crumb and right sidebar toggle -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->
            <!-- Container fluid  -->
            <!-- ============================================================== -->
            <div class="page-content container-fluid">
                <!-- ============================================================== -->
                <!-- First Cards Row  -->
                <!-- ============================================================== -->

    <?php if ($_SESSION['acceso'] == "administradorG") { ?> 

    <!-- Row -->
    <div class="row">
        <div class="col-md-6 col-lg-3">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase">Sucursales</h5>
                    <div class="d-flex align-items-center mb-2 mt-4">
                        <h2 class="mb-0 display-5"><i class="fa fa-bank text-primary"></i></h2>
                        <div class="ml-auto">
                            <h2 class="mb-0 display-6"><span class="font-normal"><?php echo $con['total_sucursales']; ?></span></h2>
                        </div>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-primary" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-3">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase">Usuarios</h5>
                    <div class="d-flex align-items-center mb-2 mt-4">
                        <h2 class="mb-0 display-5"><i class="fa fa-user text-info"></i></h2>
                        <div class="ml-auto">
                            <h2 class="mb-0 display-6"><span class="font-normal"><?php echo $con['total_usuarios']; ?></span></h2>
                        </div>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-info" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-3">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase">Clientes</h5>
                    <div class="d-flex align-items-center mb-2 mt-4">
                        <h2 class="mb-0 display-5"><i class="fa fa-users text-danger"></i></h2>
                        <div class="ml-auto">
                            <h2 class="mb-0 display-6"><span class="font-normal"><?php echo $con['total_clientes']; ?></span></h2>
                        </div>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-danger" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-3">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase">Proveedores</h5>
                    <div class="d-flex align-items-center mb-2 mt-4">
                        <h2 class="mb-0 display-5"><i class="fa fa-truck text-success"></i></h2>
                        <div class="ml-auto">
                            <h2 class="mb-0 display-6"><span class="font-normal"><?php echo $con['total_proveedores']; ?></span></h2>
                        </div>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-success" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

    <!-- ============================================================== -->
    <!-- Grafico por Sucursales -->
    <!-- ============================================================== -->
    <!-- Row -->
    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase mb-0">
                        Gráficos de Sucursales del Año <?php echo $ano_actual; ?>
                    </h5>
                    <div id="chart-container-bar-sucursales">
                        <canvas id="barChart" height="450"></canvas>
                        <div id="no-data-message-sucursales" class="text-center text-muted" style="display: none; padding-top: 50px;"></div>
                    </div>
                    <script>
                    $(document).ready(function () {
                        showGraphBarS();
                    });
                    </script>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
    <!-- ============================================================== -->
    <!-- Grafico por Sucursales -->
    <!-- ============================================================== -->

    <?php } elseif ($_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria") { ?>

    <!-- Row -->
    <div class="row">
        <div class="col-lg-12">

        <!-- Row -->
        <div class="row">

        <!-- .col -->
        <div class="col-md-4">

            <div class="row">

                <div class="col-md-6">
                    <div class="card bg-info">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mr-3 align-self-center">
                                <h2 class="text-white"><i class="fa fa-truck"></i></h2>
                                </div>
                                <div>
                                <a href="proveedores"><h4 class="card-title text-white">Proveedores</h4></a>
                                <h4 class="card-subtitle text-white"><?php echo $con['total_proveedores']; ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card bg-info">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mr-3 align-self-center">
                                <h2 class="text-white"><i class="fa fa-user"></i></h2>
                                </div>
                                <div>
                                <a href="clientes"><h4 class="card-title text-white">Clientes</h4></a>
                                <h4 class="card-subtitle text-white"><?php echo $con['total_clientes']; ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row">
                <div class="col-md-6">
                    <div class="card bg-success">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mr-3 align-self-center">
                                <h2 class="text-white"><i class="fa fa-cubes"></i></h2>
                                </div>
                                <div>
                                <a href="productos"><h4 class="card-title text-white">Productos</h4></a>
                                <h4 class="card-subtitle text-white"><?php echo $con['total_productos']; ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card bg-success">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mr-3 align-self-center">
                                <h2 class="text-white"><i class="fa fa-folder-open"></i></h2>
                                </div>
                                <div>
                                <a href="combos"><h4 class="card-title text-white">Combos</h4></a>
                                <h4 class="card-subtitle text-white"><?php echo $con['total_combos']; ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row">
                <div class="col-md-6">
                    <div class="card bg-secondary">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mr-3 align-self-center">
                                <h2 class="text-white"><i class="fa fa-cart-arrow-down"></i></h2>
                                </div>
                                <div>
                                <a href="compras"><h4 class="card-title text-white">Compras</h4></a>
                                <h4 class="card-subtitle text-white"><?php echo $con['total_compras']; ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card bg-secondary">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mr-3 align-self-center">
                                <h2 class="text-white"><i class="fa fa-cart-arrow-down"></i></h2>
                                </div>
                                <div>
                                <?php if($con['deudas_compras'] > 0){ ?>
                                <a href="reportepdf?tipo=<?php echo encrypt("CUENTASXPAGAR"); ?>" target="_blank" rel="noopener noreferrer"><h4 class="card-title text-white">Deudas</h4></a>
                                <?php } else { ?>
                                <a href="#"><h4 class="card-title text-white">Deudas</h4></a>
                                <?php } ?>
                                <h4 class="card-subtitle text-white"><?php echo $deuda = ($con['deudas_compras'] == "" ? "0.00" : $simbolo.number_format($con['deudas_compras'], 0, '.', ',')); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row">
                <div class="col-md-6">
                    <div class="card bg-warning">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mr-3 align-self-center">
                                <h2 class="text-white"><i class="fa fa-calculator"></i></h2>
                                </div>
                                <div>
                                <a href="cotizaciones"><h4 class="card-title text-white">Cotizaciones</h4></a>
                                <h4 class="card-subtitle text-white"><?php echo $con['total_cotizaciones']; ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card bg-warning">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mr-3 align-self-center">
                                <h2 class="text-white"><i class="fa fa-cart-plus"></i></h2>
                                </div>
                                <div>
                                <a href="ventas"><h4 class="card-title text-white">Ventas</h4></a>
                                <h4 class="card-subtitle text-white"><?php echo $con['total_ventas']; ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="card bg-danger">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mr-3 align-self-center">
                                <h2 class="text-white"><i class="fa fa-usd"></i></h2>
                                </div>
                                <div>
                                <h4 class="card-title text-white">Ingresos</h4>
                                <h4 class="card-subtitle text-white"><?php echo $ingresos = ($con['total_ingresos'] == "" ? "0.00" : $simbolo.number_format($con['total_ingresos'], 0, '.', ',')); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card bg-danger">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="mr-3 align-self-center">
                                <h2 class="text-white"><i class="fa fa-usd"></i></h2>
                                </div>
                                <div>
                                <h4 class="card-title text-white">Egresos</h4>
                                <h4 class="card-subtitle text-white"><?php echo $egresos = ($con['total_egresos'] == "" ? "0.00" : $simbolo.number_format($con['total_egresos'], 0, '.', ',')); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    
        </div>
        <!-- /.col -->
        
        <!-- .col -->  
        <div class="col-md-8">

            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div class="card">
                        <div class="card-body">
                        <h5 class="card-title text-uppercase mb-0">
                            Gráfico de Registros
                        </h5>
                        <div id="chart-container">
                            <canvas id="bar-chart" width="250" height="500"></canvas>
                        </div>
                        <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            const chartCanvas = document.getElementById("bar-chart");

                            // Datos directamente desde PHP, como los tenías inicialmente
                            // Asegúrate de que las variables PHP $con['total_clientes'], etc., estén definidas ANTES de este script
                            const labels = ["Clientes", "Proveedores", "Productos", "Traspasos", "Pedidos", "Compras", "Cotizaciones", "Preventas", "Ventas"];
                            const chartData = [
                                <?php echo $con['total_clientes']; ?>,
                                <?php echo $con['total_proveedores']; ?>,
                                <?php echo $con['total_productos']; ?>,
                                <?php echo $con['total_traspasos']; ?>,
                                <?php echo $con['total_pedidos']; ?>,
                                <?php echo $con['total_compras']; ?>,
                                <?php echo $con['total_cotizaciones']; ?>,
                                <?php echo $con['total_preventas']; ?>,
                                <?php echo $con['total_ventas']; ?>
                            ];

                            // Colores para las barras (puedes ajustar esta paleta a tu gusto)
                            const backgroundColors = [
                                'rgba(255, 99, 132, 0.7)', // Rojo claro
                                'rgba(54, 162, 235, 0.7)', // Azul claro
                                'rgba(150, 151, 136, 0.7)', // Amarillo claro
                                'rgba(255, 206, 86, 0.7)', // Marron claro
                                'rgba(0, 51, 153, 0.7)', // Azul Oscuro claro
                                'rgba(117, 32, 77, 0.7)', // Magenta claro
                                'rgba(75, 192, 192, 0.7)', // Verde azulado claro
                                'rgba(153, 102, 255, 0.7)',// Morado claro
                                'rgba(255, 159, 64, 0.7)'  // Naranja claro
                            ];
                            const borderColors = [
                                'rgba(255, 99, 132, 1)',
                                'rgba(54, 162, 235, 1)',
                                'rgba(150, 151, 136, 1)',
                                'rgba(255, 206, 86, 1)', 
                                'rgba(0, 51, 153, 1)',
                                'rgba(117, 32, 77, 1)',
                                'rgba(75, 192, 192, 1)',
                                'rgba(153, 102, 255, 1)',
                                'rgba(255, 159, 64, 1)'
                            ];

                            new Chart(chartCanvas, {
                                type: 'bar',
                                data: {
                                    labels: labels,
                                    datasets: [{
                                        label: "Cantidad Nº",
                                        backgroundColor: backgroundColors,
                                        borderColor: borderColors,
                                        borderWidth: 1, // Borde para las barras
                                        data: chartData
                                    }]
                                },
                                options: {
                                    responsive: true, // Hace el gráfico responsive
                                    maintainAspectRatio: false, // Permite que el gráfico no mantenga el aspecto original y se ajuste al contenedor
                                    animation: {
                                        duration: 1000, // Duración de la animación en milisegundos
                                        easing: 'easeOutQuart' // Tipo de easing para la animación
                                    },
                                    plugins: { // Options for the chart title and legend (Chart.js 3+)
                                        title: {
                                            display: true,
                                            text: 'Cantidad de Registros por Categoría',
                                            font: {
                                                size: 18,
                                                weight: 'bold'
                                            },
                                            color: '#333'
                                        },
                                        legend: {
                                            display: false // Oculta la leyenda si solo hay un dataset
                                        },
                                        tooltip: { // Configuración del tooltip
                                            callbacks: {
                                                label: function(context) {
                                                    let label = context.dataset.label || '';
                                                    if (label) {
                                                        label += ': ';
                                                    }
                                                    if (context.parsed.y !== null) {
                                                        // Usamos 'es-VE' para el formato de número local
                                                        label += new Intl.NumberFormat('es-CL').format(context.parsed.y) + ' unidades';
                                                    }
                                                    return label;
                                                }
                                            },
                                            backgroundColor: 'rgba(0,0,0,0.8)',
                                            titleColor: '#fff',
                                            bodyColor: '#fff',
                                            borderWidth: 1,
                                            borderColor: '#ddd'
                                        }
                                    },
                                    scales: {
                                        x: { // Configuración del eje X
                                            grid: {
                                                display: false // Oculta las líneas de la cuadrícula en el eje X
                                            },
                                            title: {
                                                display: true,
                                                text: 'Categoría',
                                                font: {
                                                    size: 14,
                                                    weight: 'bold'
                                                },
                                                color: '#555'
                                            }
                                        },
                                        y: { // Configuración del eje Y
                                            beginAtZero: true, // Empieza el eje Y en 0
                                            ticks: {
                                                precision: 0 // Asegura que los ticks del eje Y sean números enteros
                                            },
                                            title: {
                                                display: true,
                                                text: 'Cantidad',
                                                font: {
                                                    size: 14,
                                                    weight: 'bold'
                                                },
                                                color: '#555'
                                            }
                                        }
                                    }
                                }
                            });
                        });
                        </script>
                        </div>
                    </div>
                </div>
            </div>

        </div>
       <!-- /.col -->    
            
        </div>
        <!-- End Row -->

        </div>
    </div>
    <!-- End Row -->

    <!-- ============================================================== -->
    <!-- Graficos Individual Traspasos, Pedidos y Compras -->
    <!-- ============================================================== -->
    <!-- Row -->
    <div class="row">
        <!-- .col -->
        <div class="col-md-12 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase mb-0">
                        Traspasos del Año <?php echo $ano_actual; ?>
                    </h5>
                    <div id="chart-container-traspasos">
                        <canvas id="bar-chart-traspasos" height="250"></canvas>
                        <div id="no-data-message-traspasos" class="text-center text-muted"></div>
                    </div>
                    <script>
                    $(document).ready(function() {
                        showGraphBarTraspasosMensuales(); 
                    });
                    </script>
                </div>
            </div>
        </div>
        <!-- .col -->

        <!-- .col -->
        <div class="col-md-12 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase mb-0">
                        Pedidos a Proveedores del Año <?php echo $ano_actual; ?>
                    </h5>
                    <div id="chart-container-pedidos">
                        <canvas id="bar-chart-pedidos" height="250"></canvas>
                        <div id="no-data-message-pedidos" class="text-center text-muted"></div>
                    </div>
                    <script>
                    $(document).ready(function() {
                        showGraphBarPedidosMensuales(); 
                    });
                    </script>
                </div>
            </div>
        </div>
        <!-- .col -->

        <!-- .col -->
        <div class="col-md-12 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase mb-0">
                        Compras del Año <?php echo $ano_actual; ?>
                    </h5>
                    <div id="chart-container-compras">
                        <canvas id="bar-chart-compras" height="250"></canvas>
                        <div id="no-data-message-compras" class="text-center text-muted"></div>
                    </div>
                    <script>
                    $(document).ready(function() {
                        showGraphBarComprasMensuales(); 
                    });
                    </script>
                </div>
            </div>
        </div>
        <!-- .col -->

    </div>
    <!-- End Row -->
    <!-- ============================================================== -->
    <!-- Graficos Individual Traspasos, Pedidos y Compras -->
    <!-- ============================================================== -->


    <!-- ============================================================== -->
    <!-- Graficos Individual Preventas, Cotizaciones y Ventas -->
    <!-- ============================================================== -->
    <!-- Row -->
    <div class="row">
        <!-- .col -->
        <div class="col-md-12 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase mb-0">
                        Cotizaciones del Año <?php echo $ano_actual; ?>  
                    </h5>
                    <div id="chart-container-cotizaciones">
                        <canvas id="bar-chart-cotizaciones" height="250"></canvas>
                        <div id="no-data-message-cotizaciones" class="text-center text-muted"></div>
                    </div>
                    <script>
                    $(document).ready(function() {
                        showGraphBarCotizacionesMensuales(); 
                    });
                    </script>
                </div>
            </div>
        </div>
        <!-- .col -->

        <!-- .col -->
        <div class="col-md-12 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase mb-0">
                        Preventas del Año <?php echo $ano_actual; ?>
                    </h5>
                    <div id="chart-container-preventas">
                        <canvas id="bar-chart-preventas" height="250"></canvas>
                        <div id="no-data-message-preventas" class="text-center text-muted"></div>
                    </div>
                    <script>
                    $(document).ready(function() {
                        showGraphBarPreventasMensuales(); 
                    });
                    </script>
                </div>
            </div>
        </div>
        <!-- .col -->

        <!-- .col -->
        <div class="col-md-12 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase mb-0">
                        Ventas del Año <?php echo $ano_actual; ?>
                    </h5>
                    <div id="chart-container-ventas">
                        <canvas id="bar-chart-ventas" height="250"></canvas>
                        <div id="no-data-message-ventas" class="text-center text-muted"></div>
                    </div>
                    <script>
                    $(document).ready(function() {
                        showGraphBarVentasMensuales(); 
                    });
                    </script>
                </div>
            </div>
        </div>
        <!-- .col -->

    </div>
    <!-- End Row -->
    <!-- ============================================================== -->
    <!-- Graficos Individual Preventas, Cotizaciones y Ventas -->
    <!-- ============================================================== -->


    <!-- ============================================================== -->
    <!-- Graficos 5 Productos + Vendidos y Total Ventas -->
    <!-- ============================================================== -->
    <!-- Row -->
    <div class="row">
        <!-- .col -->
        <div class="col-md-12 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase mb-0">
                        Total en Compras a Proveedores del Año <?php echo $ano_actual; ?>  
                    </h5>
                    <div id="chart-container-cp">
                        <canvas id="DoughnutChartCP" height="350"></canvas>
                        <div id="no-data-message-compras-proveedor" class="text-center text-muted"></div>
                    </div>
                    <script>
                    $(document).ready(function () {
                        showGraphDoughnutComprasxProveedor();
                    });
                    </script>
                </div>
            </div>
        </div>
        <!-- .col -->

        <!-- .col -->
        <div class="col-md-12 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase mb-0">
                        Total en Ventas del Año <?php echo $ano_actual; ?>  
                    </h5>
                    <div id="chart-container-vu">
                    <canvas id="DoughnutChartVU" height="350"></canvas>
                        <div id="no-data-message-ventas-usuarios" class="text-center text-muted"></div>
                    </div>
                    <script>
                    $(document).ready(function () {
                        showGraphDoughnutVentasxUsuarios();
                    });
                    </script>
                </div>
            </div>
        </div>
        <!-- .col -->

        <!-- .col -->
        <div class="col-md-12 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase mb-0">
                        5 Productos Mas Vendidos del Año <?php echo $ano_actual; ?>
                    </h5>
                    <div id="chart-container-pv">
                        <canvas id="DoughnutChartPV" height="350"></canvas>
                        <div id="no-data-message-productos-vendidos" class="text-center text-muted"></div>
                    </div>
                    <script>
                    $(document).ready(function () {
                        showGraphDoughnutProductosVendidos();
                    });
                    </script>
                </div>
            </div>
        </div>
        <!-- .col -->
    </div>
    <!-- End Row -->
    <!-- ============================================================== -->
    <!-- Graficos 5 Productos + Vendidos y Total Ventas -->
    <!-- ============================================================== -->

    <!-- ============================================================== -->
    <!-- Grafico de Ventas Diarias -->
    <!-- ============================================================== -->
    <!-- Row -->
    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase mb-0">
                        Gráficos de Ventas Diarias del Mes <?php echo $mes_actual; ?> del Año <?php echo $ano_actual; ?>
                    </h5>
                    <div id="chart-container-ventas-diarias">
                        <canvas id="lineChart" width="400" height="350"></canvas>
                        <div id="no-data-message-ventas-diarias" class="text-center text-muted"></div>
                    </div>
                    <script>
                    $(document).ready(function () {
                        showGraphLineVentasDiarias();
                    });
                    </script>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

    <!-- Row -->
    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header bg-danger">
                <h4 class="card-title text-white"><i class="fa fa-tasks"></i> Ventas de Hoy <?php echo date("d-m-Y"); ?></h4>
                </div>
                <div class="form-body">
                    <div class="card-body">

                            <div class="table-responsive">
                                <table id="html5-extension" class="table table-striped table-bordered border display">
                                    <thead>
                                        <tr role="row" class="warning-element" style="border-left: 2px solid #ff5050 !important; background: #ece8e9;">
                                            <th>N°</th>
                                            <th>N° de Factura</th>
                                            <th>Vendedor</th>
                                            <th>Descripción de Cliente</th>
                                            <th>Descontado</th>
                                            <th>Subtotal</th>
                                            <th>Total <?php echo $NomImpuesto; ?></th>
                                            <th>Imp. Total</th>
                                            <th>Estado</th>
                                            <th>Fecha Emisión</th>
                                            <th>...</th>
                                        </tr>
                                    </thead>
                                    <tbody class="BusquedaRapida">
                                    </tbody>
                                </table>
                            </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

    <!-- ============================================================== -->
    <!-- Grafico de Ventas Diarias -->
    <!-- ============================================================== -->

    <?php } elseif ($_SESSION["acceso"] == "cajero" || $_SESSION["acceso"] == "vendedor") { ?>

    <!-- Row -->
    <div class="row">
        <div class="col-lg-12">

            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div class="card">
                        <div class="card-body">
                        <h5 class="card-title text-uppercase mb-0">
                            Gráfico de Registros
                        </h5>
                        <div id="chart-container">
                            <canvas id="bar-chart" width="500" height="350"></canvas>
                        </div>
                        <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            const chartCanvas = document.getElementById("bar-chart");

                            // Datos directamente desde PHP, como los tenías inicialmente
                            // Asegúrate de que las variables PHP $con['total_clientes'], etc., estén definidas ANTES de este script
                            const labels = ["Clientes", "Proveedores", "Productos", "Cotizaciones", "Preventas", "Ventas"];
                            const chartData = [
                                <?php echo $con['total_clientes']; ?>,
                                <?php echo $con['total_proveedores']; ?>,
                                <?php echo $con['total_productos']; ?>,
                                <?php echo $con['total_cotizaciones']; ?>,
                                <?php echo $con['total_preventas']; ?>,
                                <?php echo $con['total_ventas']; ?>
                            ];

                            // Colores para las barras (puedes ajustar esta paleta a tu gusto)
                            const backgroundColors = [
                                'rgba(255, 99, 132, 0.7)', // Rojo claro
                                'rgba(54, 162, 235, 0.7)', // Azul claro
                                'rgba(255, 206, 86, 0.7)', // Amarillo claro
                                'rgba(75, 192, 192, 0.7)', // Verde azulado claro
                                'rgba(153, 102, 255, 0.7)',// Morado claro
                                'rgba(255, 159, 64, 0.7)'  // Naranja claro
                            ];
                            const borderColors = [
                                'rgba(255, 99, 132, 1)',
                                'rgba(54, 162, 235, 1)',
                                'rgba(255, 206, 86, 1)',
                                'rgba(75, 192, 192, 1)',
                                'rgba(153, 102, 255, 1)',
                                'rgba(255, 159, 64, 1)'
                            ];

                            new Chart(chartCanvas, {
                                type: 'bar',
                                data: {
                                    labels: labels,
                                    datasets: [{
                                        label: "Cantidad Nº",
                                        backgroundColor: backgroundColors,
                                        borderColor: borderColors,
                                        borderWidth: 1, // Borde para las barras
                                        data: chartData
                                    }]
                                },
                                options: {
                                    responsive: true, // Hace el gráfico responsive
                                    maintainAspectRatio: false, // Permite que el gráfico no mantenga el aspecto original y se ajuste al contenedor
                                    animation: {
                                        duration: 1000, // Duración de la animación en milisegundos
                                        easing: 'easeOutQuart' // Tipo de easing para la animación
                                    },
                                    plugins: { // Options for the chart title and legend (Chart.js 3+)
                                        title: {
                                            display: true,
                                            text: 'Cantidad de Registros por Categoría',
                                            font: {
                                                size: 18,
                                                weight: 'bold'
                                            },
                                            color: '#333'
                                        },
                                        legend: {
                                            display: false // Oculta la leyenda si solo hay un dataset
                                        },
                                        tooltip: { // Configuración del tooltip
                                            callbacks: {
                                                label: function(context) {
                                                    let label = context.dataset.label || '';
                                                    if (label) {
                                                        label += ': ';
                                                    }
                                                    if (context.parsed.y !== null) {
                                                        // Usamos 'es-VE' para el formato de número local
                                                        label += new Intl.NumberFormat('es-CL').format(context.parsed.y) + ' unidades';
                                                    }
                                                    return label;
                                                }
                                            },
                                            backgroundColor: 'rgba(0,0,0,0.8)',
                                            titleColor: '#fff',
                                            bodyColor: '#fff',
                                            borderWidth: 1,
                                            borderColor: '#ddd'
                                        }
                                    },
                                    scales: {
                                        x: { // Configuración del eje X
                                            grid: {
                                                display: false // Oculta las líneas de la cuadrícula en el eje X
                                            },
                                            title: {
                                                display: true,
                                                text: 'Categoría',
                                                font: {
                                                    size: 14,
                                                    weight: 'bold'
                                                },
                                                color: '#555'
                                            }
                                        },
                                        y: { // Configuración del eje Y
                                            beginAtZero: true, // Empieza el eje Y en 0
                                            ticks: {
                                                precision: 0 // Asegura que los ticks del eje Y sean números enteros
                                            },
                                            title: {
                                                display: true,
                                                text: 'Cantidad',
                                                font: {
                                                    size: 14,
                                                    weight: 'bold'
                                                },
                                                color: '#555'
                                            }
                                        }
                                    }
                                }
                            });
                        });
                        </script>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!-- End Row -->

    <!-- ============================================================== -->
    <!-- Grafico de Ventas Diarias -->
    <!-- ============================================================== -->
    <!-- Row -->
    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title text-uppercase mb-0">
                        Gráficos de Ventas Diarias del Mes <?php echo $mes_actual; ?> del Año <?php echo $ano_actual; ?>
                    </h5>
                    <div id="chart-container-ventas-diarias">
                        <canvas id="lineChart" width="400" height="350"></canvas>
                        <div id="no-data-message-ventas-diarias" class="text-center text-muted"></div>
                    </div>
                    <script>
                    $(document).ready(function () {
                        showGraphLineVentasDiarias();
                    });
                    </script>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

    <!-- Row -->
    <div class="row">
        <div class="col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header bg-danger">
                <h4 class="card-title text-white"><i class="fa fa-tasks"></i> Ventas de Hoy <?php echo date("d-m-Y"); ?></h4>
                </div>
                <div class="form-body">
                    <div class="card-body">

                            <div class="table-responsive">
                                <table id="html5-extension" class="table table-striped table-bordered border display">
                                    <thead>
                                        <tr role="row" class="warning-element" style="border-left: 2px solid #ff5050 !important; background: #ece8e9;">
                                            <th>N°</th>
                                            <th>N° de Factura</th>
                                            <th>Vendedor</th>
                                            <th>Descripción de Cliente</th>
                                            <th>Descontado</th>
                                            <th>Subtotal</th>
                                            <th>Total <?php echo $NomImpuesto; ?></th>
                                            <th>Imp. Total</th>
                                            <th>Estado</th>
                                            <th>Fecha Emisión</th>
                                            <th>...</th>
                                        </tr>
                                    </thead>
                                    <tbody class="BusquedaRapida">
                                    </tbody>
                                </table>
                            </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

    <!-- ============================================================== -->
    <!-- Grafico de Ventas Diarias -->
    <!-- ============================================================== -->

    <?php } ?> 

            </div>
            <!-- ============================================================== -->
            <!-- End Container fluid  -->
            <!-- ============================================================== -->
            <!-- ============================================================== -->
            <!-- footer -->
            <!-- ============================================================== -->
            <footer class="footer text-center">
                <i class="fa fa-copyright"></i> <span class="current-year"></span>.
            </footer>
            <!-- ============================================================== -->
            <!-- End footer -->
            <!-- ============================================================== -->
        </div>
        <!-- ============================================================== -->
        <!-- End Page wrapper  -->
        <!-- ============================================================== -->
    </div>
    <!-- ============================================================== -->
    <!-- End Wrapper -->
    <!-- ============================================================== -->
    <!-- ============================================================== -->
    <!-- All Jquery -->
    <!-- ============================================================== -->
    <script src="assets/js/bootstrap.js"></script>
    <!-- apps -->
    <script src="assets/js/app.min.js"></script>
    <script src="assets/js/app.init.horizontal-fullwidth.js"></script>
    <script src="assets/js/app-style-switcher.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="assets/js/perfect-scrollbar.js"></script>
    <script src="assets/js/sparkline.js"></script>
    <!--Wave Effects -->
    <script src="assets/js/waves.js"></script>
    <!-- Sweet-Alert -->
    <script src="assets/js/sweetalert-dev.js"></script>
    <!--Menu sidebar -->
    <script src="assets/js/sidebarmenu.js"></script>
    <!--Custom JavaScript -->
    <script src="assets/js/custom.js"></script>

    <!-- script jquery -->
    <script type="text/javascript" src="assets/script/titulos.js"></script>
    <script type="text/javascript" src="assets/script/jquery.mask.js"></script>
    <script type="text/javascript" src="assets/script/mask.js"></script>
    <script type="text/javascript" src="assets/script/script2.js"></script>
    <script type="text/javascript" src="assets/script/VentanaCentrada.js"></script>
    <script type="text/javascript" src="assets/script/validation.min.js"></script>
    <script type="text/javascript" src="assets/script/script.js"></script>
    <!-- script jquery -->

    <!-- Calendario -->
    <link rel="stylesheet" href="assets/calendario/jquery-ui.css" />
    <script src="assets/calendario/jquery-ui.js"></script>
    <script src="assets/script/jscalendario.js"></script>
    <script src="assets/script/autocompleto.js"></script>
    <!-- Calendario -->

    <!-- jQuery -->
    <script src="assets/plugins/noty/packaged/jquery.noty.packaged.min.js"></script>
    <script src="assets/plugins/noty/themes/relax.js"></script>
    <?php if ($_SESSION["acceso"] != "administradorG") { ?>
    <script src="assets/plugins/datatables/datatables.js"></script>
    <script>
    $(document).ready(function() {
        // Función para habilitar o deshabilitar los botones de exportación
        function toggleExportButtons(enable) {
            // Selecciona todos los enlaces de exportación (PDF, Excel, Word)
            // Asumiendo que quieres mantener los botones de Excel y Word también
            const exportLinks = $('#pdfGeneralLink, #excelLink, #wordLink'); // Usamos pdfGeneralLink si ese es el ID de tu botón PDF ahora

            if (enable) {
                exportLinks.removeClass('disabled').removeAttr('tabindex');
            } else {
                exportLinks.addClass('disabled').attr('tabindex', '-1');
            }
        }

        // Función para actualizar los atributos href de los botones de exportación
        function updateExportButtons() {
            // Ya no hay tipobusqueda, search_criterio, desde, hasta.
            // Los reportes siempre serán de ventas diarias.
            // Asegúrate de que 'VENTASDIARIAS' sea el tipo de reporte correcto para tu backend.
            const baseUrl = 'reportepdf?tipo=<?php echo encrypt("VENTASDIARIAS"); ?>'; // URL base para ventas diarias

            $('#pdfGeneralLink').attr('href', baseUrl); // Asigna la URL al botón de PDF general
            $('#excelLink').attr('href', `reporteexcel?documento=<?php echo encrypt("EXCEL"); ?>&tipo=<?php echo encrypt("VENTASDIARIAS"); ?>`);
            $('#wordLink').attr('href', `reporteexcel?documento=<?php echo encrypt("WORD"); ?>&tipo=<?php echo encrypt("VENTASDIARIAS"); ?>`);
        }

        var dataTable = $('#html5-extension').DataTable({
            "oLanguage": {
                "oPaginate": { "sPrevious": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>', "sNext": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>' },
                "sInfo": "Mostrar _START_ - _END_ de _TOTAL_ Registros",
                "sInfoEmpty": "Mostrar 0 para 0 de 0 Registros",
                "sInfoFiltered": "(Resultados de _MAX_ Registros)",
                "sSearch": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
                "sSearchPlaceholder": "Búsqueda...",
                "sLengthMenu": "Mostrar :  _MENU_",
                "sZeroRecords": "NO SE ENCONTRARON REGISTROS ACTUALMENTE",
            },
            "ajax": {
                "url": "obtener_json.php?CargaVentasDiarias=si", // URL directa para ventas diarias
                "type": "GET",
                // "data" function no es necesaria ya que no hay filtros
                "dataSrc": function(json) {
                    if (json.data && json.data.length > 0) {
                        toggleExportButtons(true); // Activar botones si hay registros
                    } else {
                        toggleExportButtons(false); // Desactivar botones si no hay registros
                    }
                    return json.data; // Devolver los datos a DataTables
                },
                "error": function(xhr, error, thrown) {
                    console.error("Error en la carga de DataTables:", error, thrown, xhr);
                    $('#html5-extension tbody').html('<tr><td colspan="10" class="text-center text-danger">Error al cargar los datos. Intente de nuevo.</td></tr>');
                    toggleExportButtons(false); // Desactivar botones en caso de error
                }
            },
            "columns": [
                { "data": 0, "visible": true },
                { "data": 1 },
                { "data": 2 },
                { "data": 3 },
                { "data": 4, "render": function(data, type, row) { return '' + data + ''; } },
                { "data": 5, "render": function(data, type, row) { return '' + data + ''; } },
                { "data": 6, "render": function(data, type, row) { return '' + data + ''; } },
                { "data": 7, "render": function(data, type, row) { return '' + data + ''; } },
                { "data": 8 },
                { "data": 9 },
                { "data": 10 }
            ],
            "order": [[ 0, "asc" ]],
            "stripeClasses": [],
            "lengthMenu": [10, 20, 50, 100, 300, 800, 1500],
            "pageLength": 10,
            "processing": true,
            "serverSide": false,
            drawCallback: function () {
                $('.dataTables_paginate > .pagination').addClass('pagination-style-13 pagination-bordered mb-5');
            }
        });

        // Ya no necesitamos listeners para radio buttons o campos de búsqueda
        // porque no hay tipobusqueda ni criterios de filtrado en el frontend.

        // Llama a la función al cargar la página para establecer los enlaces de exportación
        updateExportButtons();

        // La tabla se carga automáticamente al inicio con la configuración del ajax.
        // No se necesita lógica de inicialización para tipobusqueda, search_criterio, etc.
    });
    </script>
    <?php } elseif ($_SESSION["acceso"]=="cajero") { ?>
    <script type="text/jscript">
    $('#loading').append('<center><i class="fa fa-spin fa-spinner"></i> Por favor espere, cargando registros ......</center>').fadeIn("slow");
    setTimeout(function() {
    $('#loading').load("familias_productos?CargarProductos=si&tipo_precio=3");
    }, 200);
    </script>
    <script id='rowPago' type="text/html">
    <div class="row">
        <div class="col-md-6">
            <div class="form-group has-feedback4"> 
                <i class="fa fa-bars form-control-feedback4"></i> 
                <select style="color:#000;font-weight:bold;" name="pagos[$INDEX][codmediopago]" id="codmediopago" title="Seleccione Forma Pago" class="form-control" required>
                <option value=""> -- SELECCIONE -- </option>
                <?php
                $medio = new Login();
                $medio = $medio->ListarMediosPagos();
                if($medio==""){ 
                    echo "";
                } else {
                for ($i = 0; $i < sizeof($medio); $i++) { ?>
                <option value="<?php echo encrypt($medio[$i]['codmediopago']); ?>">
                <?php echo $medio[$i]['mediopago']; ?>
                </option>
                <?php } } ?>
                </select>
            </div>
        </div>

        <div class="col-md-6">
            <div class="input-group">
                <input style="color:#000;font-weight:bold;" class="form-control" type="text" name="pagos[$INDEX][montopagado]" id="montopagado" onKeyUp="CalculoDevolucion();" onKeyPress="EvaluateText('%f', this);" onBlur="this.value = NumberFormat(this.value, '2', '.', '')" placeholder="Monto Recibido" title="Ingrese Monto Recibido" autocomplete="off">
                <div class="input-group-append">
                    <div class="btn-group" data-bs-toggle="buttons">
                        <button type="button" class="btn btn-danger waves-effect waves-light" data-placement="left" title="Quitar" data-original-title="" onclick='rmRowPago(this)'><span class="fa fa-minus"></span></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </script>

    <script id='rowPago2' type="text/html">
    <div class="row">
        <div class="col-md-6">
            <div class="form-group has-feedback4"> 
                <i class="fa fa-bars form-control-feedback4"></i> 
                <select style="color:#000;font-weight:bold;" name="pagos2[$INDEX][codmediopago]" id="codmediopago2" title="Seleccione Forma Pago" class="form-control" required>
                <option value=""> -- SELECCIONE -- </option>
                <?php
                $medio = new Login();
                $medio = $medio->ListarMediosPagos();
                if($medio==""){ 
                    echo "";
                } else {
                for ($i = 0; $i < sizeof($medio); $i++) { ?>
                <option value="<?php echo encrypt($medio[$i]['codmediopago']); ?>">
                <?php echo $medio[$i]['mediopago']; ?>
                </option>
                <?php } } ?>
                </select>
            </div>
        </div>

        <div class="col-md-6">
            <div class="input-group">
                <input style="color:#000;font-weight:bold;" class="form-control" type="text" name="pagos2[$INDEX][montopagado]" id="montopagado2" onKeyUp="CalculoDevolucion2();" onKeyPress="EvaluateText('%f', this);" onBlur="this.value = NumberFormat(this.value, '2', '.', '')" placeholder="Monto Recibido" title="Ingrese Monto Recibido" autocomplete="off">
                <div class="input-group-append">
                    <div class="btn-group" data-bs-toggle="buttons">
                        <button type="button" class="btn btn-danger waves-effect waves-light" data-placement="left" title="Quitar" data-original-title="" onclick='rmRowPago2(this)'><span class="fa fa-minus"></span></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </script>    
    <?php } ?>
    <!-- jQuery -->

</body>
</html>