<?php
define('FPDF_FONTPATH','fpdf/font/');
define('EURO', chr(128));
require 'pdf_js.php';

############## VARIABLE PARA TAMAO DE LOGO ##############
$GLOBALS['logo1_vertical'] = 30;
$GLOBALS['logo1_vertical_X'] = 8;
$GLOBALS['logo1_vertical_Y'] = 2;

$GLOBALS['logo2_vertical'] = 30;
$GLOBALS['logo2_vertical_X'] = 10;
$GLOBALS['logo2_vertical_Y'] = 2;

$GLOBALS['logo1_horizontal'] = 32;
$GLOBALS['logo1_horizontal_X'] = 25;
$GLOBALS['logo1_horizontal_Y'] = 1;

$GLOBALS['logo2_horizontal'] = 32;
$GLOBALS['logo2_horizontal_X'] = 15;
$GLOBALS['logo2_horizontal_Y'] = 1;

$GLOBALS['logo1_letter_X'] = 18;
$GLOBALS['logo1_letter_Y'] = 2;
$GLOBALS['logo1_letter'] = 24;

$GLOBALS['logo2_letter_X'] = 18;
$GLOBALS['logo2_letter_Y'] = 2;
$GLOBALS['logo2_letter'] = 24;
############## VARIABLE PARA TAMAO DE LOGO ##############

############## VARIABLE PARA TEXTO DE GARANTIA ##############
$GLOBALS['texto_global'] = "";
############## VARIABLE PARA TEXTO DE GARANTIA ##############
 
//class PDF extends FPDF{ 
class PDF extends PDF_JavaScript
{
var $widths;
var $aligns;
var $flowingBlockAttr;
protected $B = 0;
protected $I = 0;
protected $U = 0;
protected $HREF = '';
//$Tamhoriz = 88;


########################### FUNCION PARA MOSTRAR CODIGO QR ###########################
function QR($reg, $xpos, $ypos){
    require_once("phpqrcode/qrlib.php");
    //echo json_encode($reg[0]); exit;

    $con = new Login();
    $con = $con->ConfiguracionPorId();
    //$simbolo = $con[0]['simbolo'] ?? $con[0]['simbolo'];

    $jo = new StdClass();
    $textoQR = portales('No Tracking: '.$reg[0]['numero_tracking']);

    $tempfile = tempnam(sys_get_temp_dir(), '');
    try {
        QRcode::png($textoQR, $tempfile);
         $this->Image($tempfile, $xpos, $this->GetY() + 0, 30, 30, "png");
    } finally {
        unlink($tempfile);
    }
}
########################### FUNCION PARA MOSTRAR CODIGO QR ###########################

########################### FUNCION PARA MOSTRAR EL FOOTER ###########################
function Footer() 
{
  if(!in_array(decrypt($_GET['tipo']), ['TICKETCOMPRA', 'TICKETCREDITO', 'TICKETCOTIZACION', 'TICKETPREVENTA', 'GUIADESPACHO_80MM', 'TICKETCIERRE', 'TICKETMOVIMIENTO', 'BOLETA', 'FACTURA', 'FACTURA_A4', 'NOTA DE VENTA', 'NOTACREDITO'])){
  //footer code
  $this->Ln();
  $this->SetY(-12);
  //Courier B 10
  $this->SetFont('courier','B',10);
  //Titulo de Footer
  $this->Cell(190,5,'FACTURACIN E INVENTARIOS (Administracin, Compras y Ventas)','T',0,'L');
  //$this->AliasNbPages();
  //Numero de Pagina
  $this->Cell(0,5,'Pagina '.$this->PageNo(),'T',1,'R'); 

  }
}
########################## FUNCION PARA MOSTRAR EL FOOTER ############################
    
######################## FUNCION PARA CARGAR AUTOPRINTF ########################
function AutoPrint($printer='')
{
    // Open the print dialog
    if($printer)
    {
        $printer = str_replace('\\', '\\\\', $printer);
        $script = "var pp = getPrintParams();";
        $script .= "pp.interactive = pp.constants.interactionLevel.full;";
        $script .= "pp.printerName = '$printer'";
        $script .= "print(pp);";
    }
    else
        $script = 'print(true);';
    $this->IncludeJS($script);
}
######################## FUNCION PARA CARGAR AUTOPRINT ########################




########################### FUNCION PARA MOSTRAR EL HEADER ###########################
function Header()
{
    if(in_array(decrypt($_GET['tipo']), ['USUARIOS', 'LOGS', 'SUCURSALES', 'CLIENTES', 'CLIENTESXCREDITOS', 'PROVEEDORES', 'PEDIDOS', 'PEDIDOSXPROVEEDOR', 'PEDIDOSXFECHAS',
        'SERVICIOS', 'SERVICIOSXMONEDA', 'KARDEXSERVICIO', 'SERVICIOSVALORIZADOXFECHAS', 'SERVICIOSVENDIDOSXFECHAS', 
        'PRODUCTOS', 'PRODUCTOSXSUCURSAL', 'PRODUCTOSXBUSQUEDA', 'STOCKOPTIMO', 'STOCKMEDIO', 'STOCKMINIMO', 'STOCKCERO', 'FECHASOPTIMO', 'FECHASMEDIO', 'FECHASMINIMO', 'PRODUCTOSXMONEDA', 'KARDEXPRODUCTO', 'KARDEXPRODUCTOSVALORIZADO', 'PRODUCTOSVALORIZADOXFECHAS', 'PRODUCTOSVENDIDOSXFECHAS', 'PRODUCTOSVENDIDOSXBUSQUEDA', 'PRODUCTOSSINVENDER', 'AJUSTEPRODUCTOS', 'AJUSTEPRODUCTOSXBUSQUEDA', 
        'COMBOS', 'COMBOSMINIMO', 'COMBOSMAXIMO', 'COMBOSXMONEDA', 'KARDEXCOMBO', 'KARDEXCOMBOSVALORIZADO', 'COMBOSVALORIZADOXFECHAS', 'COMBOSVENDIDOSXFECHAS', 
        'TRASPASOS', 'TRASPASOSXFECHAS', 'DETALLESTRASPASOSXFECHAS', 
        'COMPRAS', 'COMPRASXBUSQUEDA', 'CUENTASXPAGAR', 'CUENTASXPAGARXBUSQUEDA', 'CUENTASXPAGARVENCIDAS', 'COMPRASXPROVEEDOR', 'COMPRASXFECHAS', 'ABONOSCREDITOSCOMPRASXFECHAS', 'CREDITOSCOMPRASXPROVEEDOR', 'CREDITOSCOMPRASXFECHAS', 'DETALLESCREDITOSCOMPRASXPROVEEDOR', 'DETALLESCREDITOSCOMPRASXFECHAS', 
        'COTIZACIONES', 'COTIZACIONESXBUSQUEDA', 'COTIZACIONESXFECHAS', 'COTIZACIONESXVENDEDOR', 'DETALLESCOTIZACIONESXFECHAS', 'DETALLESCOTIZACIONESXVENDEDOR', 
        'PREVENTAS', 'CLIENTESXPREVENTAS', 'PREVENTASXFECHAS', 'PREVENTASXVENDEDOR', 'DETALLESPREVENTASXFECHAS', 'DETALLESPREVENTASXVENDEDOR',

        'DESPACHOS', 'DESPACHOSXFECHAS', 'DESPACHOSXVENDEDOR', 'DESPACHOSXCLIENTES', 'DETALLESDESPACHOSXFECHAS', 'DETALLESDESPACHOSXVENDEDOR', 'DETALLESDESPACHOSXCLIENTES',

        'ARQUEOS', 'ARQUEOSXFECHAS', 'GANANCIASXFECHAS', 
        'VENTAS', 'VENTASXBUSQUEDA', 'VENTASDIARIAS', 'LIBROVENTASXFECHAS', 'VENTASXCAJAS', 'VENTASXFECHAS', 'VENTASXCLIENTES', 'VENTASXCONDICIONES', 'COMISIONXVENTAS', 'DETALLESVENTASXCONDICIONES', 'DETALLESVENTASXFECHAS', 'DETALLESVENTASXVENDEDOR', 
        'CREDITOS', 'CREDITOSXBUSQUEDA', 'CREDITOSXBUSQUEDA', 'CREDITOSVENCIDOS', 'ABONOSCREDITOSVENTASXCAJAS', 'CREDITOSVENTASXCONDICIONES', 'CREDITOSVENTASXFECHAS', 'CREDITOSVENTASXCLIENTES', 'DETALLESCREDITOSVENTASXFECHAS', 'DETALLESCREDITOSVENTASXCLIENTE', 
        'NOTASCREDITO', 'NOTASCREDITOXCAJAS', 'NOTASCREDITOXFECHAS', 'NOTASCREDITOXCLIENTES'])){

        if($this->page==1){

        ################################# MEMBRETE LEGAL #################################
        if($_SESSION['acceso'] == "administradorG"){

            $logo = ( file_exists("fotos/logo_pdf.png") == "" ? "assets/images/null.png" : "fotos/logo_pdf.png");
            $logo2 = ( file_exists("fotos/logo_pdf2.png") == "" ? "assets/images/null.png" : "fotos/logo_pdf2.png");
                
            $con = new Login();
            $con = $con->ConfiguracionPorId();

            $this->Ln(2);
            $this->SetFont('Courier','B',14);
            $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
            $this->SetFillColor(255, 118, 118); // establece el color del fondo de la celda (en este caso es AZUL
            $this->Cell(85,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
            $this->Cell(165,5,mb_convert_encoding($con[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(85,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

            $this->Ln();
            $this->Cell(85,5,"",0,0,'C');
            $this->Cell(165,5,mb_convert_encoding($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$con[0]['cuit'],0,0,'C');
            $this->Cell(85,5,"",0,0,'C');

            if($con[0]['id_ciudad']!='0'){

            $this->Ln();
            $this->Cell(85,5,"",0,0,'C');
            $this->Cell(165,5,mb_convert_encoding($comuna = ($con[0]['id_comuna'] == '0' ? " " : $con[0]['comuna'])." ".$ciudad = ($con[0]['id_ciudad'] == '0' ? " " : $con[0]['ciudad']), 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(85,5,"",0,0,'C');

            }

            $this->Ln();
            $this->Cell(85,5,"",0,0,'C');
            $this->Cell(165,5,mb_convert_encoding($con[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(85,5,"",0,0,'C');

            $this->Ln();
            $this->Cell(85,5,"",0,0,'C');
            $this->Cell(165,5,"N TLF: ".$con[0]['tlfsucursal'],0,0,'C');
            $this->Cell(85,5,"",0,0,'C');

            $this->Ln();
            $this->Cell(85,5,"",0,0,'C');
            $this->Cell(165,5,mb_convert_encoding($con[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(85,5,"",0,0,'C');
            $this->Ln(10);

        } else { 

            $js   = new Login();
            $suc   = $js->SucursalesSessionPorId();

            $logo  = ( file_exists("fotos/sucursales/".$suc[0]['cuitsucursal'].".png") == "" ? "assets/images/null.png" : "fotos/sucursales/".$suc[0]['cuitsucursal'].".png");
            $logo2 = ( file_exists("fotos/logo_pdf.png") == "" ? "assets/images/null.png" : "fotos/logo_pdf.png");

            $this->Ln(2);
            $this->SetFont('Courier','B',14);
            $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
            $this->SetFillColor(255, 118, 118); // establece el color del fondo de la celda (en este caso es AZUL
            $this->Cell(85,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_horizontal_X'], $this->GetY()+$GLOBALS['logo1_horizontal_Y'], $GLOBALS['logo1_horizontal']),0,0,'C');
            $this->Cell(165,5,mb_convert_encoding($suc[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(85,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_horizontal_X'], $this->GetY()+$GLOBALS['logo2_horizontal_Y'], $GLOBALS['logo2_horizontal']),0,0,'C');

            $this->Ln();
            $this->Cell(85,5,"",0,0,'C');
            $this->Cell(165,5,mb_convert_encoding($suc[0]['documsucursal'] == '0' ? "" : $suc[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$suc[0]['cuitsucursal'],0,0,'C');
            $this->Cell(85,5,"",0,0,'C');

            if($suc[0]['id_ciudad']!='0'){

            $this->Ln();
            $this->Cell(85,5,"",0,0,'C');
            $this->Cell(165,5,mb_convert_encoding($comuna = ($suc[0]['id_comuna'] == '0' ? " " : $suc[0]['comuna'])." ".$ciudad = ($suc[0]['id_ciudad'] == '0' ? " " : $suc[0]['ciudad']), 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(85,5,"",0,0,'C');

            }

            $this->Ln();
            $this->Cell(85,5,"",0,0,'C');
            $this->Cell(165,5,mb_convert_encoding($suc[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(85,5,"",0,0,'C');

            $this->Ln();
            $this->Cell(85,5,"",0,0,'C');
            $this->Cell(165,5,"N TLF: ".$suc[0]['tlfsucursal'],0,0,'C');
            $this->Cell(85,5,"",0,0,'C');

            $this->Ln();
            $this->Cell(85,5,"",0,0,'C');
            $this->Cell(165,5,mb_convert_encoding($suc[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(85,5,"",0,0,'C');
            $this->Ln(10);
        }
        ################################# MEMBRETE LEGAL #################################
        }

    } elseif(in_array(decrypt($_GET['tipo']), ['CIUDADES', 'COMUNAS', 'DOCUMENTOS', 'TIPOMONEDA', 'TIPOCAMBIO', 'MEDIOSPAGOS', 'IMPUESTOS', 'BANCOS', 'FAMILIAS', 'SUBFAMILIAS', 'MARCAS', 'MODELOS', 'PRESENTACIONES', 'COLORES', 'ORIGENES', 'IMEIS', 'CODIGOBARRAS2', 'CAJAS', 'MOVIMIENTOS', 'MOVIMIENTOSXFECHAS', 'INFORMECAJASXFECHAS'])){

        if($this->page==1){

        ################################# MEMBRETE A4 #################################
        if($_SESSION['acceso'] == "administradorG"){

            $logo = ( file_exists("fotos/logo_pdf.png") == "" ? "assets/images/null.png" : "fotos/logo_pdf.png");
            $logo2 = ( file_exists("fotos/logo_pdf2.png") == "" ? "assets/images/null.png" : "fotos/logo_pdf2.png");
                
            $con = new Login();
            $con = $con->ConfiguracionPorId();

            $this->Ln(2);
            $this->SetFont('Courier','B',12);
            $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
            $this->SetFillColor(255, 118, 118); // establece el color del fondo de la celda (en este caso es AZUL
            $this->Cell(50,4,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
            $this->Cell(90,4,mb_convert_encoding($con[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(50,4,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

            $this->Ln();
            $this->Cell(50,4,"",0,0,'C');
            $this->Cell(90,4,mb_convert_encoding($con[0]['documsucursal'] == '0' ? "" : $con[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$con[0]['cuit'],0,0,'C');
            $this->Cell(50,4,"",0,0,'C');

            if($con[0]['id_ciudad']!='0'){

            $this->Ln();
            $this->Cell(50,4,"",0,0,'C');
            $this->Cell(90,4,mb_convert_encoding($comuna = ($con[0]['id_comuna'] == '0' ? " " : $con[0]['comuna'])." ".$ciudad = ($con[0]['id_ciudad'] == '0' ? " " : $con[0]['ciudad']), 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(50,4,"",0,0,'C');

            }

            $this->Ln();
            $this->Cell(50,4,"",0,0,'C');
            $this->Cell(90,4,mb_convert_encoding($con[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(50,4,"",0,0,'C');

            $this->Ln();
            $this->Cell(50,4,"",0,0,'C');
            $this->Cell(90,4,"N TLF: ".$con[0]['tlfsucursal'],0,0,'C');
            $this->Cell(50,4,"",0,0,'C');

            $this->Ln();
            $this->Cell(50,4,"",0,0,'C');
            $this->Cell(90,4,mb_convert_encoding($con[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(50,4,"",0,0,'C');
            $this->Ln(10);

        } else { 

            $js   = new Login();
            $suc   = $js->SucursalesSessionPorId();

            $logo  = ( file_exists("fotos/sucursales/".$suc[0]['cuitsucursal'].".png") == "" ? "assets/images/null.png" : "fotos/sucursales/".$suc[0]['cuitsucursal'].".png");
            $logo2 = ( file_exists("fotos/logo_pdf.png") == "" ? "assets/images/null.png" : "fotos/logo_pdf.png");

            $this->Ln(2);
            $this->SetFont('Courier','B',12);
            $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
            $this->SetFillColor(255, 118, 118); // establece el color del fondo de la celda (en este caso es AZUL
            $this->Cell(50,4,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
            $this->Cell(90,4,mb_convert_encoding($suc[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(50,4,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

            $this->Ln();
            $this->Cell(50,4,"",0,0,'C');
            $this->Cell(90,4,mb_convert_encoding($suc[0]['documsucursal'] == '0' ? "" : $suc[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$suc[0]['cuitsucursal'],0,0,'C');
            $this->Cell(50,4,"",0,0,'C');

            if($suc[0]['id_ciudad']!='0'){

            $this->Ln();
            $this->Cell(50,4,"",0,0,'C');
            $this->Cell(90,4,mb_convert_encoding($comuna = ($suc[0]['id_comuna'] == '0' ? " " : $suc[0]['comuna'])." ".$ciudad = ($suc[0]['id_ciudad'] == '0' ? " " : $suc[0]['ciudad']), 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(50,4,"",0,0,'C');

            }

            $this->Ln();
            $this->Cell(50,4,"",0,0,'C');
            $this->Cell(90,4,mb_convert_encoding($suc[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(50,4,"",0,0,'C');

            $this->Ln();
            $this->Cell(50,4,"",0,0,'C');
            $this->Cell(90,4,"N TLF: ".$suc[0]['tlfsucursal'],0,0,'C');
            $this->Cell(50,4,"",0,0,'C');

            $this->Ln();
            $this->Cell(50,4,"",0,0,'C');
            $this->Cell(90,4,mb_convert_encoding($suc[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
            $this->Cell(50,4,"",0,0,'C');
            $this->Ln(10);
        }
        ################################# MEMBRETE A4 #################################

        }
    }
}
########################### FUNCION PARA MOSTRAR EL HEADER ###########################






 
############################### REPORTES DE ADMINISTRACION ##############################

########################## FUNCION LISTAR CIUDADES ##############################
function TablaListarCiudades()
{
    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE CIUDADES',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(20,8,'N',1,0,'C', True);
    $this->Cell(30,8,'CDIGO',1,0,'C', True);
    $this->Cell(140,8,'NOMBRE DE CIUDAD',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarCiudades();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(20,30,140));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array(
            $reg[$i]['id_ciudad'],
            $reg[$i]["codciudad"],
            mb_convert_encoding($reg[$i]["ciudad"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CIUDADES ##############################

########################## FUNCION LISTAR COMUNAS ##############################
function TablaListarComunas()
{
    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE COMUNAS',0,0,'C');

    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(20,8,'N',1,0,'C', True);
    $this->Cell(30,8,'CDIGO',1,0,'C', True);
    $this->Cell(140,8,'NOMBRE DE COMUNA',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarComunas();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(20,30,140));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array(
            $reg[$i]['id_comuna'],
            $reg[$i]["codcomuna"],
            mb_convert_encoding($reg[$i]["comuna"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('Courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMUNAS ##############################

########################## FUNCION LISTAR TIPOS DE DOCUMENTOS ##########################
function TablaListarDocumentos()
{
    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE DOCUMENTOS TRIBUTARIOS',0,0,'C');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(50,8,'NOMBRE DE DOCUMENTO',1,0,'C', True);
    $this->Cell(105,8,'DESCRIPCIN DE DOCUMENTO',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarDocumentos();

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,20,50,105));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            mb_convert_encoding($reg[$i]["coddocumento"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["documento"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["descripcion"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR TIPOS DE DOCUMENTOS ##########################

########################## FUNCION LISTAR TIPOS DE MONEDA ##############################
function TablaListarTiposMonedas()
{
    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE TIPOS DE MONEDA',0,0,'C');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(65,8,'NOMBRE DE MONEDA',1,0,'C', True);
    $this->Cell(45,8,'SIGLAS',1,0,'C', True);
    $this->Cell(45,8,'SIMBOLO',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarTipoMoneda();

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,20,65,45,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            mb_convert_encoding($reg[$i]["codmoneda"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["moneda"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["siglas"], 'ISO-8859-1', 'UTF-8'),
            $tipo = ($reg[$i]["moneda"] == "EURO" ? chr(128) : $reg[$i]["simbolo"])));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR TIPOS DE MONEDA ##############################

########################## FUNCION LISTAR TIPOS DE CAMBIO ##############################
function TablaListarTiposCambio()
{
    $tra = new Login();
    $reg = $tra->ListarTipoCambio();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE TIPOS DE CAMBIO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE CAMBIO',1,0,'C', True);
    $this->Cell(35,8,'MONTO DE CAMBIO',1,0,'C', True);
    $this->Cell(35,8,'TIPO DE MONEDA',1,0,'C', True);
    $this->Cell(35,8,'FECHA DE INGRESO',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,70,35,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            mb_convert_encoding($reg[$i]["descripcioncambio"], 'ISO-8859-1', 'UTF-8'),
            number_format($reg[$i]["montocambio"], 2, '.', ','),
            $reg[$i]['moneda']."/".$reg[$i]['siglas'],
            date("d/m/Y",strtotime($reg[$i]['fechacambio']))));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR TIPOS DE CAMBIO ##############################

########################## FUNCION LISTAR MEDIOS DE PAGO ##############################
function TablaListarMediosPagos()
{
    $tra = new Login();
    $reg = $tra->ListarMediosPagos();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE FORMAS DE PAGO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(155,8,'NOMBRE DE PAGO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,20,155));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
   $this->Row(array($a++,
            $reg[$i]["codmediopago"],
            mb_convert_encoding($reg[$i]["mediopago"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR MEDIOS DE PAGO ##############################

########################## FUNCION LISTAR IMPUESTOS ##############################
function TablaListarImpuestos()
{
    $tra = new Login();
    $reg = $tra->ListarImpuestos();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE IMPUESTOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(60,8,'NOMBRE DE IMPUESTO',1,0,'C', True);
    $this->Cell(35,8,'VALOR(%)',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(35,8,'FECHA DE INGRESO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,20,60,35,25,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["codimpuesto"],
            mb_convert_encoding($reg[$i]["nomimpuesto"], 'ISO-8859-1', 'UTF-8'),
            number_format($reg[$i]["valorimpuesto"], 0, '.', '.'),
            $status = ($reg[$i]['statusimpuesto'] == 1 ? "ACTIVO" : "INACTIVO"),
            date("d/m/Y",strtotime($reg[$i]['fechaimpuesto']))));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR IMPUESTOS ##############################

########################## FUNCION LISTAR BANCOS ##############################
function TablaListarBancos()
{
    $tra = new Login();
    $reg = $tra->ListarBancos();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE BANCOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(155,8,'NOMBRE DE BANCO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,20,155));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["codbanco"],
            mb_convert_encoding($reg[$i]["nombanco"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR BANCOS ##############################

########################## FUNCION LISTAR FAMILIAS ##############################
function TablaListarFamilias()
{
    $tra = new Login();
    $reg = $tra->ListarFamilias();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE FAMILIAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(155,8,'NOMBRE DE FAMILIA',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,20,155));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["codfamilia"],
            mb_convert_encoding($reg[$i]["nomfamilia"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR FAMILIAS ##############################

########################## FUNCION LISTAR SUB-FAMILIAS ##############################
function TablaListarSubfamilias()
{
    $tra = new Login();
    $reg = $tra->ListarSubfamilias();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE SUB-FAMILIAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(80,8,'NOMBRE DE FAMILIA',1,0,'C', True);
    $this->Cell(80,8,'NOMBRE DE SUBFAMILIA',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,20,80,80));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["codsubfamilia"],
            mb_convert_encoding($reg[$i]["nomfamilia"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["nomsubfamilia"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR SUB-FAMILIAS ##############################

########################## FUNCION LISTAR MARCAS ##############################
function TablaListarMarcas()
{
    $tra = new Login();
    $reg = $tra->ListarMarcas();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE MARCAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(155,8,'NOMBRE DE MARCA',1,1,'C', True);
    

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,20,155));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["codmarca"],
            mb_convert_encoding($reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR MARCAS ##############################

########################## FUNCION LISTAR MODELOS ##############################
function TablaListarModelos()
{
    $tra = new Login();
    $reg = $tra->ListarModelos();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE MODELOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(80,8,'NOMBRE DE MARCA',1,0,'C', True);
    $this->Cell(80,8,'NOMBRE DE MODELO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,20,80,80));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["codmodelo"],
            mb_convert_encoding($reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["nommodelo"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR MODELOS ##############################

########################## FUNCION LISTAR PRESENTACIONES ##############################
function TablaListarPresentaciones()
{
    $tra = new Login();
    $reg = $tra->ListarPresentaciones();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE PRESENTACIONES',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(155,8,'NOMBRE DE PRESENTACIN',1,1,'C', True);
    

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,20,155));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["codpresentacion"],
            mb_convert_encoding($reg[$i]["nompresentacion"], 'ISO-8859-1', 'UTF-8')));
       }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRESENTACIONES ##############################

########################## FUNCION LISTAR COLORES ##############################
function TablaListarColores()
{
    $tra = new Login();
    $reg = $tra->ListarColores();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE COLORES',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(155,8,'NOMBRE DE COLOR',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,20,155));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["codcolor"],
            mb_convert_encoding($reg[$i]["nomcolor"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COLORES ##############################

########################## FUNCION LISTAR ORIGENES ##############################
function TablaListarOrigenes()
{
    $tra = new Login();
    $reg = $tra->ListarOrigenes();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE ORIGENES',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(155,8,'NOMBRE DE ORIGEN',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,20,155));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["codorigen"],
            mb_convert_encoding($reg[$i]["nomorigen"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR ORIGENES ##############################

########################## FUNCION LISTAR SUCURSALES ##############################
function TablaListarSucursales()
{
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(330,10,'LISTADO GENERAL DE SUCURSALES',0,0,'C');
    
    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE DOCUMENTO',1,0,'C', True);
    $this->Cell(60,8,'RAZN SOCIAL',1,0,'C', True);
    $this->Cell(20,8,'CIUDAD',1,0,'C', True);
    $this->Cell(30,8,'COMUNA',1,0,'C', True);
    $this->Cell(55,8,'DIRECCIN',1,0,'C', True);
    $this->Cell(40,8,'N DE TELFONO',1,0,'C', True);
    $this->Cell(35,8,'N DE DNI ',1,0,'C', True);
    $this->Cell(45,8,'ENCARGADO',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarSucursales();

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,35,60,20,30,55,40,35,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["cuitsucursal"],
        mb_convert_encoding($reg[$i]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['id_ciudad'] == '0' ? "********" : mb_convert_encoding($reg[$i]['ciudad'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['id_comuna'] == '0' ? "********" : mb_convert_encoding($reg[$i]['comuna'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["direcsucursal"], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["tlfsucursal"],
        $reg[$i]["dniencargado"],
        mb_convert_encoding($reg[$i]["nomencargado"], 'ISO-8859-1', 'UTF-8')));
        }
    }


    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR SUCURSALES ##############################

########################## FUNCION LISTAR USUARIOS ##############################
function TablaListarUsuarios()
{
    $tra = new Login();
    $reg = $tra->ListarUsuarios();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(330,10,'LISTADO GENERAL DE USUARIOS',0,0,'C');
    
    if($_SESSION['acceso'] == "administradorG"){

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DOCUMENTO',1,0,'C', True);
    $this->Cell(70,8,'NOMBRES Y APELLIDOS',1,0,'C', True);
    $this->Cell(25,8,'N TELFONO',1,0,'C', True);
    $this->Cell(60,8,'EMAIL',1,0,'C', True);
    $this->Cell(40,8,'USUARIO',1,0,'C', True);
    $this->Cell(40,8,'NIVEL',1,0,'C', True);
    $this->Cell(50,8,'SUCURSAL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,35,70,25,60,40,40,50));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["dni"],
        mb_convert_encoding($reg[$i]["nombres"], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["telefono"],
        mb_convert_encoding($reg[$i]["email"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["usuario"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["nivel"], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['codsucursal'] == '' ? "*********" : mb_convert_encoding($reg[$i]['nomsucursal'], 'ISO-8859-1', 'UTF-8')));
   }
 }
    } else {

    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DOCUMENTO',1,0,'C', True);
    $this->Cell(80,8,'NOMBRES Y APELLIDOS',1,0,'C', True);
    $this->Cell(25,8,'SEXO',1,0,'C', True);
    $this->Cell(45,8,'N DE TELFONO',1,0,'C', True);
    $this->Cell(60,8,'EMAIL',1,0,'C', True);
    $this->Cell(40,8,'USUARIO',1,0,'C', True);
    $this->Cell(40,8,'NIVEL',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,30,80,25,45,60,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["dni"],
        mb_convert_encoding($reg[$i]["nombres"], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["sexo"],
        $reg[$i]["telefono"],
        mb_convert_encoding($reg[$i]["email"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["usuario"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["nivel"], 'ISO-8859-1', 'UTF-8')));
            }
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR USUARIOS ##############################

########################## FUNCION LISTAR LOGS DE USUARIOS ##############################
function TablaListarLogs()
{
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(330,10,'LISTADO DE LOGS DE ACCESO DE USUARIOS',0,0,'C');
    
    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(35,8,'IP EQUIPO',1,0,'C', True);
    $this->Cell(45,8,'TIEMPO ENTRADA',1,0,'C', True);
    $this->Cell(145,8,'NAVEGADOR DE ACCESO',1,0,'C', True);
    $this->Cell(60,8,'PGINAS DE ACCESO',1,0,'C', True);
    $this->Cell(35,8,'USUARIO',1,1,'C', True);
    
    $tra = new Login();
    $reg = $tra->ListarLogs();

    if($reg==""){
    echo "";      
    } else {
    
    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,35,45,145,60,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            mb_convert_encoding($reg[$i]["ip"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["tiempo"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["detalles"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["paginas"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["usuario"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR LOGS DE USUARIOS ##############################

############################ REPORTES DE ADMINISTRACION #############################




























############################### REPORTES DE MANTENIMIENTO ##############################

########################## FUNCION LISTAR CLIENTES ##############################
function TablaListarClientes()
{
    $tra = new Login();
    $reg = $tra->ListarClientes();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(330,10,'LISTADO GENERAL DE CLIENTES',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(330,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(330,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(330,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE DOCUMENTO',1,0,'C', True);
    $this->Cell(60,8,'NOMBRES Y APELLIDOS',1,0,'C', True);
    $this->Cell(35,8,'N DE TELEFONO',1,0,'C', True);
    $this->Cell(75,8,'DIRECCIN DOMICILIARIA',1,0,'C', True);
    $this->Cell(60,8,'EMAIL',1,0,'C', True);
    $this->Cell(25,8,'TIPO',1,0,'C', True);
    $this->Cell(25,8,'CRDITO',1,1,'C', True);

    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,60,35,75,60,25,25));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]["documento"]." ".$reg[$i]["dnicliente"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($cliente = ($reg[$i]['tipocliente'] == 'NATURAL' ? $reg[$i]['nomcliente'] : $reg[$i]['razoncliente']), 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["tlfcliente"],
        mb_convert_encoding($ciudad = ($reg[$i]['id_ciudad'] == '0' ? "" : $reg[$i]['ciudad']."-").$comuna = ($reg[$i]['id_comuna'] == '0' ? "" : $reg[$i]['comuna']."-").$reg[$i]["direccliente"], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['emailcliente'],
        $reg[$i]["tipocliente"],
        number_format($reg[$i]["limitecredito"], 0, '.', '.')));
       }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CLIENTES ##############################

########################## FUNCION LISTAR CLIENTES X CREDITOS ACTIVOS ##############################
function TablaListarClientesxCreditos()
{
    $tra = new Login();
    $reg = $tra->ListarClientesxCreditosActivos();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(330,10,'LISTADO DE CRDITOS ACTIVOS A CLIENTES',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(90,8,'NOMBRES DE CLIENTES',1,0,'C', True);
    $this->Cell(35,8,'N DE TELEFONO',1,0,'C', True);
    $this->Cell(120,8,'DIRECCIN DOMICILIARIA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL CRDITO',1,0,'C', True);
    $this->Cell(35,8,'CRDITO VENCIDO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,90,35,120,40,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalCredito   = 0;
    $CreditoVencido = 0;
    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $TotalCredito   += $reg[$i]['TotalCredito'];
    $CreditoVencido += $reg[$i]['CreditoVencido'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]["documento"]." ".$reg[$i]["dnicliente"]."\n".$reg[$i]["nomcliente"], 'ISO-8859-1', 'UTF-8'),
        $tlfcliente = ($reg[$i]["tlfcliente"] == "" ? "******" : $reg[$i]["tlfcliente"]),
        mb_convert_encoding($direccliente = ($reg[$i]['direccliente'] == '' ? "******" : $reg[$i]['direccliente']).$comuna = ($reg[$i]['id_comuna'] == '0' ? "" : ", ".$reg[$i]['comuna']).$ciudad = ($reg[$i]['id_ciudad'] == '0' ? "" : " - ".$reg[$i]['ciudad']), 'ISO-8859-1', 'UTF-8'),
        $simbolo.number_format($reg[$i]["TotalCredito"] ?? 0.00, 0, '.', '.'),
        $simbolo.number_format($reg[$i]["CreditoVencido"] ?? 0.00, 0, '.', '.')));
    }
   
    $this->Cell(260,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalCredito, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($CreditoVencido, 0, '.', '.'),0,0,'L');
    $this->Ln();
        
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CLIENTES X CREDITOS ACTIVOS ##############################

############################################ REPORTES DE CLIENTES ############################################








############################################ REPORTES DE PROVEEDORES ############################################

########################## FUNCION LISTAR PROVEEDORES ##############################
function TablaListarProveedores()
{
    $tra = new Login();
    $reg = $tra->ListarProveedores();
    
    $this->SetFont('courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PROVEEDORES',0,0,'C');
    
    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO DE SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE DOCUMENTO',1,0,'C', True);
    $this->Cell(90,8,'NOMBRE DE PROVEEDOR',1,0,'C', True);
    $this->Cell(40,8,'N DE TELEFONO',1,0,'C', True);
    $this->Cell(90,8,'DIRECCIN DOMICILIARIA',1,0,'C', True);
    $this->Cell(60,8,'VENDEDOR',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {

    /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,90,40,90,60));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["documento"]." ".mb_convert_encoding($reg[$i]["cuitproveedor"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]['nomproveedor'], 'ISO-8859-1', 'UTF-8'),
            $reg[$i]['tlfproveedor'] == '' ? "*********" : $reg[$i]['tlfproveedor'],
            mb_convert_encoding($direcproveedor = ($reg[$i]['direcproveedor'] == '' ? "******" : $reg[$i]['direcproveedor']).$comuna = ($reg[$i]['id_comuna'] == '0' ? "" : ", ".$reg[$i]['comuna']).$ciudad = ($reg[$i]['id_ciudad'] == '0' ? "" : " - ".$reg[$i]['ciudad']), 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["vendedor"], 'ISO-8859-1', 'UTF-8')));
        }
    }


    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PROVEEDORES ##############################

########################## FUNCION FACTURA PEDIDO ##############################
function FacturaPedido()
{   
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################
        
    $tra       = new Login();
    $reg       = $tra->PedidosPorId();
    $simbolo   = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra = "Courier";

    //Logo
    if (isset($reg[0]['cuitsucursal'])) {
        if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
           $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
           $this->Image($logo, 15, 11, 30, 16, "PNG");
        } else {
           $logo = "fotos/logo_principal.png";
           $this->Image($logo, 15, 10, 40, 16, "PNG");                         
        }                                      
    }

    ######################## BLOQUE N 1 FACTURA ##########################   
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 10, 190, 17, '1.5', '');
    
    $this->SetFillColor(229);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(98, 12, 12, 12, '1.5', 'F');

    $this->SetFillColor(229);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(98, 12, 12, 12, '1.5', '');

    $this->SetFont($TipoLetra,'B',16);
    $this->SetXY(101, 14);
    $this->Cell(20, 5, 'P', 0 , 0);
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(98, 19);
    $this->Cell(20, 5, 'Pedido', 0, 0);
    
    $this->SetFont($TipoLetra,'B',11);
    $this->SetXY(124, 12);
    $this->Cell(20, 5, 'N DE FACTURA ', 0, 0);
    $this->SetFont($TipoLetra,'B',11);
    $this->SetXY(176, 12);
    $this->Cell(22, 5,$reg[0]['codfactura'], 0, 0, "R");

    $this->SetFont($TipoLetra,'B',9);
    $this->SetXY(124, 16);
    $this->Cell(20, 5, 'FECHA DE PEDIDO ', 0, 0);
    $this->SetFont($TipoLetra,'',9);
    $this->SetXY(177, 16);
    $this->Cell(20, 5,date("d/m/Y H:i:s",strtotime($reg[0]['fechapedido'])), 0, 0, "R");

    $this->SetFont($TipoLetra,'B',9);
    $this->SetXY(124, 20);
    $this->Cell(20, 5, 'FECHA DE EMISIN', 0, 0);
    $this->SetFont($TipoLetra,'',9);
    $this->SetXY(177, 20);
    $this->Cell(20, 5,date("d/m/Y H:i:s"), 0, 0, "R");
    ############################### BLOQUE N 1 FACTURA ############################### 

    ############################### BLOQUE N 2 SUCURSAL ##############################   
    //Bloque de datos de empresa
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 29, 190, 18, '1.5', '');
    //DATOS DE SUCURSAL LINEA 1
    $this->SetFont($TipoLetra,'B',9);
    $this->SetXY(10, 30);
    $this->Cell(190, 4, 'DATOS DE SUCURSAL ', 0, 0);
    //DATOS DE SUCURSAL LINEA 1

    //DATOS DE SUCURSAL LINEA 2
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(10, 34);
    $this->Cell(25, 4, 'RAZN SOCIAL:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(35, 34);
    $this->CellFitSpace(60, 4,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(95, 34);
    $this->Cell(40, 4, 'N DE '.$documento = ($reg[0]['documsucursal'] == '0' ? "REG.:" : mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8').":"), 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(135, 34);
    $this->CellFitSpace(20, 4,mb_convert_encoding($reg[0]['cuitsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(155, 34);
    $this->Cell(20, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(175, 34);
    $this->CellFitSpace(25, 4,$tlf = ($reg[0]['tlfsucursal'] == '' ? " " : $reg[0]['tlfsucursal']), 0, 0);
    //DATOS DE SUCURSAL LINEA 2

    //DATOS DE SUCURSAL LINEA 3
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(10, 38);
    $this->Cell(25, 4, 'DIRECCIN:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(35, 38);
    $this->CellFitSpace(100, 4,$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8')).$comuna = ($reg[0]['id_comuna'] == '0' ? "" : " ".mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))." ".mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(135, 38);
    $this->Cell(20, 4, 'EMAIL:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(155, 38);
    $this->CellFitSpace(45, 4,$correo = ($reg[0]['correosucursal'] == '' ? " " : $reg[0]['correosucursal']), 0, 0);
    //DATOS DE SUCURSAL LINEA 3

    //DATOS DE SUCURSAL LINEA 4
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(10, 42);
    $this->Cell(25, 4, 'RESPONSABLE:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(35, 42);
    $this->CellFitSpace(60, 4,mb_convert_encoding($reg[0]['nomencargado'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(95, 42);
    $this->CellFitSpace(40, 4, 'N DE '.$documento = ($reg[0]['documencargado'] == '0' ? "DOC.:" : $reg[0]['documento2'].":"), 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(135, 42);
    $this->CellFitSpace(20, 4,$reg[0]['dniencargado'], 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(155, 42);
    $this->Cell(20, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(175, 42);
    $this->CellFitSpace(25, 4,$tlf = ($reg[0]['tlfencargado'] == '' ? " " : $reg[0]['tlfencargado']), 0, 0);
    //DATOS DE SUCURSAL LINEA 4
    ############################# BLOQUE N 2 SUCURSAL ##############################   

    ############################# BLOQUE N 3 PROVEEDOR #################################  
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 49, 190, 14, '1.5', '');

    $this->SetFont($TipoLetra,'B',9);
    $this->SetXY(10, 50);
    $this->Cell(190, 4, 'DATOS DEL PROVEEDOR', 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(10, 54);
    $this->Cell(20, 4, 'PROVEEDOR:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(30, 54);
    $this->Cell(65, 4,mb_convert_encoding($reg[0]['nomproveedor'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(95, 54);
    $this->CellFitSpace(30, 4, 'N DE '.$documento = ($reg[0]['documproveedor'] == '0' ? "DOC.:" : $reg[0]['documento3'].":"), 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(125, 54);
    $this->Cell(30, 4,mb_convert_encoding($reg[0]['cuitproveedor'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(155, 54);
    $this->Cell(20, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(175, 54);
    $this->Cell(25, 4,$reg[0]['tlfproveedor'], 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(10, 58);
    $this->Cell(20, 4, 'DIRECCIN:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(30, 58);
    $this->CellFitSpace(65, 4,getSubString($ciudad = ($reg[0]['id_ciudad2'] == '' ? "" : mb_convert_encoding($reg[0]['ciudad2'], 'ISO-8859-1', 'UTF-8')).$comuna = ($reg[0]['id_comuna2'] == '' ? "" : " ".mb_convert_encoding($reg[0]['comuna2'], 'ISO-8859-1', 'UTF-8'))." ".mb_convert_encoding($reg[0]['direcproveedor'], 'ISO-8859-1', 'UTF-8'),38), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(95, 58);
    $this->Cell(15, 4, 'EMAIL:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(110, 58);
    $this->CellFitSpace(40, 4,$email = ($reg[0]['emailproveedor'] == '' ? "" : $reg[0]['emailproveedor']), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(150, 58);
    $this->Cell(18, 4, 'VENDEDOR:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(168, 58);
    $this->CellFitSpace(32, 4,getSubString(mb_convert_encoding($reg[0]['vendedor'], 'ISO-8859-1', 'UTF-8'),22), 0, 0); 
    ############################## BLOQUE N 3 PROVEEDOR ###############################  

    ################################# BLOQUE N 4 #######################################   
    $this->SetFont($TipoLetra,'B',9);
    $this->SetXY(10, 65);
    $this->SetDrawColor(3,3,3);
    $this->SetTextColor(3,3,3);
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->CellFitSpace(8, 10,"N", 1, 0, 'C', True);
    $this->CellFitSpace(55, 10,"DESCRIPCIN DE PRODUCTO", 1, 0, 'C', True);
    $this->CellFitSpace(15, 10,"MARCA", 1, 0, 'C', True);
    $this->CellFitSpace(15, 10,"MODELO", 1, 0, 'C', True);
    $this->CellFitSpace(10, 10,"CANT", 1, 0, 'C', True);
    $this->MultiAlignCell2(20, 10,"PRECIO UNITARIO", 1, 0, 'C', True);
    $this->MultiAlignCell2(20, 10,"VALOR TOTAL", 1, 0, 'C', True);
    $this->CellFitSpace(15, 10,"DESC %", 1, 0, 'C', True);
    $this->CellFitSpace(12, 10,$NomImpuesto, 1, 0, 'C', True);
    $this->MultiAlignCell2(20, 10,"VALOR NETO", 1, 1, 'C', True);
    ################################# BLOQUE N 4 ####################################### 

    ################################# BLOQUE N 5 #######################################
    $tra = new Login();
    $detalle = $tra->VerDetallesPedidos();
    $cantidad = 0;
    $SubTotal = 0;

    $this->SetWidths(array(8,55,15,15,10,20,20,15,12,20));
    $this->SetAligns(array('L','L','L','C','C','C','C','C','C','C'));

    $a=1;
    for($i=0;$i<sizeof($detalle);$i++){ 
    $cantidad += $detalle[$i]['cantidad'];
    $valortotal = $detalle[$i]["preciocompra"]*$detalle[$i]["cantidad"];
    $SubTotal += $detalle[$i]['valorneto'];

    $this->SetX(10);
    $this->SetFont($TipoLetra,'',7);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->RowFacture(array($a++,
        mb_convert_encoding($detalle[$i]["producto"]." ".$detalle[$i]["condicion"].$descripcion = ($detalle[$i]["producto"] != "" ? "\n".$detalle[$i]["descripcion"] : "").$imei = ($detalle[$i]["imei"] != "" ? "\nIMEI: ".$detalle[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]["codmarca"] == '0' ? "******" : mb_convert_encoding($detalle[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]["codmodelo"] == '0' ? "******" : mb_convert_encoding($detalle[$i]["nommodelo"], 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]['cantidad'],
        $simbolo.number_format($detalle[$i]['preciocompra'], 0, '.', '.'),
        $simbolo.number_format($detalle[$i]['valortotal'], 0, '.', '.'),
        number_format($detalle[$i]['descfactura'], 0, '.', '.'),
        $detalle[$i]["ivaproducto"] == '0.00' ? "(E)" : number_format($detalle[$i]["ivaproducto"], 0, '.', '.'),
        $simbolo.number_format($detalle[$i]['valorneto'], 0, '.', '.')));
    }
    ################################# BLOQUE N 5 ####################################### 

    ########################### BLOQUE N 6 #############################
    $this->Ln();
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(110,5,'INFORMACIN ADICIONAL',1,0,'C', True);
    $this->Cell(4,5,"",0,0,'C');
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(36,5,'SUBTOTAL ',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(110,5,'CANTIDAD DE PRODUCTOS: '.number_format($cantidad, 2, '.', '.'),1,0,'L');
    $this->Cell(4,5,"",0,0,'C');
    $this->CellFitSpace(36,5,'GRAVADO ('.number_format($reg[0]["iva"], 0, '.', '.').'%):',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["subtotalivasi"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(110,5,'TIPO DE DOCUMENTO: FACTURA',1,0,'L');
    $this->Cell(4,5,"",0,0,'C');
    $this->CellFitSpace(36,5,'EXENTO (0%):',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["subtotalivano"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(110,5,'REGISTRADO POR: '.mb_convert_encoding($reg[0]["nombres"], 'ISO-8859-1', 'UTF-8'),1,0,'L');

    $this->Cell(4,5,"",0,0,'C');
    $this->CellFitSpace(36,5,$NomImpuesto." (".number_format($reg[0]["iva"], 0, '.', '.')."%):",1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["totaliva"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(110,5,"",0,0,'L');
    $this->Cell(4,5,"",0,0,'C');
    $this->CellFitSpace(36,5,'DESCONTADO %:',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["descontado"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)

    $this->Cell(110,5,"",0,0,'L');
    $this->Cell(4,5,"",0,0,'C');
    $this->CellFitSpace(36,5,'DESC % ('.number_format($reg[0]["descuento"], 0, '.', '.').'%):',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["totaldescuento"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(110,5,"",0,0,'L');
    $this->Cell(4,5,"",0,0,'C');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(36,5,'IMPORTE TOTAL:',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["totalpago"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    if($reg[0]['observaciones'] != ''){
    //Linea de membrete Nro 4
    $this->SetFont($TipoLetra,'B',10);
    $this->MultiCell(190,5,$this->SetFont($TipoLetra,'B',10).'OBSERVACIONES: '.$reg[0]['observaciones'] == '' ? "**********" : mb_convert_encoding($reg[0]['observaciones'], 'ISO-8859-1', 'UTF-8'),0,'J');
    }
    ################################# BLOQUE N 6 ####################################### 
    $this->Ln();
}
########################## FUNCION FACTURA PEDIDO ##############################

########################## FUNCION LISTAR PEDIDOS ##############################
function TablaListarPedidos()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "Impuesto" : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarPedidos();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PEDIDOS A PROVEEDORES',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(80,8,'DESCRIPCIN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(35,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(40,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(40,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,80,30,25,35,40,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($documproveedor = ($reg[$i]['documproveedor'] == '0' ? "DOCUMENTO" : $reg[$i]['documento3'])." ".$reg[$i]['cuitproveedor'].": ".$reg[$i]['nomproveedor'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechapedido'])),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(155,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PEDIDOS ##############################

########################## FUNCION LISTAR PEDIDOS POR PROVEEDORES ##############################
function TablaListarPedidosxProveedor()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "Impuesto" : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarPedidosxProveedor();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PEDIDOS POR PROVEEDORES',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"N DE ".$documento = ($reg[0]['documproveedor'] == '0' ? "DOCUMENTO" : mb_convert_encoding($reg[0]['documento3'] ?? "******", 'ISO-8859-1', 'UTF-8').": ".$reg[0]["cuitproveedor"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"PROVEEDOR: ".mb_convert_encoding($reg[0]['nomproveedor'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"N DE TELEFONO: ".$tlfproveedor = ($reg[0]['tlfproveedor'] == "" ? "********" : $reg[0]['tlfproveedor']),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DIRECCIN DOMICILIARIA: ".$direcproveedor = ($reg[0]['direcproveedor'] == "" ? "********" : mb_convert_encoding($reg[0]['direcproveedor'], 'ISO-8859-1', 'UTF-8')),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(65,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(45,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(35,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(40,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(40,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,65,45,25,35,40,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($observaciones = ($reg[$i]["observaciones"] == "" ? "********" : $reg[$i]["observaciones"]), 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechapedido'])),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }

    $this->Cell(155,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PEDIDOS POR PROVEEDORES ##############################

########################## FUNCION LISTAR PEDIDOS POR FECHAS ##############################
function TablaListarPedidosxFechas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "Impuesto" : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarPedidosxFechas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PEDIDOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(80,8,'DESCRIPCIN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(35,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(40,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(40,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,80,30,25,35,40,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($documproveedor = ($reg[$i]['documproveedor'] == '0' ? "DOCUMENTO" : $reg[$i]['documento3'])." ".$reg[$i]['cuitproveedor'].": ".$reg[$i]['nomproveedor'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechapedido'])),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(155,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PEDIDOS POR FECHAS ##############################

############################### REPORTES DE MANTENIMIENTO ###########################






















############################### REPORTES DE PRODUCTOS ###########################

####################### FUNCION LISTAR PRODUCTOS ##############################
function TablaListarProductos()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarProductos(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PRODUCTOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(25,8,'MARCA',1,0,'C', True);
    $this->Cell(25,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DCTO %',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(30,8,'P. COMPRA',1,0,'C', True);
    $this->Cell(30,8,'P. MAYOR',1,0,'C', True);
    $this->Cell(30,8,'P. MENOR',1,0,'C', True);
    $this->Cell(30,8,'P. PBLICO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,25,60,25,25,20,20,25,30,30,30,30));

    $a=1;
    $TotalCompra    = 0;
    $TotalMenor     = 0;
    $TotalMayor     = 0;
    $TotalPublico   = 0;
    $TotalArticulos = 0;
    
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalCompra    += $reg[$i]['preciocompra'];
    $TotalMayor     += $reg[$i]['precioxmayor'];
    $TotalMenor     += $reg[$i]['precioxmenor'];
    $TotalPublico   += $reg[$i]['precioxpublico'];
    $TotalArticulos += $reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "******" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivaproducto'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $reg[$i]['existencia'],
        $simbolo.number_format($reg[$i]['preciocompra'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmayor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmenor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxpublico'], 0, '.', '.')));
    }
   
    $this->Cell(190,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalCompra, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMayor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMenor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalPublico, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRODUCTOS ##############################

####################### FUNCION LISTAR PRODUCTOS POR SUCURSALES ##############################
function TablaListarProductosxSucursales()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarProductosxSucursales(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PRODUCTOS POR SUCURSAL',0,0,'C');

    if(!empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    } 
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(25,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(25,8,'DCTO %',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(30,8,'P. MAYOR',1,0,'C', True);
    $this->Cell(30,8,'P. MENOR',1,0,'C', True);
    $this->Cell(30,8,'P. PBLICO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,25,70,30,30,25,25,25,30,30,30));

    $a=1;
    $TotalCompra    = 0;
    $TotalMenor     = 0;
    $TotalMayor     = 0;
    $TotalPublico   = 0;
    $TotalArticulos = 0;
    
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalCompra    += $reg[$i]['preciocompra'];
    $TotalMayor     += $reg[$i]['precioxmayor'];
    $TotalMenor     += $reg[$i]['precioxmenor'];
    $TotalPublico   += $reg[$i]['precioxpublico'];
    $TotalArticulos += $reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "******" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
            $reg[$i]['ivaproducto'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
            number_format($reg[$i]['descproducto'], 0, '.', '.'),
            $reg[$i]['existencia'],
            $simbolo.number_format($reg[$i]['precioxmayor'], 0, '.', '.'),
            $simbolo.number_format($reg[$i]['precioxmenor'], 0, '.', '.'),
            $simbolo.number_format($reg[$i]['precioxpublico'], 0, '.', '.')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRODUCTOS POR SUCURSALES ##############################

####################### FUNCION LISTAR PRODUCTOS EN STOCK OPTIMO ##############################
function TablaListarProductosOptimo()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarProductosOptimo(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PRODUCTOS EN STOCK PTIMO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(50,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(20,8,'MARCA',1,0,'C', True);
    $this->Cell(20,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DCTO %',1,0,'C', True);
    $this->Cell(25,8,'STOCK PT.',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(30,8,'P. COMPRA',1,0,'C', True);
    $this->Cell(30,8,'P. MAYOR',1,0,'C', True);
    $this->Cell(30,8,'P. MENOR',1,0,'C', True);
    $this->Cell(30,8,'P. PBLICO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,50,20,20,20,20,25,25,30,30,30,30));

    $a=1;
    $TotalCompra    = 0;
    $TotalMenor     = 0;
    $TotalMayor     = 0;
    $TotalPublico   = 0;
    $TotalArticulos = 0;
    
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalCompra    += $reg[$i]['preciocompra'];
    $TotalMayor     += $reg[$i]['precioxmayor'];
    $TotalMenor     += $reg[$i]['precioxmenor'];
    $TotalPublico   += $reg[$i]['precioxpublico'];
    $TotalArticulos += $reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "******" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivaproducto'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $reg[$i]['stockoptimo'],
        $reg[$i]['existencia'],
        $simbolo.number_format($reg[$i]['preciocompra'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmayor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmenor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxpublico'], 0, '.', '.')));
    }
   
    $this->Cell(190,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalCompra, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMayor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMenor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalPublico, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRODUCTOS EN STOCK OPTIMO ##############################

####################### FUNCION LISTAR PRODUCTOS EN STOCK MEDIO ##############################
function TablaListarProductosMedio()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarProductosMedio(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PRODUCTOS EN STOCK MEDIO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(50,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(20,8,'MARCA',1,0,'C', True);
    $this->Cell(20,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DCTO %',1,0,'C', True);
    $this->Cell(25,8,'STOCK MED.',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(30,8,'P. COMPRA',1,0,'C', True);
    $this->Cell(30,8,'P. MAYOR',1,0,'C', True);
    $this->Cell(30,8,'P. MENOR',1,0,'C', True);
    $this->Cell(30,8,'P. PBLICO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,50,20,20,20,20,25,25,30,30,30,30));

    $a=1;
    $TotalCompra    = 0;
    $TotalMenor     = 0;
    $TotalMayor     = 0;
    $TotalPublico   = 0;
    $TotalArticulos = 0;
    
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalCompra    += $reg[$i]['preciocompra'];
    $TotalMayor     += $reg[$i]['precioxmayor'];
    $TotalMenor     += $reg[$i]['precioxmenor'];
    $TotalPublico   += $reg[$i]['precioxpublico'];
    $TotalArticulos += $reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "******" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivaproducto'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $reg[$i]['stockmedio'],
        $reg[$i]['existencia'],
        $simbolo.number_format($reg[$i]['preciocompra'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmayor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmenor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxpublico'], 0, '.', '.')));
    }

   
    $this->Cell(190,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalCompra, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMayor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMenor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalPublico, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRODUCTOS EN STOCK MEDIO ##############################

####################### FUNCION LISTAR PRODUCTOS EN STOCK MINIMO ##############################
function TablaListarProductosMinimo()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarProductosMinimo(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PRODUCTOS EN STOCK MINIMO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(50,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(20,8,'MARCA',1,0,'C', True);
    $this->Cell(20,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DCTO %',1,0,'C', True);
    $this->Cell(25,8,'STOCK MIN.',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(30,8,'P. COMPRA',1,0,'C', True);
    $this->Cell(30,8,'P. MAYOR',1,0,'C', True);
    $this->Cell(30,8,'P. MENOR',1,0,'C', True);
    $this->Cell(30,8,'P. PBLICO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,50,20,20,20,20,25,25,30,30,30,30));

    $a=1;
    $TotalCompra    = 0;
    $TotalMenor     = 0;
    $TotalMayor     = 0;
    $TotalPublico   = 0;
    $TotalArticulos = 0;
    
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalCompra    += $reg[$i]['preciocompra'];
    $TotalMayor     += $reg[$i]['precioxmayor'];
    $TotalMenor     += $reg[$i]['precioxmenor'];
    $TotalPublico   += $reg[$i]['precioxpublico'];
    $TotalArticulos += $reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "******" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivaproducto'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $reg[$i]['stockminimo'],
        $reg[$i]['existencia'],
        $simbolo.number_format($reg[$i]['preciocompra'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmayor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmenor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxpublico'], 0, '.', '.')));
    }
   
    $this->Cell(190,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalCompra, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMayor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMenor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalPublico, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRODUCTOS EN STOCK MINIMO ##############################

########################## FUNCION LISTAR PRODUCTOS EN STOCK CERO ##############################
function TablaListarProductosCero()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarProductosCero(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PRODUCTOS SIN EXISTENCIA',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(25,8,'MARCA',1,0,'C', True);
    $this->Cell(25,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DCTO %',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(30,8,'P. COMPRA',1,0,'C', True);
    $this->Cell(30,8,'P. MAYOR',1,0,'C', True);
    $this->Cell(30,8,'P. MENOR',1,0,'C', True);
    $this->Cell(30,8,'P. PBLICO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,65,25,25,20,20,25,30,30,30,30));

    $a=1;
    $TotalCompra    = 0;
    $TotalMenor     = 0;
    $TotalMayor     = 0;
    $TotalPublico   = 0;
    $TotalArticulos = 0;
    
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalCompra    += $reg[$i]['preciocompra'];
    $TotalMayor     += $reg[$i]['precioxmayor'];
    $TotalMenor     += $reg[$i]['precioxmenor'];
    $TotalPublico   += $reg[$i]['precioxpublico'];
    $TotalArticulos += $reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "******" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivaproducto'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $reg[$i]['existencia'],
        $simbolo.number_format($reg[$i]['preciocompra'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmayor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmenor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxpublico'], 0, '.', '.')));
    }

   
    $this->Cell(190,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalCompra, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMayor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMenor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalPublico, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRODUCTOS EN STOCK CERO ##############################

####################### FUNCION LISTAR PRODUCTOS EN FECHAS OPTIMO ##############################
function TablaListarProductosFechasOptimo()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarProductosFechasOptimo(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PRODUCTOS EN FECHA OPTIMO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(50,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(20,8,'MARCA',1,0,'C', True);
    $this->Cell(20,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DCTO %',1,0,'C', True);
    $this->Cell(25,8,'STOCK PT.',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(30,8,'P. COMPRA',1,0,'C', True);
    $this->Cell(30,8,'P. MAYOR',1,0,'C', True);
    $this->Cell(30,8,'P. MENOR',1,0,'C', True);
    $this->Cell(30,8,'P. PBLICO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,50,20,20,20,20,25,25,30,30,30,30));

    $a=1;
    $TotalCompra    = 0;
    $TotalMenor     = 0;
    $TotalMayor     = 0;
    $TotalPublico   = 0;
    $TotalArticulos = 0;
    
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalCompra    += $reg[$i]['preciocompra'];
    $TotalMayor     += $reg[$i]['precioxmayor'];
    $TotalMenor     += $reg[$i]['precioxmenor'];
    $TotalPublico   += $reg[$i]['precioxpublico'];
    $TotalArticulos += $reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "******" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivaproducto'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $reg[$i]['stockoptimo'],
        $reg[$i]['existencia'],
        $simbolo.number_format($reg[$i]['preciocompra'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmayor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmenor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxpublico'], 0, '.', '.')));
    }
   
    $this->Cell(190,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalCompra, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMayor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMenor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalPublico, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRODUCTOS EN FECHAS OPTIMO ##############################

####################### FUNCION LISTAR PRODUCTOS EN FECHAS MEDIO ##############################
function TablaListarProductosFechasMedio()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarProductosFechasMedio(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PRODUCTOS EN FECHA MEDIO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(50,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(20,8,'MARCA',1,0,'C', True);
    $this->Cell(20,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DCTO %',1,0,'C', True);
    $this->Cell(25,8,'STOCK MED.',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(30,8,'P. COMPRA',1,0,'C', True);
    $this->Cell(30,8,'P. MAYOR',1,0,'C', True);
    $this->Cell(30,8,'P. MENOR',1,0,'C', True);
    $this->Cell(30,8,'P. PBLICO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,50,20,20,20,20,25,25,30,30,30,30));

    $a=1;
    $TotalCompra    = 0;
    $TotalMenor     = 0;
    $TotalMayor     = 0;
    $TotalPublico   = 0;
    $TotalArticulos = 0;
    
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalCompra    += $reg[$i]['preciocompra'];
    $TotalMayor     += $reg[$i]['precioxmayor'];
    $TotalMenor     += $reg[$i]['precioxmenor'];
    $TotalPublico   += $reg[$i]['precioxpublico'];
    $TotalArticulos += $reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "******" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivaproducto'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $reg[$i]['stockmedio'],
        $reg[$i]['existencia'],
        $simbolo.number_format($reg[$i]['preciocompra'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmayor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmenor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxpublico'], 0, '.', '.')));
    }
   
    $this->Cell(190,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalCompra, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMayor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMenor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalPublico, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRODUCTOS EN FECHAS MEDIO ##############################

####################### FUNCION LISTAR PRODUCTOS EN FECHAS MINIMO ##############################
function TablaListarProductosFechasMinimo()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarProductosFechasMinimo(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PRODUCTOS EN FECHA MINIMO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(50,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(20,8,'MARCA',1,0,'C', True);
    $this->Cell(20,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DCTO %',1,0,'C', True);
    $this->Cell(25,8,'STOCK MIN.',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(30,8,'P. COMPRA',1,0,'C', True);
    $this->Cell(30,8,'P. MAYOR',1,0,'C', True);
    $this->Cell(30,8,'P. MENOR',1,0,'C', True);
    $this->Cell(30,8,'P. PBLICO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,50,20,20,20,20,25,25,30,30,30,30));

    $a=1;
    $TotalCompra    = 0;
    $TotalMenor     = 0;
    $TotalMayor     = 0;
    $TotalPublico   = 0;
    $TotalArticulos = 0;
    
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalCompra    += $reg[$i]['preciocompra'];
    $TotalMayor     += $reg[$i]['precioxmayor'];
    $TotalMenor     += $reg[$i]['precioxmenor'];
    $TotalPublico   += $reg[$i]['precioxpublico'];
    $TotalArticulos += $reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "******" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivaproducto'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $reg[$i]['stockminimo'],
        $reg[$i]['existencia'],
        $simbolo.number_format($reg[$i]['preciocompra'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmayor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxmenor'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['precioxpublico'], 0, '.', '.')));
    }
   
    $this->Cell(190,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalCompra, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMayor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalMenor, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalPublico, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PRODUCTOS EN FECHAS MINIMO ##############################

##################### FUNCION LISTAR CODIGO DE BARRAS DE PRODUCTOS #####################
function TablaListarCodigoBarras()
{
    $tra = new Login();
    $reg = $tra->ListarCodigoBarra();

    if(empty($reg)){
    echo "";      
    } else {

    $this->SetFont('Courier','B',14); 
    $this->Ln();
    $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["nomsucursal"],0,0,'L');
    $this->Ln();
    $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    $this->Ln();
    $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();

    $ancho_etiqueta     = 46;
    $alto_etiqueta      = 30;
    $barcode_altura_deseada = 10; // Altura deseada para el cdigo de barras en el PDF (aproximada)
    $margen_x           = 10;
    $margen_y           = 30;
    $cols               = 4;
    $rows               = 8;
    $etiquetas_por_pagina = $cols * $rows;
    $ruta_temporal      = 'temp_barcode/'; // Asegrate de que esta carpeta exista y tenga permisos de escritura

    // Crear la carpeta temporal si no existe
    if (!is_dir($ruta_temporal)) {
        mkdir($ruta_temporal, 0777, true);
    }

    for ($i = 0; $i < sizeof($reg); $i++) {
        if ($i > 0 && $i % $etiquetas_por_pagina == 0) {
            $this->AddPage();
        }

        $pos_en_pagina = $i % $etiquetas_por_pagina;
        $fila = floor($pos_en_pagina / $cols);
        $col = $pos_en_pagina % $cols;

        $x = $margen_x + $col * $ancho_etiqueta;
        $y = $margen_y + $fila * $alto_etiqueta;

        $this->Rect($x, $y, $ancho_etiqueta, $alto_etiqueta);

        $this->SetXY($x + 1, $y + 1);
        $this->SetFont('Arial', 'B', 8);
        $this->MultiCell($ancho_etiqueta - 2, 4, mb_convert_encoding($reg[$i]['producto'], 'ISO-8859-1', 'UTF-8'), 0, 'C');

        // Generar el nombre del archivo temporal para el cdigo de barras
        $codigobarra = ($reg[$i]["codigobarra"] == "" ? $reg[$i]["codproducto"] : $reg[$i]["codigobarra"]);
        $nombre_archivo_temporal = $ruta_temporal . 'barcode_' . $codigobarra . '_' . $i . '.png';

        // Calcular la posicin y tamao de la imagen del cdigo de barras en el PDF
        $barcode_x_pdf = $x + ($ancho_etiqueta * 0.1);
        $barcode_y_pdf = $y + 9; // Ajusta este valor segn necesites
        $barcode_ancho_pdf = $ancho_etiqueta * 0.8;
        // La altura se ajustar proporcionalmente al ancho si mantenemos las proporciones

        // Generar la imagen del cdigo de barras guardndola en el archivo temporal
        barcode($nombre_archivo_temporal, $codigobarra, 40, 'horizontal', 'code128', false, 1); // Ajusta los parmetros de 'barcode' si es necesario

        // Insertar la imagen del cdigo de barras en el PDF
        if (file_exists($nombre_archivo_temporal)) {
            $this->Image($nombre_archivo_temporal, $barcode_x_pdf, $barcode_y_pdf, $barcode_ancho_pdf);
            // Eliminar el archivo temporal despus de insertarlo
            unlink($nombre_archivo_temporal);

            // Mostrar el cdigo de barras debajo de la imagen
            $texto_y = $barcode_y_pdf + $barcode_altura_deseada + 2; // Ajusta el '2' para el espacio vertical
            $this->SetXY($barcode_x_pdf, $texto_y);
            $this->SetFont('Arial', '', 10); // Puedes ajustar la fuente y el tamao
            $this->Cell($barcode_ancho_pdf, 2, $codigobarra, 0, 0, 'C'); // 'C' para centrar el texto
        }

        // Imprimir el precio
        $precio_y = $y + $alto_etiqueta - 2 - 3;
        $this->SetXY($x + 2, $precio_y);
        $this->SetFont('Arial', 'B', 10);
        $this->Cell($ancho_etiqueta - 4, 3, $reg[$i]['simbolo'] . ' ' . number_format($reg[$i]['precioxpublico'], 0, '.', '.'), 0, 0, 'C');
    }

    // Eliminar la carpeta temporal si est vaca (opcional)
    $archivos_en_temp = glob($ruta_temporal . '*');
    if (empty($archivos_en_temp)) {
        rmdir($ruta_temporal);
    }

    }
}
##################### FUNCION LISTAR CODIGO DE BARRAS DE PRODUCTOS ###################

################## FUNCION LISTAR PRODUCTOS POR SUCURSAL SEGUN MODENA ###################
function TablaListarProductosxMoneda()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $cambio = new Login();
    $cambio = $cambio->BuscarTiposCambios();
    $siglas = ($cambio[0]['codmoneda'] == '' ? " " : $cambio[0]['siglas']);
    $tipo_simbolo = ($cambio[0]['codmoneda'] == '' ? " " : $cambio[0]['simbolo']);

    $tra = new Login();
    $reg = $tra->ListarProductos(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PRODUCTOS POR MONEDA',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"MONEDA: ".mb_convert_encoding($cambio[0]["moneda"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"MONTO: ".number_format($cambio[0]['montocambio'], 2, '.', ','),0,0,'L'); 

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(25,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DCTO %',1,0,'C', True);
    $this->Cell(30,8,'EXIST.',1,0,'C', True);
    $this->Cell(30,8,'PREC. MAYOR',1,0,'C', True);
    $this->Cell(30,8,'PREC. MENOR',1,0,'C', True);
    $this->Cell(30,8,'PREC. PBLICO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,25,70,30,30,25,20,30,30,30,30));

    $a                  = 1;
    $TotalCompra        = 0;
    $TotalMayor         = 0;
    $TotalMenor         = 0;
    $TotalPublico       = 0;
    $TotalMonedaCompra  = 0;
    $TotalMonedaMayor   = 0;
    $TotalMonedaMenor   = 0;
    $TotalMonedaPublico = 0;
    $TotalArticulos     = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo   = ($reg[$i]['simbolo'] == "" ? "" : "<strong>".$reg[$i]['simbolo']."</strong>");

    $TotalCompra        += number_format($reg[$i]['preciocompra'], 2, '.', '');
    $TotalMayor         += number_format($reg[$i]['precioxmayor'], 2, '.', '');
    $TotalMenor         += number_format($reg[$i]['precioxmenor'], 2, '.', '');
    $TotalPublico       += number_format($reg[$i]['precioxpublico'], 2, '.', '');

    $TotalMonedaCompra  += number_format($reg[$i]['preciocompra']/$cambio[0]['montocambio'], 2, '.', '');
    $TotalMonedaMayor   += number_format($reg[$i]['precioxmayor']/$cambio[0]['montocambio'], 2, '.', '');
    $TotalMonedaMenor   += number_format($reg[$i]['precioxmenor']/$cambio[0]['montocambio'], 2, '.', '');
    $TotalMonedaPublico += number_format($reg[$i]['precioxpublico']/$cambio[0]['montocambio'], 2, '.', '');
    $TotalArticulos     += $reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]["codproducto"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "******" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivaproducto'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $reg[$i]['existencia'],
        $tipo = ($cambio[0]['moneda'] == "EURO" ? chr(128) : $tipo_simbolo).number_format($reg[$i]['precioxmayor']/$cambio[0]['montocambio'], 2, '.', ','),
        $tipo = ($cambio[0]['moneda'] == "EURO" ? chr(128) : $tipo_simbolo).number_format($reg[$i]['precioxmenor']/$cambio[0]['montocambio'], 2, '.', ','),
        $tipo = ($cambio[0]['moneda'] == "EURO" ? chr(128) : $tipo_simbolo).number_format($reg[$i]['precioxpublico']/$cambio[0]['montocambio'], 2, '.', ',')));
    }

    $this->Cell(215,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,$tipo_simbolo.number_format($TotalMonedaMayor, 2, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$tipo_simbolo.number_format($TotalMonedaMenor, 2, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$tipo_simbolo.number_format($TotalMonedaPublico, 2, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
################### FUNCION LISTAR PRODUCTOS POR SUCURSAL SEGUN MODENA ################

###################### FUNCION LISTAR KARDEX POR PRODUCTO ########################
function TablaListarKardexProducto()
{
    $detalle = new Login();
    $detalle = $detalle->DetalleKardexProducto();
    $simbolo = ($detalle[0]['simbolo'] == "" ? "" : $detalle[0]['simbolo']);

    $kardex = new Login();
    $kardex = $kardex->BuscarKardexProducto();

    // Trabajamos con foreach para recorrer los movimientos y totalizar
    $entradas     = 0.00; 
    $salidas      = 0.00; 
    $devoluciones = 0.00;
    if (!empty($kardex)) {
        foreach ($kardex as $k) {
          $entradas     += (float)$k['entradas'];
          $salidas      += (float)$k['salidas'];
          $devoluciones += (float)$k['devolucion'];
        }
    }
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE KARDEX POR PRODUCTO ',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->CellFitSpace(115,5,'DETALLE DE PRODUCTO',1,0,'C', True);
    $this->Cell(10,5,'',0,0,'C');
    $this->CellFitSpace(100,5,'DETALLE DE PRECIO',1,0,'C', True);
    $this->Cell(10,5,'',0,0,'C');
    $this->CellFitSpace(100,5,'DETALLE DE MOVIMIENTOS',1,0,'C', True);
    $this->Ln();
    
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(35,5,'CDIGO',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(80,5,mb_convert_encoding($detalle[0]['codproducto'], 'ISO-8859-1', 'UTF-8'),1,0,'L');

    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'PRECIO COMPRA',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,$pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? $simbolo.number_format($detalle[0]['preciocompra'], 0, '.', '.') : "0"),1,0,'L');

    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'EXISTENCIA',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,$detalle[0]['existencia'],1,0,'L');
    $this->Ln();

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,'MARCA',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(80,5,mb_convert_encoding($detalle[0]['nommarca'], 'ISO-8859-1', 'UTF-8'),1,0,'L');
    
    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'PRECIO MAYORISTA',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,($simbolo ?? "").number_format($detalle[0]['precioxmayor'], 0, '.', '.'),1,0,'L');
    
    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'TOTAL ENTRADAS',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,$entradas,1,0,'L');
    $this->Ln();
    
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,'MODELO',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->MultiAlignCell(80,5,mb_convert_encoding($nommodelo = ($detalle[0]['codmodelo'] == 0 ? "******" : $detalle[0]['nommodelo']), 'ISO-8859-1', 'UTF-8'),1,0,'L');

    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'PRECIO MENORISTA',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,($simbolo ?? "").number_format($detalle[0]['precioxmenor'], 0, '.', '.'),1,0,'L');
    
    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'TOTAL SALIDAS',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,$salidas,1,0,'L');
    $this->Ln();

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,'DESCRIPCIN',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->MultiAlignCell(80,5,mb_convert_encoding($detalle[0]['producto'], 'ISO-8859-1', 'UTF-8'),1,0,'L');

    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'PRECIO PUBLICO',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,($simbolo ?? "").number_format($detalle[0]['precioxpublico'], 0, '.', '.'),1,0,'L');
    
    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'TOTAL DEVOLUCIONES',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,$devoluciones,1,0,'L');
    $this->Ln();
    
    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(50,8,'REALIZADO POR',1,0,'C', True);
    $this->Cell(25,8,'MOVIMIENTO',1,0,'C', True);
    $this->Cell(25,8,'ENTRADAS',1,0,'C', True);
    $this->Cell(25,8,'SALIDAS',1,0,'C', True);
    $this->Cell(25,8,'DEVOLUCIN',1,0,'C', True);
    $this->Cell(20,8,'STOCK',1,0,'C', True);
    $this->Cell(30,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,'PRECIO',1,0,'C', True);
    $this->Cell(40,8,'DOCUMENTO',1,0,'C', True);
    $this->Cell(30,8,'FECHA KARDEX',1,1,'C', True);

    if($kardex==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,50,25,25,25,25,20,30,20,30,40,30));

    $a=1;
    for($i=0;$i<sizeof($kardex);$i++){ 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($usuario = ($kardex[$i]['codigo'] == "0" ? "**********" : $kardex[$i]['dni'].": ".$kardex[$i]['nombres']), 'ISO-8859-1', 'UTF-8'),
        $kardex[$i]["movimiento"],
        $kardex[$i]["entradas"],
        $kardex[$i]["salidas"],
        $kardex[$i]["devolucion"],
        $kardex[$i]['stockactual'],
        $kardex[$i]['ivaproducto'],
        number_format($kardex[$i]['descproducto'], 0, '.', '.'),
        $simbolo.number_format($kardex[$i]['precio'], 0, '.', '.'),
        $kardex[$i]['documento']." ".$num = ($kardex[$i]['documento'] == 'VENTA' || $kardex[$i]['documento'] == 'DEVOLUCION' ? $kardex[$i]['codproceso'] : ""),
        date("d/m/Y",strtotime($kardex[$i]['fechakardex']))));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR KARDEX POR PRODUCTO ########################

####################### FUNCION LISTAR KARDEX VALORIZADO ###########################
function TablaListarKardexProductosValorizado()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarKardexProductosValorizado(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO KARDEX PRODUCTOS VALORIZADO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(25,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(15,8,'DESC%',1,0,'C', True);
    $this->Cell(25,8,'STOCK',1,0,'C', True);
    $this->Cell(40,8,'TOTAL VENTA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL COMPRA',1,0,'C', True);
    $this->Cell(30,8,'GANANCIAS',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,65,30,30,25,15,25,40,40,30));

    $a=1;
    $PrecioCompraTotal    = 0;
    $PrecioVentaTotal     = 0;
    $ExisteTotal          = 0;
    $ImpuestosCompraTotal = 0;
    $ImpuestosVentaTotal  = 0;
    $CompraTotal          = 0;
    $VentaTotal           = 0;
    $TotalGanancia        = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioCompraTotal    += $reg[$i]['preciocompra'];
    $PrecioVentaTotal     += $reg[$i]['precioxpublico'];
    $ExisteTotal          += $reg[$i]['existencia'];

    $Descuento            = $reg[$i]['descproducto']/100;
    $PrecioDescuento      = $reg[$i]['precioxpublico']*$Descuento;
    $PrecioFinal          = $reg[$i]['precioxpublico']-$PrecioDescuento;

    //VALOR DE IMPUESTO
    $ValorIva = 1 + ($ValorImpuesto/100);

    //CALCULO SUBTOTAL IMPUESTOS PRECIO COMPRA
    $DiscriminadoC         = $reg[$i]['preciocompra']/$ValorIva;
    $SubtotalDiscriminadoC = $reg[$i]['preciocompra'] - $DiscriminadoC;
    $BaseDiscriminadoC     = $SubtotalDiscriminadoC * $reg[$i]['existencia'];
    $SubtotalimpuestosC    = ($reg[$i]['ivaproducto'] == 'SI' ? number_format($BaseDiscriminadoC, 2, '.', '') : "0.00");

    //CALCULO SUBTOTAL IMPUESTOS PRECIO VENTA
    $DiscriminadoV         = $PrecioFinal/$ValorIva;
    $SubtotalDiscriminadoV = $PrecioFinal - $DiscriminadoV;
    $BaseDiscriminadoV     = $SubtotalDiscriminadoV * $reg[$i]['existencia'];
    $SubtotalimpuestosV    = ($reg[$i]['ivaproducto'] == 'SI' ? number_format($BaseDiscriminadoV, 2, '.', '') : "0.00");

    $SumCompra = ($reg[$i]['preciocompra']*$reg[$i]['existencia'])-$SubtotalimpuestosC;
    $SumVenta  = ($PrecioFinal*$reg[$i]['existencia'])-$SubtotalimpuestosV; 

    $CompraTotal          += $SumCompra;
    $ImpuestosCompraTotal += $SubtotalimpuestosC;
    $VentaTotal           += $SumVenta;
    $ImpuestosVentaTotal  += $SubtotalimpuestosV;
    $TotalGanancia        += $SumVenta-$SumCompra;

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivaproducto'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $reg[$i]['existencia'],
        $simbolo.number_format($PrecioFinal*$reg[$i]['existencia'], 0, '.', '.'),
        $pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? $simbolo.number_format($reg[$i]['preciocompra']*$reg[$i]['existencia'], 0, '.', '.') : "0"),
        $pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? $simbolo.number_format($SumVenta-$SumCompra, 0, '.', '.') : "0")));
    }
   
    $this->Cell(200,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$ExisteTotal,0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($VentaTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,$pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? ($simbolo ?? "").number_format($CompraTotal, 0, '.', '.') : "******"),0,0,'L');
    $this->CellFitSpace(30,5,$pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? ($simbolo ?? "").number_format($TotalGanancia, 0, '.', '.') : "******"),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR KARDEX VALORIZADO ##########################

####################### FUNCION LISTAR PRODUCTOS VALORIZADO POR FECHAS ###########################
function TablaListarProductosValorizadoxFechas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarProductosValorizadoxFechas(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO KARDEX PRODUCTOS VALORIZADO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(25,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(15,8,'DESC%',1,0,'C', True);
    $this->Cell(25,8,'VENDIDO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL VENTA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL COMPRA',1,0,'C', True);
    $this->Cell(30,8,'GANANCIAS',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,65,30,30,25,15,25,40,40,30));

    $PrecioCompraTotal    = 0;
    $PrecioVentaTotal     = 0;
    $VendidosTotal        = 0;
    $ImpuestosCompraTotal = 0;
    $ImpuestosVentaTotal  = 0;
    $CompraTotal          = 0;
    $VentaTotal           = 0;
    $TotalGanancia        = 0;
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioCompraTotal     += $reg[$i]['preciocompra'];
    $PrecioVentaTotal      += $reg[$i]['precioventa'];
    $VendidosTotal         += $reg[$i]['cantidad'];

    $Descuento             = $reg[$i]['descproducto']/100;
    $PrecioDescuento       = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal           = $reg[$i]['precioventa']-$PrecioDescuento;

    //VALOR DE IMPUESTO
    $ValorIva = 1 + ($ValorImpuesto/100);

    //CALCULO SUBTOTAL IMPUESTOS PRECIO COMPRA
    $DiscriminadoC         = $reg[$i]['preciocompra']/$ValorIva;
    $SubtotalDiscriminadoC = $reg[$i]['preciocompra'] - $DiscriminadoC;
    $BaseDiscriminadoC     = $SubtotalDiscriminadoC * $reg[$i]['cantidad'];
    $SubtotalimpuestosC    = ($reg[$i]['ivaproducto'] != '0.00' ? number_format($BaseDiscriminadoC, 2, '.', '') : "0.00");

    //CALCULO SUBTOTAL IMPUESTOS PRECIO VENTA
    $DiscriminadoV         = $PrecioFinal/$ValorIva;
    $SubtotalDiscriminadoV = $PrecioFinal - $DiscriminadoV;
    $BaseDiscriminadoV     = $SubtotalDiscriminadoV * $reg[$i]['cantidad'];
    $SubtotalimpuestosV    = ($reg[$i]['ivaproducto'] != '0.00' ? number_format($BaseDiscriminadoV, 2, '.', '') : "0.00");

    $SumCompra = ($reg[$i]['preciocompra']*$reg[$i]['cantidad'])-$SubtotalimpuestosC;
    $SumVenta  = ($PrecioFinal*$reg[$i]['cantidad'])-$SubtotalimpuestosV; 

    $CompraTotal          += $SumCompra;
    $ImpuestosCompraTotal += $SubtotalimpuestosC;
    $VentaTotal           += $SumVenta;
    $ImpuestosVentaTotal  += $SubtotalimpuestosV;
    $TotalGanancia        += $SumVenta-$SumCompra; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : "").$imei = ($reg[$i]["imei"] != "" ? "\nIMEI: ".$reg[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivaproducto'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $reg[$i]['cantidad'],
        $simbolo.number_format($SumVenta, 0, '.', '.'),
        $pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? $simbolo.number_format($SumCompra, 0, '.', '.') : "0"),
        $pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? $simbolo.number_format($SumVenta-$SumCompra, 0, '.', '.') : "0")));
    }
   
    $this->Cell(200,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$VendidosTotal,0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($VentaTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,$pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? ($simbolo ?? "").number_format($CompraTotal, 0, '.', '.') : "******"),0,0,'L');
    $this->CellFitSpace(30,5,$pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? ($simbolo ?? "").number_format($TotalGanancia, 0, '.', '.') : "******"),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR PRODUCTOS VALORIZADO POR FECHAS ##########################

######################## FUNCION LISTAR PRODUCTOS VENDIDOS POR FECHAS #########################
function TablaListarProductosVendidosxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarProductosVendidosxFechas(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO PRODUCTOS VENDIDOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(75,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(40,8,'MARCA',1,0,'C', True);
    $this->Cell(40,8,'MODELO',1,0,'C', True);
    $this->Cell(30,8,'VENDIDO',1,0,'C', True);
    $this->Cell(35,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(30,8,'DESC %',1,0,'C', True);
    $this->Cell(50,8,'MONTO TOTAL ',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,75,40,40,30,35,30,50));

    $a=1;
    $PrecioVentaTotal = 0;
    $VendidosTotal    = 0;
    $TotalDescuento   = 0;
    $TotalImpuesto    = 0;
    $TotalGeneral     = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioVentaTotal  += $reg[$i]['precioventa'];
    $VendidosTotal     += $reg[$i]['cantidad'];

    $Descuento         = $reg[$i]['descproducto']/100;
    $PrecioDescuento   = $reg[$i]['precioventa']*$Descuento;

    $SubtotalDescuento = number_format($reg[$i]['totaldescuentov'], 2, '.', '');
    $PrecioFinal       = $reg[$i]['precioventa']-$PrecioDescuento;

    $ivg               = $reg[$i]['ivaproducto']/100;
    $SubtotalImpuesto  = number_format($reg[$i]['subtotalimpuestos'], 2, '.', '');

    $TotalDescuento   += $SubtotalDescuento; 
    $TotalImpuesto    += $SubtotalImpuesto; 
    $TotalGeneral     += $PrecioFinal*$reg[$i]['cantidad']; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : "").$imei = ($reg[$i]["imei"] != "" ? "\nIMEI: ".$reg[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['cantidad'],
        number_format($SubtotalImpuesto, 0, '.', '.'),
        number_format($SubtotalDescuento, 0, '.', '.'),
        $simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 0, '.', '.')));
    }
   
    $this->Cell(190,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,$VendidosTotal,0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalImpuesto, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(50,5,($simbolo ?? "").number_format($TotalGeneral, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR PRODUCTOS VENDIDOS POR FECHAS ########################

############################### REPORTES DE PRODUCTOS ###########################





























############################### REPORTES DE COMBOS ###########################

########################## FUNCION LISTAR COMBOS ##############################
function TablaListarCombos()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarCombos();  

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE COMBOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255, 118, 118); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(85,8,'DESCRIPCIN DE COMBO',1,0,'C', True);
    $this->Cell(50,8,'FAMILIA',1,0,'C', True);
    $this->Cell(30,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,'STOCK',1,0,'C', True);
    $this->Cell(40,8,'PRECIO COMPRA',1,0,'C', True);
    $this->Cell(40,8,'PRECIO VENTA',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,85,50,30,25,30,40,40));

    $a=1;
    $TotalCompra    = 0;
    $TotalVenta     = 0;
    $TotalArticulos = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo  = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $simbolo2 = ($reg[$i]['simbolo2'] == "" ? "" : $reg[$i]['simbolo2']);

    $TotalCompra    += $reg[$i]['preciocompra'];
    $TotalVenta     += $reg[$i]['precioventa'];
    $TotalArticulos += $reg[$i]['existencia'];
    $detalles       =  (empty($reg[$i]['detalles_productos']) ? "" : str_replace("<br>","\n", $reg[$i]['detalles_productos']));

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codcombo'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["nomcombo"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["nomfamilia"], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivacombo'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['desccombo'], 0, '.', '.'),
        number_format($reg[$i]['existencia'], 0, '.', '.'),
        $pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? $simbolo.number_format($reg[$i]['preciocompra'], 0, '.', '.') : "******"),
        $simbolo.number_format($reg[$i]['precioventa'], 0, '.', '.')));
    }
   
    $this->Cell(225,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,number_format($TotalArticulos, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,$pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? ($simbolo ?? "").number_format($TotalCompra, 0, '.', '.') : "******"),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalVenta, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMBOS ##############################

########################## FUNCION LISTAR COMBOS EN STOCK MINIMO ##############################
function TablaListarCombosMinimo()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarCombosMinimo();  

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE COMBOS EN STOCK MINIMO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255, 118, 118); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE COMBO',1,0,'C', True);
    $this->Cell(50,8,'FAMILIA',1,0,'C', True);
    $this->Cell(30,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(20,8,'MINIMO',1,0,'C', True);
    $this->Cell(30,8,'STOCK',1,0,'C', True);
    $this->Cell(40,8,'PRECIO COMPRA',1,0,'C', True);
    $this->Cell(40,8,'PRECIO VENTA',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,70,50,30,20,20,30,40,40));

    $a=1;
    $TotalCompra    = 0;
    $TotalVenta     = 0;
    $TotalArticulos = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo  = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $simbolo2 = ($reg[$i]['simbolo2'] == "" ? "" : $reg[$i]['simbolo2']);

    $TotalCompra    += $reg[$i]['preciocompra'];
    $TotalVenta     += $reg[$i]['precioventa'];
    $TotalArticulos += $reg[$i]['existencia'];
    $detalles       =  (empty($reg[$i]['detalles_productos']) ? "" : str_replace("<br>","\n", $reg[$i]['detalles_productos']));

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codcombo'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["nomcombo"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["nomfamilia"], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivacombo'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['desccombo'], 0, '.', '.'),
        number_format($reg[$i]['stockminimo'], 0, '.', '.'),
        number_format($reg[$i]['existencia'], 0, '.', '.'),
        $pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? $simbolo.number_format($reg[$i]['preciocompra'], 0, '.', '.') : "******"),
        $simbolo.number_format($reg[$i]['precioventa'], 0, '.', '.')));
    }
   
    $this->Cell(225,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,number_format($TotalArticulos, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,$pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? ($simbolo ?? "").number_format($TotalCompra, 0, '.', '.') : "******"),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalVenta, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMBOS EN STOCK MINIMO ##############################

########################## FUNCION LISTAR COMBOS EN STOCK MAXIMO ##############################
function TablaListarCombosMaximo()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarCombosMaximo();  

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE COMBOS EN STOCK MAXIMO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255, 118, 118); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE COMBO',1,0,'C', True);
    $this->Cell(50,8,'FAMILIA',1,0,'C', True);
    $this->Cell(30,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(20,8,'MAXIMO',1,0,'C', True);
    $this->Cell(30,8,'STOCK',1,0,'C', True);
    $this->Cell(40,8,'PRECIO COMPRA',1,0,'C', True);
    $this->Cell(40,8,'PRECIO VENTA',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,70,50,30,20,20,30,40,40));

    $a=1;
    $TotalCompra    = 0;
    $TotalVenta     = 0;
    $TotalArticulos = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo  = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $simbolo2 = ($reg[$i]['simbolo2'] == "" ? "" : $reg[$i]['simbolo2']);

    $TotalCompra    += $reg[$i]['preciocompra'];
    $TotalVenta     += $reg[$i]['precioventa'];
    $TotalArticulos += $reg[$i]['existencia'];
    $detalles       =  (empty($reg[$i]['detalles_productos']) ? "" : str_replace("<br>","\n", $reg[$i]['detalles_productos']));

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codcombo'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["nomcombo"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["nomfamilia"], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivacombo'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['desccombo'], 0, '.', '.'),
        number_format($reg[$i]['stockmaximo'], 0, '.', '.'),
        number_format($reg[$i]['existencia'], 0, '.', '.'),
        $pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? $simbolo.number_format($reg[$i]['preciocompra'], 0, '.', '.') : "******"),
        $simbolo.number_format($reg[$i]['precioventa'], 0, '.', '.')));
    }
   
    $this->Cell(225,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,number_format($TotalArticulos, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,$pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? ($simbolo ?? "").number_format($TotalCompra, 0, '.', '.') : "******"),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalVenta, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMBOS EN STOCK MAXIMO ##############################

########################## FUNCION LISTAR COMBOS POR MONEDA ##############################
function TablaListarCombosxMoneda()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $cambio = new Login();
    $cambio = $cambio->BuscarTiposCambios();
    $siglas = ($cambio[0]['codmoneda'] == '' ? " " : $cambio[0]['siglas']);
    $tipo_simbolo = ($cambio[0]['codmoneda'] == '' ? " " : $cambio[0]['simbolo']);

    $tra = new Login();
    $reg = $tra->ListarCombos();  

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE COMBOS POR MONEDA',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"MONEDA: ".mb_convert_encoding($cambio[0]["moneda"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"MONTO: ".number_format($cambio[0]['montocambio'], 2, '.', ','),0,0,'L'); 

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(110,8,'DESCRIPCIN DE COMBO',1,0,'C', True);
    $this->Cell(60,8,'FAMILIA',1,0,'C', True);
    $this->Cell(30,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(30,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,'STOCK',1,0,'C', True);
    $this->Cell(40,8,'PREC. VENTA '.$siglas,1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,110,60,30,30,30,40));

    $a                  = 1;
    $TotalCompra        = 0;
    $TotalVenta         = 0;
    $TotalMonedaCompra  = 0;
    $TotalMonedaVenta   = 0;
    $TotalArticulos     = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo   = ($reg[$i]['simbolo'] == "" ? "" : "<strong>".$reg[$i]['simbolo']."</strong>");
    $detalles  = str_replace("<br>","\n", $reg[$i]['detalles_productos']);

    $TotalCompra        += number_format($reg[$i]['preciocompra'], 2, '.', '');
    $TotalVenta         += number_format($reg[$i]['precioventa'], 2, '.', '');

    $TotalMonedaCompra  += number_format($reg[$i]['preciocompra']/$cambio[0]['montocambio'], 2, '.', '');
    $TotalMonedaVenta   += number_format($reg[$i]['precioventa']/$cambio[0]['montocambio'], 2, '.', '');
    $TotalArticulos     += $reg[$i]['existencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codcombo'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["nomcombo"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["nomfamilia"], 'ISO-8859-1', 'UTF-8'),
        $reg[$i]['ivacombo'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO",
        number_format($reg[$i]['desccombo'], 0, '.', '.'),
        number_format($reg[$i]['existencia'], 0, '.', '.'),
        $tipo = ($cambio[0]['moneda'] == "EURO" ? chr(128) : $tipo_simbolo).number_format($reg[$i]['precioventa']/$cambio[0]['montocambio'], 0, '.', '.')));
    }
   
    $this->Cell(265,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,number_format($TotalArticulos, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,$tipo_simbolo.number_format($TotalMonedaVenta, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMBOS POR MONEDA ##############################

########################## FUNCION LISTAR KARDEX POR COMBO ##############################
function TablaListarKardexCombo()
{
    $detalle = new Login();
    $detalle = $detalle->DetalleKardexCombo();
    $simbolo = ($detalle[0]['simbolo'] == "" ? "" : $detalle[0]['simbolo']); 

    $kardex = new Login();
    $kardex = $kardex->BuscarKardexCombo(); 

    // Trabajamos con foreach para recorrer los movimientos y totalizar
    $entradas     = 0.00; 
    $salidas      = 0.00; 
    $devoluciones = 0.00;
    if (!empty($kardex)) {
        foreach ($kardex as $k) {
          $entradas     += (float)$k['entradas'];
          $salidas      += (float)$k['salidas'];
          $devoluciones += (float)$k['devolucion'];
        }
    }
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE KARDEX POR COMBO ',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->CellFitSpace(115,5,'DETALLE DE COMBO',1,0,'C', True);
    $this->Cell(10,5,'',0,0,'C');
    $this->CellFitSpace(100,5,'DETALLE DE PRECIO',1,0,'C', True);
    $this->Cell(10,5,'',0,0,'C');
    $this->CellFitSpace(100,5,'DETALLE DE MOVIMIENTOS',1,0,'C', True);
    $this->Ln();
    
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(35,5,'CDIGO',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(80,5,mb_convert_encoding($detalle[0]['codcombo'], 'ISO-8859-1', 'UTF-8'),1,0,'L');

    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'PRECIO COMPRA',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,$pcompra = ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"] == "administradorS" || $_SESSION["acceso"] == "secretaria" ? $simbolo.number_format($detalle[0]['preciocompra'], 0, '.', '.') : "0.00"),1,0,'L');

    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'EXISTENCIA',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,number_format($detalle[0]['existencia'], 0, '.', '.'),1,0,'L');
    $this->Ln();

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,'DESCRIPCIN',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->MultiAlignCell(80,5,mb_convert_encoding($detalle[0]['nomcombo'], 'ISO-8859-1', 'UTF-8'),1,0,'L');
    
    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'PRECIO VENTA',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,($simbolo ?? "").number_format($detalle[0]['precioventa'], 0, '.', '.'),1,0,'L');
    
    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'TOTAL ENTRADAS',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,number_format($entradas, 0, '.', '.'),1,0,'L');
    $this->Ln();
    
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(80,5,'',1,0,'L');

    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(60,5,'',1,0,'L');
    
    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'TOTAL SALIDAS',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,number_format($salidas, 0, '.', '.'),1,0,'L');
    $this->Ln();

    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(35,5,'',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(80,5,'',1,0,'L');

    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(60,5,'',1,0,'L');
    
    $this->Cell(10,5,'',0,0,'C');

    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(40,5,'TOTAL DEVOLUCIONES',1,0,'L', True);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(60,5,number_format($devoluciones, 0, '.', '.'),1,0,'L');
    $this->Ln();
    
    $this->Ln();
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(50,8,'REALIZADO POR',1,0,'C', True);
    $this->Cell(25,8,'MOVIMIENTO',1,0,'C', True);
    $this->Cell(25,8,'ENTRADAS',1,0,'C', True);
    $this->Cell(25,8,'SALIDAS',1,0,'C', True);
    $this->Cell(25,8,'DEVOLUCIN',1,0,'C', True);
    $this->Cell(20,8,'STOCK',1,0,'C', True);
    $this->Cell(30,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,'PRECIO',1,0,'C', True);
    $this->Cell(40,8,'DOCUMENTO',1,0,'C', True);
    $this->Cell(30,8,'FECHA KARDEX',1,1,'C', True);

    if($kardex==""){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,50,25,25,25,25,20,30,20,30,40,30));

    $a=1;
    for($i=0;$i<sizeof($kardex);$i++){

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($usuario = ($kardex[$i]['codigo'] == "0" ? "**********" : $kardex[$i]['dni'].": ".$kardex[$i]['nombres']), 'ISO-8859-1', 'UTF-8'),
        $kardex[$i]["movimiento"],
        number_format($kardex[$i]["entradas"], 0, '.', '.'),
        number_format($kardex[$i]["salidas"], 0, '.', '.'),
        number_format($kardex[$i]["devolucion"], 0, '.', '.'),
        number_format($kardex[$i]['stockactual'], 0, '.', '.'),
        $kardex[$i]['ivaproducto'] != '0.00' ? number_format($kardex[$i]['ivaproducto'], 0, '.', '.')."%" : "(E)",
        number_format($kardex[$i]['descproducto'], 0, '.', '.'),
        $simbolo.number_format($kardex[$i]['precio'], 0, '.', '.'),
        mb_convert_encoding($kardex[$i]['documento'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y",strtotime($kardex[$i]['fechakardex']))));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR KARDEX POR COMBO ##############################

########################## FUNCION LISTAR COMBOS KARDEX VALORIZADO ##############################
function TablaListarKardexCombosValorizado()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarKardexCombosValorizado(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO KARDEX COMBOS VALORIZADO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255, 118, 118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE COMBO',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(25,8,'DESC %',1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL VENTA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL COMPRA',1,0,'C', True);
    $this->Cell(35,8,'GANANCIAS',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,25,70,30,30,25,25,40,40,35));

    $a=1;
    $PrecioCompraTotal    = 0;
    $PrecioVentaTotal     = 0;
    $ExisteTotal          = 0;
    $ImpuestosCompraTotal = 0;
    $ImpuestosVentaTotal  = 0;
    $CompraTotal          = 0;
    $VentaTotal           = 0;
    $TotalGanancia        = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioCompraTotal    += $reg[$i]['preciocompra'];
    $PrecioVentaTotal     += $reg[$i]['precioventa'];
    $ExisteTotal          += $reg[$i]['existencia'];

    $Descuento            = $reg[$i]['desccombo']/100;
    $PrecioDescuento      = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal          = $reg[$i]['precioventa']-$PrecioDescuento;

    //VALOR DE IMPUESTO
    $ValorIva = 1 + ($ValorImpuesto/100);

    //CALCULO SUBTOTAL IMPUESTOS PRECIO COMPRA
    $DiscriminadoC         = $reg[$i]['preciocompra']/$ValorIva;
    $SubtotalDiscriminadoC = $reg[$i]['preciocompra'] - $DiscriminadoC;
    $BaseDiscriminadoC     = $SubtotalDiscriminadoC * $reg[$i]['existencia'];
    $SubtotalimpuestosC    = ($reg[$i]['ivacombo'] == 'SI' ? number_format($BaseDiscriminadoC, 2, '.', '') : "0.00");

    //CALCULO SUBTOTAL IMPUESTOS PRECIO VENTA
    $DiscriminadoV         = $PrecioFinal/$ValorIva;
    $SubtotalDiscriminadoV = $PrecioFinal - $DiscriminadoV;
    $BaseDiscriminadoV     = $SubtotalDiscriminadoV * $reg[$i]['existencia'];
    $SubtotalimpuestosV    = ($reg[$i]['ivacombo'] == 'SI' ? number_format($BaseDiscriminadoV, 2, '.', '') : "0.00");

    $SumCompra = ($reg[$i]['preciocompra']*$reg[$i]['existencia'])-$SubtotalimpuestosC;
    $SumVenta  = ($PrecioFinal*$reg[$i]['existencia'])-$SubtotalimpuestosV; 

    $CompraTotal          += $SumCompra;
    $ImpuestosCompraTotal += $SubtotalimpuestosC;
    $VentaTotal           += $SumVenta;
    $ImpuestosVentaTotal  += $SubtotalimpuestosV;
    $TotalGanancia        += $SumVenta-$SumCompra;

    $this->SetFont('courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['codcombo'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["nomcombo"], 'ISO-8859-1', 'UTF-8'),
        $simbolo.number_format($reg[$i]['precioventa'], 0, '.', '.'),
        $ivacombo = ($reg[$i]['ivacombo'] == 'SI' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "EXENTO"),
        number_format($reg[$i]['desccombo'], 0, '.', '.')."%",
        number_format($reg[$i]['existencia'], 0, '.', '.'),
        $simbolo.number_format($SumVenta, 0, '.', '.'),
        $simbolo.number_format($SumCompra, 0, '.', '.'),
        $simbolo.number_format($SumVenta-$SumCompra, 0, '.', '.')));
    }
   
    $this->Cell(195,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,number_format($ExisteTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($VentaTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($CompraTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalGanancia, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMBOS KARDEX VALORIZADO ##############################

########################## FUNCION LISTAR COMBOS KARDEX VALORIZADO POR FECHAS ##############################
function TablaListarCombosValorizadoxFechas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarCombosValorizadoxFechas(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO KARDEX COMBOS VALORIZADO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255, 118, 118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE COMBO',1,0,'C', True);
    $this->Cell(30,8,'DESC %',1,0,'C', True);
    $this->Cell(35,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'VENDIDO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL VENTA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL COMPRA',1,0,'C', True);
    $this->Cell(35,8,'GANANCIAS',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,70,30,35,25,25,40,40,35));

    $PrecioCompraTotal    = 0;
    $PrecioVentaTotal     = 0;
    $VendidosTotal        = 0;
    $ImpuestosCompraTotal = 0;
    $ImpuestosVentaTotal  = 0;
    $CompraTotal          = 0;
    $VentaTotal           = 0;
    $TotalGanancia        = 0;
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioCompraTotal     += $reg[$i]['preciocompra'];
    $PrecioVentaTotal      += $reg[$i]['precioventa'];
    $VendidosTotal         += $reg[$i]['cantidad'];

    $Descuento             = $reg[$i]['descproducto']/100;
    $PrecioDescuento       = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal           = $reg[$i]['precioventa']-$PrecioDescuento;

    //VALOR DE IMPUESTO
    $ValorIva = 1 + ($ValorImpuesto/100);

    //CALCULO SUBTOTAL IMPUESTOS PRECIO COMPRA
    $DiscriminadoC         = $reg[$i]['preciocompra']/$ValorIva;
    $SubtotalDiscriminadoC = $reg[$i]['preciocompra'] - $DiscriminadoC;
    $BaseDiscriminadoC     = $SubtotalDiscriminadoC * $reg[$i]['cantidad'];
    $SubtotalimpuestosC    = ($reg[$i]['ivaproducto'] != '0.00' ? number_format($BaseDiscriminadoC, 2, '.', '') : "0.00");

    //CALCULO SUBTOTAL IMPUESTOS PRECIO VENTA
    $DiscriminadoV         = $PrecioFinal/$ValorIva;
    $SubtotalDiscriminadoV = $PrecioFinal - $DiscriminadoV;
    $BaseDiscriminadoV     = $SubtotalDiscriminadoV * $reg[$i]['cantidad'];
    $SubtotalimpuestosV    = ($reg[$i]['ivaproducto'] != '0.00' ? number_format($BaseDiscriminadoV, 2, '.', '') : "0.00");

    $SumCompra = ($reg[$i]['preciocompra']*$reg[$i]['cantidad'])-$SubtotalimpuestosC;
    $SumVenta  = ($PrecioFinal*$reg[$i]['cantidad'])-$SubtotalimpuestosV; 

    $CompraTotal          += $SumCompra;
    $ImpuestosCompraTotal += $SubtotalimpuestosC;
    $VentaTotal           += $SumVenta;
    $ImpuestosVentaTotal  += $SubtotalimpuestosV;
    $TotalGanancia        += $SumVenta-$SumCompra; 

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["producto"], 'ISO-8859-1', 'UTF-8'),
            number_format($reg[$i]['descproducto'], 0, '.', '.')."%",
            $simbolo.number_format($reg[$i]["precioventa"], 0, '.', '.'),
            number_format($reg[$i]['existencia'], 0, '.', '.'),
            number_format($reg[$i]['cantidad'], 0, '.', '.'),
            $simbolo.number_format($SumVenta, 0, '.', '.'),
            $simbolo.number_format($SumCompra, 0, '.', '.'),
            $simbolo.number_format($SumVenta-$SumCompra, 0, '.', '.')));
        }
    }
   
    $this->Cell(195,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 118, 118);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,number_format($VendidosTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($VentaTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($CompraTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalGanancia, 0, '.', '.'),0,0,'L');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMBOS KARDEX VALORIZADO POR FECHAS ##############################

########################## FUNCION LISTAR COMBOS VENDIDOS POR FECHAS ##############################
function TablaListarCombosVendidosxFechas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarCombosVendidosxFechas(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO COMBOS VENDIDOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(15,8,'CDIGO',1,0,'C', True);
    $this->Cell(85,8,'DESCRIPCIN DE COMBO',1,0,'C', True);
    $this->Cell(45,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(25,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'VENDIDO',1,0,'C', True);
    $this->Cell(40,8,'IMPUESTO',1,0,'C', True);
    $this->Cell(40,8,'DESCUENTO',1,0,'C', True);
    $this->Cell(45,8,'MONTO TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,15,85,45,25,25,40,40,45));

    $a=1;
    $PrecioVentaTotal = 0;
    $VendidosTotal    = 0;
    $TotalDescuento   = 0;
    $TotalImpuesto    = 0;
    $TotalGeneral     = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioVentaTotal  += $reg[$i]['precioventa'];
    $VendidosTotal     += $reg[$i]['cantidad'];

    $Descuento         = $reg[$i]['descproducto']/100;
    $PrecioDescuento   = $reg[$i]['precioventa']*$Descuento;

    $SubtotalDescuento = number_format($reg[$i]['totaldescuentov'], 2, '.', '');
    $PrecioFinal       = $reg[$i]['precioventa']-$PrecioDescuento;

    $ivg               = $reg[$i]['ivaproducto']/100;
    $SubtotalImpuesto  = number_format($reg[$i]['subtotalimpuestos'], 2, '.', '');

    $TotalDescuento   += $SubtotalDescuento; 
    $TotalImpuesto    += $SubtotalImpuesto; 
    $TotalGeneral     += $PrecioFinal*$reg[$i]['cantidad'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            mb_convert_encoding($reg[$i]['codproducto'], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["producto"], 'ISO-8859-1', 'UTF-8'),
            $simbolo.number_format($reg[$i]['precioventa'], 0, '.', '.'),
            number_format($reg[$i]['existencia'], 0, '.', '.'),
            number_format($reg[$i]['cantidad'], 0, '.', '.'),
            $simbolo.number_format($SubtotalImpuesto, 0, '.', '.'),
            $simbolo.number_format($SubtotalDescuento, 0, '.', '.'),
            $simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 0, '.', '.')));
        }
    }
   
    $this->Cell(185,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,number_format($VendidosTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImpuesto, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalGeneral, 0, '.', '.'),0,0,'L');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMBOS VENDIDOS POR FECHAS ##############################

############################### REPORTES DE COMBOS ###########################

















############################### REPORTES DE TRASPASOS ################################

########################## FUNCION FACTURA TRASPASOS (A4) ##############################
function FacturaTraspaso()
{  
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################
        
    $tra       = new Login();
    $reg       = $tra->TraspasosPorId();
    $simbolo   = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra = "Courier";

    //Logo
    if (isset($reg[0]['cuitsucursal'])) {
        if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
           $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
           $this->Image($logo, 15, 11, 30, 18, "PNG");
        } else {
           $logo = "fotos/logo_principal.png";
           $this->Image($logo, 15, 10, 40, 18, "PNG");                         
        }                                      
    }

    if($reg[0]['estado_traspaso'] == 1){
    $estado = "REGISTRADO";
    } elseif($reg[0]['estado_traspaso'] == 2){
    $estado = "EN PROCESO";
    } elseif($reg[0]['estado_traspaso'] == 3){
    $estado = "PENDIENTE";
    } elseif($reg[0]['estado_traspaso'] == 4){
    $estado = "RECIBIDO"; 
    } elseif($reg[0]['estado_traspaso'] == 5){
    $estado = "RECHAZADA";
    }

    ############################# BLOQUE N 1 FACTURA ###############################   
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 10, 190, 21, '1.5', '');
    
    $this->SetFont($TipoLetra,'B',12);
    $this->SetXY(115, 11);
    $this->Cell(40, 4, 'N DE FACTURA', 0, 0);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetXY(155, 11);
    $this->CellFitSpace(45, 4,$reg[0]['codfactura'], 0, 0, "R");

    $this->SetFont($TipoLetra,'B',12);
    $this->SetXY(115, 15);
    $this->Cell(40, 4, 'N DE TRACKING', 0, 0);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetXY(155, 15);
    $this->CellFitSpace(45, 4,$reg[0]['numero_tracking'], 0, 0, "R");

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(115, 19);
    $this->Cell(40, 4, 'FECHA DE REGISTRO', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(155, 19);
    $this->CellFitSpace(45, 4,date("d/m/Y",strtotime($reg[0]['fechatraspaso'])), 0, 0, "R");

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(115, 23);
    $this->Cell(40, 4, 'HORA DE REGISTRO', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(155, 23);
    $this->CellFitSpace(45, 4,date("H:i:s",strtotime($reg[0]['fechatraspaso'])), 0, 0, "R");

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(115, 27);
    $this->Cell(40, 4, 'ESTADO', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(155, 27);
    $this->CellFitSpace(45, 4,$estado, 0, 0, "R");
    ################################# BLOQUE N 1 FACTURA ################################

    ############################# BLOQUE N 2 SUCURSAL ENVIA ###############################   
    //Bloque de datos de empresa
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 32, 190, 17, '1.5', '');
    //DATOS DE SUCURSAL LINEA 1
    $this->SetFont($TipoLetra,'B',9);
    $this->SetXY(12, 32);
    $this->Cell(186, 4, 'DATOS DE SUCURSAL REMITENTE', 0, 0);
    //DATOS DE SUCURSAL LINEA 1

    //DATOS DE SUCURSAL LINEA 2
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(12, 36);
    $this->Cell(24, 4, 'RAZN SOCIAL:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(36, 36);
    $this->CellFitSpace(66, 4,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(102, 36);
    $this->CellFitSpace(22, 4, 'N DE '.$documento = ($reg[0]['documsucursal'] == '0' ? "REG.:" : $reg[0]['documento'].":"), 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(124, 36);
    $this->CellFitSpace(28, 4,$reg[0]['cuitsucursal'], 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(152, 36);
    $this->Cell(18, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(170, 36);
    $this->Cell(28, 4,$reg[0]['tlfsucursal'], 0, 0);
    //DATOS DE SUCURSAL LINEA 2

    //DATOS DE SUCURSAL LINEA 3
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(12, 40);
    $this->Cell(24, 4, 'DIRECCIN:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(36, 40);
    $this->CellFitSpace(96, 4,$ciudad = ($reg[0]['id_ciudad'] == '' ? "" : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8'))." ".$comuna = ($reg[0]['id_comuna'] == '' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))." ".mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(132, 40);
    $this->Cell(12, 4, 'EMAIL:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(144, 40);
    $this->Cell(54, 4,mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'), 0, 0);
    //DATOS DE SUCURSAL LINEA 3

    //DATOS DE SUCURSAL LINEA 4
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(12, 44);
    $this->Cell(24, 4, 'RESPONSABLE:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(36, 44);
    $this->CellFitSpace(116, 4,mb_convert_encoding($reg[0]['nomencargado'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(152, 44);
    $this->Cell(18, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(170, 44);
    $this->Cell(28, 4,$tlf = ($reg[0]['tlfencargado'] == '' ? "*********" : $reg[0]['tlfencargado']), 0, 0);
    //DATOS DE SUCURSAL LINEA 4
    ############################ BLOQUE N 2 SUCURSAL ENVIA ###############################

    ############################# BLOQUE N 3 SUCURSAL RECIBE ###############################   
    //Bloque de datos de empresa
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 50, 190, 17, '1.5', '');
    //DATOS DE SUCURSAL LINEA 1
    $this->SetFont($TipoLetra,'B',9);
    $this->SetXY(12, 50);
    $this->Cell(186, 4, 'DATOS DE SUCURSAL DESTINATARIO', 0, 0);
    //DATOS DE SUCURSAL LINEA 1

    //DATOS DE SUCURSAL LINEA 2
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(12, 54);
    $this->Cell(24, 4, 'RAZN SOCIAL:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(36, 54);
    $this->CellFitSpace(66, 4,mb_convert_encoding($reg[0]['nomsucursal2'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(102, 54);
    $this->CellFitSpace(22, 4, 'N DE '.$documento = ($reg[0]['documsucursal2'] == '0' ? "REG.:" : $reg[0]['documento3'].":"), 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(124, 54);
    $this->CellFitSpace(28, 4,$reg[0]['cuitsucursal2'], 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(152, 54);
    $this->Cell(18, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(170, 54);
    $this->Cell(28, 4,$reg[0]['tlfsucursal2'], 0, 0);
    //DATOS DE SUCURSAL LINEA 2

    //DATOS DE SUCURSAL LINEA 3
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(12, 58);
    $this->Cell(24, 4, 'DIRECCIN:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(36, 58);
    $this->CellFitSpace(96, 4,$ciudad2 = ($reg[0]['id_ciudad2'] == '' ? "" : mb_convert_encoding($reg[0]['ciudad2'], 'ISO-8859-1', 'UTF-8'))." ".$comuna2 = ($reg[0]['id_comuna2'] == '' ? "" : mb_convert_encoding($reg[0]['comuna2'], 'ISO-8859-1', 'UTF-8'))." ".mb_convert_encoding($reg[0]['direcsucursal2'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(132, 58);
    $this->Cell(12, 4, 'EMAIL:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(144, 58);
    $this->Cell(54, 4,mb_convert_encoding($reg[0]['correosucursal2'], 'ISO-8859-1', 'UTF-8'), 0, 0);
    //DATOS DE SUCURSAL LINEA 3

    //DATOS DE SUCURSAL LINEA 4
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(12, 62);
    $this->Cell(24, 4, 'RESPONSABLE:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(36, 62);
    $this->CellFitSpace(116, 4,mb_convert_encoding($reg[0]['nomencargado2'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(152, 62);
    $this->Cell(18, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(170, 62);
    $this->Cell(28, 4,$tlf = ($reg[0]['tlfencargado2'] == '' ? "*********" : $reg[0]['tlfencargado2']), 0, 0);
    //DATOS DE SUCURSAL LINEA 4
    ############################ BLOQUE N 3 SUCURSAL RECIBE ###############################

    ################################# BLOQUE N 4 #######################################   
    $this->SetFont($TipoLetra,'B',9);
    $this->SetXY(10, 68);
    $this->SetDrawColor(3,3,3);
    $this->SetTextColor(3,3,3);
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(8, 8,"N", 1, 0, 'C', True);
    $this->Cell(83, 8,"DESCRIPCIN DE PRODUCTO", 1, 0, 'C', True);
    $this->Cell(20, 8,"MARCA", 1, 0, 'C', True);
    $this->Cell(20, 8,"MODELO", 1, 0, 'C', True);
    $this->Cell(14, 8,"CANT", 1, 0, 'C', True);
    $this->Cell(20, 8,"PRECIO", 1, 0, 'C', True);
    $this->Cell(25, 8,"IMPORTE", 1, 1, 'C', True);
    ################################# BLOQUE N 4 ####################################### 

    ################################# BLOQUE N 5 ####################################### 
    $tra      = new Login();
    $detalle  = $tra->VerDetallesTraspasos();
    $cantidad = 0;
    $SubTotal = 0;

    $this->SetWidths(array(8,83,20,20,14,20,25));
    $this->SetAligns(array('C','L','C','C','C','C','C','C','C','C'));

    $a=1;
    for($i=0;$i<sizeof($detalle);$i++){ 
    $cantidad   += $detalle[$i]['cantidad'];
    $valortotal = $detalle[$i]["precioventa"]*$detalle[$i]["cantidad"];
    $SubTotal   += $detalle[$i]['valorneto'];

    $this->SetX(10);
    $this->SetFont($TipoLetra,'',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->RowFacture(array($a++,
        mb_convert_encoding($detalle[$i]["producto"]." ".$detalle[$i]["condicion"].$descripcion = ($detalle[$i]["producto"] != "" ? "\n".$detalle[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]["codmarca"] == '0' ? "******" : mb_convert_encoding($detalle[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]["codmodelo"] == '0' ? "******" : mb_convert_encoding($detalle[$i]["nommodelo"], 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]['cantidad'],
        $simbolo.number_format($detalle[$i]['precioventa'], 0, '.', '.'),
        $simbolo.number_format($detalle[$i]['valorneto'], 0, '.', '.')));
    }
    ################################# BLOQUE N 5 ####################################### 

    ########################### BLOQUE N 6 #############################
    $this->Ln();
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(113,5,'INFORMACIN ADICIONAL',1,0,'C', True);
    $this->Cell(2,5,"",0,0,'C');
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(35,5,'SUBTOTAL ',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(113,5,'CANTIDAD DE PRODUCTOS: '.number_format($cantidad, 2, '.', '.'),1,0,'L');
    $this->Cell(2,5,"",0,0,'C');
    $this->CellFitSpace(35,5,'GRAVADO ('.number_format($reg[0]["iva"], 0, '.', '.').'%):',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["subtotalivasi"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(113,5,'REALIZADO: '.mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'),1,0,'L');
    $this->Cell(2,5,"",0,0,'C');
    $this->CellFitSpace(35,5,'EXENTO (0%):',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["subtotalivano"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(113,5,'FECHA/HORA DE EMISIN: '.date("d/m/Y H:i:s"),1,0,'L');

    $this->Cell(2,5,"",0,0,'C');
    $this->CellFitSpace(35,5,$NomImpuesto." (".number_format($reg[0]["iva"], 0, '.', '.')."%):",1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["totaliva"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(113,5,'RESPONSABLE: '.mb_convert_encoding($reg[0]['nombres_responsable'], 'ISO-8859-1', 'UTF-8'),1,0,'L');
    $this->Cell(2,5,"",0,0,'C');
    $this->CellFitSpace(35,5,'DESCONTADO %:',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["descontado"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(113,5,'RECIBIDO: '.$recibido = ($reg[0]["persona_recibe"] == 0 ? "******" : $reg[0]["nombres2"]),1,0,'L');
    $this->Cell(2,5,"",0,0,'C');
    $this->CellFitSpace(35,5,'DESC % ('.number_format($reg[0]["descuento"], 0, '.', '.').'%):',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["totaldescuento"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(113,5,'FECHA/HORA RECIBIDO: '.$recibido = ($reg[0]['fecha_recibe'] == "" ? "******" : date("d/m/Y H:i:s",strtotime($reg[0]['fecha_recibe']))),1,0,'L');
    $this->Cell(2,5,"",0,0,'C');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(35,5,'IMPORTE TOTAL:',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["totalpago"], 0, '.', '.'),1,0,'R');
    $this->Ln(6);

    if($reg[0]['observaciones'] != ''){
    //Linea de membrete Nro 4
    $this->SetFont($TipoLetra,'B',10);
    $this->MultiCell(190,5,$this->SetFont($TipoLetra,'',10).'OBSERVACIONES ENVIA: '.$reg[0]['observaciones'] == '' ? "**********" : mb_convert_encoding($reg[0]['observaciones'], 'ISO-8859-1', 'UTF-8'),1,'J');
    }

    if($reg[0]['observaciones_recibido'] != ''){
    //Linea de membrete Nro 4
    $this->SetFont($TipoLetra,'B',10);
    $this->MultiCell(190,5,$this->SetFont($TipoLetra,'',10).'OBSERVACIONES RECIBIDO: '.$reg[0]['observaciones_recibido'] == '' ? "**********" : mb_convert_encoding($reg[0]['observaciones_recibido'], 'ISO-8859-1', 'UTF-8'),1,'J');
    }

    $this->SetXY(10,250);
    $this->QR($reg,170, 0);
}
########################## FUNCION FACTURA TRASPASOS (A4) ##############################

########################## FUNCION LISTAR TRASPASOS ##############################
function TablaListarTraspasos()
{
    $tra = new Login();
    $reg = $tra->ListarTraspasos();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE TRASPASOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'SUCURSAL REMITENTE',1,0,'C', True);
    $this->Cell(60,8,'SUCURSAL DESTINATARIO',1,0,'C', True);
    $this->Cell(40,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(35,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,60,60,40,35,25,25,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    if($reg[$i]['estado_traspaso'] == 1){
    $estado = "REGISTRADO";
    } elseif($reg[$i]['estado_traspaso'] == 2){
    $estado = "EN PROCESO";
    } elseif($reg[$i]['estado_traspaso'] == 3){
    $estado = "PENDIENTE";
    } elseif($reg[$i]['estado_traspaso'] == 4){
    $estado = "RECIBIDO"; 
    } elseif($reg[$i]['estado_traspaso'] == 5){
    $estado = "RECHAZADA";
    }
 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        "N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['cuitsucursal'].": ".$reg[$i]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['cuitsucursal2'].": ".$reg[$i]["nomsucursal2"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['observaciones'] == '' ? "******" : $reg[$i]["observaciones"], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechatraspaso'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(270,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR TRASPASOS ##############################

####################### FUNCION LISTAR TRASPASOS POR FECHAS #########################
function TablaListarTraspasosxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarTraspasosxFechas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE TRASPASOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L'); 

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'SUCURSAL REMITENTE',1,0,'C', True);
    $this->Cell(60,8,'SUCURSAL DESTINATARIO',1,0,'C', True);
    $this->Cell(40,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(35,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,60,60,40,35,25,25,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    if($reg[$i]['estado_traspaso'] == 1){
    $estado = "REGISTRADO";
    } elseif($reg[$i]['estado_traspaso'] == 2){
    $estado = "EN PROCESO";
    } elseif($reg[$i]['estado_traspaso'] == 3){
    $estado = "PENDIENTE";
    } elseif($reg[$i]['estado_traspaso'] == 4){
    $estado = "RECIBIDO"; 
    } elseif($reg[$i]['estado_traspaso'] == 5){
    $estado = "RECHAZADA";
    }
 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        "N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['cuitsucursal'].": ".$reg[$i]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['cuitsucursal2'].": ".$reg[$i]["nomsucursal2"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['observaciones'] == '' ? "******" : $reg[$i]["observaciones"], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechatraspaso'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(270,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR TRASPASOS POR FECHAS #########################

####################### FUNCION LISTAR DETALLES TRASPASOS POR FECHAS #########################
function TablaListarDetallesTraspasosxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesTraspasosxFechas(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DETALLES PRODUCTOS TRASPASADOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'CDIGO',1,0,'C', True);
    $this->Cell(90,8,'DESCRIPCIN DE PRODUCTO',1,0,'C', True);
    $this->Cell(35,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'TRASPASADO',1,0,'C', True);
    $this->Cell(30,8,'MONTO TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,30,90,35,30,20,30,30,25,30));

    $a              = 1;
    $PrecioTotal    = 0;
    $ExisteTotal    = 0;
    $VendidosTotal  = 0;
    $PagoTotal      = 0;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo        = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal    += $reg[$i]['precioventa'];
    $ExisteTotal    += $reg[$i]['existencia'];
    $VendidosTotal  += $reg[$i]['cantidad']; 

    $Descuento       = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal     = $reg[$i]['precioventa']-$PrecioDescuento;
    $PagoTotal       +=$PrecioFinal*$reg[$i]['cantidad'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]["codproducto"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "******" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]["precioventa"], 0, '.', '.'),
        $reg[$i]['existencia'],
        $reg[$i]['cantidad'],
        $simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 0, '.', '.')));
    }

    $this->Cell(220,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PrecioTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$ExisteTotal,0,0,'L');
    $this->CellFitSpace(25,5,$VendidosTotal,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PagoTotal, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DETALLES TRASPASOS POR FECHAS #########################

############################### REPORTES DE TRASPASOS ##################################





































 ############################# REPORTES DE COMPRAS ##################################

########################## FUNCION FACTURA COMPRA ##############################
function FacturaCompra()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################
    
    $tra       = new Login();
    $reg       = $tra->ComprasPorId();
    $simbolo   = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra = "Courier";

    //Logo
    if (isset($reg[0]['cuitsucursal'])) {
       if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
        $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo, 15, 11, 30, 18, "PNG");
        } else {
        $logo = "fotos/logo_principal.png";                         
        $this->Image($logo, 15, 11, 50, 18, "PNG");  
       }                                      
    }

   ######################### BLOQUE N 1 ######################### 
   //BLOQUE DE DATOS DE PRINCIPAL
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 10, 335, 20, '1.5', '');
    
    $this->SetFont($TipoLetra,'B',14);
    $this->SetXY(250, 12);
    $this->Cell(50, 5, 'N DE COMPRA ', 0, 0);
    $this->SetFont('courier','B',14);
    $this->SetXY(300, 12);
    $this->CellFitSpace(42, 5,$reg[0]['codfactura'], 0, 0, "R");
    
    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(250, 16);
    $this->Cell(50, 5, 'FECHA DE EMISIN', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(300, 16);
    $this->CellFitSpace(42, 5,date("d/m/Y",strtotime($reg[0]['fechaemision'])), 0, 0, "R");
    
    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(250, 20);
    $this->Cell(50, 5, 'FECHA DE RECEPCIN', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(300, 20);
    $this->CellFitSpace(42, 5,date("d/m/Y",strtotime($reg[0]['fecharecepcion'])), 0, 0, "R");

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(250, 24);
    $this->Cell(50, 5, 'ESTADO DE COMPRA', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(300, 24);
    
    if($reg[0]['fechavencecredito']== '0000-00-00') { 
    $this->Cell(42, 5,$reg[0]['statuscompra'], 0, 0, "R");
    } elseif($reg[0]['fechavencecredito'] >= date("Y-m-d")) { 
    $this->Cell(42, 5,$reg[0]['statuscompra'], 0, 0, "R");
    } elseif($reg[0]['fechavencecredito'] < date("Y-m-d")) { 
    $this->Cell(42, 5,"VENCIDA", 0, 0, "R");
    }
    ######################### BLOQUE N 1 ######################### 

    ############################## BLOQUE N 2 #####################################   
    //BLOQUE DE DATOS DE PROVEEDOR
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 32, 335, 30, '1.5', '');

    //DATOS DE SUCURSAL LINEA 1
    $this->SetFont($TipoLetra,'B',12);
    $this->SetXY(12, 33);
    $this->Cell(330, 5, 'DATOS DE SUCURSAL ', 0, 0);
    //DATOS DE SUCURSAL LINEA 1

    //DATOS DE SUCURSAL LINEA 2
    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(12, 38);
    $this->CellFitSpace(32, 4, 'N DE '.$documento = ($reg[0]['documsucursal'] == '0' ? "REG.:" : mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8').":"), 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(44, 38);
    $this->CellFitSpace(30, 4,$reg[0]['cuitsucursal'], 0, 0);

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(74, 38);
    $this->Cell(30, 4, 'RAZN SOCIAL:', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(104, 38);
    $this->CellFitSpace(72, 4,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(176, 38);
    $this->Cell(24, 4, 'DIRECCIN:', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(200, 38);
    $this->CellFitSpace(90, 4,$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8'))." ".$comuna = ($reg[0]['id_comuna'] == '0' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))." ".mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(290, 38);
    $this->Cell(22, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(312, 38);
    $this->CellFitSpace(32, 4,$reg[0]['tlfsucursal'], 0, 0);
    //DATOS DE SUCURSAL LINEA 2

    //DATOS DE SUCURSAL LINEA 3
    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(12, 42);
    $this->Cell(32, 4, 'EMAIL:', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(44, 42);
    $this->CellFitSpace(80, 4,mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'), 0, 0);
    //DATOS DE SUCURSAL LINEA 3

    //DATOS DE SUCURSAL LINEA 4
    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(124, 42);
    $this->Cell(30, 4, 'RESPONSABLE:', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(154, 42);
    $this->CellFitSpace(74, 4,mb_convert_encoding($reg[0]['nomencargado'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(228, 42);
    $this->CellFitSpace(28, 4,'N DE '.$documento = ($reg[0]['documencargado'] == '0' ? "DOC.:" : $reg[0]['documento2'].":"), 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(256, 42);
    $this->CellFitSpace(34, 4,$reg[0]['dniencargado'], 0, 0);

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(290, 42);
    $this->Cell(22, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(312, 42);
    $this->CellFitSpace(32, 4,$tlf = ($reg[0]['tlfencargado'] == '' ? "*********" : $reg[0]['tlfencargado']), 0, 0);
    //DATOS DE SUCURSAL LINEA 4
    ################################# BLOQUE N 2 #######################################   

    ################################# BLOQUE N 3 #######################################   
    //DATOS DE SUCURSAL LINEA 5
    $this->SetFont($TipoLetra,'B',12);
    $this->SetXY(12, 48);
    $this->Cell(330, 4, 'DATOS DE PROVEEDOR', 0, 0);
    //DATOS DE SUCURSAL LINEA 5

    //DATOS DE SUCURSAL LINEA 6
    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(12, 52);
    $this->CellFitSpace(50, 4, 'N DE '.$documento = ($reg[0]['documproveedor'] == '0' ? "DOC.:" : mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8').":"), 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(62, 52);
    $this->CellFitSpace(34, 4,mb_convert_encoding($reg[0]['cuitproveedor'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(96, 52);
    $this->Cell(30, 4, 'RAZN SOCIAL:', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(126, 52);
    $this->CellFitSpace(90, 4,mb_convert_encoding($reg[0]['nomproveedor'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(216, 52);
    $this->Cell(24, 4, 'EMAIL:', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(240, 52);
    $this->CellFitSpace(104, 4,mb_convert_encoding($reg[0]['emailproveedor'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(12, 56);
    $this->Cell(32, 4, 'DIRECCIN:', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(44, 56);
    $this->CellFitSpace(126, 4,$ciudad2 = ($reg[0]['id_ciudad2'] == '' ? "" : mb_convert_encoding($reg[0]['ciudad2'], 'ISO-8859-1', 'UTF-8'))." ".$comuna2 = ($reg[0]['id_comuna2'] == '' ? "" : mb_convert_encoding($reg[0]['comuna2'], 'ISO-8859-1', 'UTF-8'))." ".mb_convert_encoding($reg[0]['direcproveedor'], 'ISO-8859-1', 'UTF-8'), 0, 0);
    //DATOS DE SUCURSAL LINEA 6

    //DATOS DE SUCURSAL LINEA 7
    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(170, 56);
    $this->Cell(26, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(196, 56);
    $this->CellFitSpace(38, 4,$reg[0]['tlfproveedor'], 0, 0);

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(234, 56);
    $this->Cell(24, 4, 'VENDEDOR:', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(258, 56);
    $this->CellFitSpace(86, 4,mb_convert_encoding($reg[0]['vendedor'], 'ISO-8859-1', 'UTF-8'), 0, 0);
    //DATOS DE SUCURSAL LINEA 7
    ################################# BLOQUE N 3 #######################################  

    ################################# BLOQUE N 4 #######################################   
    $this->SetFont($TipoLetra,'B',9);
    $this->SetXY(10, 64);
    $this->SetTextColor(3, 3, 3); // Establece el color del texto (en este caso es Negro)
    $this->SetFillColor(229, 229, 229); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(20,8,'CDIGO',1,0,'C', True);
    $this->Cell(15,8,'LOTE',1,0,'C', True);
    $this->Cell(23,8,'F.VCTO PT',1,0,'C', True);
    $this->Cell(94,8,'DESCRIPCIN DE PRODUCTO',1,0,'C', True);
    $this->Cell(20,8,'MARCA',1,0,'C', True);
    $this->Cell(20,8,'MODELO',1,0,'C', True);
    $this->Cell(15,8,'CANT',1,0,'C', True);
    $this->Cell(15,8,$NomImpuesto,1,0,'C', True);
    $this->Cell(25,8,'PRECIO UNIT',1,0,'C', True);
    $this->Cell(28,8,'VALOR TOTAL',1,0,'C', True);
    $this->Cell(18,8,'DCTO %',1,0,'C', True);
    $this->Cell(32,8,'VALOR NETO',1,1,'C', True);
    ################################# BLOQUE N 4 ####################################### 

    ################################# BLOQUE N 5 ####################################### 
    $tra      = new Login();
    $detalle  = $tra->VerDetallesCompras();
    $cantidad = 0;
    $SubTotal = 0;

     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,20,15,23,94,20,20,15,15,25,28,18,32));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($detalle);$i++){ 
    $cantidad   += $detalle[$i]['cantcompra'];
    $valortotal = $detalle[$i]["preciocompra"]*$detalle[$i]["cantcompra"];
    $SubTotal   += $detalle[$i]['valorneto'];

    $this->SetX(10);
    $this->SetFont($TipoLetra,'',9);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->RowFacture(array($a++,
        $detalle[$i]["codproducto"],
        $detalle[$i]["lote"],
        $detalle[$i]["fechaoptimo"] == '0000-00-00' ? "******" : $detalle[$i]["fechaoptimo"],
        mb_convert_encoding($detalle[$i]["producto"]." ".$detalle[$i]["condicion"].$descripcion = ($detalle[$i]["producto"] != "" ? "\n".$detalle[$i]["descripcion"] : "").$imei = ($detalle[$i]["imei"] != "" ? "\nIMEI: ".$detalle[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]["nommarca"] == '' ? "******" : mb_convert_encoding($detalle[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]["nommodelo"] == '' ? "******" : mb_convert_encoding($detalle[$i]["nommodelo"], 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]['cantcompra'],
        $detalle[$i]["ivaproducto"] != '0.00' ? number_format($detalle[$i]["ivaproducto"], 0, '.', '.')."%" : "(E)",
        $simbolo.number_format($detalle[$i]['preciocompra'], 0, '.', '.'),
        $simbolo.number_format($detalle[$i]['valortotal'], 0, '.', '.'),
        number_format($detalle[$i]['descfactura'], 0, '.', '.'),
        $simbolo.number_format($detalle[$i]['valorneto'], 0, '.', '.')));
    }
    ################################# BLOQUE N 5 ####################################### 

    ########################### BLOQUE N 6 #############################
    $this->Ln();
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',14);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(220,5,'INFORMACIN ADICIONAL',1,0,'C', True);
    $this->Cell(5,5,"",0,0,'C');
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(50,5,'SUBTOTAL ',1,0,'L', True);
    $this->CellFitSpace(60,5,$simbolo.number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(220,5,'CANTIDAD DE PRODUCTOS: '.number_format($cantidad, 2, '.', '.'),1,0,'L');
    $this->Cell(5,5,"",0,0,'C');
    $this->CellFitSpace(50,5,'GRAVADO ('.number_format($reg[0]["iva"], 0, '.', '.').'%):',1,0,'L', True);
    $this->CellFitSpace(60,5,$simbolo.number_format($reg[0]["subtotalivasi"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(220,5,'TIPO DE DOCUMENTO: FACTURA',1,0,'L');
    $this->Cell(5,5,"",0,0,'C');
    $this->CellFitSpace(50,5,'EXENTO (0%):',1,0,'L', True);
    $this->CellFitSpace(60,5,$simbolo.number_format($reg[0]["subtotalivano"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    if($reg[0]['fechavencecredito'] == '0000-00-00' || $reg[0]['fechavencecredito'] >= date("Y-m-d")) {
    $estado = $reg[0]['statuscompra'];
    $dias_vencidos = "0";
    } elseif($reg[0]['fechavencecredito'] < date("Y-m-d")) { 
    $estado = "VENCIDA";
    $dias_vencidos = Dias_Transcurridos(date("Y-m-d"),$reg[0]['fechavencecredito']);
    }

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(220,5,'TIPO DE PAGO: '.$reg[0]['tipocompra']." ".$vencimiento = ($reg[0]['tipocompra'] == "CREDITO" ? " | FECHA VENCIMIENTO: ".date("d/m/Y",strtotime($reg[0]['fechavencecredito'])) : "")." ".$dias = ($reg[0]['tipocompra'] == "CREDITO" ? " | DIAS VENCIDOS: ".$dias_vencidos : ""),1,0,'L');

    $this->Cell(5,5,"",0,0,'C');
    $this->CellFitSpace(50,5,$NomImpuesto." (".number_format($reg[0]["iva"], 0, '.', '.')."%):",1,0,'L', True);
    $this->CellFitSpace(60,5,$simbolo.number_format($reg[0]["totaliva"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(220,5,'FORMA DE PAGO: '.$variable = ($reg[0]['tipocompra'] == 'CONTADO' ? mb_convert_encoding($reg[0]['mediopago'], 'ISO-8859-1', 'UTF-8') : $reg[0]['formacompra']),1,0,'L');
    $this->Cell(5,5,"",0,0,'C');
    $this->CellFitSpace(50,5,'DESCONTADO %:',1,0,'L', True);
    $this->CellFitSpace(60,5,$simbolo.number_format($reg[0]["descontado"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)

    $this->CellFitSpace(220,5,'REALIZADO: '.mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'),1,0,'L');
    $this->Cell(5,5,"",0,0,'C');
    $this->CellFitSpace(50,5,'DESC % ('.number_format($reg[0]["descuento"], 0, '.', '.').'%):',1,0,'L', True);
    $this->CellFitSpace(60,5,$simbolo.number_format($reg[0]["totaldescuento"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(220,5,'FECHA DE EMISIN (IMPRESO): '.date("d/m/Y"),1,0,'L');
    $this->Cell(5,5,"",0,0,'C');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(50,5,'GASTO DE ENVIO:',1,0,'L', True);
    $this->CellFitSpace(60,5,$simbolo.number_format($reg[0]["gastoenvio"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(220,5,'HORA DE EMISIN (IMPRESO): '.date("H:i:s"),1,0,'L');
    $this->Cell(5,5,"",0,0,'C');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(50,5,'IMPORTE TOTAL:',1,0,'L', True);
    $this->CellFitSpace(60,5,$simbolo.number_format($reg[0]["totalpago"]+$reg[0]["gastoenvio"], 0, '.', '.'),1,0,'R');
    $this->Ln(6);

    if($reg[0]['observaciones'] != ''){
    //Linea de membrete Nro 4
    $this->SetFont($TipoLetra,'B',10);
    $this->MultiCell(330,5,$this->SetFont($TipoLetra,'B',10).'OBSERVACIONES: '.$reg[0]['observaciones'] == '' ? "**********" : mb_convert_encoding($reg[0]['observaciones'], 'ISO-8859-1', 'UTF-8'),0,'J');
    }
    ################################# BLOQUE N 6 ####################################### 
}
########################## FUNCION FACTURA COMPRA ##############################

########################## FUNCION TICKET COMPRA ##############################
function TicketCreditoCompra()
{  
    $tra       = new Login();
    $reg       = $tra->ComprasPorId();
    $simbolo   = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra = "Courier";

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
        $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo , 20, 3, 35, 15, "PNG");
        $this->Ln(8);
    }
  
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5, "TICKET DE CRDITO", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,3,$reg[0]['documsucursal'] == '0' ? "" : "N ".mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$reg[0]['cuitsucursal'],0,1,'C');

    if($reg[0]['id_comuna']!='0'){

    $this->SetX(2);
    $this->CellFitSpace(70,3,$comuna = ($reg[0]['id_comuna'] == '0' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))." ".$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8')),0,1,'C');

    }

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,'C');

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'),0,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,3,$documento = ($reg[0]['documproveedor'] == '0' ? "N DOC:" : "N ".mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8').": ".$reg[0]['cuitproveedor']),0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['nomproveedor'], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding(getSubString($reg[0]['direcproveedor'],55), 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(2);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(35,4,"Nro Factura:  ", 0, 0, 'J');
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(35,4,$reg[0]['codfactura'], 0, 1, 'R');
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(33,4,"EMISIN: ".date("d/m/Y",strtotime($reg[0]['fechaemision'])), 0, 0, 'J');
    $this->CellFitSpace(37,4,"RECEPCIN: ".date("d/m/Y",strtotime($reg[0]['fecharecepcion'])), 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(33,4,"VENCE: ".date("d/m/Y",strtotime($reg[0]['fechavencecredito'])), 0, 0, 'J');
    if($reg[0]['fechavencecredito'] == '0000-00-00' || $reg[0]['fechavencecredito'] >= date("Y-m-d")) {
    $this->CellFitSpace(37,4,"DIAS VENC: "."0", 0, 0, 'R');  
    } elseif($reg[0]['fechavencecredito'] < date("Y-m-d")) {
    $this->CellFitSpace(37,4,"DIAS VENC: ".Dias_Transcurridos(date("Y-m-d"),$reg[0]['fechavencecredito']), 0, 0, 'R'); 
    }
    $this->Ln();

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5,"DETALLES DE ABONOS", 0, 0, 'L');
    $this->Ln(5);

    $tra = new Login();
    $detalle = $tra->VerDetallesAbonosCompras();
    if($detalle==""){
        echo "";      
    } else {
    $cantidad = 0;
    $SubTotal = 0;
    $a=1;
    for($i=0;$i<sizeof($detalle);$i++):

    $this->SetX(2);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(35,3,mb_convert_encoding($detalle[$i]['mediopago'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(35,3,$simbolo.number_format($detalle[$i]['montoabono'], 0, '.', '.'),0,1,'R');

    
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(30,3,$detalle[$i]['comprobante'] == "" ? "******" : "#".$detalle[$i]['comprobante'],0,0,'L');
    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(40,3,$detalle[$i]['codbanco'] == 0 ? "******" : mb_convert_encoding($detalle[$i]['nombanco'], 'ISO-8859-1', 'UTF-8'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(35,3,date("d/m/Y H:i:s",strtotime($detalle[$i]['fechaabono'])),0,1,'L');
    $this->Ln(2);

    endfor; 
    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(20,4,"TOTAL",0,0,'L');
    $this->Cell(50,4,$simbolo.number_format($reg[0]['totalpago']+$reg[0]['gastoenvio'], 0, '.', '.'),0,1,'R');  

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(30,4,"ABONADO",0,0,'L');
    $this->Cell(40,4,$simbolo.number_format($reg[0]['creditopagado'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(30,4,"PENDIENTE",0,0,'L');
    $this->Cell(40,4,$simbolo.number_format($reg[0]['totalpago']+$reg[0]['gastoenvio']-$reg[0]['creditopagado'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'),0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(10,4,"TEL:",0,0,'L');
    $this->CellFitSpace(60,4,$reg[0]['tlfsucursal'],0,1,'L');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'BI',10);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(70,3," ",0,1,'C');
    $this->Ln(3);
}
########################## FUNCION TICKET CREDITO COMPRA ##############################

########################## FUNCION LISTAR COMPRAS POR BUSQUEDA ##############################
function TablaListarComprasxBusqueda()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BusquedaCompras();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if($_GET['tipobusqueda'] == 1){
    $this->Cell(335,10,'LISTADO GENERAL DE COMPRAS A PROVEEDORES',0,0,'C');
    } elseif($_GET['tipobusqueda'] == 2){
    $this->Cell(335,10,'LISTADO DE COMPRAS A PROVEEDORES POR BSQUEDA',0,0,'C');
    } elseif($_GET['tipobusqueda'] == 3){
    $this->Cell(335,10,'LISTADO DE COMPRAS A PROVEEDORES POR FECHAS',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    if($_GET['tipobusqueda'] == 2){
    $this->Ln();
    $this->Cell(335,6,"BSQUEDA: ".mb_convert_encoding($_GET["search_criterio"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    } elseif($_GET['tipobusqueda'] == 3){
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(35,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(30,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(40,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(35,8,'GASTO ENVIO',1,0,'C', True);
    $this->Cell(45,8,'IMPORTE TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,70,35,30,40,35,35,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalGasto     = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);  
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalGasto     += $reg[$i]['gastoenvio'];
    $TotalImporte   += $reg[$i]['totalpago']+$reg[$i]['gastoenvio'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        "FACTURA N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['cuitproveedor'].": ".$reg[$i]["nomproveedor"], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y",strtotime($reg[$i]['fechaemision'])),
        number_format($reg[$i]["articulos"], 2, '.', ','),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['gastoenvio'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio'], 0, '.', '.')));
    }

    $this->Cell(150,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,number_format($TotalArticulos, 2, '.', ','),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalGasto, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMPRAS POR BUSQUEDA ##############################

######################### FUNCION LISTAR CUENTAS POR PAGAR ###########################
function TablaListarCuentasxPagar()
{
    $tra = new Login();
    $reg = $tra->ListarCuentasxPagar();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE CUENTAS POR PAGAR',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(30,8,'FECHA VENCE',1,0,'C', True);
    $this->Cell(45,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(45,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(45,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,65,25,30,30,45,45,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalGasto   = 0;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalGasto   += $reg[$i]['gastoenvio'];
    $TotalImporte += $reg[$i]['totalpago']+$reg[$i]['gastoenvio'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']+$reg[$i]['gastoenvio']-$reg[$i]['total_nc']-$reg[$i]['creditopagado'];

    if($reg[$i]["statuscompra"] == 'PAGADA'){ 
    $estado = $reg[$i]["statuscompra"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statuscompra"];
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        "FACTURA N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['cuitproveedor'].": ".$reg[$i]['nomproveedor'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y",strtotime($reg[$i]['fechaemision'])),
        date("d/m/Y",strtotime($reg[$i]['fechavencecredito'])),
        $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio']-$reg[$i]['creditopagado'], 0, '.', '.')));
    }
   
    $this->Cell(200,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CUENTAS POR PAGAR ##########################

######################### FUNCION LISTAR CUENTAS POR PAGAR POR BUSQUEDA ###########################
function TablaListarCuentasxPagarxBusqueda()
{
    $tra = new Login();
    $reg = $tra->BusquedaCuentasxPagar();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if($_GET['tipobusqueda'] == 1){
    $this->Cell(335,10,'LISTADO GENERAL DE CUENTAS POR PAGAR A PROVEEDORES',0,0,'C');
    } elseif($_GET['tipobusqueda'] == 2){
    $this->Cell(335,10,'LISTADO DE CUENTAS POR PAGAR A PROVEEDORES POR BSQUEDA',0,0,'C');
    } elseif($_GET['tipobusqueda'] == 3){
    $this->Cell(335,10,'LISTADO DE CUENTAS POR PAGAR A PROVEEDORES POR FECHAS',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    if($_GET['tipobusqueda'] == 2){
    $this->Ln();
    $this->Cell(335,6,"BSQUEDA: ".mb_convert_encoding($_GET["search_criterio"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    } elseif($_GET['tipobusqueda'] == 3){
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(30,8,'FECHA VENCE',1,0,'C', True);
    $this->Cell(45,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(45,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(45,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,65,25,30,30,45,45,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalGasto   = 0;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalGasto   += $reg[$i]['gastoenvio'];
    $TotalImporte += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']+$reg[$i]['gastoenvio']-$reg[$i]['creditopagado'];
    
    if($reg[$i]["statuscompra"] == 'PAGADA'){ 
    $estado = $reg[$i]["statuscompra"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statuscompra"];
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        "FACTURA N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['cuitproveedor'].": ".$reg[$i]['nomproveedor'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y",strtotime($reg[$i]['fechaemision'])),
        date("d/m/Y",strtotime($reg[$i]['fechavencecredito'])),
        $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio']-$reg[$i]['creditopagado'], 0, '.', '.')));
    }
   
    $this->Cell(200,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CUENTAS POR PAGAR POR BUSQUEDA ##########################

######################### FUNCION LISTAR CUENTAS POR PAGAR VENCIDAS ###########################
function TablaListarCuentasxPagarVencidas()
{
    $tra = new Login();
    $reg = $tra->ListarCuentasxPagarVencidas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(330,10,'LISTADO DE CUENTAS POR PAGAR VENCIDAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(30,8,'FECHA VENCE',1,0,'C', True);
    $this->Cell(45,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(45,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(45,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,65,25,30,30,45,45,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalGasto   = 0;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalGasto   += $reg[$i]['gastoenvio'];
    $TotalImporte += $reg[$i]['totalpago']+$reg[$i]['gastoenvio'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']+$reg[$i]['gastoenvio']-$reg[$i]['creditopagado'];
    
    if($reg[$i]["statuscompra"] == 'PAGADA'){ 
    $estado = $reg[$i]["statuscompra"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statuscompra"];
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        "FACTURA N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['cuitproveedor'].": ".$reg[$i]['nomproveedor'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y",strtotime($reg[$i]['fechaemision'])),
        date("d/m/Y",strtotime($reg[$i]['fechavencecredito'])),
        $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio']-$reg[$i]['creditopagado'], 0, '.', '.')));
    
    $this->Cell(200,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CUENTAS POR PAGAR VENCIDAS ##########################

####################### FUNCION LISTAR COMPRAS POR PROVEEDORES #########################
function TablaListarComprasxProveedor()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarComprasxProveedor();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE COMPRAS POR PROVEEDOR',0,0,'C');
    
    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"N ".$documento = ($reg[0]['documproveedor'] == '0' ? "DOCUMENTO" : mb_convert_encoding($reg[0]['documento3'] ?? "******", 'ISO-8859-1', 'UTF-8'))." PROVEEDOR: ".$reg[0]["cuitproveedor"],0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"PROVEEDOR: ".mb_convert_encoding($reg[0]["nomproveedor"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,6,"N TELFONO: ".$tlfproveedor = ($reg[0]['tlfproveedor'] == '' ? "******" : $reg[0]["tlfproveedor"]),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(40,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(40,8,'ESTADO',1,0,'C', True);
    $this->Cell(40,8,'FECHA VENCE',1,0,'C', True);
    $this->Cell(30,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(45,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(40,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(50,8,'IMPORTE TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,40,40,40,30,45,40,50));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalGasto     = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);  

    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalGasto     += $reg[$i]['gastoenvio'];
    $TotalImporte   += $reg[$i]['totalpago']+$reg[$i]['gastoenvio'];
    
    if($reg[$i]["statuscompra"] == 'PAGADA'){ 
    $estado = $reg[$i]["statuscompra"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statuscompra"];
    }
  
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            "FACTURA N: ".$reg[$i]["codfactura"],
            date("d/m/Y",strtotime($reg[$i]['fechaemision'])),
            mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
            $reg[$i]['fechavencecredito'] == '0000-00-00' ? "******" : date("d/m/Y",strtotime($reg[$i]['fechavencecredito'])),
            number_format($reg[$i]["articulos"], 2, '.', ','),
            $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
            $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
            $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio'], 0, '.', '.')));
        }
    }

    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,number_format($TotalArticulos, 2, '.', ','),0,0,'L');
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(50,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR COMPRAS POR PROVEEDORES #########################

########################## FUNCION LISTAR COMPRAS POR FECHAS ##############################
function TablaListarComprasxFechas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarComprasxFechas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE COMPRAS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(35,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(22,8,'ESTADO',1,0,'C', True);
    $this->Cell(28,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(30,8,'GASTO ENVIO',1,0,'C', True);
    $this->Cell(45,8,'IMPORTE TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,65,35,22,28,35,30,30,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalGasto     = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);  

    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalGasto     += $reg[$i]['gastoenvio'];
    $TotalImporte   += $reg[$i]['totalpago']+$reg[$i]['gastoenvio'];
    
    if($reg[$i]["statuscompra"] == 'PAGADA'){ 
    $estado = $reg[$i]["statuscompra"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statuscompra"];
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        "FACTURA N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['cuitproveedor'].": ".$reg[$i]['nomproveedor'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y",strtotime($reg[$i]['fechaemision'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]["articulos"], 2, '.', ','),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['gastoenvio'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio'], 0, '.', '.')));
    }
   
    $this->Cell(167,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(28,5,number_format($TotalArticulos, 2, '.', ','),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalGasto, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMPRAS POR FECHAS ##############################

######################## FUNCION LISTAR ABONOS CREDITOS POR FECHAS #########################
function TablaListarAbonosCreditosComprasxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarAbonosCreditosComprasxFechas();

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,"LISTADO DE ABONOS DE COMPRAS A CRDITOS POR FECHAS",0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"FORMA DE ABONO: ".mb_convert_encoding($reg[0]["mediopago"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(45,8,'N DE DOCUMENTO',1,0,'C', True);
    $this->Cell(75,8,'DESCRIPCIN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(45,8,'FECHA DE ABONO',1,0,'C', True);
    $this->Cell(40,8,'N DE COMPROBANTE',1,0,'C', True);
    $this->Cell(40,8,'NOMBRE DE BANCO',1,0,'C', True);
    $this->Cell(45,8,'MONTO ABONO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,30,45,75,45,40,40,45));

    $a=1;
    $TotalImporte=0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalImporte+=$reg[$i]['montoabono'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            "FACTURA N: ".$reg[$i]["codfactura"],
            mb_convert_encoding($reg[$i]['documento3'].": ".$reg[$i]['cuitproveedor'], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]['nomproveedor'], 'ISO-8859-1', 'UTF-8'),
            date("d/m/Y H:i:s",strtotime($reg[$i]['fechaabono'])),
            $reg[$i]['comprobante'] == "" ? "********" : $reg[$i]['comprobante'],
            mb_convert_encoding($reg[$i]['codbanco'] == 0 ? "********" : $reg[$i]['nombanco'], 'ISO-8859-1', 'UTF-8'),
            $simbolo.number_format($reg[$i]['montoabono'], 0, '.', '.')));
        }
    }
   
    $this->Cell(290,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(45,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR ABONOS CREDITOS POR FECHAS #########################

######################## FUNCION LISTAR CREDITOS POR PROVEEDOR ########################
function TablaListarCreditosComprasxProveedor()
{
    $tra = new Login();
    $reg = $tra->BuscarCreditosComprasxProveedor();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['status']) == 1){ 
    $this->Cell(335,10,'LISTADO DE COMPRAS A CRDITOS EN GENERAL POR PROVEEDOR',0,0,'C');
    } elseif(decrypt($_GET['status']) == 2){ 
    $this->Cell(335,10,'LISTADO DE COMPRAS A CRDITOS PAGADOS POR PROVEEDOR',0,0,'C');
    } elseif(decrypt($_GET['status']) == 3){ 
    $this->Cell(335,10,'LISTADO DE COMPRAS A CRDITOS PENDIENTES POR PROVEEDOR',0,0,'C');
    }
    
    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"N ".$documento = ($reg[0]['documproveedor'] == '0' ? "DOCUMENTO" : mb_convert_encoding($reg[0]['documento3'] ?? "******", 'ISO-8859-1', 'UTF-8'))." PROVEEDOR: ".$reg[0]["cuitproveedor"],0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"PROVEEDOR: ".mb_convert_encoding($reg[0]["nomproveedor"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,6,"N TELFONO: ".$tlfproveedor = ($reg[0]['tlfproveedor'] == '' ? "******" : $reg[0]["tlfproveedor"]),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(80,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(30,8,'ESTADO',1,0,'C', True);
    $this->Cell(20,8,'DIAS VENC',1,0,'C', True);
    $this->Cell(40,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(40,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,80,30,20,40,40,40,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalGasto   = 0;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalGasto   += $reg[$i]['gastoenvio'];
    $TotalImporte += $reg[$i]['totalpago']+$reg[$i]['gastoenvio'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']+$reg[$i]['gastoenvio']-$reg[$i]['creditopagado']; 
    
    if($reg[$i]["statuscompra"] == 'PAGADA'){ 
    $estado = $reg[$i]["statuscompra"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statuscompra"];
    }

    if($reg[$i]['fechavencecredito'] == '0000-00-00'){
        $vencecredito = "0";
    } elseif($reg[$i]['fechavencecredito'] != '0000-00-00' && $reg[$i]['fechapagado'] != "0000-00-00"){
        $vencecredito = "0";
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00"){
        $vencecredito = "0";
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00"){
        $vencecredito = Dias_Transcurridos(date("Y-m-d"),$reg[$i]['fechavencecredito']);
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] != "0000-00-00"){
        $vencecredito = Dias_Transcurridos($reg[$i]['fechapagado'],$reg[$i]['fechavencecredito']);
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            "FACTURA N: ".$reg[$i]["codfactura"],
            mb_convert_encoding($reg[$i]['observaciones'] == "" ? "********" : $reg[$i]['observaciones'], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
            $vencecredito,
            date("d/m/Y",strtotime($reg[$i]['fechaemision'])),
            $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio'], 0, '.', '.'),
            $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
            $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio']-$reg[$i]['creditopagado'], 0, '.', '.')));
        }
    }
   
    $this->Cell(220,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CREDITOS POR PROVEEDOR ########################

########################## FUNCION LISTAR CREDITOS DE COMPRAS POR FECHAS #########################
function TablaListarCreditosComprasxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarCreditosComprasxFechas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['status']) == 1){ 
    $this->Cell(335,10,'LISTADO DE COMPRAS A CRDITOS EN GENERAL POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['status']) == 2){ 
    $this->Cell(335,10,'LISTADO DE COMPRAS A CRDITOS PAGADOS POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['status']) == 3){ 
    $this->Cell(335,10,'LISTADO DE COMPRAS A CRDITOS PENDIENTES POR FECHAS',0,0,'C');
    }
    
    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L'); 

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(80,8,'DESCRIPCIN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(30,8,'ESTADO',1,0,'C', True);
    $this->Cell(20,8,'DIAS VENC',1,0,'C', True);
    $this->Cell(40,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(40,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,80,30,20,40,40,40,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalGasto   = 0;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalGasto   += $reg[$i]['gastoenvio'];
    $TotalImporte += $reg[$i]['totalpago']+$reg[$i]['gastoenvio'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']+$reg[$i]['gastoenvio']-$reg[$i]['creditopagado']; 
    
    if($reg[$i]["statuscompra"] == 'PAGADA'){ 
    $estado = $reg[$i]["statuscompra"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statuscompra"];
    }

    if($reg[$i]['fechavencecredito'] == '0000-00-00'){
        $vencecredito = "0";
    } elseif($reg[$i]['fechavencecredito'] != '0000-00-00' && $reg[$i]['fechapagado'] != "0000-00-00"){
        $vencecredito = "0";
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00"){
        $vencecredito = "0";
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00"){
        $vencecredito = Dias_Transcurridos(date("Y-m-d"),$reg[$i]['fechavencecredito']);
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] != "0000-00-00"){
        $vencecredito = Dias_Transcurridos($reg[$i]['fechapagado'],$reg[$i]['fechavencecredito']);
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            "FACTURA N: ".$reg[$i]["codfactura"],
            $reg[$i]['cuitproveedor'].": ".mb_convert_encoding($reg[$i]['nomproveedor'], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
            $vencecredito,
            date("d/m/Y",strtotime($reg[$i]['fechaemision'])),
            $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio'], 0, '.', '.'),
            $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
            $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]['gastoenvio']-$reg[$i]['creditopagado'], 0, '.', '.')));
       }
    }

    $this->Cell(220,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();
    

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CREDITOS DE COMPRAS POR FECHAS #########################

########################## FUNCION LISTAR DETALLES CREDITOS COMPRAS POR PROVEEDOR #########################
function TablaListarDetallesCreditosComprasxProveedor()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesCreditosComprasxProveedor();

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['status']) == 1){ 
    $this->Cell(335,10,'DETALLES DE COMPRAS A CRDITOS GENERAL POR PROVEEDOR',0,0,'C');
    } elseif(decrypt($_GET['status']) == 2){ 
    $this->Cell(335,10,'DETALLES DE COMPRAS A CRDITOS PAGADOS POR PROVEEDOR',0,0,'C');
    } elseif(decrypt($_GET['status']) == 3){ 
    $this->Cell(335,10,'DETALLES DE COMPRAS A CRDITOS PENDIENTES POR PROVEEDOR',0,0,'C');
    }
    
   if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"N ".$documento = ($reg[0]['documproveedor'] == '0' ? "DOCUMENTO" : mb_convert_encoding($reg[0]['documento3'] ?? "******", 'ISO-8859-1', 'UTF-8'))." PROVEEDOR: ".$reg[0]["cuitproveedor"],0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"PROVEEDOR: ".mb_convert_encoding($reg[0]["nomproveedor"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    $this->Ln();
    $this->Cell(335,6,"N TELFONO: ".$tlfproveedor = ($reg[0]['tlfproveedor'] == '' ? "******" : $reg[0]["tlfproveedor"]),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DIRECCIN DOMICILIARIA: ".mb_convert_encoding($reg[0]['direcproveedor'] == "" ? "********" : $reg[0]['direcproveedor'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
 
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(33,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(22,8,'ESTADO',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(100,8,'DETALLES DE PRODUCTOS',1,0,'C', True);
    $this->Cell(35,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(30,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,33,22,30,100,35,30,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalGasto   = 0;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalGasto   += $reg[$i]['gastoenvio'];
    $TotalImporte += $reg[$i]['totalpago']+$reg[$i]['gastoenvio'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']+$reg[$i]['gastoenvio']-$reg[$i]['creditopagado']; 
    
    if($reg[$i]["statuscompra"] == 'PAGADA'){ 
    $estado = $reg[$i]["statuscompra"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statuscompra"];
    }

    $detalles_productos = (string)($reg[$i]['detalles_productos'] ?? '');
    //$detalles_abonos    = (string)($reg[$i]['detalles_abonos'] ?? '');

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            "FACTURA N: ".$reg[$i]["codfactura"],
            mb_convert_encoding($reg[$i]['observaciones'] == '' ? "***********" : $reg[$i]['observaciones'], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
            date("d/m/Y",strtotime($reg[$i]['fechaemision'])),
            mb_convert_encoding(str_replace("<br>","\n", $detalles_productos), 'ISO-8859-1', 'UTF-8'),
            $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]["gastoenvio"], 0, '.', '.'),
            $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
            $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]["gastoenvio"]-$reg[$i]['creditopagado'], 0, '.', '.')));
        }
    }
   
    $this->Cell(235,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DETALLES CREDITOS COMPRAS POR PROVEEDOR #########################

########################## FUNCION LISTAR DETALLES CREDITOS COMPRAS POR FECHAS #########################
function TablaListarDetallesCreditosComprasxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesCreditosComprasxFechas();

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['status']) == 1){ 
    $this->Cell(335,10,'DETALLES DE COMPRAS A CRDITOS EN GENERAL POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['status']) == 2){ 
    $this->Cell(335,10,'DETALLES DE COMPRAS A CRDITOS PAGADOS POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['status']) == 3){ 
    $this->Cell(335,10,'DETALLES DE COMPRAS A CRDITOS PENDIENTES POR FECHAS',0,0,'C');
    }
    
    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
 
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(53,8,'DESCRIPCIN DE PROVEEDOR',1,0,'C', True);
    $this->Cell(22,8,'ESTADO',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(80,8,'DETALLES DE PRODUCTOS',1,0,'C', True);
    $this->Cell(35,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(35,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(35,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,53,22,30,80,35,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalGasto   = 0;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalGasto   += $reg[$i]['gastoenvio'];
    $TotalImporte += $reg[$i]['totalpago']+$reg[$i]['gastoenvio'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']+$reg[$i]['gastoenvio']-$reg[$i]['creditopagado']; 
    
    if($reg[$i]["statuscompra"] == 'PAGADA'){ 
    $estado = $reg[$i]["statuscompra"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statuscompra'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statuscompra"];
    } 

    $detalles_productos = (string)($reg[$i]['detalles_productos'] ?? '');
    //$detalles_abonos    = (string)($reg[$i]['detalles_abonos'] ?? '');

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            "FACTURA N: ".$reg[$i]["codfactura"],
            mb_convert_encoding($reg[$i]['observaciones'] == '' ? "***********" : $reg[$i]['observaciones'], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
            date("d/m/Y",strtotime($reg[$i]['fechaemision'])),
            mb_convert_encoding(str_replace("<br>","\n", $detalles_productos), 'ISO-8859-1', 'UTF-8'),
            $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]["gastoenvio"], 0, '.', '.'),
            $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
            $simbolo.number_format($reg[$i]['totalpago']+$reg[$i]["gastoenvio"]-$reg[$i]['creditopagado'], 0, '.', '.')));
        }
    }

    $this->Cell(230,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();
    

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DETALLES CREDITOS COMPRAS POR FECHAS #########################

################################ REPORTES DE COMPRAS ################################
















############################### REPORTES DE COTIZACIONES #############################

########################## FUNCION TICKET COTIZACION ##############################
function TicketCotizacion()
{       
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################
    
    $tra       = new Login();
    $reg       = $tra->CotizacionesPorId();
    $simbolo   = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra = "Courier";

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
        $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo , 20, 3, 35, 15, "PNG");
        $this->Ln(8);
    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5, "TICKET DE COTIZACIN", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,3,$reg[0]['documsucursal'] == '0' ? "" : "N ".mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$reg[0]['cuitsucursal'],0,1,'C');

    if($reg[0]['id_comuna']!='0'){

    $this->SetX(2);
    $this->CellFitSpace(70,3,$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8'))." ".$comuna = ($reg[0]['id_comuna'] == '0' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8')),0,1,'C');
    }

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,'C');

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'),0,'C');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);
    
    if($reg[0]['codcliente'] == '0'){

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(70,4,"A CONSUMIDOR FINAL", 0, 1, 'J');   

    } else {

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,3,$documento = ($reg[0]['documcliente'] == '0' ? "N DOC" : "N ".mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8')).": ".$reg[0]['dnicliente'],0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['direccliente'].$comuna = ($reg[0]['id_comuna'] == '0' ? "" : " ".$reg[0]['comuna'])."".$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : " ".$reg[0]['ciudad']), 'ISO-8859-1', 'UTF-8'),0,'L');

    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(2);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(35,4,"Nro Ticket:  ", 0, 0, 'J');
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(35,4,$reg[0]['codfactura'], 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(18,4,"VENDEDOR:", 0, 0, 'J');
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(52,4,mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(35,4,"FECHA: ".date("d/m/Y",strtotime($reg[0]['fechacotizacion'])), 0, 0, 'J');
    $this->CellFitSpace(35,4,"HORA: ".date("H:i:s",strtotime($reg[0]['fechacotizacion'])), 0, 0, 'R');
    $this->Ln();

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5,"DETALLES DE PRODUCTOS", 0, 0, 'L');
    $this->Ln(5);

    $tra = new Login();
    $detalle = $tra->VerDetallesCotizaciones();
    $cantidad = 0;
    $SubTotal = 0;
    $Articulos = 0;
    $a=1;
    for($i=0;$i<sizeof($detalle);$i++):
    $SubTotal += $detalle[$i]['valortotal'];
    $Articulos += $detalle[$i]['cantcotizacion'];

    $this->SetX(2);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    
    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(35,3,$detalle[$i]['cantcotizacion']." X ".$simbolo.number_format($detalle[$i]["precioventa"], 0, '.', '.'),0,0,'J');

    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(35,3,$simbolo.number_format($detalle[$i]["valorneto"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->MultiCell(70,3,mb_convert_encoding($detalle[$i]["producto"]." ".$detalle[$i]["condicion"], 'ISO-8859-1', 'UTF-8'),0,1,'');

    if($detalle[$i]["descripcion"] != ""){
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',6);
    $this->MultiCell(70,3,mb_convert_encoding($detalle[$i]["descripcion"], 'ISO-8859-1', 'UTF-8'),0,1,'');
    }

    if($detalle[$i]["imei"] != ""){
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',6);
    $this->MultiCell(70,3,"N DE IMEI: ".mb_convert_encoding($detalle[$i]["imei"], 'ISO-8859-1', 'UTF-8'),0,1,'');
    }

    endfor;

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(22,4,"SUBTOTAL",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','',9);
    $this->CellFitSpace(22,4,$NomImpuesto." (".number_format($reg[0]["iva"], 0, '.', '.')."%)",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]["totaliva"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(22,4,"DESC (".number_format($reg[0]["descuento"], 0, '.', '.')."%)",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]['totaldescuento'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(22,4,"TOTAL",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]['totalpago'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetDrawColor(3,3,3);
    $this->SetFont($TipoLetra,'',7);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->MultiCell(70,4,mb_convert_encoding(numtoletras(number_format($reg[0]['totalpago'], 2, '.', '')), 'ISO-8859-1', 'UTF-8'),0,1,'');

    if($reg[0]['observaciones']!=""){
    ########################### OBSERVACIONES #############################
    $this->Ln(2);  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',8);
    $this->MultiCell(70,4,mb_convert_encoding($reg[0]['observaciones'], 'ISO-8859-1', 'UTF-8'),0,1,'');
    $this->Ln(2);
    ########################### OBSERVACIONES #############################    
    }

    $this->Ln();
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(30,4,"CANTIDAD TOTAL:",0,0,'L');
    $this->CellFitSpace(40,4,$Articulos,0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'),0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(10,4,"TEL:",0,0,'L');
    $this->CellFitSpace(60,4,$reg[0]['tlfsucursal'],0,1,'L');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont('Courier','BI',10).mb_convert_encoding($reg[0]['membrete'], 'ISO-8859-1', 'UTF-8'),0,'C');
    $this->Ln(3);
}
########################## FUNCION TICKET COTIZACION ##############################

########################## FUNCION FACTURA COTIZACION ##############################
function FacturaCotizacion()
{     
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################
        
    $tra       = new Login();
    $reg       = $tra->CotizacionesPorId();
    $simbolo   = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra = "Courier";

    //Logo
    if (isset($reg[0]['cuitsucursal'])) {
        if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

           $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
           $this->Image($logo, 15, 11, 30, 16, "PNG");

        } else {

           $logo = "fotos/logo_principal.png";
           $this->Image($logo, 15, 10, 40, 16, "PNG");                         
        }                                      
    }

    ############################# BLOQUE N 1 FACTURA ###############################   
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 10, 190, 17, '1.5', '');
    
    $this->SetFont($TipoLetra,'B',12);
    $this->SetXY(120, 12);
    $this->Cell(40, 4, 'N DE COTIZACIN ', 0, 0);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetXY(160, 12);
    $this->CellFitSpace(38, 4,$reg[0]['codfactura'], 0, 0, "R");

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(120, 17);
    $this->Cell(40, 4, 'FECHA DE REGISTRO ', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(160, 17);
    $this->CellFitSpace(38, 4,date("d/m/Y",strtotime($reg[0]['fechacotizacion'])), 0, 0, "R");

    $this->SetFont($TipoLetra,'B',10);
    $this->SetXY(120, 22);
    $this->Cell(40, 4, 'HORA DE REGISTRO', 0, 0);
    $this->SetFont($TipoLetra,'',10);
    $this->SetXY(160, 22);
    $this->CellFitSpace(38, 4,date("H:i:s",strtotime($reg[0]['fechacotizacion'])), 0, 0, "R");
    ################################# BLOQUE N 1 FACTURA ################################ 

    ############################# BLOQUE N 2 SUCURSAL ###############################   
    //Bloque de datos de empresa
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 29, 190, 18, '1.5', '');
    //DATOS DE SUCURSAL LINEA 1
    $this->SetFont($TipoLetra,'B',9);
    $this->SetXY(12, 30);
    $this->Cell(186, 4, 'DATOS DE SUCURSAL ', 0, 0);
    //DATOS DE SUCURSAL LINEA 1

    //DATOS DE SUCURSAL LINEA 2
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(12, 34);
    $this->Cell(24, 4, 'RAZN SOCIAL:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(36, 34);
    $this->CellFitSpace(66, 4,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(102, 34);
    $this->CellFitSpace(22, 4, 'N DE '.$documento = ($reg[0]['documsucursal'] == '0' ? "REG.:" : mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8').":"), 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(124, 34);
    $this->CellFitSpace(28, 4,$reg[0]['cuitsucursal'], 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(152, 34);
    $this->Cell(18, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(170, 34);
    $this->Cell(28, 4,$reg[0]['tlfsucursal'], 0, 0);
    //DATOS DE SUCURSAL LINEA 2

    //DATOS DE SUCURSAL LINEA 3
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(12, 38);
    $this->Cell(24, 4, 'DIRECCIN:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(36, 38);
    $this->CellFitSpace(96, 4,$ciudad = ($reg[0]['id_ciudad'] == '0' ? " " : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8'))." ".$comuna = ($reg[0]['id_comuna'] == '0' ? " " : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))." ".mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(132, 38);
    $this->Cell(12, 4, 'EMAIL:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(144, 38);
    $this->Cell(54, 4,mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'), 0, 0);
    //DATOS DE SUCURSAL LINEA 3

    //DATOS DE SUCURSAL LINEA 4
    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(12, 42);
    $this->Cell(24, 4, 'RESPONSABLE:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(36, 42);
    $this->CellFitSpace(66, 4,mb_convert_encoding($reg[0]['nomencargado'], 'ISO-8859-1', 'UTF-8'), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(102, 42);
    $this->CellFitSpace(22, 4, 'N DE '.$documento = ($reg[0]['documencargado'] == '0' ? "DOC.:" : mb_convert_encoding($reg[0]['documento2'], 'ISO-8859-1', 'UTF-8').":"), 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(124, 42);
    $this->CellFitSpace(28, 4,$reg[0]['dniencargado'], 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(152, 42);
    $this->Cell(18, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(170, 42);
    $this->Cell(28, 4,$tlf = ($reg[0]['tlfencargado'] == '' ? "*********" : $reg[0]['tlfencargado']), 0, 0);
    //DATOS DE SUCURSAL LINEA 4
    ############################ BLOQUE N 2 SUCURSAL ###############################   


    ############################## BLOQUE N 3 CLIENTE #################################  
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.1);
    $this->RoundedRect(10, 49, 190, 14, '1.5', '');

    $this->SetFont($TipoLetra,'B',9);
    $this->SetXY(12, 50);
    $this->Cell(186, 4, 'DATOS DE CLIENTE ', 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(12, 54);
    $this->Cell(20, 4, 'NOMBRES:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(32, 54);
    $this->CellFitSpace(58, 4,$nombre = ($reg[0]['nomcliente'] == '' ? "CONSUMIDOR FINAL" : mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8')), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(90, 54);
    $this->CellFitSpace(20, 4, 'N DE '.$documento = ($reg[0]['documcliente'] == '0' ? "DOC.:" : $reg[0]['documento3'].":"), 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(110, 54);
    $this->CellFitSpace(24, 4,$nombre = ($reg[0]['dnicliente'] == '' ? "*********" : mb_convert_encoding($reg[0]['dnicliente'], 'ISO-8859-1', 'UTF-8')), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(134, 54);
    $this->Cell(12, 4, 'EMAIL:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(146, 54);
    $this->CellFitSpace(52, 4,$email = ($reg[0]['emailcliente'] == '' ? "*********" : mb_convert_encoding($reg[0]['emailcliente'], 'ISO-8859-1', 'UTF-8')), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(12, 58);
    $this->Cell(20, 4, 'DIRECCIN:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(32, 58);
    $this->CellFitSpace(124, 4,getSubString($ciudad = (empty($reg[0]['id_ciudad2']) ? " " : mb_convert_encoding($reg[0]['ciudad2'], 'ISO-8859-1', 'UTF-8'))." ".$comuna = (empty($reg[0]['id_comuna2']) ? " " : mb_convert_encoding($reg[0]['comuna2'], 'ISO-8859-1', 'UTF-8'))." ".mb_convert_encoding(empty($reg[0]['direccliente']) ? "" : $reg[0]['direccliente'], 'ISO-8859-1', 'UTF-8'), 70), 0, 0);

    $this->SetFont($TipoLetra,'B',8);
    $this->SetXY(156, 58);
    $this->Cell(20, 4, 'N DE TLF:', 0, 0);
    $this->SetFont($TipoLetra,'',8);
    $this->SetXY(176, 58);
    $this->CellFitSpace(22, 4,$tlf = ($reg[0]['tlfcliente'] == '' ? "*********" : $reg[0]['tlfcliente']), 0, 0); 
    ############################## BLOQUE N 3 CLIENTE #################################  

    //######################### BLOQUE DATOS DE PRODUCTOS #############################
    $this->Ln(3);
    $this->SetXY(10, 65);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(10,5,'N',1,0,'C', True);
    $this->Cell(105,5,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(25,5,'CANTIDAD',1,0,'C', True);
    $this->Cell(25,5,'PRECIO',1,0,'C', True);
    $this->Cell(25,5,'IMPORTE',1,1,'C', True);
    
    $tra = new Login();
    $detalle = $tra->VerDetallesCotizaciones();
    $cantidad = 0;
    $SubTotal = 0;

    $this->SetWidths(array(10,105,25,25,25));

    $a=1;
    for($i=0;$i<sizeof($detalle);$i++){ 
    $cantidad += $detalle[$i]['cantcotizacion'];
    $valortotal = $detalle[$i]["precioventa"]*$detalle[$i]["cantcotizacion"];
    $SubTotal += $detalle[$i]['valorneto'];

    $this->SetX(10);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,"",10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->RowFacture(array($a++,
        mb_convert_encoding($detalle[$i]["producto"]." ".$detalle[$i]["condicion"].$descripcion = ($detalle[$i]["producto"] != "" ? "\n".$detalle[$i]["descripcion"] : "").$imei = ($detalle[$i]["imei"] != "" ? "\nIMEI: ".$detalle[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]['cantcotizacion'],
        number_format($detalle[$i]["precioventa"], 0, '.', '.'),
        number_format($detalle[$i]['valorneto'], 0, '.', '.')));
    }
    //######################### BLOQUE DATOS DE PRODUCTOS #############################

    ########################### BLOQUE N 6 #############################
    $this->Ln();
    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(108,5,'INFORMACIN ADICIONAL',1,0,'C', True);
    $this->Cell(2,5,"",0,0,'C');
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(40,5,'SUBTOTAL ',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(108,5,'CANTIDAD DE PRODUCTOS: '.number_format($cantidad, 0, '.', '.'),1,0,'L');
    $this->Cell(2,5,"",0,0,'C');
    $this->CellFitSpace(40,5,'GRAVADO ('.number_format($reg[0]["iva"], 0, '.', '.').'%):',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["subtotalivasi"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(108,5,'TIPO DE DOCUMENTO: FACTURA',1,0,'L');
    $this->Cell(2,5,"",0,0,'C');
    $this->CellFitSpace(40,5,'EXENTO (0%):',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["subtotalivano"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(108,5,'REALIZADO: '.mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'),1,0,'L');

    $this->Cell(2,5,"",0,0,'C');
    $this->CellFitSpace(40,5,$NomImpuesto." (".number_format($reg[0]["iva"], 0, '.', '.')."%):",1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["totaliva"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(108,5,'FECHA DE EMISIN: '.date("d/m/Y"),1,0,'L');
    $this->Cell(2,5,"",0,0,'C');
    $this->CellFitSpace(40,5,'DESCONTADO %:',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["descontado"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(108,5,'HORA DE EMISIN: '.date("H:i:s"),1,0,'L');
    $this->Cell(2,5,"",0,0,'C');
    $this->CellFitSpace(40,5,'DESC % ('.number_format($reg[0]["descuento"], 0, '.', '.').'%):',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["totaldescuento"], 0, '.', '.'),1,0,'R');
    $this->Ln();

    $this->SetFillColor(245,245,245); // establece el color del fondo de la celda (en este caso es AZUL
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(108,5,'',0,0,'L');
    $this->Cell(2,5,"",0,0,'C');
    $this->SetFont($TipoLetra,'B',10);
    $this->Cell(40,5,'IMPORTE TOTAL:',1,0,'L', True);
    $this->CellFitSpace(40,5,$simbolo.number_format($reg[0]["totalpago"], 0, '.', '.'),1,0,'R');
    $this->Ln(6);

    if($reg[0]['observaciones'] != ''){
    //Linea de membrete Nro 4
    $this->SetFont($TipoLetra,'B',10);
    $this->MultiCell(190,5,$this->SetFont($TipoLetra,'',10).'OBSERVACIONES ENVIA: '.$reg[0]['observaciones'] == '' ? "**********" : mb_convert_encoding($reg[0]['observaciones'], 'ISO-8859-1', 'UTF-8'),1,'J');
    }
}
########################## FUNCION FACTURA COTIZACION ##############################

########################## FUNCION LISTAR COTIZACIONES ##############################
function TablaListarCotizaciones()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarCotizaciones();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE COTIZACIONES',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,70,30,25,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]['procesada']==1) { 
    $estado = 'PENDIENTE'; 
    } elseif($reg[$i]['procesada']==2) {  
    $estado = 'PROCESADA'; 
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechacotizacion'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]["articulos"], 2, '.', ','),
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }

    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,number_format($TotalArticulos, 2, '.', ','),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COTIZACIONES ##############################

########################## FUNCION LISTAR COTIZACIONES POR BUSQUEDA ##############################
function TablaListarCotizacionesxBusqueda()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BusquedaCotizaciones();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if($_GET['tipobusqueda'] == 1){
    $this->Cell(335,10,'LISTADO GENERAL DE COTIZACIONES A CLIENTES',0,0,'C');
    } elseif($_GET['tipobusqueda'] == 2){
    $this->Cell(335,10,'LISTADO DE COTIZACIONES A CLIENTES POR BSQUEDA',0,0,'C');
    } elseif($_GET['tipobusqueda'] == 3){
    $this->Cell(335,10,'LISTADO DE COTIZACIONES A CLIENTES POR FECHAS',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    if($_GET['tipobusqueda'] == 2){
    $this->Ln();
    $this->Cell(335,6,"BSQUEDA: ".mb_convert_encoding($_GET["search_criterio"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    } elseif($_GET['tipobusqueda'] == 3){
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,70,30,25,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]['procesada']==1) { 
    $estado = 'PENDIENTE'; 
    } elseif($reg[$i]['procesada']==2) {  
    $estado = 'PROCESADA'; 
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechacotizacion'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]["articulos"], 2, '.', ','),
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }

    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,number_format($TotalArticulos, 2, '.', ','),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COTIZACIONES POR BUSQUEDA ##############################

########################## FUNCION LISTAR COTIZACIONES POR FECHAS ##############################
function TablaListarCotizacionesxFechas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarCotizacionesxFechas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE COTIZACIONES POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,70,30,25,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]['procesada']==1) { 
    $estado = 'PENDIENTE'; 
    } elseif($reg[$i]['procesada']==2) {  
    $estado = 'PROCESADA'; 
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechacotizacion'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]["articulos"], 2, '.', ','),
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,number_format($TotalArticulos, 2, '.', ','),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COTIZACIONES POR FECHAS ##############################

########################## FUNCION LISTAR COTIZACIONES POR VENDEDOR ##############################
function TablaListarCotizacionesxVendedor()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarCotizacionesxVendedor();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE COTIZACIONES POR VENDEDOR',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"VENDEDOR: ".mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,70,30,25,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]['procesada']==1) { 
    $estado = 'PENDIENTE'; 
    } elseif($reg[$i]['procesada']==2) {  
    $estado = 'PROCESADA'; 
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechacotizacion'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]["articulos"], 2, '.', ','),
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,number_format($TotalArticulos, 2, '.', ','),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COTIZACIONES POR VENDEDOR ##############################

########################## FUNCION LISTAR DETALLES COTIZACIONES POR FECHAS ##############################
function TablaListarDetallesCotizacionesxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesCotizacionesxFechas(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DETALLES COTIZACIONES POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(80,8,'DESCRIPCIN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'COTIZADO',1,0,'C', True);
    $this->Cell(30,8,'MONTO TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,25,80,30,30,20,30,30,25,30));

    $a              = 1;
    $PrecioTotal    = 0;
    $ExisteTotal    = 0;
    $VendidosTotal  = 0;
    $PagoTotal      = 0;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal    += $reg[$i]['precioventa'];
    if($reg[$i]['tipodetalle'] == 1){
    $tipodetalle     = "PRODUCTO";
    $Existencia      = $reg[$i]['existencia'];
    $ExisteTotal    += $reg[$i]['existencia'];
    } elseif($reg[$i]['tipodetalle'] == 2){
    $tipodetalle     = "COMBO";
    $Existencia      = $reg[$i]['cantcombo'];
    $ExisteTotal    += $reg[$i]['cantcombo'];
    } elseif($reg[$i]['tipodetalle']==3){
    $tipodetalle     = "SERVICIO";
    $Existencia      = '0';
    $ExisteTotal    += '0';
    }
    $VendidosTotal  += $reg[$i]['cantidad']; 

    $Descuento       = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal     = $reg[$i]['precioventa']-$PrecioDescuento;
    $PagoTotal      += $PrecioFinal*$reg[$i]['cantidad'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipodetalle,
        mb_convert_encoding($reg[$i]["codproducto"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "*****" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]["precioventa"], 0, '.', '.'),
        number_format($Existencia, 2, '.', ','),
        number_format($reg[$i]['cantidad'], 2, '.', ','),
        $simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 0, '.', '.')));
    }

    $this->Cell(220,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PrecioTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,number_format($ExisteTotal, 2, '.', ','),0,0,'L');
    $this->CellFitSpace(25,5,number_format($VendidosTotal, 2, '.', ','),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PagoTotal, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DETALLES COTIZACIONES POR FECHAS ##############################

########################## FUNCION LISTAR DETALLES COTIZACIONES POR VENDEDOR ##############################
function TablaListarDetallesCotizacionesxVendedor()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesCotizacionesxVendedor(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DETALLES COTIZACIONES POR VENDEDOR',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"VENDEDOR: ".mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(80,8,'DESCRIPCIN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'COTIZADO',1,0,'C', True);
    $this->Cell(30,8,'MONTO TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,25,80,30,30,20,30,30,25,30));

    $a              = 1;
    $PrecioTotal    = 0;
    $ExisteTotal    = 0;
    $VendidosTotal  = 0;
    $PagoTotal      = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo         = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal    += $reg[$i]['precioventa'];
    if($reg[$i]['tipodetalle'] == 1){
    $tipodetalle     = "PRODUCTO";
    $Existencia      = $reg[$i]['existencia'];
    $ExisteTotal    += $reg[$i]['existencia'];
    } elseif($reg[$i]['tipodetalle'] == 2){
    $tipodetalle     = "COMBO";
    $Existencia      = $reg[$i]['cantcombo'];
    $ExisteTotal    += $reg[$i]['cantcombo'];
    } elseif($reg[$i]['tipodetalle']==3){
    $tipodetalle     = "SERVICIO";
    $Existencia      = '0';
    $ExisteTotal    += '0';
    }
    $VendidosTotal  += $reg[$i]['cantidad']; 

    $Descuento       = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal     = $reg[$i]['precioventa']-$PrecioDescuento;
    $PagoTotal      += $PrecioFinal*$reg[$i]['cantidad'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipodetalle,
        mb_convert_encoding($reg[$i]["codproducto"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "*****" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]["precioventa"], 0, '.', '.'),
        number_format($Existencia, 2, '.', ','),
        number_format($reg[$i]['cantidad'], 2, '.', ','),
        $simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 0, '.', '.')));
    }

    $this->Cell(220,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PrecioTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,number_format($ExisteTotal, 2, '.', ','),0,0,'L');
    $this->CellFitSpace(25,5,number_format($VendidosTotal, 2, '.', ','),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PagoTotal, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DETALLES COTIZACIONES POR VENDEDOR ##############################

########################### REPORTES DE COTIZACIONES ############################



















############################### REPORTES DE PREVENTAS #############################

########################## FUNCION TICKET PREVENTA ##############################
function TicketPreventa()
{       
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################
    
    $tra       = new Login();
    $reg       = $tra->PreventasPorId();
    $simbolo   = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra = "Courier";

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
        $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo , 20, 3, 35, 15, "PNG");
        $this->Ln(8);
    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5, "TICKET DE PREVENTA", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,3,$reg[0]['documsucursal'] == '0' ? "" : "N ".mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$reg[0]['cuitsucursal'],0,1,'C');

    if($reg[0]['id_comuna']!='0'){

    $this->SetX(2);
    $this->CellFitSpace(70,3,$comuna = ($reg[0]['id_comuna'] == '0' ? " " : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))." ".$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8')),0,1,'C');
    }

    $this->SetX(2);
    $this->CellFitSpace(70,3,mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,1,'C');

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'),0,'C');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);
    
    if($reg[0]['codcliente'] == '0'){

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(70,4,"A CONSUMIDOR FINAL", 0, 1, 'J');   

    } else {

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,3,$documento = ($reg[0]['documcliente'] == '0' ? "N DOC" : "N ".mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8')).": ".$reg[0]['dnicliente'],0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['direccliente'].$comuna = ($reg[0]['id_comuna'] == '0' ? "" : " ".$reg[0]['comuna'])."".$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : " ".$reg[0]['ciudad']), 'ISO-8859-1', 'UTF-8'),0,'L');
    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(2);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(35,4,"Nro Ticket:  ", 0, 0, 'J');
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(35,4,$reg[0]['codfactura'], 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(18,4,"VENDEDOR:", 0, 0, 'J');
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(52,4,mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(35,4,"FECHA: ".date("d/m/Y",strtotime($reg[0]['fechapreventa'])), 0, 0, 'J');
    $this->CellFitSpace(35,4,"HORA: ".date("H:i:s",strtotime($reg[0]['fechapreventa'])), 0, 0, 'R');
    $this->Ln();

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5,"DETALLES DE PRODUCTOS", 0, 0, 'L');
    $this->Ln(5);

    $tra       = new Login();
    $detalle   = $tra->VerDetallesPreventas();
    $cantidad  = 0;
    $SubTotal  = 0;
    $Articulos = 0;
    $a=1;
    for($i=0;$i<sizeof($detalle);$i++):
    $SubTotal  += $detalle[$i]['valortotal'];
    $Articulos += $detalle[$i]['cantpreventa'];

    $this->SetX(2);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    
    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(35,3,$detalle[$i]['cantpreventa']." X ".$simbolo.number_format($detalle[$i]["precioventa"], 0, '.', '.'),0,0,'J');

    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(35,3,$simbolo.number_format($detalle[$i]["valortotal"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->MultiCell(70,3,mb_convert_encoding($detalle[$i]["producto"]." ".$detalle[$i]["condicion"], 'ISO-8859-1', 'UTF-8'),0,1,'');

    if($detalle[$i]["descripcion"] != ""){
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',6);
    $this->MultiCell(70,3,mb_convert_encoding($detalle[$i]["descripcion"], 'ISO-8859-1', 'UTF-8'),0,1,'');
    }

    if($detalle[$i]["imei"] != ""){
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',6);
    $this->MultiCell(70,3,"N DE IMEI: ".mb_convert_encoding($detalle[$i]["imei"], 'ISO-8859-1', 'UTF-8'),0,1,'');
    }

    endfor;

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(22,4,"SUBTOTAL",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','',9);
    $this->CellFitSpace(22,4,$NomImpuesto." (".number_format($reg[0]["iva"], 0, '.', '.')."%)",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]["totaliva"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(22,4,"DESC (".number_format($reg[0]["descuento"], 0, '.', '.')."%)",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]['totaldescuento'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(22,4,"TOTAL",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]['totalpago'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetDrawColor(3,3,3);
    $this->SetFont($TipoLetra,'',7);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->MultiCell(70,4,mb_convert_encoding(numtoletras(number_format($reg[0]['totalpago'], 2, '.', '')), 'ISO-8859-1', 'UTF-8'),0,1,'');

    if($reg[0]['observaciones']!=""){
    ########################### OBSERVACIONES #############################
    $this->Ln(2);  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',8);
    $this->MultiCell(70,4,mb_convert_encoding($reg[0]['observaciones'], 'ISO-8859-1', 'UTF-8'),0,1,'');
    $this->Ln(2);
    ########################### OBSERVACIONES #############################    
    }

    $this->Ln();
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(30,4,"CANTIDAD TOTAL:",0,0,'L');
    $this->CellFitSpace(40,4,$Articulos,0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'),0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(10,4,"TEL:",0,0,'L');
    $this->CellFitSpace(60,4,$reg[0]['tlfsucursal'],0,1,'L');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'BI',10).mb_convert_encoding($reg[0]['membrete'], 'ISO-8859-1', 'UTF-8'),0,'C');
    $this->Ln(3);
}
########################## FUNCION TICKET PREVENTA ##############################

########################## FUNCION LISTAR PREVENTAS ##############################
function TablaListarPreventas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarPreventas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE PREVENTAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,70,30,25,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]['procesada']==1) { 
    $estado = 'PENDIENTE'; 
    } elseif($reg[$i]['procesada']==2) {  
    $estado = 'PROCESADA'; 
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechapreventa'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }

    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PREVENTAS ##############################

########################## FUNCION LISTAR CLIENTES EN PREVENTAS ##############################
function ClientesxPreventas()
{
    $tra = new Login();
    $reg = $tra->ListarClientesxPreventas();

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(330,10,'LISTADO DE CLIENTES CON PREVENTAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N FACTURA',1,0,'C', True);
    $this->Cell(40,8,'N DOCUMENTO',1,0,'C', True);
    $this->Cell(70,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(130,8,'DIRECCIN',1,0,'C', True);
    $this->Cell(40,8,'TELEFONO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,40,40,70,130,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["codfactura"],
            mb_convert_encoding($reg[$i]["documento"], 'ISO-8859-1', 'UTF-8')." ".$reg[$i]["dnicliente"],
            mb_convert_encoding($reg[$i]["nomcliente"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($direccliente = ($reg[$i]['direccliente'] == '' ? "******" : $reg[$i]['direccliente']).$comuna = ($reg[$i]['id_comuna2'] == '0' ? "" : ", ".$reg[$i]['comuna2']).$ciudad = ($reg[$i]['id_ciudad2'] == '0' ? "" : " - ".$reg[$i]['ciudad2']), 'ISO-8859-1', 'UTF-8'),
            $reg[$i]["tlfcliente"]));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CLIENTES EN PREVENTAS ##############################

########################## FUNCION LISTAR PREVENTAS POR FECHAS ##############################
function TablaListarPreventasxFechas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarPreventasxFechas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE PREVENTAS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,70,30,25,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]['procesada']==1) { 
    $estado = 'PENDIENTE'; 
    } elseif($reg[$i]['procesada']==2) {  
    $estado = 'PROCESADA'; 
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechapreventa'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }

    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PREVENTAS POR FECHAS ##############################

########################## FUNCION LISTAR PREVENTAS POR VENDEDOR ##############################
function TablaListarPreventasxVendedor()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarPreventasxVendedor();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE PREVENTAS POR VENDEDOR',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"VENDEDOR: ".mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,70,30,25,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]['procesada']==1) { 
    $estado = 'PENDIENTE'; 
    } elseif($reg[$i]['procesada']==2) {  
    $estado = 'PROCESADA'; 
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechapreventa'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }

    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR PREVENTAS POR VENDEDOR ##############################

####################### FUNCION LISTAR DETALLES DE PREVENTAS POR FECHAS ###########################
function TablaListarDetallesPreventasxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesPreventasxFechas(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DETALLES PREVENTAS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(80,8,'DESCRIPCIN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'PREVENTA',1,0,'C', True);
    $this->Cell(30,8,'MONTO TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,25,80,30,30,20,30,30,25,30));

    $a              = 1;
    $PrecioTotal    = 0;
    $ExisteTotal    = 0;
    $VendidosTotal  = 0;
    $PagoTotal      = 0;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo        = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal    += $reg[$i]['precioventa'];
    if($reg[$i]['tipodetalle'] == 1){
    $tipodetalle     = "PRODUCTO";
    $Existencia      = $reg[$i]['existencia'];
    $ExisteTotal    += $reg[$i]['existencia'];
    } elseif($reg[$i]['tipodetalle'] == 2){
    $tipodetalle     = "COMBO";
    $Existencia      = $reg[$i]['cantcombo'];
    $ExisteTotal    += $reg[$i]['cantcombo'];
    } elseif($reg[$i]['tipodetalle']==3){
    $tipodetalle     = "SERVICIO";
    $Existencia      = '0';
    $ExisteTotal    += '0';
    }
    $VendidosTotal  += $reg[$i]['cantidad']; 

    $Descuento       = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal     = $reg[$i]['precioventa']-$PrecioDescuento;
    $PagoTotal      += $PrecioFinal*$reg[$i]['cantidad'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipodetalle,
        mb_convert_encoding($reg[$i]["codproducto"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : "").$imei = ($reg[$i]["imei"] != "" ? "\nIMEI: ".$reg[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "*****" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]["precioventa"], 0, '.', '.'),
        $Existencia,
        $reg[$i]['cantidad'],
        $simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 0, '.', '.')));
    }

    $this->Cell(220,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PrecioTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$ExisteTotal,0,0,'L');
    $this->CellFitSpace(25,5,$VendidosTotal,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PagoTotal, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR DETALLES DE PREVENTAS POR FECHAS ##########################

####################### FUNCION LISTAR DETALLES DE PREVENTAS POR VENDEDOR ###########################
function TablaListarDetallesPreventasxVendedor()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesPreventasxVendedor(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DETALLES PREVENTAS POR VENDEDOR',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"VENDEDOR: ".mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(80,8,'DESCRIPCIN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'PREVENTA',1,0,'C', True);
    $this->Cell(30,8,'MONTO TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,25,80,30,30,20,30,30,25,30));

    $a              = 1;
    $PrecioTotal    = 0;
    $ExisteTotal    = 0;
    $VendidosTotal  = 0;
    $PagoTotal      = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo         = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal    += $reg[$i]['precioventa'];
    if($reg[$i]['tipodetalle'] == 1){
    $tipodetalle     = "PRODUCTO";
    $Existencia      = $reg[$i]['existencia'];
    $ExisteTotal    += $reg[$i]['existencia'];
    } elseif($reg[$i]['tipodetalle'] == 2){
    $tipodetalle     = "COMBO";
    $Existencia      = $reg[$i]['cantcombo'];
    $ExisteTotal    += $reg[$i]['cantcombo'];
    } elseif($reg[$i]['tipodetalle']==3){
    $tipodetalle     = "SERVICIO";
    $Existencia      = '0';
    $ExisteTotal    += '0';
    }
    $VendidosTotal  += $reg[$i]['cantidad']; 

    $Descuento       = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal     = $reg[$i]['precioventa']-$PrecioDescuento;
    $PagoTotal      += $PrecioFinal*$reg[$i]['cantidad'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipodetalle,
        mb_convert_encoding($reg[$i]["codproducto"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : "").$imei = ($reg[$i]["imei"] != "" ? "\nIMEI: ".$reg[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "*****" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]["precioventa"], 0, '.', '.'),
        $Existencia,
        $reg[$i]['cantidad'],
        $simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 0, '.', '.')));
    }

    $this->Cell(220,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PrecioTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$ExisteTotal,0,0,'L');
    $this->CellFitSpace(25,5,$VendidosTotal,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PagoTotal, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR DETALLES DE PREVENTAS POR VENDEDOR ##########################

########################## FUNCION GUIA PREVENTA ##############################
function GuiaPreventaxFechas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################
        
    $tra   = new Login();
    $reg   = $tra->BuscarProductosPreventas();
    $logo  = ( file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png") == "" ? "assets/images/null.png" : "fotos/sucursales/".$reg[0]['cuitsucursal'].".png");
    $logo2 = ( file_exists("fotos/logo_pdf2.png") == "" ? "assets/images/null.png" : "fotos/logo_pdf2.png");

    $this->Ln(2);
    $this->SetFont('Courier','B',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->SetFillColor(255, 118, 118); // establece el color del fondo de la celda (en este caso es AZUL
    $this->Cell(55,5,$this->Image($logo, $this->GetX()+$GLOBALS['logo1_vertical_X'], $this->GetY()+$GLOBALS['logo1_vertical_Y'], $GLOBALS['logo1_vertical']),0,0,'C');
    $this->CellFitSpace(80,5,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
    $this->Cell(55,5,$this->Image($logo2, $this->GetX()+$GLOBALS['logo2_vertical_X'], $this->GetY()+$GLOBALS['logo2_vertical_Y'], $GLOBALS['logo2_vertical']),0,0,'C');

    $this->Ln();
    $this->Cell(55,5,"",0,0,'C');
    $this->CellFitSpace(80,5,$reg[0]['documsucursal'] == '0' ? "" : mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$reg[0]['cuitsucursal'],0,0,'C');
    $this->Cell(55,5,"",0,0,'C');

    if($reg[0]['id_comuna']!='0'){

    $this->Ln();
    $this->Cell(55,5,"",0,0,'C');
    $this->CellFitSpace(80,5,$comuna = ($reg[0]['id_comuna'] == '0' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))." ".$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8')),0,0,'C');
    $this->Cell(55,5,"",0,0,'C');

    }

    $this->Ln();
    $this->Cell(55,5,"",0,0,'C');
    $this->CellFitSpace(80,5,mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
    $this->Cell(55,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(55,5,"",0,0,'C');
    $this->CellFitSpace(80,5,"N TLF: ".$reg[0]['tlfsucursal'],0,0,'C');
    $this->Cell(55,5,"",0,0,'C');

    $this->Ln();
    $this->Cell(55,5,"",0,0,'C');
    $this->CellFitSpace(80,5,mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'),0,0,'C');
    $this->Cell(55,5,"",0,0,'C');
    $this->Ln(5);

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,14,'GUIA DE REMISIN',0,0,'C');

    $this->Ln();
    $this->SetFont('courier','B',9);
    $this->SetTextColor(255,255,255); // Establece el color del texto (en este caso es Negro)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(70,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(25,8,"PRESENTACIN", 1, 0, 'C', True);
    $this->Cell(20,8,'MARCA',1,0,'C', True);
    $this->Cell(20,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'CANTIDAD',1,1,'C', True);
    ############################### BLOQUE N 5 #####################################


    ############################### BLOQUE N 6 #####################################
    $cantidad = 0;
    $SubTotal = 0;

    $this->SetWidths(array(10,25,70,25,20,20,20));

    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $cantidad += $reg[$i]['cantidad'];
    $valortotal = $reg[$i]["precioventa"]*$reg[$i]["cantidad"];

    $this->SetX(10);
    $this->SetFont('Courier','B',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->RowFacture(array($a++,
        $reg[$i]["codproducto"],
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : "").$imei = ($reg[$i]["imei"] != "" ? "\nIMEI: ".$reg[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        $presentaciion = ($reg[$i]["codpresentacion"] == '0' ? "*********" : mb_convert_encoding($reg[$i]["nompresentacion"])),
        $marca = ($reg[$i]["codmarca"] == '0' ? "*********" : mb_convert_encoding($reg[$i]["nommarca"])),
        $modelo = ($reg[$i]["codmodelo"] == '0' ? "*********" : mb_convert_encoding($reg[$i]["nommodelo"], 'ISO-8859-1', 'UTF-8', 'ISO-8859-1', 'UTF-8', 'ISO-8859-1', 'UTF-8')),
        $reg[$i]["cantidad"]));
    }
    ############################### BLOQUE N 6 #####################################

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION GUIA PREVENTA ##############################

########################### REPORTES DE PREVENTAS ############################

















############################### REPORTES DE GUIA DE DESPACHO #############################

########################## FUNCION GUIA DE DESPACHO (80 mm) ##############################
function GuiaDespachoBoleta()
{  
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra        = new Login();
    $reg        = $tra->DespachosPorId();
    $timbrePath = Lioren::getTimbreGuia($reg[0]);
    $simbolo    = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra  = "Arial"; 

    //Bloque de membrete principal
    $this->SetFillColor(229);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.3);
    $this->RoundedRect(8, 8, 58, 18, '0', '');
  
    $this->SetXY(8,8);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->CellFitSpace(58, 6, $reg[0]['documsucursal'] == '0' ? "" : "".mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8').": ".$reg[0]['cuitsucursal'], 0, 1, 'C');

    $this->SetX(8);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(58, 6, "GUIA DE DESPACHO", 0, 1, 'C');

    $this->SetX(8);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->CellFitSpace(58, 6, "N ".$reg[0]['codfactura'], 0, 1, 'C');

    $this->SetX(8);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetFillColor(2,157,116);
    $this->CellFitSpace(58, 5, "S.I.I. - ".strtoupper($comuna = ($reg[0]['comuna'] == '' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))), 0, 0, 'C');
    $this->Ln();

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
        $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo , 20, 32, 35, 15, "PNG");
        $this->Ln(16);
    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->Cell(70, 3, "", 0, 1, 'C');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'B',9).mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',7);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'',7).mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',7);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'',7)."CASA MATRIZ: ".strtoupper(mb_convert_encoding($reg[0]['direcsucursal'].", ".$comuna = ($reg[0]['comuna'] == '' ? "" : $reg[0]['comuna'])." - ".$ciudad = ($reg[0]['ciudad'] == '' ? "" : $reg[0]['ciudad']), 'ISO-8859-1', 'UTF-8')),0,'L');
    $this->Ln(2);


    if($reg[0]['codcliente'] == '0'){

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(70,4,"A CONSUMIDOR FINAL", 0, 1, 'J');   

    } else {

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',7);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'',8)."Receptor: ".mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(70,3,$documento = ($reg[0]['documcliente'] == '0' ? "DOC:" : "".mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8').": ".$reg[0]['dnicliente']),0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',7);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'',7)."Giro: ".mb_convert_encoding($reg[0]['girocliente'], 'ISO-8859-1', 'UTF-8'),0,'J');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',7);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'',7)."Direccin: ".mb_convert_encoding($reg[0]['direccliente'], 'ISO-8859-1', 'UTF-8'),0,'J');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(35, 3, "Comuna: ".strtoupper($comuna2 = ($reg[0]['comuna2'] == '' ? "" : mb_convert_encoding($reg[0]['comuna2'], 'ISO-8859-1', 'UTF-8'))), 0, 0, 'L');
    $this->CellFitSpace(35, 3, "Ciudad: ".strtoupper($ciudad2 = ($reg[0]['ciudad2'] == '' ? "" : mb_convert_encoding($reg[0]['ciudad2'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'L');

    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',7);
    $this->CellFitSpace(20, 3, "Fecha Emisin:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(50, 3, date("d/m/Y",strtotime($reg[0]['fechadespacho'])), 0, 1, 'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,0,'_____________________________',0,0,'C');
    $this->Ln(2);

    $this->SetX(3);
    $this->SetFont($TipoLetra,'B',7);
    $this->SetFillColor(2,157,116);
    $this->Cell(22, 5,"CODIGO/ITEM", 0, 0, 'L');
    $this->Cell(30, 5,"CANTIDAD/PRECIO", 0, 0, 'C');
    $this->Cell(16, 5,"TOTAL", 0, 0, 'R');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,0,'_____________________________',0,0,'C');
    $this->Ln(3);

    $tra         = new Login();
    $detalle     = $tra->VerDetallesDespachos();
    $cantidad    = 0;
    $SubTotal    = 0;
    $montoExento = 0;
    $valorIva    = $reg[0]["iva"] / 100;
    $Articulos   = 0;
    $a=1;
    for($i=0;$i<sizeof($detalle);$i++):
    $SubTotal   += $detalle[$i]['valortotal'];
    $Articulos  += $detalle[$i]['cantdespacho'];

    $this->SetX(3);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(26,3,$detalle[$i]['codproducto'],0,0,'J');
    $this->CellFitSpace(13,3,$detalle[$i]['cantdespacho'],0,0,'J');
    $this->CellFitSpace(13,3,number_format($detalle[$i]['precioventa'], 0, '.', '.'),0,0,'J');
    $this->CellFitSpace(16,3,number_format($detalle[$i]["valorneto"], 0, '.', '.'),0,1,'R');

    $this->SetX(3);
    $this->SetFont($TipoLetra,'',7);
    $this->MultiCell(68,3,mb_convert_encoding($detalle[$i]["producto"]." ".$detalle[$i]["condicion"], 'ISO-8859-1', 'UTF-8'),0,1,'');

    if($detalle[$i]["descripcion"] != ""){
    $this->SetX(3);
    $this->SetFont($TipoLetra,'',6);
    $this->MultiCell(68,3,mb_convert_encoding($detalle[$i]["descripcion"], 'ISO-8859-1', 'UTF-8'),0,1,'');
    }

    if($detalle[$i]["imei"] != ""){
    $this->SetX(3);
    $this->SetFont($TipoLetra,'',6);
    $this->MultiCell(68,3,"N DE IMEI: ".mb_convert_encoding($detalle[$i]["imei"], 'ISO-8859-1', 'UTF-8'),0,1,'');
    }

    endfor;

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,0,'_____________________________',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(22,4,"Subtotal",0,0,'L');
    $this->Cell(48,4,number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->MultiCell(70,4,$this->SetFont($TipoLetra,'',7)."SON: ".mb_convert_encoding(numtoletras(number_format($reg[0]['totalpago'], 0, '.', '')), 'ISO-8859-1', 'UTF-8'),0,'J');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(68,4,"Tipo Despacho:",0,0,'L');
    $this->Ln();

    if($reg[0]['tipodespacho'] == 1) {
    $tipo = "TRASLADO DE MERCADERIA";
    } elseif ($reg[0]['tipodespacho'] == 2) {
    $tipo = "DEVOLUCIN";
    } elseif ($reg[0]['tipodespacho'] == 3) {
    $tipo = "CONSIGNACIONES";
    } elseif ($reg[0]['tipodespacho'] == 4) {
    $tipo = "ENTREGA GRATUITA";
    } elseif ($reg[0]['tipodespacho'] == 5) {
    $tipo = "OPERACIN CONSTITUYE VENTAS";
    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(68,4,$tipo, 0, 1, 'L');
    $this->Ln();

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(22,3,"MONTO NETO",0,0,'L');
    $this->Cell(48,3,number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(22,3,"MONTO ".$NomImpuesto,0,0,'L');
    $this->Cell(48,3,number_format($reg[0]['totaliva'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(22,5,"MONTO TOTAL",0,0,'L');
    $this->Cell(48,5,number_format($reg[0]['totalpago'], 0, '.', '.'),0,1,'R');

    if($reg[0]['observaciones']!=""){
    ########################### OBSERVACIONES #############################
    $this->Ln(2);  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',8);
    $this->MultiCell(70,4,mb_convert_encoding($reg[0]['observaciones'], 'ISO-8859-1', 'UTF-8'),0,1,'');
    $this->Ln(2);
    ########################### OBSERVACIONES #############################    
    }

    if ($timbrePath) {

    $this->SetX(2);
    $this->Cell(70, 25, $this->Image($timbrePath, $this->GetX(), $this->GetY(), 70, 25), 0, 1);
    $this->SetX(4);
    $this->SetFont($TipoLetra, 'B', 10);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66, 6, "Timbre Electronico S.I.I", 0, 1, 'C');
    $this->SetX(4);
    $this->SetFont($TipoLetra, 'B', 7);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66, 3, "Res. 159 de 2009 - Verifique Documento:", 0, 1, 'C');
    $this->SetX(4);
    $this->SetFont($TipoLetra, 'B', 7);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66, 3, "www.sii.cl", 0, 1, 'C');
    $this->Ln(2);
    
    }
}
########################## FUNCION GUIA DE DESPACHO (80 mm) ##############################

########################## FUNCION DE GUIA DE DESPACHO (A4) ##############################
function GuiaDespachoFactura()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra        = new Login();
    $reg        = $tra->DespachosPorId();
    $timbrePath = Lioren::getTimbreGuia($reg[0]);
    $simbolo    = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']); 
    $TipoLetra  = "Arial";

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
        $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo , 20, 14, 48, 28, "PNG");
        $this->Ln(5);
    }
    
    //Bloque de Factura Eletronica
    $this->SetDrawColor(220,50,50);
    $this->SetLineWidth(.8);
    $this->SetFillColor(229);
    $this->RoundedRect(120, 12, 80, 26, '0', '');

    $this->SetFont($TipoLetra,'B',13);
    $this->SetFillColor(2,157,116);
    $this->SetLineWidth(.3);
    $this->Cell(110, 8, "", 0, 0, 'C');
    $this->Cell(80, 8, $reg[0]['documsucursal'] == '0' ? "" : "".mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8').": ".$reg[0]['cuitsucursal'], 0, 1, 'C');

    $this->Cell(110, 8, "", 0, 0, 'C');
    $this->Cell(80, 8, "GUIA DE DESPACHO", 0, 1, 'C');

    $this->Cell(110, 8, "", 0, 0, 'C');
    $this->Cell(80, 8, "N ".$reg[0]['codfactura'], 0, 1, 'C');

    $this->Cell(110, 9, "", 0, 0, 'C');
    $this->SetTextColor(220,50,50);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(80, 12, "S.I.I - ".strtoupper($comuna = ($reg[0]['comuna'] == '' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'C');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(110, 6, "", 0, 0, 'C');
    $this->Cell(50, 6, "Fecha de Emisin", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(30, 6, date("d/m/Y",strtotime($reg[0]['fechadespacho'])), 0, 1, 'R');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(1,163,232);
    $this->Cell(110, 6, "", 0, 1, 'C',True);

    $this->SetFont($TipoLetra,'B',14);
    $this->SetTextColor(220,50,50);  // Establece el color del texto (en este caso es ROJO)
    $this->SetFillColor(1,163,232);
    $this->Cell(190, 8, mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Giro ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6,mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Direccin ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6, strtoupper(mb_convert_encoding($reg[0]['direcsucursal'].", ".$ciudad = ($reg[0]['ciudad'] == '' ? "" : $reg[0]['ciudad']), 'ISO-8859-1', 'UTF-8')), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Comuna ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6,strtoupper($comuna = ($reg[0]['comuna'] == '' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Telefono ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6,$tlf = ($reg[0]['tlfsucursal'] == '' ? "" : $reg[0]['tlfsucursal']), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Email ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6,$email = ($reg[0]['correosucursal'] == '' ? "" : mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8')), 0, 1, 'L');

    //Bloque de Receptor
    $this->SetDrawColor(1,163,232);
    $this->SetLineWidth(.1);
    $this->SetFillColor(229);
    $this->RoundedRect(10, 101, 190, 24, '0', '');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(190, 6, "INFORMACIN DEL RECEPTOR", 0, 1, 'C',True);

    $this->SetFont($TipoLetra,'',11);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Seor(es)", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(76, 6,$reg[0]['nomcliente'] == '' ? " " : mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Direccin", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(78, 6,$direccliente = ($reg[0]['direccliente'] == '' ? " " : mb_convert_encoding($reg[0]['direccliente'], 'ISO-8859-1', 'UTF-8')), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',11);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,$documento = ($reg[0]['documcliente'] == '0' ? "DOC:" : "".mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8')), 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(76, 6,$reg[0]['dnicliente'] == '' ? " " : $reg[0]['dnicliente'], 0, 0, 'L');
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Comuna", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(78, 6,strtoupper($comuna2 = ($reg[0]['comuna2'] == '' ? " " : mb_convert_encoding($reg[0]['comuna2'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',11);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Giro", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(76, 6,$reg[0]['girocliente'] == '' ? " " : mb_convert_encoding($reg[0]['girocliente'], 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Ciudad", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(78, 6,strtoupper($ciudad2 = ($reg[0]['ciudad2'] == '' ? " " : mb_convert_encoding($reg[0]['ciudad2'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'L');
    $this->Cell(34, 2, "", 0, 1, 'L');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(190, 6, "DETALLE DEL DOCUMENTO", 0, 1, 'C',True);

    $this->SetFont($TipoLetra,'',12);
    $this->SetDrawColor(230,230,250);
    $this->SetLineWidth(.1);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232);
    $this->Cell(20, 6,"Cdigo", 1, 0, 'L');
    $this->Cell(105, 6,"Nombre", 1, 0, 'L');
    $this->Cell(20, 6,"Cantidad", 1, 0, 'L');
    $this->Cell(25, 6,"Precio Neto", 1, 0, 'L');
    $this->Cell(20, 6,"Total", 1, 1, 'L');

    $tra         = new Login();
    $detalle     = $tra->VerDetallesDespachos();
    $cantidad    = 0;
    $SubTotal    = 0;
    $montoExento = 0;
    $valorIva    = $reg[0]["iva"] / 100;
    $Articulos   = 0;
    $a=1;

    $this->SetWidths(array(20,105,20,25,20));

    for($i=0;$i<sizeof($detalle);$i++){
    $SubTotal   += $detalle[$i]['valortotal'];
    $Articulos  += $detalle[$i]['cantdespacho'];

    $this->SetX(10);
    $this->SetFont($TipoLetra,'',10);  
    $this->SetDrawColor(230,230,250);
    $this->SetLineWidth(.1);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->RowFacture3(array(
        $detalle[$i]["codproducto"],
        mb_convert_encoding($detalle[$i]["producto"]." ".$detalle[$i]["condicion"].$descripcion = ($detalle[$i]["producto"] != "" ? "\n".$detalle[$i]["descripcion"] : "").$imei = ($detalle[$i]["imei"] != "" ? "\nIMEI: ".$detalle[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]['cantdespacho'],
        $simbolo.number_format($detalle[$i]['precioventa'], 0, '.', '.'),
        $simbolo.number_format($detalle[$i]['valorneto'], 0, '.', '.')));
    }

    $this->Ln(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetDrawColor(1,163,232);
    //$this->SetDrawColor(230,230,250);// Establece el color de tabla (en este caso es GRIS CLARO)
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es VERDE)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    if ($timbrePath) {
        $this->Cell(105, 35, $this->Image($timbrePath, $this->GetX(), $this->GetY(), 100, 32), 0, 0);
    } else {
        $this->Cell(105, 35,"", 0, 0);
    }
    $this->Cell(85, 6, "RESUMEN DEL DOCUMENTO", 1, 1, 'C',True);

    if($reg[0]['tipodespacho'] == 1) {
    $tipo = "TRASLADO DE MERCADERIA";
    } elseif ($reg[0]['tipodespacho'] == 2) {
    $tipo = "DEVOLUCIN";
    } elseif ($reg[0]['tipodespacho'] == 3) {
    $tipo = "CONSIGNACIONES";
    } elseif ($reg[0]['tipodespacho'] == 4) {
    $tipo = "ENTREGA GRATUITA";
    } elseif ($reg[0]['tipodespacho'] == 5) {
    $tipo = "OPERACIN CONSTITUYE VENTAS";
    } 

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetLineWidth(.1);
    $this->SetFillColor(1,163,232);
    $this->Cell(105, 8,"", 0, 0, 'L');
    $this->Cell(85, 8,$tipo, 1, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetLineWidth(.1);
    $this->SetFillColor(1,163,232);
    $this->Cell(105, 8,"", 0, 0, 'L');
    $this->Cell(35, 8,"Monto Neto", 1, 0, 'L');
    $this->Cell(10, 8,$simbolo, 1, 0, 'L');
    $this->Cell(40, 8,number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'), 1, 1, 'R');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetLineWidth(.1);
    $this->SetFillColor(1,163,232);
    $this->Cell(105, 8,"", 0, 0, 'L');
    $this->Cell(35, 8,$NomImpuesto." (".number_format($reg[0]["iva"], 0, '.', '.')."%)", 1, 0, 'L');
    $this->Cell(10, 8,$simbolo, 1, 0, 'L');
    $this->Cell(40, 8,number_format($reg[0]["totaliva"], 0, '.', '.'), 1, 1, 'R');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetLineWidth(.1);
    $this->SetFillColor(1,163,232);
    $this->Cell(105, 8,"", 0, 0, 'L');
    $this->Cell(35, 8,"Total", 1, 0, 'L');
    $this->Cell(10, 8,$simbolo, 1, 0, 'L');
    $this->Cell(40, 8,number_format($reg[0]['totalpago'], 0, '.', '.'), 1, 0, 'R');

    if ($timbrePath) {

    $this->Ln(10);
    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(105, 5, "Timbre Electronico S.I.I", 0, 1, 'C');
    $this->Cell(105, 5, "Verifique el Documento en: www.sii.cl", 0, 0, 'C');

    }

    if($reg[0]['observaciones']!=""){
    ########################### OBSERVACIONES #############################
    $this->Ln(10);  
    $this->SetFont($TipoLetra,'B',10);
    $this->MultiCell(190,4,mb_convert_encoding($reg[0]['observaciones'], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Ln(2);
    ########################### OBSERVACIONES #############################    
    }
    $this->SetDrawColor(255,255,255);// Establece el color de tabla (en este caso es GRIS CLARO)
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
}
########################## FUNCION DE GUIA DE DESPACHO (A4) ##############################

########################## FUNCION LISTAR DESPACHOS ##############################
function TablaListarDespachos()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarDespachos();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE DESPACHOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(35,8,'TIPO DE DESPACHO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,60,30,35,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    if($reg[$i]['tipodespacho'] == 1) {
    $tipo_despacho = "TRASLADO DE MERCADERIA";
    } elseif ($reg[$i]['tipodespacho'] == 2) {
    $tipo_despacho = "DEVOLUCION";
    } elseif ($reg[$i]['tipodespacho'] == 3) {
    $tipo_despacho = "CONSIGNACIONES";
    } elseif ($reg[$i]['tipodespacho'] == 4) {
    $tipo_despacho = "ENTREGA GRATUITA";
    } elseif ($reg[$i]['tipodespacho'] == 5) {
    $tipo_despacho = "OPERACION CONSTITUYE VENTAS";
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechadespacho'])),
        mb_convert_encoding($tipo_despacho, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }

    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DESPACHOS ##############################

####################### FUNCION LISTAR DESPACHOS POR FECHAS ########################
function TablaListarDespachosxFechas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarDespachosxFechas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE DESPACHOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(35,8,'TIPO DE DESPACHO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,60,30,35,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    if($reg[$i]['tipodespacho'] == 1) {
    $tipo_despacho = "TRASLADO DE MERCADERIA";
    } elseif ($reg[$i]['tipodespacho'] == 2) {
    $tipo_despacho = "DEVOLUCION";
    } elseif ($reg[$i]['tipodespacho'] == 3) {
    $tipo_despacho = "CONSIGNACIONES";
    } elseif ($reg[$i]['tipodespacho'] == 4) {
    $tipo_despacho = "ENTREGA GRATUITA";
    } elseif ($reg[$i]['tipodespacho'] == 5) {
    $tipo_despacho = "OPERACION CONSTITUYE VENTAS";
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechadespacho'])),
        mb_convert_encoding($tipo_despacho, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }

    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DESPACHOS POR FECHAS ######################

########################## FUNCION LISTAR DESPACHOS POR VENDEDOR ##############################
function TablaListarDespachosxVendedor()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarDespachosxVendedor();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE DESPACHOS POR VENDEDOR',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"VENDEDOR: ".mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(35,8,'TIPO DE DESPACHO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,60,30,35,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    if($reg[$i]['tipodespacho'] == 1) {
    $tipo_despacho = "TRASLADO DE MERCADERIA";
    } elseif ($reg[$i]['tipodespacho'] == 2) {
    $tipo_despacho = "DEVOLUCION";
    } elseif ($reg[$i]['tipodespacho'] == 3) {
    $tipo_despacho = "CONSIGNACIONES";
    } elseif ($reg[$i]['tipodespacho'] == 4) {
    $tipo_despacho = "ENTREGA GRATUITA";
    } elseif ($reg[$i]['tipodespacho'] == 5) {
    $tipo_despacho = "OPERACION CONSTITUYE VENTAS";
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechadespacho'])),
        mb_convert_encoding($tipo_despacho, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }

    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DESPACHOS POR VENDEDOR ##############################

####################### FUNCION LISTAR DESPACHOS POR CLIENTES ########################
function TablaListarDespachosxClientes()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarDespachosxClientes();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE DESPACHOS POR CLIENTE',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"N ".$documento = ($reg[0]['documcliente'] == '0' ? "DOCUMENTO" : mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8')).": ".$reg[0]["dnicliente"],0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"NOMBRE DE CLIENTE: ".mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(50,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(70,8,'TIPO DE DESPACHO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,35,50,70,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    if($reg[$i]['tipodespacho'] == 1) {
    $tipo_despacho = "TRASLADO DE MERCADERIA";
    } elseif ($reg[$i]['tipodespacho'] == 2) {
    $tipo_despacho = "DEVOLUCION";
    } elseif ($reg[$i]['tipodespacho'] == 3) {
    $tipo_despacho = "CONSIGNACIONES";
    } elseif ($reg[$i]['tipodespacho'] == 4) {
    $tipo_despacho = "ENTREGA GRATUITA";
    } elseif ($reg[$i]['tipodespacho'] == 5) {
    $tipo_despacho = "OPERACION CONSTITUYE VENTAS";
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $reg[$i]["codfactura"],
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechadespacho'])),
        mb_convert_encoding($tipo_despacho, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }

    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DESPACHOS POR CLIENTES ######################

####################### FUNCION LISTAR DETALLES DE DESPACHOS POR FECHAS ###########################
function TablaListarDetallesDespachosxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesDespachosxFechas(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DETALLES DESPACHOS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(80,8,'DESCRIPCIN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'DESPACHO',1,0,'C', True);
    $this->Cell(30,8,'MONTO TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,25,80,30,30,20,30,30,25,30));

    $a              = 1;
    $PrecioTotal    = 0;
    $ExisteTotal    = 0;
    $VendidosTotal  = 0;
    $PagoTotal      = 0;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo        = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal    += $reg[$i]['precioventa'];
    if($reg[$i]['tipodetalle'] == 1){
    $tipodetalle     = "PRODUCTO";
    $Existencia      = $reg[$i]['existencia'];
    $ExisteTotal    += $reg[$i]['existencia'];
    } elseif($reg[$i]['tipodetalle'] == 2){
    $tipodetalle     = "COMBO";
    $Existencia      = $reg[$i]['cantcombo'];
    $ExisteTotal    += $reg[$i]['cantcombo'];
    } elseif($reg[$i]['tipodetalle']==3){
    $tipodetalle     = "SERVICIO";
    $Existencia      = '0';
    $ExisteTotal    += '0';
    }
    $VendidosTotal  += $reg[$i]['cantidad']; 

    $Descuento       = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal     = $reg[$i]['precioventa']-$PrecioDescuento;
    $PagoTotal      += $PrecioFinal*$reg[$i]['cantidad'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipodetalle,
        mb_convert_encoding($reg[$i]["codproducto"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : "").$imei = ($reg[$i]["imei"] != "" ? "\nIMEI: ".$reg[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "*****" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]["precioventa"], 0, '.', '.'),
        $Existencia,
        $reg[$i]['cantidad'],
        $simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 0, '.', '.')));
    }

    $this->Cell(220,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PrecioTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$ExisteTotal,0,0,'L');
    $this->CellFitSpace(25,5,$VendidosTotal,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PagoTotal, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR DETALLES DE DESPACHOS POR FECHAS ##########################

####################### FUNCION LISTAR DETALLES DE DESPACHOS POR VENDEDOR ###########################
function TablaListarDetallesDespachosxVendedor()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesDespachosxVendedor(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DETALLES DESPACHOS POR VENDEDOR',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"VENDEDOR: ".mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(80,8,'DESCRIPCIN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'DESPACHO',1,0,'C', True);
    $this->Cell(30,8,'MONTO TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,25,80,30,30,20,30,30,25,30));

    $a              = 1;
    $PrecioTotal    = 0;
    $ExisteTotal    = 0;
    $VendidosTotal  = 0;
    $PagoTotal      = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo         = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal    += $reg[$i]['precioventa'];
    if($reg[$i]['tipodetalle'] == 1){
    $tipodetalle     = "PRODUCTO";
    $Existencia      = $reg[$i]['existencia'];
    $ExisteTotal    += $reg[$i]['existencia'];
    } elseif($reg[$i]['tipodetalle'] == 2){
    $tipodetalle     = "COMBO";
    $Existencia      = $reg[$i]['cantcombo'];
    $ExisteTotal    += $reg[$i]['cantcombo'];
    } elseif($reg[$i]['tipodetalle']==3){
    $tipodetalle     = "SERVICIO";
    $Existencia      = '0';
    $ExisteTotal    += '0';
    }
    $VendidosTotal  += $reg[$i]['cantidad']; 

    $Descuento       = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal     = $reg[$i]['precioventa']-$PrecioDescuento;
    $PagoTotal      += $PrecioFinal*$reg[$i]['cantidad'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipodetalle,
        mb_convert_encoding($reg[$i]["codproducto"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : "").$imei = ($reg[$i]["imei"] != "" ? "\nIMEI: ".$reg[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "*****" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]["precioventa"], 0, '.', '.'),
        $Existencia,
        $reg[$i]['cantidad'],
        $simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 0, '.', '.')));
    }

    $this->Cell(220,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PrecioTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$ExisteTotal,0,0,'L');
    $this->CellFitSpace(25,5,$VendidosTotal,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PagoTotal, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR DETALLES DE DESPACHOS POR VENDEDOR ##########################

####################### FUNCION LISTAR DETALLES DE DESPACHOS POR CLIENTES ###########################
function TablaListarDetallesDespachosxClientes()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesDespachosxClientes(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DETALLES DESPACHOS POR CLIENTES',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"N ".$documento = ($reg[0]['documcliente'] == '0' ? "DOCUMENTO" : mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8')).": ".$reg[0]["dnicliente"],0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"NOMBRE DE CLIENTE: ".mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(80,8,'DESCRIPCIN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'DESPACHO',1,0,'C', True);
    $this->Cell(30,8,'MONTO TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,25,80,30,30,20,30,30,25,30));

    $a              = 1;
    $PrecioTotal    = 0;
    $ExisteTotal    = 0;
    $VendidosTotal  = 0;
    $PagoTotal      = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo         = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal    += $reg[$i]['precioventa'];
    if($reg[$i]['tipodetalle'] == 1){
    $tipodetalle     = "PRODUCTO";
    $Existencia      = $reg[$i]['existencia'];
    $ExisteTotal    += $reg[$i]['existencia'];
    } elseif($reg[$i]['tipodetalle'] == 2){
    $tipodetalle     = "COMBO";
    $Existencia      = $reg[$i]['cantcombo'];
    $ExisteTotal    += $reg[$i]['cantcombo'];
    } elseif($reg[$i]['tipodetalle']==3){
    $tipodetalle     = "SERVICIO";
    $Existencia      = '0';
    $ExisteTotal    += '0';
    }
    $VendidosTotal  += $reg[$i]['cantidad']; 

    $Descuento       = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal     = $reg[$i]['precioventa']-$PrecioDescuento;
    $PagoTotal      += $PrecioFinal*$reg[$i]['cantidad'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipodetalle,
        mb_convert_encoding($reg[$i]["codproducto"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : "").$imei = ($reg[$i]["imei"] != "" ? "\nIMEI: ".$reg[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "*****" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]["precioventa"], 0, '.', '.'),
        $Existencia,
        $reg[$i]['cantidad'],
        $simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 0, '.', '.')));
    }

    $this->Cell(220,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PrecioTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$ExisteTotal,0,0,'L');
    $this->CellFitSpace(25,5,$VendidosTotal,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PagoTotal, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR DETALLES DE DESPACHOS POR CLIENTES ##########################

############################### REPORTES DE GUIA DE DESPACHOS #############################





















########################### REPORTES DE CAJAS DE VENTAS ##############################

########################## FUNCION LISTAR CAJAS ASIGNADAS ##############################
function TablaListarCajas()
{
    $tra = new Login();
    $reg = $tra->ListarCajas();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE CAJAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(35,8,'N DE CAJA',1,0,'C', True);
    $this->Cell(55,8,'NOMBRE DE CAJA',1,0,'C', True);
    $this->Cell(90,8,'RESPONSABLE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,35,55,90));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["nrocaja"],
            mb_convert_encoding($reg[$i]['nomcaja'], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["nombres"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CAJAS ASIGNADAS ##############################

########################## FUNCION TICKET CIERRE ARQUEO ##############################
function TicketCierre()
{  
    $tra     = new Login();
    $reg     = $tra->ArqueoCajaPorId();
    $simbolo = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);

    $detalleabonos      = (new Login)->DetallesAbonosArqueoCajaPorId();
    $detallemovimientos = (new Login)->DetallesMovimientosArqueoCajaPorId();

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
        $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo , 20, 3, 35, 15, "PNG");
        $this->Ln(8);
    }
  
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5, "TICKET DE CIERRE", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(70,3,$reg[0]['documsucursal'] == '0' ? "" : "N ".mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$reg[0]['cuitsucursal'],0,1,'C');

    if($reg[0]['ciudad']==''){

    $this->SetX(2);
    $this->CellFitSpace(70,3,$ciudad = ($reg[0]['id_ciudad'] == '0' ? " " : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8'))." ".$comuna = ($reg[0]['id_comuna'] == '0' ? " " : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8')),0,1,'C');

    }

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,'C');

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'),0,'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(20,3,"CAJA N:",0,0,'L');
    $this->CellFitSpace(50,3,mb_convert_encoding($reg[0]['nrocaja']."-".$reg[0]['nomcaja'], 'ISO-8859-1', 'UTF-8'),0,1,'L');
    
    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(20,3,"CAJERO:",0,0,'L');
    $this->CellFitSpace(50,3,mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'),0,1,'L');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(20,3,"FECHA EMISIN:",0,0,'L');
    $this->CellFitSpace(40,3,date("d/m/Y H:i:s"),0,1,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"HORA APERTURA:",0,0,'L');
    $this->CellFitSpace(40,3,date("d/m/Y H:i:s",strtotime($reg[0]['fechaapertura'])),0,1,'L');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"HORA CIERRE:",0,0,'L');
    $this->CellFitSpace(40,3,date("d/m/Y H:i:s",strtotime($reg[0]['fechacierre'])),0,1,'L');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(30,3,"MONTO APERTURA:",0,0,'L');
    $this->CellFitSpace(40,3,$simbolo.number_format($reg[0]["montoinicial"], 0, '.', '.'),0,1,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(70,3,"DESGLOSE EN VENTAS",0,1,'C');
    $this->Ln(1);

    $a=1;
    $Ventas_Efectivo = 0;
    for($i=0;$i<sizeof($reg);$i++):
    $Ventas_Efectivo += ($reg[$i]['mediopago'] == "EFECTIVO" ? $reg[$i]['montopagado'] : 0);
       if($reg[$i]['mediopago'] != ""){

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,mb_convert_encoding($reg[$i]['mediopago'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->CellFitSpace(6,3,$simbolo,0,0,'R');
    $this->CellFitSpace(30,3,number_format($reg[$i]['montopagado'], 0, '.', '.'),0,1,'R');

       }
    endfor;

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"CRDITOS:",0,0,'L');
    $this->CellFitSpace(6,3,$simbolo,0,0,'R');
    $this->CellFitSpace(30,3,number_format($reg[0]["creditos"], 0, '.', '.'),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(70,3,"DESGLOSE EN ABONOS CRDITOS",0,1,'C');
    $this->Ln(1);

    $a=1;
    $Abonos_Efectivo = 0;
    for($i=0;$i<sizeof($detalleabonos);$i++):
    $Abonos_Efectivo += ($detalleabonos[$i]['mediopago'] == "EFECTIVO" ? $detalleabonos[$i]['monto_abonado'] : 0);
    if($detalleabonos[$i]['mediopago'] != ""){

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,mb_convert_encoding($detalleabonos[$i]['mediopago'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->CellFitSpace(6,3,$simbolo,0,0,'R');
    $this->CellFitSpace(30,3,number_format($detalleabonos[$i]['monto_abonado'], 0, '.', '.'),0,1,'R');

    }
    endfor;

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(70,3,"MOVIMIENTOS EN CAJA",0,1,'C');
    $this->Ln(1);

    $a=1;
    $Movimientos_Efectivo = 0;
    for($i=0;$i<sizeof($detallemovimientos);$i++):
    $Movimientos_Efectivo += ($detallemovimientos[$i]['mediopago'] == "EFECTIVO" ? $detallemovimientos[$i]['movimientos_efectivo'] : 0);
    if($detallemovimientos[$i]['mediopago'] != ""){

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,mb_convert_encoding($detallemovimientos[$i]['mediopago'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->CellFitSpace(6,3,$simbolo,0,0,'R');
    $this->CellFitSpace(30,3,number_format($detallemovimientos[$i]['movimientos_efectivo'], 0, '.', '.'),0,1,'R');

    }
    endfor;

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"EGRESOS:",0,0,'L');
    $this->CellFitSpace(6,3,$simbolo,0,0,'R');
    $this->CellFitSpace(30,3,number_format($reg[0]["egresos"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"EGRESOS(NC):",0,0,'L');
    $this->CellFitSpace(6,3,$simbolo,0,0,'R');
    $this->CellFitSpace(30,3,number_format($reg[0]["egresonotas"], 0, '.', '.'),0,1,'R');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->CellFitSpace(70,3,"REPORTE DE CAJA",0,1,'C');
    $this->Ln(1);

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"TOTAL EN VENTAS:",0,0,'L');
    $this->CellFitSpace(6,3,$simbolo,0,0,'R');
    $this->CellFitSpace(30,3,number_format($reg[0]["ingresos"]+$reg[0]["creditos"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"TOTAL DE ABONOS:",0,0,'L');
    $this->CellFitSpace(6,3,$simbolo,0,0,'R');
    $this->CellFitSpace(30,3,number_format($reg[0]['abonos'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"EFECTIVO EN CAJA:",0,0,'L');
    $this->CellFitSpace(6,3,$simbolo,0,0,'R');
    $this->CellFitSpace(30,3,number_format(($reg[0]["montoinicial"]+$Ventas_Efectivo+$Abonos_Efectivo+$Movimientos_Efectivo)-($reg[0]["egresos"]+$reg[0]["egresonotas"]), 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"EFECTIVO DISPONIBLE:",0,0,'L');
    $this->CellFitSpace(6,3,$simbolo,0,0,'R');
    $this->CellFitSpace(30,3,number_format($reg[0]["dineroefectivo"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->CellFitSpace(34,3,"DIF. EFECTIVO:",0,0,'L');
    $this->CellFitSpace(6,3,$simbolo,0,0,'R');
    $this->CellFitSpace(30,3,number_format($reg[0]["diferencia"], 0, '.', '.'),0,1,'R');


    if($reg[0]["comentarios"]==""){

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->Ln(3);

   } else { 

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(2);

    $this->SetX(2);
    $this->MultiCell(70,4,$this->SetFont('Courier',"",7).mb_convert_encoding($reg[0]["comentarios"], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetFont('Courier','B',12);
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->Ln(3);

    }

    $this->SetX(2);
    $this->SetFont('Courier','B',9);
    $this->CellFitSpace(13,4,"FIRMA:",0,0,'L');
    $this->Cell(55,5,"_________________________",0,1,'L');
 
    $this->SetFont('Courier','BI',9);
    $this->SetX(2);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(70,3,"GRACIAS POR SU ATENCIN",0,1,'C');
    $this->Ln(3);
        
}
########################## FUNCION TICKET CIERRE ARQUEO ##############################

########################## FUNCION LISTAR ARQUEOS DE CAJAS ##############################
function TablaListarArqueos()
{
    $tra = new Login();
    $reg = $tra->ListarArqueoCaja();

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE ARQUEOS EN CAJAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(70,8,'N DE CAJA',1,0,'C', True);
    $this->Cell(25,8,'INICIO',1,0,'C', True);
    $this->Cell(25,8,'CIERRE',1,0,'C', True);
    $this->Cell(25,8,'INICIAL',1,0,'C', True);
    $this->Cell(40,8,'TOTAL VENTAS',1,0,'C', True);
    $this->Cell(30,8,'TOTAL ABONOS',1,0,'C', True);
    $this->Cell(40,8,'EFECTIVO EN CAJA',1,0,'C', True);
    $this->Cell(40,8,'EFECTIVO DISPON',1,0,'C', True);
    $this->Cell(30,8,'DIF EFECTIVO',1,1,'C', True);
    
    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,70,25,25,25,40,30,40,40,30));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalVentas     = 0;
    $TotalAbonos     = 0;
    $TotalIngresos   = 0; 
    $TotalEgresos    = 0;  
    $TotalCaja       = 0;
    $TotalEfectivo   = 0;
    $TotalDiferencia = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $TotalVentas     += $reg[$i]['ingresos']+$reg[$i]['creditos'];
    $TotalAbonos     += $reg[$i]['abonos'];
    $TotalIngresos   += $reg[$i]['ingresos2'];
    $TotalEgresos    += $reg[$i]['egresos']+$reg[$i]['egresonotas'];
    $TotalCaja       += $reg[$i]['efectivocaja'];
    $TotalEfectivo   += $reg[$i]['dineroefectivo'];
    $TotalDiferencia += $reg[$i]['diferencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        mb_convert_encoding($reg[$i]['nrocaja'].": ".$reg[$i]['nomcaja'].":".$reg[$i]['nombres'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaapertura'])),
        $reg[$i]['fechacierre'] == '0000-00-00 00:00:00' ? "******" : date("d/m/Y H:i:s",strtotime($reg[$i]['fechacierre'])),
        $simbolo.number_format($reg[$i]['montoinicial'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['ingresos']+$reg[$i]['creditos'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['abonos'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['efectivocaja'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['dineroefectivo'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['diferencia'], 0, '.', '.')));
    }

    $this->Cell(155,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,$simbolo.number_format($TotalVentas, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$simbolo.number_format($TotalAbonos, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,$simbolo.number_format($TotalCaja, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,$simbolo.number_format($TotalEfectivo, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$simbolo.number_format($TotalDiferencia, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR ARQUEOS DE CAJAS ##############################

########################## FUNCION LISTAR ARQUEOS DE CAJAS POR FECHAS ##############################
function TablaListarArqueosxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarArqueosxFechas();

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE ARQUEOS EN CAJAS POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"N DE CAJA: ".mb_convert_encoding($reg[0]['nrocaja'].": ".$reg[0]['nomcaja'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"RESPONSABLE: ".mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(25,8,'INICIO',1,0,'C', True);
    $this->Cell(25,8,'CIERRE',1,0,'C', True);
    $this->Cell(25,8,'INICIAL',1,0,'C', True);
    $this->Cell(40,8,'TOTAL VENTAS',1,0,'C', True);
    $this->Cell(30,8,'TOTAL ABONOS',1,0,'C', True);
    $this->Cell(35,8,'TOTAL INGRESOS',1,0,'C', True);
    $this->Cell(35,8,'TOTAL EGRESOS',1,0,'C', True);
    $this->Cell(40,8,'EFECTIVO EN CAJA',1,0,'C', True);
    $this->Cell(40,8,'EFECTIVO DISPON',1,0,'C', True);
    $this->Cell(30,8,'DIF EFECTIVO',1,1,'C', True);
    
    if($reg==""){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,25,25,25,40,30,35,35,40,40,30));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalVentas     = 0;
    $TotalAbonos     = 0;
    $TotalIngresos   = 0; 
    $TotalEgresos    = 0;  
    $TotalCaja       = 0;
    $TotalEfectivo   = 0;
    $TotalDiferencia = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $TotalVentas     += $reg[$i]['ingresos']+$reg[$i]['creditos'];
    $TotalAbonos     += $reg[$i]['abonos'];
    $TotalIngresos   += $reg[$i]['ingresos2'];
    $TotalEgresos    += $reg[$i]['egresos']+$reg[$i]['egresonotas'];
    $TotalCaja       += $reg[$i]['efectivocaja'];
    $TotalEfectivo   += $reg[$i]['dineroefectivo'];
    $TotalDiferencia += $reg[$i]['diferencia'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaapertura'])),
        $reg[$i]['fechacierre'] == '0000-00-00 00:00:00' ? "******" : date("d/m/Y H:i:s",strtotime($reg[$i]['fechacierre'])),
        $simbolo.number_format($reg[$i]['montoinicial'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['ingresos']+$reg[$i]['creditos'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['abonos'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['ingresos2'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['egresos']+$reg[$i]['egresonotas'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['efectivocaja'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['dineroefectivo'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['diferencia'], 0, '.', '.')));
    }

    $this->Cell(85,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,$simbolo.number_format($TotalVentas, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$simbolo.number_format($TotalAbonos, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,$simbolo.number_format($TotalIngresos, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,$simbolo.number_format($TotalEgresos, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,$simbolo.number_format($TotalCaja, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,$simbolo.number_format($TotalEfectivo, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$simbolo.number_format($TotalDiferencia, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR ARQUEOS DE CAJAS POR FECHAS ##############################

########################## FUNCION TICKET MOVIMIENTOS EN CAJA ##############################
function TicketMovimiento()
{  
    $tra       = new Login();
    $reg       = $tra->MovimientosPorId();
    $simbolo   = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra = "Courier";

    //Logo
    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
       $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
       $this->Image($logo , 20, 3, 35, 15, "PNG");
       $this->Ln(8);
    }
  
    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5, "TICKET DE MOVIMIENTO", 0, 0, 'C');
    $this->Ln(5);
  
    //######################### BLOQUE DATOS DE SUCURSAL #############################
    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

    $this->SetX(2);
    $this->SetFont('Courier','B',9);
    $this->CellFitSpace(70,3,$reg[0]['documsucursal'] == '0' ? "" : "N ".mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$reg[0]['cuitsucursal'],0,1,'C');

    if($reg[0]['id_comuna']!='0'){

    $this->SetX(2);
    $this->CellFitSpace(70,3,$comuna = ($reg[0]['id_comuna'] == '0' ? " " : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))." ".$ciudad = ($reg[0]['id_ciudad'] == '0' ? " " : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8')),0,1,'C');
    }

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,'C');

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'),0,'C');
    //######################### BLOQUE DATOS DE SUCURSAL #############################

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(2);

    $this->SetX(2);
    $this->SetFont('Courier','',9);
    $this->CellFitSpace(35,4,"Nro Ticket:  ", 0, 0, 'J');
    $this->SetFont('Courier','B',9);
    $this->CellFitSpace(35,4,$reg[0]['numero'], 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont('Courier','',9);
    $this->CellFitSpace(18,4,"CAJA:", 0, 0, 'J');
    $this->SetFont('Courier','B',9);
    $this->CellFitSpace(52,4,mb_convert_encoding($reg[0]['nrocaja']."-".$reg[0]['nomcaja'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont('Courier','',9);
    $this->CellFitSpace(18,4,"CAJERO:", 0, 0, 'J');
    $this->SetFont('Courier','B',9);
    $this->CellFitSpace(52,4,mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont('Courier','',9);
    $this->CellFitSpace(35,4,"FECHA: ".date("d/m/Y",strtotime($reg[0]['fechamovimiento'])), 0, 0, 'J');
    $this->CellFitSpace(35,4,"HORA: ".date("H:i:s",strtotime($reg[0]['fechamovimiento'])), 0, 0, 'R');
    $this->Ln();

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','',9);
    $this->CellFitSpace(35,4,"TIPO:  ", 0, 0, 'J');
    $this->SetFont('Courier','B',9);
    $this->CellFitSpace(35,4,mb_convert_encoding($reg[0]['tipomovimiento'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont('Courier','',9);
    $this->CellFitSpace(35,4,"MONTO:  ", 0, 0, 'J');
    $this->SetFont('Courier','B',9);
    $this->CellFitSpace(35,4,$simbolo.number_format($reg[0]["montomovimiento"], 0, '.', '.'), 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont('Courier','',9);
    $this->CellFitSpace(35,4,"MEDIO:  ", 0, 0, 'J');
    $this->SetFont('Courier','B',9);
    $this->CellFitSpace(35,4,mb_convert_encoding($reg[0]['mediopago'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont('Courier','B',10);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5,"DESCRIPCIN DE MOVIMIENTO", 0, 0, 'L');
    $this->Ln(5);

    $this->SetX(2);
    $this->SetFont('Courier','B',8);
    $this->MultiCell(70,3,$this->SetFont('Courier','',8).$reg[0]['descripcionmovimiento'] == "" ? "SIN OBSERVACIONES" : mb_convert_encoding($reg[0]['descripcionmovimiento'], 'ISO-8859-1', 'UTF-8'),0,'J');
    $this->Ln();

    $this->SetX(2);
    $this->SetFont('Courier','B',12);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->Ln();

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont('Courier','BI',10)." ",0,'C');
    $this->Ln(3);   
}
########################## FUNCION TICKET MOVIMIENTOS EN CAJA ##############################

####################### FUNCION LISTAR MOVIMIENTOS EN CAJA ##########################
function TablaListarMovimientos()
{
    $tra = new Login();
    $reg = $tra->ListarMovimientos();

    $this->SetFont('Courier','B',12);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,'LISTADO GENERAL DE MOVIMIENTOS EN CAJA',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE CAJA',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(55,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(30,8,'MONTO',1,0,'C', True);
    $this->Cell(35,8,'MEDIO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,40,20,55,30,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            mb_convert_encoding($reg[$i]['nrocaja'].": ".$reg[$i]['nomcaja'], 'ISO-8859-1', 'UTF-8'),
            $reg[$i]["tipomovimiento"],
            mb_convert_encoding($reg[$i]['descripcionmovimiento'], 'ISO-8859-1', 'UTF-8'),
            $simbolo.number_format($reg[$i]['montomovimiento'], 0, '.', '.'),
            mb_convert_encoding($reg[$i]["mediopago"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR MOVIMIENTOS EN CAJAS #########################

##################### FUNCION LISTAR MOVIMIENTOS EN CAJA POR FECHAS #####################
function TablaListarMovimientosxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarMovimientosxFechas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(190,10,"LISTADO DE MOVIMIENTOS EN CAJA POR FECHAS",0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(190,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(190,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(190,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(130,6,"N DE CAJA: ".mb_convert_encoding($reg[0]["nrocaja"].": ".$reg[0]["nomcaja"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Cell(60,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'R');
    $this->Ln();
    $this->Cell(130,6,"RESPONSABLE: ".mb_convert_encoding($reg[0]["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Cell(60,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'R');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(10,8,'N',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(75,8,'DESCRIPCIN',1,0,'C', True);
    $this->Cell(40,8,'MONTO',1,0,'C', True);
    $this->Cell(45,8,'MEDIO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(10,20,75,40,45));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $reg[$i]["tipomovimiento"],
            mb_convert_encoding($reg[$i]['descripcionmovimiento'], 'ISO-8859-1', 'UTF-8'),
            $simbolo.number_format($reg[$i]['montomovimiento'], 0, '.', '.'),
            mb_convert_encoding($reg[$i]["mediopago"], 'ISO-8859-1', 'UTF-8')));
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(86,6,'RECIBIDO:____________________________',0,0,'');
    $this->Ln();
    $this->Cell(4,6,'',0,0,'');
    $this->Cell(100,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(86,6,'',0,0,'');
    $this->Ln(4);
}
##################### FUNCION LISTAR MOVIMIENTOS EN CAJAS POR FECHAS ###################

####################### FUNCION LISTAR GANANCIAS POR FECHAS ###########################
function TablaListarGananciasxFechas()
{
    $ingresos = new Login();
    $detalle_ingreso = $ingresos->BuscarIngresosxFechas(); 

    $ganancias = new Login();
    $reg = $ganancias->BuscarGananciasxFechas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,"LISTADO DE DE GANANCIAS POR FECHAS",0,0,'C'); 

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L'); 

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'CDIGO',1,0,'C', True);
    $this->Cell(75,8,'DESCRIPCIN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(15,8,'DCTO %',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(20,8,'VENDIDO',1,0,'C', True);
    $this->Cell(30,8,'TOTAL VENTA',1,0,'C', True);
    $this->Cell(30,8,'TOTAL COMPRA',1,0,'C', True);
    $this->Cell(30,8,'GANANCIAS',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,30,75,30,30,15,30,20,30,30,30));

    $a=1;
    $PrecioCompraTotal    = 0;
    $PrecioVentaTotal     = 0;
    $VendidosTotal        = 0;
    $ImpuestosCompraTotal = 0;
    $ImpuestosVentaTotal  = 0;
    $CompraTotal          = 0;
    $VentaTotal           = 0;
    $TotalGanancia        = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioCompraTotal   += $reg[$i]['preciocompra'];
    $PrecioVentaTotal    += $reg[$i]['precioventa'];
    $VendidosTotal       += $reg[$i]['cantidad'];

    $Descuento           = $reg[$i]['descproducto']/100;
    $PrecioDescuento     = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal         = $reg[$i]['precioventa']-$PrecioDescuento;

    //VALOR DE IMPUESTO
    $ValorIva = 1 + ($reg[$i]['ivaproducto']/100);

    //CALCULO SUBTOTAL IMPUESTOS PRECIO COMPRA
    $DiscriminadoC         = $reg[$i]['preciocompra']/$ValorIva;
    $SubtotalDiscriminadoC = $reg[$i]['preciocompra'] - $DiscriminadoC;
    $BaseDiscriminadoC     = $SubtotalDiscriminadoC * $reg[$i]['cantidad'];
    $SubtotalimpuestosC    = ($reg[$i]['ivaproducto'] != '0.00' ? number_format($BaseDiscriminadoC, 2, '.', '') : "0.00");

    //CALCULO SUBTOTAL IMPUESTOS PRECIO VENTA
    $DiscriminadoV         = $PrecioFinal/$ValorIva;
    $SubtotalDiscriminadoV = $PrecioFinal - $DiscriminadoV;
    $BaseDiscriminadoV     = $SubtotalDiscriminadoV * $reg[$i]['cantidad'];
    $SubtotalimpuestosV    = ($reg[$i]['ivaproducto'] != '0.00' ? number_format($BaseDiscriminadoV, 2, '.', '') : "0.00");

    $SumCompra = ($reg[$i]['preciocompra']*$reg[$i]['cantidad'])-$SubtotalimpuestosC;
    $SumVenta  = ($PrecioFinal*$reg[$i]['cantidad'])-$SubtotalimpuestosV; 

    $CompraTotal          += $SumCompra;
    $ImpuestosCompraTotal += $SubtotalimpuestosC;
    $VentaTotal           += $SumVenta;
    $ImpuestosVentaTotal  += $SubtotalimpuestosV;
    $TotalGanancia        += $SumVenta-$SumCompra;

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            mb_convert_encoding($reg[$i]["codproducto"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : "").$imei = ($reg[$i]["imei"] != "" ? "\nIMEI: ".$reg[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "*****" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
            mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
            number_format($reg[$i]['descproducto'], 0, '.', '.'),
            $simbolo.number_format($reg[$i]["precioventa"], 0, '.', '.'),
            number_format($reg[$i]['cantidad'], 2, '.', ','),
            $simbolo.number_format($SumVenta, 0, '.', '.'),
            $simbolo.number_format($SumCompra, 0, '.', '.'),
            $simbolo.number_format($SumVenta-$SumCompra, 0, '.', '.')));
        }
    }
   
    $this->Cell(225,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(20,5,number_format($VendidosTotal, 2, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($VentaTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($CompraTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalGanancia, 0, '.', '.'),0,0,'L');
    $this->Ln();

    $this->SetFont('courier','B',14);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(150,6,'DETALLES DE GANANCIAS / INGRESOS / GASTOS',1,0,'C', True);
    $this->Ln();
    
    $this->SetFont('courier','B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->Cell(65,5,'TOTAL DE GANANCIAS',1,0,'C', True);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,($simbolo ?? "").number_format($TotalGanancia, 0, '.', '.'),1,0,'C');
    $this->Ln();
    
    $this->SetFont('courier','B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(65,5,'INGRESOS ADICIONALES',1,0,'C', True);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,($simbolo ?? "").number_format($detalle_ingreso[0]['totalingresos'] ?? 0.00, 0, '.', '.'),1,0,'C');
    $this->Ln();
    
    $this->SetFont('courier','B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(65,5,'GASTOS',1,0,'C', True);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,($simbolo ?? "").number_format($detalle_ingreso[0]['totalegresos'] ?? 0.00, 0, '.', '.'),1,0,'C');
    $this->Ln();
    
    $this->SetFont('courier','B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(65,5,'TOTAL',1,0,'C', True);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(85,5,($simbolo ?? "").number_format($TotalGanancia+$detalle_ingreso[0]['totalingresos']-$detalle_ingreso[0]['totalegresos'], 0, '.', '.'),1,0,'C');
    $this->Ln();
   
    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
###################### FUNCION LISTAR GANANCIAS POR FECHAS ##########################

############################## REPORTES DE CAJAS DE VENTAS ##############################























################################### REPORTES DE VENTAS ##################################

########################## FUNCION BOLETA VENTA ##############################
function BoletaVenta()
{  
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra        = new Login();
    $reg        = $tra->VentasPorId();
    $timbrePath = Lioren::getTimbre($reg[0]);
    $simbolo    = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra  = "Courier"; 

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

    $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
    $this->Image($logo , 20, 3, 35, 15, "PNG");
    $this->Ln(8);

    }
  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5, "BOLETA DE VENTA", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,3,$reg[0]['documsucursal'] == '0' ? "" : "N ".mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$reg[0]['cuitsucursal'],0,1,'C');

    if($reg[0]['id_ciudad']!='0'){

    $this->SetX(2);
    $this->CellFitSpace(70,3,$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8')." ".$comuna = $reg[0]['id_comuna'] == '0' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8')),0,1,'C');
    }

    $this->SetX(2);
    $this->CellFitSpace(70,3,mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,1,'C');

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'B',9).mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'),0,'C');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);
    
    if($reg[0]['codcliente'] == '0'){

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(70,4,"A CONSUMIDOR FINAL", 0, 1, 'J');   

    } else {

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,3,$documento = ($reg[0]['documcliente'] == '0' ? "N DOC:" : "N ".mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8').": ".$reg[0]['dnicliente']),0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['direccliente'].$comuna = ($reg[0]['id_comuna2'] == '0' ? "" : " ".$reg[0]['comuna2'])."".$ciudad = ($reg[0]['id_ciudad2'] == '0' ? "" : " ".$reg[0]['ciudad2']), 'ISO-8859-1', 'UTF-8'),0,'L');
    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(2);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(35,4,"Nro BOLETA:  ", 0, 0, 'J');
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(35,4,$reg[0]['codfactura'], 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(18,4,"CAJERO:", 0, 0, 'J');
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(52,4,mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(35,4,"FECHA: ".date("d/m/Y",strtotime($reg[0]['fechaventa'])), 0, 0, 'J');
    $this->CellFitSpace(35,4,"HORA: ".date("H:i:s",strtotime($reg[0]['fechaventa'])), 0, 0, 'R');
    $this->Ln();

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5,"DETALLES DE PRODUCTOS", 0, 0, 'L');
    $this->Ln(5);

    $tra = new Login();
    $detalle = $tra->VerDetallesVentas();
    $cantidad = 0;
    $SubTotal = 0;
    $montoExento = 0;
    $valorIva    = $reg[0]["iva"] / 100;
    $Articulos = 0;
    $a=1;
    for($i=0;$i<sizeof($detalle);$i++):
    $SubTotal += $detalle[$i]['valortotal'];
    $Articulos += $detalle[$i]['cantventa'];

    $this->SetX(2);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    
    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(35,3,$detalle[$i]['cantventa']." X ".$simbolo.number_format($detalle[$i]["precioventa"], 0, '.', '.'),0,0,'J');

    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(35,3,$simbolo.number_format($detalle[$i]["valorneto"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->MultiCell(70,3,mb_convert_encoding($detalle[$i]["producto"]." ".$detalle[$i]["condicion"], 'ISO-8859-1', 'UTF-8'),0,1,'');

    if($detalle[$i]["descripcion"] != ""){
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',6);
    $this->MultiCell(70,3,mb_convert_encoding($detalle[$i]["descripcion"], 'ISO-8859-1', 'UTF-8'),0,1,'');
    }

    if($detalle[$i]["imei"] != ""){
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',6);
    $this->MultiCell(70,3,"N DE IMEI: ".mb_convert_encoding($detalle[$i]["imei"], 'ISO-8859-1', 'UTF-8'),0,1,'');
    }

    endfor;

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(22,4,"TIPO PAGO",0,0,'L');
    $this->Cell(48,4,mb_convert_encoding($reg[0]['tipopago'], 'ISO-8859-1', 'UTF-8'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(22,4,"SUBTOTAL",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(22,4,$NomImpuesto." (".number_format($reg[0]["iva"], 0, '.', '.')."%):",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]["totaliva"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(22,4,"DESC (".number_format($reg[0]["descuento"], 0, '.', '.')."%)",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]['totaldescuento'], 0, '.', '.'),0,1,'R');

    if($reg[0]['montodescuento'] != 0.00){
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(22,4,"DESCUENTO",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]['montodescuento'], 0, '.', '.'),0,1,'R');
    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(22,4,"TOTAL",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]['totalpago'], 0, '.', '.'),0,1,'R');

    if($reg[0]['tipopago'] == "CONTADO"){ 

    $explode = explode("<br>",$reg[0]['detalles_pagos']);
    for($cont=0; $cont<COUNT($explode); $cont++):
    list($codmediopago,$mediopago,$montopagado,$montodevuelto) = explode("|",$explode[$cont]);

        if(COUNT($explode) == 1) {

            $this->SetX(2);
            $this->SetFont($TipoLetra,'',9);
            $this->CellFitSpace(30,4,mb_convert_encoding($mediopago, 'ISO-8859-1', 'UTF-8'),0,0,'L');
            $this->Cell(40,4,$simbolo.number_format($montopagado, 0, '.', '.'),0,1,'R');

            $this->SetX(2);
            $this->SetFont($TipoLetra,'',9);
            $this->CellFitSpace(30,4,"SU VUELTO",0,0,'L');
            $this->Cell(40,4,$simbolo.number_format($montodevuelto, 0, '.', '.'),0,1,'R');

        } else {

            $this->SetX(2);
            $this->SetFont($TipoLetra,'',9);
            $this->CellFitSpace(30,4,mb_convert_encoding($mediopago, 'ISO-8859-1', 'UTF-8'),0,0,'L');
            $this->Cell(40,4,$simbolo.number_format($montopagado, 0, '.', '.'),0,1,'R');

        }

    endfor;

    }

    ############# MUESTRO ABONOS Y PENDIENTE #############
    if($reg[0]['tipopago']=="CREDITO"){

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(30,4,"ABONADO",0,0,'L');
    $this->Cell(40,4,$simbolo.number_format($reg[0]['creditopagado'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(30,4,"PENDIENTE",0,0,'L');
    $this->Cell(40,4,$simbolo.number_format($reg[0]['totalpago']-$reg[0]['creditopagado'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(30,4,"VENCIMIENTO",0,0,'L');
    $this->Cell(40,4,date("d/m/Y",strtotime($reg[0]["fechavencecredito"])),0,1,'R');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,4,"ACEPTO PAGAR EL TOTAL DE CRDITO",0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(12,4,"FIRMA:",0,0,'L');
    $this->Cell(50,5,"____________________________",0,1,'L');
    }
    ############# MUESTRO ABONOS Y PENDIENTE #############

    if($reg[0]['observaciones']!=""){
    ########################### OBSERVACIONES #############################
    $this->Ln(2);  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',8);
    $this->MultiCell(70,4,mb_convert_encoding($reg[0]['observaciones'], 'ISO-8859-1', 'UTF-8'),0,1,'');
    $this->Ln(2);
    ########################### OBSERVACIONES #############################    
    }

    $this->Ln(2);
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(30,4,"CANTIDAD TOTAL:",0,0,'L');
    $this->CellFitSpace(40,4,$Articulos,0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'),0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(10,4,"TEL:",0,0,'L');
    $this->CellFitSpace(60,4,$reg[0]['tlfsucursal'],0,1,'L');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->Ln(3); 

    if ($timbrePath) {

    $this->SetX(2);
    $this->Cell(70, 25, $this->Image($timbrePath, $this->GetX(), $this->GetY(), 70, 25), 0, 1);
    $this->SetX(4);
    $this->SetFont($TipoLetra, 'B', 10);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66, 6, "TIMBRE ELECTRONICO S.I.I", 0, 1, 'C');
    $this->SetX(4);
    $this->SetFont($TipoLetra, 'B', 7);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66, 3, "Verifique el Documento en: www.sii.cl", 0, 1, 'C');
    $this->Ln(2);

    } else {

    $this->SetX(2);
    $this->SetFont($TipoLetra,'BI',10);
    $this->SetFillColor(3, 3, 3);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'BI',10).mb_convert_encoding($reg[0]['membrete'], 'ISO-8859-1', 'UTF-8'),0,'C');
    $this->Ln(3);
    
    }
}
########################## FUNCION BOLETA VENTA ##############################

########################## FUNCION FACTURA VENTA (80 mm) ##############################
function FacturaVenta()
{  
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra        = new Login();
    $reg        = $tra->VentasPorId();
    $timbrePath = Lioren::getTimbre($reg[0]);
    $simbolo    = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra  = "Arial"; 

    //Bloque de membrete principal
    $this->SetFillColor(229);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.3);
    $this->RoundedRect(8, 8, 58, 18, '0', '');
  
    $this->SetXY(8,8);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->CellFitSpace(58, 6, $reg[0]['documsucursal'] == '0' ? "" : "".mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8').": ".$reg[0]['cuitsucursal'], 0, 1, 'C');

    $this->SetX(8);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(58, 6, "FACTURA ELECTRONICA", 0, 1, 'C');

    $this->SetX(8);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->CellFitSpace(58, 6, "N ".$reg[0]['codfactura'], 0, 1, 'C');

    $this->SetX(8);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetFillColor(2,157,116);
    $this->CellFitSpace(58, 5, "S.I.I. - ".strtoupper($comuna = ($reg[0]['id_comuna'] == '0' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))), 0, 0, 'C');
    $this->Ln();

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {

    $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
    $this->Image($logo , 20, 32, 35, 15, "PNG");
    $this->Ln(16);

    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->Cell(70, 3, "", 0, 1, 'C');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'B',9).mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',7);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'',7).mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',7);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'',7)."CASA MATRIZ: ".strtoupper(mb_convert_encoding($reg[0]['direcsucursal'].", ".$comuna = ($reg[0]['id_comuna'] == '0' ? "" : $reg[0]['comuna'])." - ".$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : $reg[0]['ciudad']), 'ISO-8859-1', 'UTF-8')),0,'L');
    $this->Ln(2);


    if($reg[0]['codcliente'] == '0'){

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(70,4,"A CONSUMIDOR FINAL", 0, 1, 'J');   

    } else {

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',7);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'',8)."Receptor: ".mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(70,3,$documento = ($reg[0]['documcliente'] == '0' ? "DOC:" : "".mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8')).": ".$reg[0]['dnicliente'],0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',7);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'',7)."Giro: ".mb_convert_encoding($reg[0]['girocliente'], 'ISO-8859-1', 'UTF-8'),0,'J');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',7);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'',7)."Direccin: ".mb_convert_encoding($reg[0]['direccliente'], 'ISO-8859-1', 'UTF-8'),0,'J');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(35, 3, "Comuna: ".strtoupper($comuna2 = ($reg[0]['id_comuna2'] == '0' ? "" : mb_convert_encoding($reg[0]['comuna2'], 'ISO-8859-1', 'UTF-8'))), 0, 0, 'L');
    $this->CellFitSpace(35, 3, "Ciudad: ".strtoupper($ciudad2 = ($reg[0]['id_ciudad2'] == '0' ? "" : mb_convert_encoding($reg[0]['ciudad2'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'L');

    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',7);
    $this->CellFitSpace(20, 3, "Fecha Emisin:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(50, 3, date("d/m/Y",strtotime($reg[0]['fechaventa'])), 0, 1, 'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',7);
    $this->CellFitSpace(20, 3, "Vendedor:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(50, 3, mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',7);
    $this->CellFitSpace(30, 3, "Fecha de Vencimiento:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(40, 3, $vence = ($reg[0]['tipopago'] == "CONTADO" ? date("d/m/Y",strtotime($reg[0]['fechaventa'])) : date("d/m/Y",strtotime($reg[0]['fechavencecredito']))), 0, 1, 'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',7);
    $this->CellFitSpace(20, 3, "Tipo de Pago:", 0, 0, 'L');
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(50, 3, mb_convert_encoding($reg[0]['tipopago'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');

    if($reg[0]['tipopago'] == "CONTADO"){ 

    $explode = explode("<br>",$reg[0]['detalles_pagos']);
    $j=1;
    for($cont=0; $cont<COUNT($explode); $cont++):
    list($codmediopago,$mediopago,$montopagado,$montodevuelto) = explode("|",$explode[$cont]);

        if(COUNT($explode) == 1) {

            $this->SetX(2);
            $this->SetFont($TipoLetra,'B',7);
            $this->CellFitSpace(18, 3, "Forma Pago:", 0, 0, 'L');
            $this->SetFont($TipoLetra,'',7);
            $this->CellFitSpace(32, 3, mb_convert_encoding($mediopago, 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
            $this->SetFont($TipoLetra,'',7);
            $this->CellFitSpace(20, 3,$simbolo.number_format($montopagado, 0, '.', '.'), 0, 0, 'R');
            $this->Ln();

        } else {

            $this->SetX(2);
            $this->SetFont($TipoLetra,'B',7);
            $this->CellFitSpace(18, 3, "Forma Pago: ".$j++, 0, 0, 'L');
            $this->SetFont($TipoLetra,'',7);
            $this->CellFitSpace(32, 3, mb_convert_encoding($mediopago, 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
            $this->SetFont($TipoLetra,'',7);
            $this->CellFitSpace(20, 3,$simbolo.number_format($montopagado, 0, '.', '.'), 0, 0, 'R');
            $this->Ln();
        }
    endfor;
    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,0,'_____________________________',0,0,'C');
    $this->Ln(2);

    $this->SetX(3);
    $this->SetFont($TipoLetra,'B',7);
    $this->SetFillColor(2,157,116);
    $this->Cell(22, 5,"CODIGO/ITEM", 0, 0, 'L');
    $this->Cell(30, 5,"CANTIDAD/PRECIO", 0, 0, 'C');
    $this->Cell(16, 5,"TOTAL", 0, 0, 'R');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,0,'_____________________________',0,0,'C');
    $this->Ln(3);

    $tra = new Login();
    $detalle = $tra->VerDetallesVentas();
    $cantidad = 0;
    $SubTotal = 0;
    $montoExento = 0;
    $valorIva    = $reg[0]["iva"] / 100;
    $Articulos = 0;
    $a=1;
    for($i=0;$i<sizeof($detalle);$i++):
    $SubTotal += $detalle[$i]['valortotal'];
    $Articulos += $detalle[$i]['cantventa'];

    $this->SetX(3);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFont($TipoLetra,'',7);
    $this->CellFitSpace(26,3,$detalle[$i]['codproducto'],0,0,'J');
    $this->CellFitSpace(13,3,$detalle[$i]['cantventa'],0,0,'J');
    $this->CellFitSpace(13,3,number_format($detalle[$i]['precioventa'], 0, '.', '.'),0,0,'J');
    $this->CellFitSpace(16,3,number_format($detalle[$i]["valorneto"], 0, '.', '.'),0,1,'R');

    $this->SetX(3);
    $this->SetFont($TipoLetra,'',7);
    $this->MultiCell(68,3,mb_convert_encoding($detalle[$i]["producto"]." ".$detalle[$i]["condicion"], 'ISO-8859-1', 'UTF-8'),0,1,'');

    if($detalle[$i]["descripcion"] != ""){
    $this->SetX(3);
    $this->SetFont($TipoLetra,'',6);
    $this->MultiCell(68,3,mb_convert_encoding($detalle[$i]["descripcion"], 'ISO-8859-1', 'UTF-8'),0,1,'');
    }

    if($detalle[$i]["imei"] != ""){
    $this->SetX(3);
    $this->SetFont($TipoLetra,'',6);
    $this->MultiCell(68,3,"N DE IMEI: ".mb_convert_encoding($detalle[$i]["imei"], 'ISO-8859-1', 'UTF-8'),0,1,'');
    }


    endfor;

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,0,'_____________________________',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(22,4,"Subtotal",0,0,'L');
    $this->Cell(48,4,number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->MultiCell(70,4,$this->SetFont($TipoLetra,'',7)."SON: ".mb_convert_encoding(numtoletras(number_format($reg[0]['totalpago'], 0, '.', '')), 'ISO-8859-1', 'UTF-8'),0,'J');


    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(68,4,"Referencias:",0,0,'L');
    $this->Ln();

    $this->SetX(3);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(24,4,"TIPO DOC", 1, 0, 'C');
    $this->CellFitSpace(22,4,"FOLIO", 1, 0, 'C');
    $this->CellFitSpace(22,4,"FECHA", 1, 1, 'C');

    $this->SetX(3);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(24,6," ", 1, 0, 'C');
    $this->CellFitSpace(22,6," ", 1, 0, 'C');
    $this->CellFitSpace(22,6," ", 1, 0, 'C');
    $this->Ln(8);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(22,3,"MONTO NETO",0,0,'L');
    $this->Cell(48,3,number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(22,3,"MONTO ".$NomImpuesto,0,0,'L');
    $this->Cell(48,3,number_format($reg[0]['totaliva'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(22,5,"MONTO TOTAL",0,0,'L');
    $this->Cell(48,5,number_format($reg[0]['totalpago'], 0, '.', '.'),0,1,'R');

    if($reg[0]['observaciones']!=""){
    ########################### OBSERVACIONES #############################
    $this->Ln(2);  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',8);
    $this->MultiCell(70,4,mb_convert_encoding($reg[0]['observaciones'], 'ISO-8859-1', 'UTF-8'),0,1,'');
    $this->Ln(2);
    ########################### OBSERVACIONES #############################    
    }

    if ($timbrePath) {

    $this->SetX(2);
    $this->Cell(70, 25, $this->Image($timbrePath, $this->GetX(), $this->GetY(), 70, 25), 0, 1);
    $this->SetX(4);
    $this->SetFont($TipoLetra, 'B', 10);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66, 6, "Timbre Electronico S.I.I", 0, 1, 'C');
    $this->SetX(4);
    $this->SetFont($TipoLetra, 'B', 7);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66, 3, "Res. 159 de 2009 - Verifique Documento:", 0, 1, 'C');
    $this->SetX(4);
    $this->SetFont($TipoLetra, 'B', 7);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66, 3, "www.sii.cl", 0, 1, 'C');
    $this->Ln(2);
    
    }
}
########################## FUNCION FACTURA VENTA (80 mm) ##############################

########################## FUNCION FACTURA VENTA (A4) ##############################
function FacturaVenta_A4()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra        = new Login();
    $reg        = $tra->VentasPorId();
    $timbrePath = Lioren::getTimbre($reg[0]);
    $simbolo    = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']); 
    $TipoLetra  = "Arial";

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
    $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
    $this->Image($logo , 20, 14, 48, 28, "PNG");
    $this->Ln(5);
    } else {
    $this->Ln(5);
    }
    
    //Bloque de Factura Eletronica
    $this->SetDrawColor(220,50,50);
    $this->SetLineWidth(.8);
    $this->SetFillColor(229);
    $this->RoundedRect(120, 12, 80, 26, '0', '');

    $this->SetFont($TipoLetra,'B',13);
    $this->SetFillColor(2,157,116);
    $this->SetLineWidth(.3);
    $this->Cell(110, 8, "", 0, 0, 'C');
    $this->Cell(80, 8, $reg[0]['documsucursal'] == '0' ? "" : "".mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8').": ".$reg[0]['cuitsucursal'], 0, 1, 'C');

    $this->Cell(110, 8, "", 0, 0, 'C');
    $this->Cell(80, 8, "FACTURA ELECTRONICA", 0, 1, 'C');

    $this->Cell(110, 8, "", 0, 0, 'C');
    $this->Cell(80, 8, "N ".$reg[0]['codfactura'], 0, 1, 'C');

    $this->Cell(110, 9, "", 0, 0, 'C');
    $this->SetTextColor(220,50,50);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(80, 12, "S.I.I - ".strtoupper($comuna = ($reg[0]['comuna'] == '' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'C');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(110, 6, "", 0, 0, 'C');
    $this->Cell(50, 6, "Fecha de Emisin", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(30, 6, date("d/m/Y",strtotime($reg[0]['fechaventa'])), 0, 1, 'R');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(1,163,232);
    $this->Cell(110, 6, "", 0, 1, 'C',True);

    $this->SetFont($TipoLetra,'B',14);
    $this->SetTextColor(220,50,50);  // Establece el color del texto (en este caso es ROJO)
    $this->SetFillColor(1,163,232);
    $this->Cell(190, 8, mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Giro ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6,mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Direccin ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6, strtoupper(mb_convert_encoding($reg[0]['direcsucursal'].", ".$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : $reg[0]['ciudad']), 'ISO-8859-1', 'UTF-8')), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Comuna ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6,strtoupper($comuna = ($reg[0]['id_comuna'] == '0' ? " " : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Telefono ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6,$tlf = ($reg[0]['tlfsucursal'] == '' ? " " : $reg[0]['tlfsucursal']), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Email ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6,$email = ($reg[0]['correosucursal'] == '' ? " " : mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8')), 0, 1, 'L');

    //Bloque de Receptor
    $this->SetDrawColor(1,163,232);
    $this->SetLineWidth(.1);
    $this->SetFillColor(229);
    $this->RoundedRect(10, 101, 190, 24, '0', '');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(190, 6, "INFORMACIN DEL RECEPTOR", 0, 1, 'C',True);

    $this->SetFont($TipoLetra,'',11);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Seor(es)", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(76, 6,$reg[0]['nomcliente'] == '' ? " " : mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Direccin", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(78, 6,$direccliente = ($reg[0]['direccliente'] == '' ? " " : mb_convert_encoding($reg[0]['direccliente'], 'ISO-8859-1', 'UTF-8')), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',11);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,$documento = ($reg[0]['documcliente'] == '0' ? "DOC:" : "".mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8')), 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(76, 6,$reg[0]['dnicliente'] == '' ? " " : $reg[0]['dnicliente'], 0, 0, 'L');
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Comuna", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(78, 6,strtoupper($comuna2 = (empty($reg[0]['id_comuna2']) ? " " : mb_convert_encoding($reg[0]['comuna2'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',11);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Giro", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(76, 6,$reg[0]['girocliente'] == '' ? " " : mb_convert_encoding($reg[0]['girocliente'], 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Ciudad", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(78, 6,strtoupper($ciudad2 = (empty($reg[0]['id_ciudad2']) ? " " : mb_convert_encoding($reg[0]['ciudad2'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'L');
    $this->Cell(34, 2, "", 0, 1, 'L');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(190, 6, "DETALLE DEL DOCUMENTO", 0, 1, 'C',True);

    $this->SetFont($TipoLetra,'',12);
    $this->SetDrawColor(230,230,250);
    $this->SetLineWidth(.1);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232);
    $this->Cell(20, 6,"Cdigo", 1, 0, 'L');
    $this->Cell(105, 6,"Nombre", 1, 0, 'L');
    $this->Cell(20, 6,"Cantidad", 1, 0, 'L');
    $this->Cell(25, 6,"Precio Neto", 1, 0, 'L');
    $this->Cell(20, 6,"Total", 1, 1, 'L');

    $tra = new Login();
    $detalle = $tra->VerDetallesVentas();
    $cantidad = 0;
    $SubTotal = 0;
    $montoExento = 0;
    $valorIva    = $reg[0]["iva"] / 100;
    $Articulos = 0;
    $a=1;

    $this->SetWidths(array(20,105,20,25,20));

    for($i=0;$i<sizeof($detalle);$i++){
    $SubTotal += $detalle[$i]['valortotal'];
    $Articulos += $detalle[$i]['cantventa'];

    $this->SetX(10);
    $this->SetFont($TipoLetra,'',10);  
    $this->SetDrawColor(230,230,250);
    $this->SetLineWidth(.1);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->RowFacture3(array(
        $detalle[$i]["codproducto"],
        mb_convert_encoding($detalle[$i]["producto"]." ".$detalle[$i]["condicion"].$descripcion = ($detalle[$i]["producto"] != "" ? "\n".$detalle[$i]["descripcion"] : "").$imei = ($detalle[$i]["imei"] != "" ? "\nIMEI: ".$detalle[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]['cantventa'],
        $simbolo.number_format($detalle[$i]['precioventa'], 0, '.', '.'),
        $simbolo.number_format($detalle[$i]['valorneto'], 0, '.', '.')));
    }

    $this->Ln(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetDrawColor(1,163,232);
    //$this->SetDrawColor(230,230,250);// Establece el color de tabla (en este caso es GRIS CLARO)
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es VERDE)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    if ($timbrePath) {
        $this->Cell(105, 35, $this->Image($timbrePath, $this->GetX(), $this->GetY(), 100, 32), 0, 0);
    } else {
        $this->Cell(105, 35,"", 0, 0);
    }
    $this->Cell(85, 6, "RESUMEN DEL DOCUMENTO", 1, 1, 'C',True);

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetLineWidth(.1);
    $this->SetFillColor(1,163,232);
    $this->Cell(105, 8,"", 0, 0, 'L');
    $this->Cell(35, 8,"Monto Neto", 1, 0, 'L');
    $this->Cell(10, 8,$simbolo, 1, 0, 'L');
    $this->Cell(40, 8,number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'), 1, 1, 'R');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetLineWidth(.1);
    $this->SetFillColor(1,163,232);
    $this->Cell(105, 8,"", 0, 0, 'L');
    $this->Cell(35, 8,$NomImpuesto." (".number_format($reg[0]["iva"], 0, '.', '.')."%)", 1, 0, 'L');
    $this->Cell(10, 8,$simbolo, 1, 0, 'L');
    $this->Cell(40, 8,number_format($reg[0]["totaliva"], 0, '.', '.'), 1, 1, 'R');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetLineWidth(.1);
    $this->SetFillColor(1,163,232);
    $this->Cell(105, 8,"", 0, 0, 'L');
    $this->Cell(35, 8,"Total", 1, 0, 'L');
    $this->Cell(10, 8,$simbolo, 1, 0, 'L');
    $this->Cell(40, 8,number_format($reg[0]['totalpago'], 0, '.', '.'), 1, 0, 'R');

    if ($timbrePath) {

    $this->Ln(10);
    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(105, 5, "Timbre Electronico S.I.I", 0, 1, 'C');
    $this->Cell(105, 5, "Verifique el Documento en: www.sii.cl", 0, 0, 'C');

    } 

    if($reg[0]['tipopago'] == "CREDITO"){

    $this->AddPage();

    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra        = new Login();
    $reg        = $tra->VentasPorId();
    $timbrePath = Lioren::getTimbre($reg[0]);
    $simbolo    = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']); 
    $TipoLetra  = "Arial";

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
        $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo , 20, 14, 48, 28, "PNG");
        $this->Ln(5);
    }

    //Bloque de Factura Eletronica
    $this->SetDrawColor(220,50,50);
    $this->SetLineWidth(.8);
    $this->SetFillColor(229);
    $this->RoundedRect(120, 12, 80, 26, '0', '');

    $this->SetFont($TipoLetra,'B',13);
    $this->SetFillColor(1,163,232);
    $this->SetLineWidth(.3);
    $this->Cell(110, 8, "", 0, 0, 'C');
    $this->Cell(80, 8, $reg[0]['documsucursal'] == '0' ? "" : mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8').": ".$reg[0]['cuitsucursal'], 0, 1, 'C');

    $this->Cell(110, 8, "", 0, 0, 'C');
    $this->Cell(80, 8, "FACTURA ELECTRONICA", 0, 1, 'C');

    $this->Cell(110, 8, "", 0, 0, 'C');
    $this->Cell(80, 8, "N ".$reg[0]['codfactura'], 0, 1, 'C');

    $this->Cell(110, 9, "", 0, 0, 'C');
    $this->SetTextColor(220,50,50);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(80, 12, "S.I.I - ".strtoupper($comuna = ($reg[0]['comuna'] == '' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'C');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(1,163,2326);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(110, 6, "", 0, 0, 'C');
    $this->Cell(50, 6, "Fecha de Emisin", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->Cell(30, 6, date("d/m/Y",strtotime($reg[0]['fechaventa'])), 0, 1, 'R');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(1,163,232);
    $this->Cell(110, 6, "", 0, 1, 'C',True);

    $this->SetFont($TipoLetra,'B',14);
    $this->SetTextColor(220,50,50);  // Establece el color del texto (en este caso es ROJO)
    $this->SetFillColor(1,163,232);
    $this->Cell(190, 8, mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Giro ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6,mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Direccin ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6, strtoupper(mb_convert_encoding($reg[0]['direcsucursal'].", ".$ciudad = ($reg[0]['ciudad'] == '' ? " " : $reg[0]['ciudad']), 'ISO-8859-1', 'UTF-8')), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Comuna ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6,strtoupper($comuna = ($reg[0]['comuna'] == '' ? " " : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Telefono ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6,$tlf = ($reg[0]['tlfsucursal'] == '' ? " " : $reg[0]['tlfsucursal']), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(34, 6, "Email ", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->Cell(156, 6,$email = ($reg[0]['correosucursal'] == '' ? " " : mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8')), 0, 1, 'L');

    //Bloque de Receptor
    $this->SetDrawColor(1,163,232);
    $this->SetLineWidth(.1);
    $this->SetFillColor(229);
    $this->RoundedRect(10, 101, 190, 24, '0', '');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(190, 6, "INFORMACIN DEL RECEPTOR", 0, 1, 'C',True);

    $this->SetFont($TipoLetra,'',11);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Seor(es)", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(76, 6,mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Direccin", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(78, 6,mb_convert_encoding($direccliente = ($reg[0]['direccliente'] == '' ? " " : $reg[0]['direccliente']), 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',11);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,$documento = ($reg[0]['documcliente'] == '0' ? "DOC:" : "".mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8')), 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(76, 6,$reg[0]['dnicliente'], 0, 0, 'L');
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Comuna", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(78, 6,strtoupper($comuna2 = ($reg[0]['comuna2'] == '' ? " " : mb_convert_encoding($reg[0]['comuna2'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'L');

    $this->SetFont($TipoLetra,'',11);
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Giro", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(76, 6,$girocliente = ($reg[0]['girocliente'] == '' ? " " : mb_convert_encoding($reg[0]['girocliente'], 'ISO-8859-1', 'UTF-8')), 0, 0, 'L');
    $this->SetTextColor(1,163,232);  // Establece el color del texto (en este caso es VERDE)
    $this->Cell(18, 6,"Ciudad", 0, 0, 'L');
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es NEGRO)
    $this->CellFitSpace(78, 6,strtoupper($ciudad2 = ($reg[0]['ciudad2'] == '' ? " " : mb_convert_encoding($reg[0]['ciudad2'], 'ISO-8859-1', 'UTF-8'))), 0, 1, 'L');
    $this->Cell(34, 2, "", 0, 1, 'L');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(190, 6, "DETALLE DEL DOCUMENTO", 0, 1, 'C',True);

    $this->SetFont($TipoLetra,'',12);
    $this->SetDrawColor(230,230,250);
    $this->SetLineWidth(.1);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232);
    $this->Cell(20, 6,"Cdigo", 1, 0, 'L');
    $this->Cell(85, 6,"Nombre", 1, 0, 'L');
    $this->Cell(25, 6,"Cantidad", 1, 0, 'L');
    $this->Cell(30, 6,"Precio Neto", 1, 0, 'L');
    $this->Cell(30, 6,"Total", 1, 1, 'L');

    $tra = new Login();
    $detalle = $tra->VerDetallesVentas();
    $cantidad = 0;
    $SubTotal = 0;
    $montoExento = 0;
    $valorIva    = $reg[0]["iva"] / 100;
    $Articulos = 0;
    $a=1;

    $this->SetWidths(array(20,85,25,30,30));

    for($i=0;$i<sizeof($detalle);$i++){
    $SubTotal += $detalle[$i]['valortotal'];
    $Articulos += $detalle[$i]['cantventa'];

    $this->SetX(10);
    $this->SetFont($TipoLetra,'',10);  
    $this->SetDrawColor(230,230,250);
    $this->SetLineWidth(.1);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->SetFillColor(255, 255, 255); // establece el color del fondo de la celda (en este caso es GRIS)
    $this->RowFacture3(array(
        $detalle[$i]["codproducto"],
        mb_convert_encoding($detalle[$i]["producto"], 'ISO-8859-1', 'UTF-8'),
        $detalle[$i]['cantventa'],
        $simbolo.number_format($detalle[$i]['precioventa'], 0, '.', '.'),
        $simbolo.number_format($detalle[$i]['valorneto'], 0, '.', '.')));
    }

    $this->Ln(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetDrawColor(1,163,232);
    //$this->SetDrawColor(230,230,250);// Establece el color de tabla (en este caso es GRIS CLARO)
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es VERDE)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    if ($timbrePath) {
        $this->Cell(105, 35, $this->Image($timbrePath, $this->GetX(), $this->GetY(), 100, 32), 0, 0);
    } else {
        $this->Cell(105, 35,"", 0, 0);
    }
    $this->Cell(85, 6, "RESUMEN DEL DOCUMENTO", 1, 1, 'C',True);

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetLineWidth(.1);
    $this->SetFillColor(1,163,232);
    $this->Cell(105, 8,"", 0, 0, 'L');
    $this->Cell(35, 8,"Monto Neto", 1, 0, 'L');
    $this->Cell(10, 8,$simbolo, 1, 0, 'L');
    $this->Cell(40, 8,number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'), 1, 1, 'R');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetLineWidth(.1);
    $this->SetFillColor(1,163,232);
    $this->Cell(105, 8,"", 0, 0, 'L');
    $this->Cell(35, 8,$NomImpuesto." (".number_format($reg[0]["iva"], 0, '.', '.')."%)", 1, 0, 'L');
    $this->Cell(10, 8,$simbolo, 1, 0, 'L');
    $this->Cell(40, 8,number_format($reg[0]["totaliva"], 0, '.', '.'), 1, 1, 'R');

    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetLineWidth(.1);
    $this->SetFillColor(1,163,232);
    $this->Cell(105, 8,"", 0, 0, 'L');
    $this->Cell(35, 8,"Total", 1, 0, 'L');
    $this->Cell(10, 8,$simbolo, 1, 0, 'L');
    $this->Cell(40, 8,number_format($reg[0]['totalpago'], 0, '.', '.'), 1, 0, 'R');

    $this->Ln(10);
    $this->SetFont($TipoLetra,'',12);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(105, 5, "Timbre Electronico S.I.I", 0, 1, 'C');
    $this->Cell(105, 5, "Verifique el Documento en: www.sii.cl", 0, 0, 'C');

    $this->Ln(6);
    $this->SetFont($TipoLetra,'',10);
    $this->SetDrawColor(230,230,250);// Establece el color de tabla (en este caso es GRIS CLARO)
    //$this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es VERDE)
    $this->SetLineWidth(.1);
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(1,163,232);
    $this->Cell(20, 8,"Nombre", 1, 0, 'L');
    $this->Cell(44, 8,"____________________", 1, 0, 'L');
    $this->Cell(20, 8,"RUT", 1, 0, 'L');
    $this->Cell(43, 8,"____________________", 1, 0, 'L');
    $this->Cell(20, 8,"Firma", 1, 0, 'L');
    $this->Cell(43, 8,"____________________", 1, 1, 'L');

    $this->Cell(20, 8,"Fecha", 1, 0, 'L');
    $this->Cell(44, 8,"____________________", 1, 0, 'L');
    $this->Cell(20, 8,"Recinto", 1, 0, 'L');
    $this->Cell(43, 8,"____________________", 1, 0, 'L');
    $this->Cell(20, 8,"", 1, 0, 'L');
    $this->Cell(43, 8,"", 1, 1, 'L');

    $this->SetFont($TipoLetra,'',10);
    $this->MultiCell(190,5,$this->SetFont($TipoLetra,'',12)."El acuse de recibo que se declara en este acto, de acuerdo a lo dispuesto en la letra b) del Art. 4, y la letra c) del Art. 5 de la Ley 19.983, acredita que la entrega de mercaderas o servicio(s) prestado(s) ha(n) sido recibido(s).",1,'J');

    $this->SetFont($TipoLetra,'B',12);
    $this->SetTextColor(220,50,50);  // Establece el color del texto (en este caso es ROJO)
    $this->SetFillColor(1,163,232); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(190, 6, "CEDIBLE", 0, 1, 'R');/**/

    }//Fin muestre factura cedible
    
    $this->SetDrawColor(255,255,255);// Establece el color de tabla (en este caso es GRIS CLARO)
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
}
########################## FUNCION FACTURA VENTA (A4) ##############################

########################## FUNCION LISTAR VENTAS ##############################
function TablaListarVentas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->ListarVentas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE VENTAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(38,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(22,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,38,65,30,22,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR VENTAS ##############################

########################## FUNCION LISTAR VENTAS POR BUSQUEDA ##############################
function TablaListarVentasxBusqueda()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BusquedaVentas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if($_GET['tipobusqueda'] == 1){
    $this->Cell(335,10,'LISTADO GENERAL DE VENTAS A CLIENTES',0,0,'C');
    } elseif($_GET['tipobusqueda'] == 2){
    $this->Cell(335,10,'LISTADO DE VENTAS POR BSQUEDA',0,0,'C');
    } elseif($_GET['tipobusqueda'] == 3){
    $this->Cell(335,10,'LISTADO DE VENTAS POR FECHAS',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    if($_GET['tipobusqueda'] == 2){
    $this->Ln();
    $this->Cell(335,6,"BSQUEDA: ".mb_convert_encoding($_GET["search_criterio"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    } elseif($_GET['tipobusqueda'] == 3){
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(38,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(22,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,38,65,30,22,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR VENTAS POR BUSQUEDA ##############################

########################## FUNCION LISTAR VENTAS DEL DIA ##############################
function TablaListarVentasDiarias()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarVentasDiarias();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO GENERAL DE VENTAS DEL DIA',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,5,"FECHA ACTUAL: ".date("d/m/Y"),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(38,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(22,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,38,65,30,22,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR VENTAS DEL DIA ##############################

########################## FUNCION LISTAR VENTAS POR CAJAS ##############################
function TablaListarVentasxCajas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarVentasxCajas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['tipopago']) == 1){ 
    $this->Cell(335,7,'LISTADO DE VENTAS GENERALES POR CAJAS',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 2){ 
    $this->Cell(335,7,'LISTADO DE VENTAS A CONTADO POR CAJAS',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 3){ 
    $this->Cell(335,7,'LISTADO DE VENTAS A CRDITO POR CAJAS',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(235,6,"N DE CAJA: ".mb_convert_encoding($reg[0]["nrocaja"].": ".$reg[0]["nomcaja"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Cell(100,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'R');
    $this->Ln();
    $this->Cell(235,6,"RESPONSABLE: ".mb_convert_encoding($reg[0]["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Cell(100,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'R');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(38,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(22,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,38,65,30,22,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }

    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR VENTAS POR CAJAS ##############################

########################## FUNCION LISTAR VENTAS POR FECHAS ##############################
function TablaListarVentasxFechas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarVentasxFechas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['tipopago']) == 1){ 
    $this->Cell(335,7,'LISTADO DE VENTAS GENERALES POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 2){ 
    $this->Cell(335,7,'LISTADO DE VENTAS A CONTADO POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 3){ 
    $this->Cell(335,7,'LISTADO DE VENTAS A CRDITO POR FECHAS',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(38,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(65,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(22,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(35,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,38,65,30,22,25,30,35,35,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(170,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR VENTAS POR FECHAS ##############################

########################## FUNCION LISTAR VENTAS POR CLIENTES ##############################
function TablaListarVentasxClientes()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarVentasxClientes();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['tipopago']) == 1){ 
    $this->Cell(335,7,'LISTADO DE VENTAS GENERALES POR CLIENTES',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 2){ 
    $this->Cell(335,7,'LISTADO DE VENTAS A CONTADO POR CLIENTES',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 3){ 
    $this->Cell(335,7,'LISTADO DE VENTAS A CRDITO POR CLIENTES',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(330,6,"N DE ".$documento = ($reg[0]['documcliente'] == '0' ? "DOCUMENTO" : mb_convert_encoding($reg[0]['documento3'] ?? "******", 'ISO-8859-1', 'UTF-8')).": ".$reg[0]["dnicliente"],0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"NOMBRE DE CLIENTE: ".mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"N DE TELEFONO: ".$tlfcliente = ($reg[0]['tlfcliente'] == "" ? "********" : $reg[0]['tlfcliente']),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"DIRECCIN DOMICILIARIA: ".mb_convert_encoding($reg[0]['direccliente'] == "" ? "********" : $reg[0]['direccliente'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"CORREO ELECTRONICO: ".mb_convert_encoding($reg[0]["emailcliente"] == "" ? "********" : $reg[0]["emailcliente"], 'ISO-8859-1', 'UTF-8'),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(75,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(45,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(40,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(40,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,75,45,25,25,30,40,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(160,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR VENTAS POR CLIENTES ##############################

########################## FUNCION LISTAR VENTAS POR CONDICIONES ##############################
function TablaListarVentasxCondiciones()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################
    $tra = new Login();
    $reg = $tra->BuscarVentasxCondiciones();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE VENTAS POR FORMA DE PAGO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(235,6,"CAJA N: ".mb_convert_encoding($reg[0]["nrocaja"].": ".$reg[0]["nomcaja"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Cell(100,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'R');
    $this->Ln();
    $this->Cell(235,6,"RESPONSABLE: ".mb_convert_encoding($reg[0]["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Cell(100,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'R');
    $this->Ln();
    $this->Cell(335,6,"FORMA DE PAGO: ".mb_convert_encoding($reg[0]["mediopago"], 'ISO-8859-1', 'UTF-8'),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(40,8,'IMPORTE TOTAL',1,0,'C', True);
    $this->Cell(30,8,'TOTAL PAGADO',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,60,30,25,30,35,30,40,30));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos  = 0;
    $TotalDescuento  = 0;
    $TotalSubtotal   = 0;
    $TotalIva        = 0;
    $TotalImporte    = 0;
    $ImportePagado   = 0;
    $TotalPagado     = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];
    $ImportePagado  =  $reg[$i]['suma_pagado'];
    $TotalPagado    += $reg[$i]['suma_pagado'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.'),
        $simbolo.number_format($ImportePagado, 0, '.', '.')));
    }
   
    $this->Cell(145,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalPagado, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR VENTAS POR CONDICIONES ##############################

########################## FUNCION LISTAR COMISION POR VENTAS ##############################
function TablaListarComisionxVentas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra = new Login();
    $reg = $tra->BuscarComisionxVentas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['tipopago']) == 1){ 
    $this->Cell(335,10,'LISTADO DE COMISIN DE VENTAS GENERALES POR VENDEDOR',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 2){ 
    $this->Cell(335,10,'LISTADO DE COMISIN DE VENTAS A CONTADO POR VENDEDOR',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 3){ 
    $this->Cell(335,10,'LISTADO DE COMISIN DE VENTAS A CRDITO POR VENDEDOR',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(235,6,"N DE DOCUMENTO: ".$reg[0]["dni"],0,0,'L'); 
    $this->Cell(100,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'R');
    $this->Ln();
    $this->Cell(235,6,"NOMBRE DE VENDEDOR: ".mb_convert_encoding($reg[0]["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Cell(100,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'R');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(55,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(100,8,'DETALLES DE PRODUCTOS',1,0,'C', True);
    $this->Cell(35,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(35,8,'TOTAL COMISIN',1,1,'C', True);
    
    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,55,30,25,100,35,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a               = 1;
    $TotalArticulos  = 0;
    $TotalImporte    = 0;
    $TotalComision   = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo            = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $detalles_productos = str_replace("<br>","\n", $reg[$i]['detalles_productos']);

    $TotalArticulos += $reg[$i]['articulos']; 
    $TotalImporte   += $reg[$i]['totalpago'];
    $TotalComision  += $reg[$i]['totalpago']*$reg[$i]['comision']/100;

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($detalles_productos, 'ISO-8859-1', 'UTF-8'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']*$reg[$i]['comision']/100, 0, '.', '.')));
    }

    $this->Cell(265,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalComision, 0, '.', '.'),0,0,'L');
    $this->Ln();
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR COMISION POR VENTAS ##############################

########################## FUNCION LISTAR DETALLES VENTAS POR FECHAS ##############################
function TablaListarDetallesVentasxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesVentasxFechas(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['tipopago']) == 1){ 
    $this->Cell(335,10,'LISTADO DETALLES DE VENTAS GENERALES POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 2){ 
    $this->Cell(335,10,'LISTADO DETALLES DE VENTAS A CONTADO POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 3){ 
    $this->Cell(335,10,'LISTADO DETALLES DE VENTAS A CRDITO POR FECHAS',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(80,8,'DESCRIPCIN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'VENDIDO',1,0,'C', True);
    $this->Cell(30,8,'MONTO TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,25,80,30,30,20,30,30,25,30));

    $a              = 1;
    $PrecioTotal    = 0;
    $ExisteTotal    = 0;
    $VendidosTotal  = 0;
    $PagoTotal      = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal    += $reg[$i]['precioventa'];
    if($reg[$i]['tipodetalle'] == 1){
    $tipodetalle     = "PRODUCTO";
    $Existencia      = $reg[$i]['existencia'];
    $ExisteTotal    += $reg[$i]['existencia'];
    } elseif($reg[$i]['tipodetalle'] == 2){
    $tipodetalle     = "COMBO";
    $Existencia      = $reg[$i]['cantcombo'];
    $ExisteTotal    += $reg[$i]['cantcombo'];
    } elseif($reg[$i]['tipodetalle']==3){
    $tipodetalle     = "SERVICIO";
    $Existencia      = '0';
    $ExisteTotal    += '0';
    }
    $VendidosTotal  += $reg[$i]['cantidad']; 

    $Descuento       = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal     = $reg[$i]['precioventa']-$PrecioDescuento;
    $PagoTotal      += $PrecioFinal*$reg[$i]['cantidad'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipodetalle,
        mb_convert_encoding($reg[$i]["codproducto"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : "").$imei = ($reg[$i]["imei"] != "" ? "\nIMEI: ".$reg[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "*****" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]["precioventa"], 0, '.', '.'),
        $Existencia,
        $reg[$i]['cantidad'],
        $simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 0, '.', '.')));
    }

    $this->Cell(220,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PrecioTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$ExisteTotal,0,0,'L');
    $this->CellFitSpace(25,5,$VendidosTotal,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PagoTotal, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DETALLES VENTAS POR FECHAS ##############################

########################## FUNCION LISTAR DETALLES VENTAS POR VENDEDOR ##############################
function TablaListarDetallesVentasxVendedor()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesVentasxVendedor(); 
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['tipopago']) == 1){ 
    $this->Cell(335,10,'LISTADO DETALLES DE VENTAS GENERALES POR VENDEDOR',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 2){ 
    $this->Cell(335,10,'LISTADO DETALLES DE VENTAS A CONTADO POR VENDEDOR',0,0,'C');
    } elseif(decrypt($_GET['tipopago']) == 3){ 
    $this->Cell(335,10,'LISTADO DETALLES DE VENTAS A CRDITO POR VENDEDOR',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"VENDEDOR: ".mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(20,8,'TIPO',1,0,'C', True);
    $this->Cell(25,8,'CDIGO',1,0,'C', True);
    $this->Cell(80,8,'DESCRIPCIN DE PRODUCTO',1,0,'C', True);
    $this->Cell(30,8,'MARCA',1,0,'C', True);
    $this->Cell(30,8,'MODELO',1,0,'C', True);
    $this->Cell(20,8,'DESC %',1,0,'C', True);
    $this->Cell(30,8,"PRECIO VENTA",1,0,'C', True);
    $this->Cell(30,8,'EXISTENCIA',1,0,'C', True);
    $this->Cell(25,8,'VENDIDO',1,0,'C', True);
    $this->Cell(30,8,'MONTO TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,20,25,80,30,30,20,30,30,25,30));

    $a              = 1;
    $PrecioTotal    = 0;
    $ExisteTotal    = 0;
    $VendidosTotal  = 0;
    $PagoTotal      = 0;

    for($i=0;$i<sizeof($reg);$i++){
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);

    $PrecioTotal    += $reg[$i]['precioventa'];
    if($reg[$i]['tipodetalle'] == 1){
    $tipodetalle     = "PRODUCTO";
    $Existencia      = $reg[$i]['existencia'];
    $ExisteTotal    += $reg[$i]['existencia'];
    } elseif($reg[$i]['tipodetalle'] == 2){
    $tipodetalle     = "COMBO";
    $Existencia      = $reg[$i]['cantcombo'];
    $ExisteTotal    += $reg[$i]['cantcombo'];
    } elseif($reg[$i]['tipodetalle']==3){
    $tipodetalle     = "SERVICIO";
    $Existencia      = '0';
    $ExisteTotal    += '0';
    }
    $VendidosTotal  += $reg[$i]['cantidad']; 

    $Descuento       = $reg[$i]['descproducto']/100;
    $PrecioDescuento = $reg[$i]['precioventa']*$Descuento;
    $PrecioFinal     = $reg[$i]['precioventa']-$PrecioDescuento;
    $PagoTotal      += $PrecioFinal*$reg[$i]['cantidad'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipodetalle,
        mb_convert_encoding($reg[$i]["codproducto"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]["producto"]." ".$reg[$i]["condicion"].$descripcion = ($reg[$i]["descripcion"] != "" ? "\n".$reg[$i]["descripcion"] : "").$imei = ($reg[$i]["imei"] != "" ? "\nIMEI: ".$reg[$i]["imei"] : ""), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmarca'] == '0' ? "*****" : $reg[$i]["nommarca"], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['codmodelo'] == '0' ? "*****" : $reg[$i]['nommodelo'], 'ISO-8859-1', 'UTF-8'),
        number_format($reg[$i]['descproducto'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]["precioventa"], 0, '.', '.'),
        $Existencia,
        $reg[$i]['cantidad'],
        $simbolo.number_format($PrecioFinal*$reg[$i]['cantidad'], 0, '.', '.')));
    }

    $this->Cell(220,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PrecioTotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,$ExisteTotal,0,0,'L');
    $this->CellFitSpace(25,5,$VendidosTotal,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($PagoTotal, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DETALLES VENTAS POR VENDEDOR ##############################

################################### REPORTES DE VENTAS ##################################






















############################## REPORTES DE CREDITOS ##################################

########################## FUNCION TICKET CREDITO ##############################
function TicketCredito()
{  
    $tra       = new Login();
    $reg       = $tra->CreditosPorId();
    $simbolo   = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra = "Courier";

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
        $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo , 20, 3, 35, 15, "PNG");
        $this->Ln(8);
    }
  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5, "TICKET DE CRDITO VENTA", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,3,$reg[0]['documsucursal'] == '0' ? "" : "N ".mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$reg[0]['cuitsucursal'],0,1,'C');

    if($reg[0]['id_comuna']!='0'){

    $this->SetX(2);
    $this->CellFitSpace(70,3,$comuna = ($reg[0]['id_comuna'] == '0' ? " " : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8'))." ".$ciudad = ($reg[0]['id_ciudad'] == '0' ? " " : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8')),0,1,'C');

    }

    $this->SetX(2);
    $this->CellFitSpace(70,3,mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,1,'C');

    $this->SetX(2);
    $this->CellFitSpace(70,3,mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'),0,1,'C');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);
    
    if($reg[0]['codcliente'] == '0'){

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(70,4,"A CONSUMIDOR FINAL", 0, 1, 'J');   

    } else {

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,3,$documento = ($reg[0]['documcliente'] == '0' ? "N DOC" : "N ".mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8')).": ".$reg[0]['dnicliente'],0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['direccliente'].$comuna = ($reg[0]['id_comuna'] == '0' ? "" : " ".$reg[0]['comuna'])."".$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : " ".$reg[0]['ciudad']), 'ISO-8859-1', 'UTF-8'),0,'L');

    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(2);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(35,4,"Nro Ticket:  ", 0, 0, 'J');
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(35,4,$reg[0]['codfactura'], 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(35,4,"FECHA: ".date("d/m/Y",strtotime($reg[0]['fechaventa'])), 0, 0, 'J');
    $this->CellFitSpace(35,4,"HORA: ".date("H:i:s",strtotime($reg[0]['fechaventa'])), 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(33,4,"VENCE: ".date("d/m/Y",strtotime($reg[0]['fechavencecredito'])), 0, 0, 'J');
    if($reg[0]['fechavencecredito'] == '0000-00-00' || $reg[0]['fechavencecredito'] >= date("Y-m-d")) {
    $this->CellFitSpace(37,4,"DIAS VENC: "."0", 0, 0, 'R');  
    } elseif($reg[0]['fechavencecredito'] < date("Y-m-d")) {
    $this->CellFitSpace(37,4,"DIAS VENC: ".Dias_Transcurridos(date("Y-m-d"),$reg[0]['fechavencecredito']), 0, 0, 'R'); 
    }
    $this->Ln();

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5,"DETALLES DE ABONOS", 0, 0, 'L');
    $this->Ln(5);

    $tra = new Login();
    $detalle = $tra->VerDetallesAbonosVentas();
    if($detalle==""){
        echo "";      
    } else {
    $cantidad = 0;
    $SubTotal = 0;
    $a=1;
    for($i=0;$i<sizeof($detalle);$i++):

    $this->SetX(2);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(70,3,mb_convert_encoding($detalle[$i]['nrocaja'].": ".$detalle[$i]['nomcaja'], 'ISO-8859-1', 'UTF-8'),0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->CellFitSpace(35,3,mb_convert_encoding($detalle[$i]['mediopago'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(35,3,$simbolo.number_format($detalle[$i]['montoabono'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(35,3,date("d/m/Y H:i:s",strtotime($detalle[$i]['fechaabono'])),0,1,'L');
    $this->Ln(1);

    endfor; 
    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(20,4,"TOTAL",0,0,'L');
    $this->Cell(50,4,$simbolo.number_format($reg[0]['totalpago'], 0, '.', '.'),0,1,'R');  

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(30,4,"ABONADO",0,0,'L');
    $this->Cell(40,4,$simbolo.number_format($reg[0]['creditopagado'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(30,4,"PENDIENTE",0,0,'L');
    $this->Cell(40,4,$simbolo.number_format($reg[0]['totalpago']-$reg[0]['creditopagado'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'),0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(10,4,"TEL:",0,0,'L');
    $this->CellFitSpace(60,4,$reg[0]['tlfsucursal'],0,1,'L');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->MultiCell(70,3,$this->SetFont('Courier','BI',10).mb_convert_encoding($reg[0]['membrete'], 'ISO-8859-1', 'UTF-8'),0,'C');
    $this->Ln(3);
}
########################## FUNCION TICKET CREDITO ##############################

########################## FUNCION LISTAR CREDITOS ##############################
function TablaListarCreditos()
{
    $tra = new Login();
    $reg = $tra->ListarCreditos();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(40,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(35,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(40,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,60,40,25,35,40,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalImporte += $reg[$i]['totalpago'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }
    
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['observaciones'] == '' ? "***********" : $reg[$i]['observaciones'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 0, '.', '.')));
    }
   
    $this->Cell(215,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CREDITOS ##############################

########################## FUNCION LISTAR CREDITOS POR BUSQUEDA ##############################
function TablaListarCreditosxBusqueda()
{
    $tra = new Login();
    $reg = $tra->BusquedaCreditos();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if($_GET['tipobusqueda'] == 1){
    $this->Cell(335,10,'LISTADO GENERAL DE VENTAS A CRDITOS',0,0,'C');
    } elseif($_GET['tipobusqueda'] == 2){
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS POR BSQUEDA',0,0,'C');
    } elseif($_GET['tipobusqueda'] == 3){
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS POR FECHAS',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    if($_GET['tipobusqueda'] == 2){
    $this->Ln();
    $this->Cell(335,6,"BSQUEDA: ".mb_convert_encoding($_GET["search_criterio"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    } elseif($_GET['tipobusqueda'] == 3){
    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(40,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(35,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(40,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,60,40,25,35,40,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalImporte += $reg[$i]['totalpago'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }
    
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['observaciones'] == '' ? "***********" : $reg[$i]['observaciones'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 0, '.', '.')));
    }
   
    $this->Cell(215,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CREDITOS POR BUSQUEDA ##############################

########################## FUNCION LISTAR CREDITOS VENCIDOS ##############################
function TablaListarCreditosVencidos()
{
    $tra = new Login();
    $reg = $tra->ListarCreditosVencidos();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS VENCIDAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(35,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(40,8,'FECHA VENCIMIENTO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,60,25,35,40,40,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalImporte += $reg[$i]['totalpago'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }
    
    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        date("d/m/Y",strtotime($reg[$i]['fechavencecredito'])),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 0, '.', '.')));
   
    $this->Cell(215,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();
        }
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CREDITOS VENCIDOS ##############################

######################## FUNCION LISTAR ABONOS CREDITOS POR CAJAS #########################
function TablaListarAbonosCreditosVentasxCajas()
{
    $tra = new Login();
    $reg = $tra->BuscarAbonosCreditosVentasxCajas();

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,"LISTADO DE ABONOS EN VENTAS A CRDITOS POR CAJAS",0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(235,6,"CAJA N: ".mb_convert_encoding($reg[0]["nrocaja"].": ".$reg[0]["nomcaja"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Cell(100,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'R');
    $this->Ln();
    $this->Cell(235,6,"RESPONSABLE: ".mb_convert_encoding($reg[0]["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Cell(100,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'R');
    $this->Ln();
    $this->Cell(335,6,"FORMA DE ABONO: ".mb_convert_encoding($reg[0]["mediopago"], 'ISO-8859-1', 'UTF-8'),0,1,'L');
    
    $this->Ln();
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es NARANJA)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(50,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'N DE DOCUMENTO',1,0,'C', True);
    $this->Cell(100,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(55,8,'FECHA DE ABONO',1,0,'C', True);
    $this->Cell(55,8,'MONTO ABONO',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
    $this->SetWidths(array(15,50,60,100,55,55));

    $a=1;
    $TotalImporte = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    $TotalImporte += $reg[$i]['montoabono'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
            $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
            mb_convert_encoding($reg[$i]['documento3'], 'ISO-8859-1', 'UTF-8').": ".$reg[$i]['dnicliente'],
            mb_convert_encoding($reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
            date("d/m/Y H:i:s",strtotime($reg[$i]['fechaabono'])),
            $simbolo.number_format($reg[$i]['montoabono'], 0, '.', '.')));
        }
    }
   
    $this->Cell(280,5,'',0,0,'C');
    $this->SetFont('Courier','B',10);
    $this->SetTextColor(255, 255, 255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(55,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
######################## FUNCION LISTAR ABONOS CREDITOS POR CAJAS #########################

########################## FUNCION LISTAR CREDITOS POR CONDICIONES ##############################
function TablaListarCreditosVentasxCondiciones()
{
    $tra = new Login();
    $reg = $tra->BuscarCreditosVentasxCondiciones();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['tipobusqueda']) == 1){ 
    $this->Cell(335,10,'LISTADO  DE VENTAS A CRDITOS GENERALES',0,0,'C');
    } elseif(decrypt($_GET['tipobusqueda']) == 2){ 
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS PAGADAS',0,0,'C');
    } elseif(decrypt($_GET['tipobusqueda']) == 3){ 
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS PENDIENTES',0,0,'C');
    } elseif(decrypt($_GET['tipobusqueda']) == 4){ 
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS VENCIDAS',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(35,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(40,8,'FECHA VENCIMIENTO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,60,25,35,40,40,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalImporte += $reg[$i]['totalpago'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }
    

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        date("d/m/Y",strtotime($reg[$i]['fechavencecredito'])),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 0, '.', '.')));
    }
   
    $this->Cell(215,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CREDITOS POR CONDICIONES ##############################

########################## FUNCION LISTAR CREDITOS POR FECHAS ##############################
function TablaListarCreditosVentasxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarCreditosVentasxFechas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['status']) == 1){ 
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS GENERALES POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['status']) == 2){ 
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS PAGADAS POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['status']) == 3){ 
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS PENDIENTES POR FECHAS',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(40,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(35,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(40,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,60,40,25,35,40,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalImporte += $reg[$i]['totalpago'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }
    

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($reg[$i]['observaciones'] == '' ? "***********" : $reg[$i]['observaciones'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 0, '.', '.')));
    }

    $this->Cell(215,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CREDITOS POR FECHAS ##############################

########################## FUNCION LISTAR CREDITOS POR CLIENTES ##############################
function TablaListarCreditosVentasxClientes()
{
    $tra = new Login();
    $reg = $tra->BuscarCreditosVentasxClientes();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['status']) == 1){ 
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS GENERALES POR CLIENTES',0,0,'C');
    } elseif(decrypt($_GET['status']) == 2){ 
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS PAGADAS POR CLIENTES',0,0,'C');
    } elseif(decrypt($_GET['status']) == 3){ 
    $this->Cell(335,10,'LISTADO DE VENTAS A CRDITOS PENDIENTES POR CLIENTES',0,0,'C');
    }

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(330,6,"N DE ".$documento = ($reg[0]['documcliente'] == '0' ? "DOCUMENTO" : mb_convert_encoding($reg[0]['documento3'] ?? "******", 'ISO-8859-1', 'UTF-8')).": ".$reg[0]["dnicliente"],0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"NOMBRE DE CLIENTE: ".mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"N DE TELEFONO: ".$tlfcliente = ($reg[0]['tlfcliente'] == "" ? "********" : $reg[0]['tlfcliente']),0,0,'L');
    $this->Ln();
    $this->Cell(330,6,"DIRECCIN DOMICILIARIA: ".mb_convert_encoding($reg[0]['direccliente'] == "" ? "********" : $reg[0]['direccliente'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"CORREO ELECTRONICO: ".mb_convert_encoding($reg[0]["emailcliente"] == "" ? "********" : $reg[0]["emailcliente"], 'ISO-8859-1', 'UTF-8'),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(60,8,'OBSERVACIONES',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(35,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(40,8,'FECHA VENCIMIENTO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(40,8,'TOTAL ABONADO',1,0,'C', True);
    $this->Cell(40,8,'TOTAL PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,60,25,35,40,40,40,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalImporte += $reg[$i]['totalpago'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }
    

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['observaciones'] == '' ? "***********" : $reg[$i]['observaciones'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        date("d/m/Y",strtotime($reg[$i]['fechavencecredito'])),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 0, '.', '.')));
    }
   
    $this->Cell(215,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();
    
    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR CREDITOS POR CLIENTES ##############################

########################## FUNCION LISTAR DETALLES CREDITOS POR FECHAS #########################
function TablaListarDetallesCreditosVentasxFechas()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesCreditosVentasxFechas();

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['status']) == 1){ 
    $this->Cell(335,10,'DETALLES DE VENTAS A CRDITOS EN GENERAL POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['status']) == 2){ 
    $this->Cell(335,10,'DETALLES DE VENTAS A CRDITOS PAGADOS POR FECHAS',0,0,'C');
    } elseif(decrypt($_GET['status']) == 3){ 
    $this->Cell(335,10,'DETALLES DE VENTAS A CRDITOS PENDIENTES POR FECHAS',0,0,'C');
    }
    
    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');
 
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(40,8,'NOMBRE DE CLIENTE',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(90,8,'DETALLES DE PRODUCTOS',1,0,'C', True);
    $this->Cell(35,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(30,8,'ABONADO',1,0,'C', True);
    $this->Cell(30,8,'PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,40,25,30,90,35,30,30));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalImporte += $reg[$i]['totalpago'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }

    $detalles_productos = (string)($reg[$i]['detalles_productos'] ?? '');
    $detalles_abonos    = (string)($reg[$i]['detalles_abonos'] ?? '');

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        mb_convert_encoding(str_replace("<br>","\n", $detalles_productos), 'ISO-8859-1', 'UTF-8'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 0, '.', '.')));
        }
    }

    $this->Cell(240,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();
    

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DETALLES CREDITOS POR FECHAS #########################

########################## FUNCION LISTAR DETALLES CREDITOS POR CLIENTES #########################
function TablaListarDetallesCreditosVentasxClientes()
{
    $tra = new Login();
    $reg = $tra->BuscarDetallesCreditosVentasxClientes();

    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    if(decrypt($_GET['status']) == 1){ 
    $this->Cell(335,10,'DETALLES DE VENTAS A CRDITOS EN GENERAL POR CLIENTES',0,0,'C');
    } elseif(decrypt($_GET['status']) == 2){ 
    $this->Cell(335,10,'DETALLES DE VENTAS A CRDITOS PAGADOS POR CLIENTES',0,0,'C');
    } elseif(decrypt($_GET['status']) == 3){ 
    $this->Cell(335,10,'DETALLES DE VENTAS A CRDITOS PENDIENTES POR CLIENTES',0,0,'C');
    }
    
    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"N DE ".$documento = ($reg[0]['documcliente'] == '0' ? "DOCUMENTO" : mb_convert_encoding($reg[0]['documento3'] ?? "******", 'ISO-8859-1', 'UTF-8')).": ".$reg[0]["dnicliente"],0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"NOMBRE DE CLIENTE: ".mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"N DE TELEFONO: ".$tlfcliente = ($reg[0]['tlfcliente'] == "" ? "********" : $reg[0]['tlfcliente']),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DIRECCIN DOMICILIARIA: ".mb_convert_encoding($reg[0]['direccliente'] == "" ? "********" : $reg[0]['direccliente'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"CORREO ELECTRONICO: ".mb_convert_encoding($reg[0]["emailcliente"] == "" ? "********" : $reg[0]["emailcliente"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
 
    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(25,8,'ESTADO',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(70,8,'DETALLES DE PRODUCTOS',1,0,'C', True);
    $this->Cell(60,8,'DETALLES DE ABONOS',1,0,'C', True);
    $this->Cell(35,8,'TOTAL FACTURA',1,0,'C', True);
    $this->Cell(30,8,'ABONADO',1,0,'C', True);
    $this->Cell(30,8,'PENDIENTE',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,25,30,70,60,35,30,30));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalImporte = 0;
    $TotalAbono   = 0;
    $TotalDebe    = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']); 
    
    $TotalImporte += $reg[$i]['totalpago'];
    $TotalAbono   += $reg[$i]['creditopagado'];
    $TotalDebe    += $reg[$i]['totalpago']-$reg[$i]['creditopagado'];

    if($reg[$i]["statusventa"] == 'PAGADA'){ 
    $estado = $reg[$i]["statusventa"];
    } elseif($reg[$i]['fechavencecredito'] >= date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO';
    } elseif($reg[$i]['fechavencecredito'] < date("Y-m-d") && $reg[$i]['fechapagado'] == "0000-00-00" && $reg[$i]['statusventa'] == "PENDIENTE"){
    $estado = 'CREDITO VENCIDO';
    } else { 
    $estado = $reg[$i]["statusventa"];
    }

    $detalles_productos = (string)($reg[$i]['detalles_productos'] ?? '');
    $detalles_abonos     = (string)($reg[$i]['detalles_abonos'] ?? '');

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["codfactura"],
        mb_convert_encoding($estado, 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y H:i:s",strtotime($reg[$i]['fechaventa'])),
        mb_convert_encoding(str_replace("<br>","\n", $detalles_productos), 'ISO-8859-1', 'UTF-8'),
        mb_convert_encoding(str_replace("<br>","\n", $detalles_abonos), 'ISO-8859-1', 'UTF-8'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['creditopagado'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago']-$reg[$i]['creditopagado'], 0, '.', '.')));
        }
    }

    $this->Cell(240,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalAbono, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDebe, 0, '.', '.'),0,0,'L');
    $this->Ln();
    

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR DETALLES CREDITOS POR CLIENTES #########################

############################### REPORTES DE CREDITOS ###############################




















############################## REPORTES DE NOTAS DE CREDITOS ##################################

########################## FUNCION NOTA DE CREDITO (BOLETA) ##############################
function NotaCredito()
{  
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################

    $tra        = new Login();
    $reg        = $tra->NotaCreditoPorId();
    $timbrePath = Lioren::getTimbre($reg[0]);
    $simbolo    = ($reg[0]['simbolo'] == "" ? "" : $reg[0]['simbolo']);
    $TipoLetra  = "Courier";  

    if (file_exists("fotos/sucursales/".$reg[0]['cuitsucursal'].".png")) {
        $logo = "fotos/sucursales/".$reg[0]['cuitsucursal'].".png";
        $this->Image($logo , 20, 3, 35, 15, "PNG");
        $this->Ln(8);
    }
  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5, "NOTA DE CREDITO", 0, 0, 'C');
    $this->Ln(5);
  
    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['nomsucursal'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,3,$reg[0]['documsucursal'] == '0' ? "" : "N ".mb_convert_encoding($reg[0]['documento'], 'ISO-8859-1', 'UTF-8')." ".$reg[0]['cuitsucursal'],0,1,'C');

    if($reg[0]['id_ciudad']!='0'){

    $this->SetX(2);
    $this->CellFitSpace(70,3,$ciudad = ($reg[0]['ciudad'] == '' ? "" : mb_convert_encoding($reg[0]['ciudad'], 'ISO-8859-1', 'UTF-8'))." ".$comuna = ($reg[0]['comuna'] == '' ? "" : mb_convert_encoding($reg[0]['comuna'], 'ISO-8859-1', 'UTF-8')),0,1,'C');
    }

    $this->SetX(2);
    $this->CellFitSpace(70,3,mb_convert_encoding($reg[0]['direcsucursal'], 'ISO-8859-1', 'UTF-8'),0,1,'C');

    $this->SetX(2);
    $this->CellFitSpace(70,3,mb_convert_encoding($reg[0]['girosucursal'], 'ISO-8859-1', 'UTF-8'),0,1,'C');


    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);
    
    if($reg[0]['codcliente'] == '0'){

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(70,4,"A CONSUMIDOR FINAL", 0, 1, 'J');   

    } else {

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(70,3,$documento = ($reg[0]['documcliente'] == '0' ? "N DOC:" : "N ".mb_convert_encoding($reg[0]['documento3'], 'ISO-8859-1', 'UTF-8').": ".$reg[0]['dnicliente']),0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',9);
    $this->MultiCell(70,3,$this->SetFont($TipoLetra,'B',9).mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,'L');

    $this->SetX(2);
    $this->SetFont('Courier','B',9);
    $this->MultiCell(70,3,$this->SetFont('Courier','B',9).mb_convert_encoding($reg[0]['direccliente'].$comuna = ($reg[0]['id_comuna'] == '0' ? "" : " ".$reg[0]['comuna'])."".$ciudad = ($reg[0]['id_ciudad'] == '0' ? "" : " ".$reg[0]['ciudad']), 'ISO-8859-1', 'UTF-8'),0,'L');
    }

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(2);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(35,4,"Nro NOTA:  ", 0, 0, 'J');
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(35,4,$reg[0]['codfactura'], 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(35,4,"Nro ". $tipodocumento = ($reg[0]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[0]['tipodocumento']).": ", 0, 0, 'J');
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(35,4,mb_convert_encoding($reg[0]['facturaventa'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(18,4,"CAJERO:", 0, 0, 'J');
    $this->SetFont($TipoLetra,'B',9);
    $this->CellFitSpace(52,4,mb_convert_encoding($reg[0]['nombres'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(35,4,"FECHA: ".date("d/m/Y",strtotime($reg[0]['fechanota'])), 0, 0, 'J');
    $this->CellFitSpace(35,4,"HORA: ".date("H:i:s",strtotime($reg[0]['fechanota'])), 0, 0, 'R');
    $this->Ln();

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->SetFillColor(2,157,116);
    $this->Cell(70, 5,"DETALLES DE PRODUCTOS", 0, 0, 'L');
    $this->Ln(5);

    $tra         = new Login();
    $detalle     = $tra->VerDetallesNotasCredito();
    $cantidad    = 0;
    $SubTotal    = 0;
    $montoExento = 0;
    $valorIva    = $reg[0]["iva"] / 100;
    $Articulos   = 0;
    $a=1;
    for($i=0;$i<sizeof($detalle);$i++):
    $SubTotal  += $detalle[$i]['valortotal'];
    $Articulos += $detalle[$i]['cantventa'];

    $this->SetX(2);
    $this->SetFillColor(192);
    $this->SetDrawColor(3,3,3);
    $this->SetLineWidth(.2);
    $this->SetFont($TipoLetra,'',8);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    
    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(35,3,$detalle[$i]['cantventa']." X ".$simbolo.number_format($detalle[$i]["precioventa"], 0, '.', '.'),0,0,'J');

    $this->SetFont($TipoLetra,'B',8);
    $this->CellFitSpace(35,3,$simbolo.number_format($detalle[$i]["valorneto"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',8);
    $this->MultiCell(70,3,mb_convert_encoding($detalle[$i]["producto"]." ".$detalle[$i]["condicion"], 'ISO-8859-1', 'UTF-8'),0,1,'');

    if($detalle[$i]["descripcion"] != ""){
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',6);
    $this->MultiCell(70,3,mb_convert_encoding($detalle[$i]["descripcion"], 'ISO-8859-1', 'UTF-8'),0,1,'');
    }

    if($detalle[$i]["imei"] != ""){
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',6);
    $this->MultiCell(70,3,"N DE IMEI: ".mb_convert_encoding($detalle[$i]["imei"], 'ISO-8859-1', 'UTF-8'),0,1,'');
    }

    endfor;

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,3,'---------------------------',0,0,'C');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(22,4,"SUBTOTAL",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]["subtotalivasi"]+$reg[0]["subtotalivano"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(22,4,$NomImpuesto." (".number_format($reg[0]["iva"], 0, '.', '.')."%):",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]["totaliva"], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(22,4,"DESC (".number_format($reg[0]["descuento"], 0, '.', '.')."%)",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]['totaldescuento'], 0, '.', '.'),0,1,'R');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',10);
    $this->CellFitSpace(22,4,"TOTAL",0,0,'L');
    $this->Cell(48,4,$simbolo.number_format($reg[0]['totalpago'], 0, '.', '.'),0,1,'R');

    if($reg[0]['observaciones']!=""){
    ########################### OBSERVACIONES #############################
    $this->Ln(2);  
    $this->SetX(2);
    $this->SetFont('courier','B',8);
    $this->MultiCell(70,4,mb_convert_encoding($reg[0]['observaciones'], 'ISO-8859-1', 'UTF-8'),0,1,'');
    $this->Ln(2);
    ########################### OBSERVACIONES #############################    
    }

    $this->Ln(2);
    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(30,4,"CANTIDAD TOTAL:",0,0,'L');
    $this->CellFitSpace(40,4,$Articulos,0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(70,4,mb_convert_encoding($reg[0]['correosucursal'], 'ISO-8859-1', 'UTF-8'),0,1,'L');

    $this->SetX(2);
    $this->SetFont($TipoLetra,'',9);
    $this->CellFitSpace(10,4,"TEL:",0,0,'L');
    $this->CellFitSpace(60,4,$reg[0]['tlfsucursal'],0,1,'L');
    $this->Ln(3);

    $this->SetX(2);
    $this->SetFont($TipoLetra,'B',12);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->SetX(2);
    $this->Cell(70,0.5,'---------------------------',0,1,'C');
    $this->Ln(3); 

    if ($timbrePath) {

    $this->SetX(2);
    $this->Cell(70, 25, $this->Image($timbrePath, $this->GetX(), $this->GetY(), 70, 25), 0, 1);
    $this->SetX(4);
    $this->SetFont($TipoLetra, 'B', 10);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66, 6, "TIMBRE ELECTRONICO S.I.I", 0, 1, 'C');
    $this->SetX(4);
    $this->SetFont($TipoLetra, 'B', 7);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(66, 3, "Verifique el Documento en: www.sii.cl", 0, 1, 'C');
    $this->Ln(2);

    } else {

    $this->SetX(2);
    $this->SetFont($TipoLetra,'BI',10);
    $this->SetFillColor(3, 3, 3);
    $this->CellFitSpace(70,3,"GRACIAS POR SU COMPRA",0,1,'C');
    $this->Ln(3);
    
    }
}
########################## FUNCION NOTA DE CREDITO (BOLETA) ############################## 

########################## FUNCION LISTAR NOTAS DE CREDITO ##############################
function TablaListarNotasCredito()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################
    
    $tra = new Login();
    $reg = $tra->ListarNotasCreditos();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'LISTADO GENERAL DE NOTAS DE CRDITO',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(40,8,'N DE DOCUMENTO',1,0,'C', True);
    $this->Cell(55,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(35,8,'TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,40,55,30,25,30,35,30,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        "N: ".$reg[$i]["codfactura"],
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["facturaventa"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y",strtotime($reg[$i]['fechanota'])),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }

    $this->Cell(180,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR NOTAS DE CREDITO ##############################

########################## FUNCION LISTAR NOTAS DE CREDITO POR CAJA ##############################
function TablaListarNotasxCajas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################
    
    $tra = new Login();
    $reg = $tra->BuscarNotasCreditosxCajas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,10,'LISTADO DE NOTAS DE CRDITO POR CAJAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(235,6,"N CAJA: ".mb_convert_encoding($reg[0]["nrocaja"].": ".$reg[0]["nomcaja"], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Cell(100,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'R');
    $this->Ln();
    $this->Cell(235,6,"RESPONSABLE DE CAJA: ".mb_convert_encoding($reg[0]["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    $this->Cell(100,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'R');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(40,8,'N DE DOCUMENTO',1,0,'C', True);
    $this->Cell(55,8,'DESCRIPCIN DE CLIENTE',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(35,8,'TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,40,55,30,25,30,35,30,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        "N: ".$reg[$i]["codfactura"],
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["facturaventa"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y",strtotime($reg[$i]['fechanota'])),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(180,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR NOTAS DE CREDITO POR CAJA ##############################

########################## FUNCION LISTAR NOTAS DE CREDITO POR FECHAS ##############################
function TablaListarNotasxFechas()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################
    
    $tra = new Login();
    $reg = $tra->BuscarNotasCreditosxFechas();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'LISTADO DE NOTAS DE CRDITO POR FECHAS',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"DESDE: ".date("d/m/Y", strtotime($_GET["desde"])),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"HASTA: ".date("d/m/Y", strtotime($_GET["hasta"])),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(40,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(40,8,'N DE DOCUMENTO',1,0,'C', True);
    $this->Cell(55,8,'DESCRIPCIN DE CLIE/PROV',1,0,'C', True);
    $this->Cell(30,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(30,8,'DESCONTADO',1,0,'C', True);
    $this->Cell(35,8,'SUBTOTAL',1,0,'C', True);
    $this->Cell(30,8,'TOTAL '.$NomImpuesto,1,0,'C', True);
    $this->Cell(35,8,'TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,40,40,55,30,25,30,35,30,35));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        "N: ".$reg[$i]["codfactura"],
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["facturaventa"],
        mb_convert_encoding($reg[$i]['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $reg[$i]['dnicliente'].": ".$reg[$i]['nomcliente'], 'ISO-8859-1', 'UTF-8'),
        date("d/m/Y",strtotime($reg[$i]['fechanota'])),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['descontado']+$reg[$i]['totaldescuento'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totaliva'], 0, '.', '.'),
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(180,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalDescuento, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalSubtotal, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(30,5,($simbolo ?? "").number_format($TotalIva, 0, '.', '.'),0,0,'L');
    $this->CellFitSpace(35,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR NOTAS DE CREDITO POR FECHAS ##############################

########################## FUNCION LISTAR NOTAS DE CREDITO POR CLIENTE ##############################
function TablaListarNotasxClientes()
{
    ###################### DETALLE DE IMPUESTO ######################
    $imp           = new Login();
    $imp           = $imp->ImpuestosPorId();
    $NomImpuesto   = (empty($imp) ? "IMP." : $imp[0]['nomimpuesto']);
    $ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
    ###################### DETALLE DE IMPUESTO ######################
    
    $tra = new Login();
    $reg = $tra->BuscarNotasCreditosxClientes();
    
    $this->SetFont('Courier','B',14);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Cell(335,7,'LISTADO DE NOTAS DE CRDITO POR CLIENTES',0,0,'C');

    if($_SESSION['acceso'] == "administradorG" && !empty($reg)){
        $this->Ln();
        $this->Cell(335,6,"N DE SUCURSAL: ".$reg[0]["cuitsucursal"],0,0,'L');
        $this->Ln();
        $this->Cell(335,6,"SUCURSAL: ".mb_convert_encoding($reg[0]["nomsucursal"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
        $this->Ln();
        $this->Cell(335,6,"ENCARGADO SUCURSAL: ".mb_convert_encoding($reg[0]["nomencargado"], 'ISO-8859-1', 'UTF-8'),0,0,'L'); 
    }

    $this->Ln();
    $this->Cell(335,6,"N DE ".$documento = ($reg[0]['documcliente'] == '0' ? "DOCUMENTO" : mb_convert_encoding($reg[0]['documento3'] ?? "******", 'ISO-8859-1', 'UTF-8')).": ".$reg[0]["dnicliente"],0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"NOMBRE DE CLIENTE: ".mb_convert_encoding($reg[0]['nomcliente'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"N DE TELEFONO: ".$tlfcliente = ($reg[0]['tlfcliente'] == "" ? "********" : $reg[0]['tlfcliente']),0,0,'L');
    $this->Ln();
    $this->Cell(335,6,"DIRECCIN DOMICILIARIA: ".mb_convert_encoding($reg[0]['direccliente'] == "" ? "********" : $reg[0]['direccliente'], 'ISO-8859-1', 'UTF-8'),0,0,'L');
    $this->Ln();
    $this->Cell(335,5,"CORREO ELECTRONICO: ".mb_convert_encoding($reg[0]["emailcliente"] == "" ? "********" : $reg[0]["emailcliente"], 'ISO-8859-1', 'UTF-8'),0,0,'L');

    $this->Ln(10);
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es BLANCO)
    $this->SetFillColor(255,118,118); // establece el color del fondo de la celda (en este caso es AZUL)
    $this->Cell(15,8,'N',1,0,'C', True);
    $this->Cell(30,8,'N DE FACTURA',1,0,'C', True);
    $this->Cell(40,8,'N DE DOCUMENTO',1,0,'C', True);
    $this->Cell(35,8,'FECHA EMISIN',1,0,'C', True);
    $this->Cell(150,8,'DETALLES DE PRODUCTOS',1,0,'C', True);
    $this->Cell(25,8,'N ARTIC.',1,0,'C', True);
    $this->Cell(40,8,'TOTAL',1,1,'C', True);

    if(empty($reg)){
    echo "";      
    } else {
 
     /* AQUI DECLARO LAS COLUMNAS */
    $this->SetWidths(array(15,30,40,35,150,25,40));

    /* AQUI AGREGO LOS VALORES A MOSTRAR EN COLUMNAS */
    $a=1;
    $TotalArticulos = 0;
    $TotalDescuento = 0;
    $TotalSubtotal  = 0;
    $TotalIva       = 0;
    $TotalImporte   = 0;

    for($i=0;$i<sizeof($reg);$i++){ 
    $simbolo = ($reg[$i]['simbolo'] == "" ? "" : $reg[$i]['simbolo']);
    
    $TotalArticulos += $reg[$i]['articulos'];
    $TotalDescuento += $reg[$i]['descontado']+$reg[$i]['totaldescuento'];
    $TotalSubtotal  += $reg[$i]['subtotalivasi']+$reg[$i]['subtotalivano'];
    $TotalIva       += $reg[$i]['totaliva'];
    $TotalImporte   += $reg[$i]['totalpago'];

    $this->SetFont('Courier','',10);  
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es negro)
    $this->Row(array($a++,
        "N: ".$reg[$i]["codfactura"],
        $tipo_documento = ($reg[$i]['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $reg[$i]['tipodocumento'])." N: ".$reg[$i]["facturaventa"],
        date("d/m/Y",strtotime($reg[$i]['fechanota'])),
        mb_convert_encoding(str_replace("<br>","\n", $reg[$i]['detalles_productos']), 'ISO-8859-1', 'UTF-8'),
        $reg[$i]["articulos"],
        $simbolo.number_format($reg[$i]['totalpago'], 0, '.', '.')));
    }
   
    $this->Cell(270,5,'',0,0,'C');
    $this->SetFont('courier','B',10);
    $this->SetTextColor(255,255,255);  // Establece el color del texto (en este caso es blanco)
    $this->SetTextColor(3,3,3);  // Establece el color del texto (en este caso es blanco)
    $this->CellFitSpace(25,5,$TotalArticulos,0,0,'L');
    $this->CellFitSpace(40,5,($simbolo ?? "").number_format($TotalImporte, 0, '.', '.'),0,0,'L');
    $this->Ln();

    }

    $this->Ln(12); 
    $this->SetFont('courier','B',10);
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'ELABORADO: '.mb_convert_encoding($_SESSION["nombres"], 'ISO-8859-1', 'UTF-8'),0,0,'');
    $this->Cell(125,6,'RECIBIDO:_____________________________________',0,0,'');
    $this->Ln();
    $this->Cell(5,6,'',0,0,'');
    $this->Cell(200,6,'FECHA/HORA: '.date('d/m/Y H:i:s'),0,0,'');
    $this->Cell(125,6,'',0,0,'');
    $this->Ln(4);
}
########################## FUNCION LISTAR NOTAS DE CREDITO POR FECHAS ##############################

############################## REPORTES DE NOTAS DE CREDITOS ##################################


 // FIN Class PDF
}
?>