<?php 
// valida_rut($r) v0.001
// No importa si el RUT esta con punto (.), comas (,),
// guion (-),k (minuscula | mayuscula) da igual.
// ----------------------------------------------------
// Autor: Juan Pablo Aqueveque <jp [arroba] juque [punto] cl >
// Script completamente gratis, eso si! mndame un email si lo ocupas
// o si encuentras algn problema :-)
//
// Temuco, 31 octubre 2002 11:48:00
function valida_rut($r)
{
    //$r=strtoupper(ereg_replace('\.|,|-','',$r));
    $r = strtoupper(str_replace(['.',',','-'],[''],$r));
    $sub_rut=substr($r,0,strlen($r)-1);
    $sub_dv=substr($r,-1);
    $x=2;
    $s=0;
    for ( $i=strlen($sub_rut)-1;$i>=0;$i-- )
    {
        if ( $x >7 )
        {
            $x=2;
        }
        $s += $sub_rut[$i]*$x;
        $x++;
    }
    $dv=11-($s%11);
    if ( $dv==10 )
    {
        $dv='K';
    }
    if ( $dv==11 )
    {
        $dv='0';
    }
    if ( $dv==$sub_dv )
    {
        return true;
    }
    else
    {
        return false;
    }
}


function phpRule_ValidarRut($rut) {

    // Verifica que no est vacio y que el string sea de tamao mayor a 3 carcteres(1-9)        
    if ((empty($rut)) || strlen($rut) < 3) {
        return array('error' => true, 'msj' => 'RUT vaco o con menos de 3 caracteres.');
    }

    // Quitar los ltimos 2 valores (el guin y el dgito verificador) y luego verificar que slo sea
    // numrico
    $parteNumerica = str_replace(substr($rut, -2, 2), '', $rut);

    if (!preg_match("/^[0-9]*$/", $parteNumerica)) {
        return array('error' => true, 'msj' => 'La parte numrica del RUT slo debe contener nmeros.');
    }

    $guionYVerificador = substr($rut, -2, 2);
    // Verifica que el guion y dgito verificador tengan un largo de 2.
    if (strlen($guionYVerificador) != 2) {
        return array('error' => true, 'msj' => 'Error en el largo del dgito verificador.');
    }

    // obliga a que el dgito verificador tenga la forma -[0-9] o -[kK]
    if (!preg_match('/(^[-]{1}+[0-9kK]).{0}$/', $guionYVerificador)) {
        return array('error' => true, 'msj' => 'El dgito verificador no cuenta con el patrn requerido');
    }

    // Valida que slo sean nmeros, excepto el ltimo dgito que pueda ser k
    if (!preg_match("/^[0-9.]+[-]?+[0-9kK]{1}/", $rut)) {
        return array('error' => true, 'msj' => 'Error al digitar el RUT');
    }

    $rutV = preg_replace('/[\.\-]/i', '', $rut);
    $dv = substr($rutV, -1);
    $numero = substr($rutV, 0, strlen($rutV) - 1);
    $i = 2;
    $suma = 0;
    foreach (array_reverse(str_split($numero)) as $v) {
        if ($i == 8) {
            $i = 2;
        }
        $suma += $v * $i;
        ++$i;
    }
    $dvr = 11 - ($suma % 11);
    if ($dvr == 11) {
        $dvr = 0;
    }
    if ($dvr == 10) {
        $dvr = 'K';
    }
    if ($dvr == strtoupper($dv)) {
        return array('error' => false, 'msj' => 'RUT ingresado correctamente.');
    } else {
        return array('error' => true, 'msj' => 'El RUT ingresado no es vlido.');
    }
}

function validadorRut($trut)
{
    $dvt = substr($trut, strlen($trut) - 1, strlen($trut));
    $rutt = substr($trut, 0, strlen($trut) - 1);
    $rut = (($rutt) + 0);
    $pa = $rut;
    $c = 2;
    $sum = 0;

    while ($rut > 0)
    {
        $a1 = $rut % 10;
        $rut = floor($rut / 10);
        $sum = $sum + ($a1 * $c);
        $c = $c + 1;
        if ($c == 8)
        {
            $c = 2;
        }
    }

    $di = $sum % 11;
    $digi = 11 - $di;
    $digi1 = ((string )($digi));
    if (($digi1 == '10'))
    {
        $digi1 = 'K';
    }
    if (($digi1 == '11'))
    {
        $digi1 = '0';
    }
    if (($dvt == $digi1))
    {
        echo '';
        //echo 'El rut es valido: ', $pa, '-', $digi1;
    } 
    else
    {
        echo '2';
        //echo 'El rut ingresado ', $pa, '-', $dvt, ' es invalido. Se esperaba: ', $pa,'-', $digi1;
    }
}


## funcion para prevenir ataques XSS
function limpiar($tags){
    $tags = strip_tags($tags);
    $tags = stripslashes($tags);
    //$tags = htmlentities($tags);
    return $tags;
}

function portales($cadena)
{
  $cadena = str_replace ("&aacute;", chr(225), $cadena);
  $cadena = str_replace ("&eacute;", chr(233), $cadena);
  $cadena = str_replace ("&iacute;", chr(237), $cadena);
  $cadena = str_replace ("&oacute;", chr(243), $cadena);
  $cadena = str_replace ("&uacute;", chr(250), $cadena);
  $cadena = str_replace ("&Aacute;", chr(193), $cadena);
  $cadena = str_replace ("&Eacute;", chr(201), $cadena);
  $cadena = str_replace ("&Iacute;", chr(205), $cadena);
  $cadena = str_replace ("&Oacute;", chr(211), $cadena);
  $cadena = str_replace ("&Uacute;", chr(218), $cadena);  
  $cadena = str_replace ("&ntilde;", chr(241), $cadena);    
  $cadena = str_replace ("&Ntilde;", chr(209), $cadena);      
  $cadena = str_replace ("&ldquo;", "\"", $cadena);      
  $cadena = str_replace ("&rdquo;", "\"", $cadena);        
  $cadena = str_replace ("&Ntilde;", chr(209), $cadena);      
  $cadena = str_replace ("&Ntilde;", chr(209), $cadena);      
  $cadena = str_replace ("&nbsp;", "<br /><br />", $cadena);  
  
  return $cadena;
} 

function acentos($cadena) {
  $buscar = explode(",",",,,,,,,,,,,,á,é,í,&sup3;,ú,ñ,á,é,í,&sup3;,ú,ñ");
  $cambiar = explode(",",",,,,,,,,,,,,,,,,,,,,,,,");
  $textocorregido= str_replace($buscar, $cambiar, $cadena);
  return $textocorregido;
} 

function SubirArchivo ($sfArchivo){
    $dir_subida = 'fotos/';
    $fichero_subido = $dir_subida . basename($_FILES[$sfArchivo]['name']);
    if (move_uploaded_file($_FILES[$sfArchivo]['tmp_name'], $fichero_subido)) {
        return $fichero_subido;
    } else {
        return "";
    }
}


function ceros($cadena)
{
    if( preg_match("/0([^0])/", $cadena, $match) ) {
        return strpos($cadena, $match[1]);
    } else {
        return 0;
    }
} 


#####CONTRASEA DE-ENCRIPTAR
function encrypt($string, $key="@ClaveEncriptadaWebMasterChirinos@") {
    $result = '';
    //for($i=0; $i<iconv_strlen($string); $i++) {
    for($i=0; $i<strlen($string); $i++) {
      $char = substr($string, $i, 1);
      $keychar = substr($key, ($i % strlen($key))-1, 1);
      $char = chr(ord($char)+ord($keychar));
      $result.=$char;
    }
    $result=base64_encode($result);
    $result = str_replace(array('+','/','='),array('-','_','.'),$result);
    return $result;
}

function decrypt($string, $key="@ClaveEncriptadaWebMasterChirinos@") {
    $string = str_replace(array('-','_','.'),array('+','/','='),$string);
    $result = '';
    $string = base64_decode($string);
    for($i=0; $i<strlen($string); $i++) {
       $char = substr($string, $i, 1);
       $keychar = substr($key, ($i % strlen($key))-1, 1);
       $char = chr(ord($char)-ord($keychar));
    $result.=$char;
    }
    return $result;
}

function limpiarEntrada($texto) {
 
    //creamos un arreglo que sirva de patrones para eliminar partes no deseadas en las cadenas
    $busqueda = array(
    '@<script[^>]*?>.*?</script>@si',   // quitar javascript
    '@<[\/\!]*?[^<>]*?>@si',            // quitar tags de HTML
    '@<style[^>]*?>.*?</style>@siU',    // quitar estilos
    '@<![\s\S]*?--[ \t\n\r]*>@',
    "'", "&", '"','(',')'         // quitar comentarios multilnea
    );
 
    //utilizamos la funcin preg_replace que busca en una cadena patrones para sustituir
    $salida = str_replace($busqueda, '', $texto);
    //devolvemos la cadena sin los patrones encontrados
    return $salida;
}


function edad($fecha_nac){
//Esta funcion toma una fecha de nacimiento 
//desde una base de datos mysql
//en formato aaaa/mm/dd y calcula la edad en numeros enteros

$dia=date("j");
$mes=date("n");
$anno=date("Y");

//descomponer fecha de nacimiento
$dia_nac=substr($fecha_nac, 8, 2);
$mes_nac=substr($fecha_nac, 5, 2);
$anno_nac=substr($fecha_nac, 0, 4);


if($mes_nac>$mes){
$calc_edad= $anno-$anno_nac-1;
}else{
if($mes==$mes_nac AND $dia_nac>$dia){
$calc_edad= $anno-$anno_nac-1; 
}else{
$calc_edad= $anno-$anno_nac;
}
}
return $calc_edad;
} 

function estado($muestra) {

    if($muestra == "administradorG") {
    echo "ADMINISTRADOR(A) GENERAL";
    } elseif ($muestra == "administradorS") {
    echo "ADMINISTRADOR(A) SUCURSAL";
    } elseif ($muestra == "secretaria") {
    echo "SECRETARIA";
    } elseif ($muestra == "cajero") {
    echo "CAJERO(A)";
    } 
}


function TipoDespacho($tipo) 
{
    if($tipo == 1) {
    echo "TRASLADO DE MERCADERIA";
    } elseif ($tipo == 2) {
    echo "DEVOLUCION";
    } elseif ($tipo == 3) {
    echo "CONSIGNACIONES";
    } elseif ($tipo == 4) {
    echo "ENTREGA GRATUITA";
    } elseif ($tipo == 5) {
    echo "OPERACIN CONSTITUYE VENTAS";
    } 
}

function convertir($string)
{
       $string = str_replace(
       array('01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12'),
       array('ENERO', 'FEBRERO', 'MARZO', 'ABRIL', 'MAYO', 'JUNIO', 'JULIO', 'AGOSTO', 'SEPTIEMBRE', 'OCTUBRE', 'NOVIEMBRE', ' DICIEMBRE'),
       $string
   );        
   return $string;
}

######## INICIO FUNCION CONVERTIR MESES PARA REPORTE PAGOS POR FECHA

function convertir2($string)
{
       $string = str_replace(
       array('01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12'),
       array('ENE', 'FEB', 'MAR', 'ABR', 'MAY', 'JUN', 'JUL', 'AGO', 'SEP', 'OCT', 'NOV', ' DIC'),
       $string
   );        
   return $string;
}

######## FIN FUNCION CONVERTIR MESES PARA REPORTE PAGOS POR FECHA

function nombremes($mes){
 setlocale(LC_TIME, 'es_ES');  
 $nombre=strftime("%B",mktime(0, 0, 0, $mes, 1, 2000)); 
 return $nombre;
} 
	

    
function generar_clave($longitud){ 
           $cadena="[^A-Z0-9]"; 
           return substr(preg_replace($cadena, "", sha1(md5(rand()))) . 
           preg_replace($cadena, "", sha1(md5(rand()))) . 
           preg_replace($cadena, "", sha1(md5(rand()))), 
           0, $longitud); 
    }

//Mtodo con rand()
function GenerateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
} 

function GenerateRandomStringg($length = 49) {
    //$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $characters = '0123456789';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
} 

//Mtodo con str_shuffle() 
function generateRandomString2($length = 50) { 
    return substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, $length); 
}



function random_string($length) {
    switch(true) {
        case function_exists('mcrypt_create_iv') :
            $r = mcrypt_create_iv($length, MCRYPT_DEV_URANDOM);
        break;
        case function_exists('openssl_random_pseudo_bytes') :
            $r = openssl_random_pseudo_bytes($length);
        break;
        case is_readable('/dev/urandom') : // deceze
            $r = file_get_contents('/dev/urandom', false, null, 0, $length);
        break;
        default :
            $i = 0;
            $r = '';
            while($i ++ < $length) {
                $r .= chr(mt_rand(0, 255));
            }
        break;
    }
    return substr(bin2hex($r), 0, $length);
}


function formatear($valor)
{
    $a = explode(".",$valor);
    $b = substr($a[1],0,2);
    $numero = $a[0].".".$b;
    
    return $numero;
}

function formatear2($number, $digitos)
{
    $raiz = 10;
    $multiplicador = pow ($raiz,$digitos);
    $resultado = ((int)($number * $multiplicador)) / $multiplicador;
    return number_format($resultado, $digitos, '.', '.');

}

function rount($number, $digitos)
{
    $raiz = 10;
    $multiplicador = pow ($raiz,$digitos);
    $resultado = ((int)($number * $multiplicador)) / $multiplicador;
    return number_format($resultado, $digitos, '.', '');

}

function removeEmptyElements(&$element)
{
    if (is_array($element)) {
        if ($key = key($element)) {
            $element[$key] = array_filter($element);
        }

        if (count($element) != count($element, COUNT_RECURSIVE)) {
            $element = array_filter(current($element), __FUNCTION__);
        }

        $element = array_filter($element);

        return $element;
    } else {
        return empty($element) ? false : $element;
    }
}

########### CALCULAR DIAS TRANSCURRIDOS ENTRE DOS FECHAS CONTANDO PURO DIAS HABILES #########
function fechas($start, $end) {
    $range = array();

    if (is_string($start) === true) $start = strtotime($start);
    if (is_string($end) === true ) $end = strtotime($end);

    if ($start > $end) return createDateRangeArray($end, $start);

    do {
        $range[] = date('Y-m-d', $start);
        $start = strtotime("+ 1 day", $start);
    } while($start <= $end);

    return $range;
}

########### CALCULAR DIAS TRANSCURRIDOS ENTRE DOS FECHAS #########
function Dias_Transcurridos($fecha_i,$fecha_f)
{
	$dias	= (strtotime($fecha_i)-strtotime($fecha_f))/86400;
	$dias 	= abs($dias); 
	$dias = floor($dias);		
	return $dias;
}

########### CACLULAR DIAS DE RETRASO ENTRE DOS FECHAS #########
function atraso($fecha)
{
    return floor((time()-strtotime($fecha)) / (60 * 60 * 24 ));
}

function numtoletras($xcifra)
{
    $xarray = array(0 => "Cero",
        1 => "UN", "DOS", "TRES", "CUATRO", "CINCO", "SEIS", "SIETE", "OCHO", "NUEVE",
        "DIEZ", "ONCE", "DOCE", "TRECE", "CATORCE", "QUINCE", "DIECISEIS", "DIECISIETE", "DIECIOCHO", "DIECINUEVE",
        "VEINTI", 30 => "TREINTA", 40 => "CUARENTA", 50 => "CINCUENTA", 60 => "SESENTA", 70 => "SETENTA", 80 => "OCHENTA", 90 => "NOVENTA",
        100 => "CIENTO", 200 => "DOSCIENTOS", 300 => "TRESCIENTOS", 400 => "CUATROCIENTOS", 500 => "QUINIENTOS", 600 => "SEISCIENTOS", 700 => "SETECIENTOS", 800 => "OCHOCIENTOS", 900 => "NOVECIENTOS"
    );
    $xcifra = trim($xcifra);
    $xlength = strlen($xcifra);
    $xpos_punto = strpos($xcifra, ".");
    $xaux_int = $xcifra;
    $xdecimales = "00";
    if (!($xpos_punto === false)) {
        if ($xpos_punto == 0) {
            $xcifra = "0" . $xcifra;
            $xpos_punto = strpos($xcifra, ".");
        }
        $xaux_int = substr($xcifra, 0, $xpos_punto); // obtengo el entero de la cifra a covertir
        $xdecimales = substr($xcifra . "00", $xpos_punto + 1, 2); // obtengo los valores decimales
    }

    $XAUX = str_pad($xaux_int, 18, " ", STR_PAD_LEFT); // ajusto la longitud de la cifra, para que sea divisible por centenas de miles (grupos de 6)
    $xcadena = "";
    for ($xz = 0; $xz < 3; $xz++) {
        $xaux = substr($XAUX, $xz * 6, 6);
        $xi = 0;
        $xlimite = 6; // inicializo el contador de centenas xi y establezco el lmite a 6 dgitos en la parte entera
        $xexit = true; // bandera para controlar el ciclo del While
        while ($xexit) {
            if ($xi == $xlimite) { // si ya lleg al lmite mximo de enteros
                break; // termina el ciclo
            }

            $x3digitos = ($xlimite - $xi) * -1; // comienzo con los tres primeros digitos de la cifra, comenzando por la izquierda
            $xaux = substr($xaux, $x3digitos, abs($x3digitos)); // obtengo la centena (los tres dgitos)
            for ($xy = 1; $xy < 4; $xy++) { // ciclo para revisar centenas, decenas y unidades, en ese orden
                switch ($xy) {
                    case 1: // checa las centenas
                        if (substr($xaux, 0, 3) < 100) { // si el grupo de tres dgitos es menor a una centena ( < 99) no hace nada y pasa a revisar las decenas
                            
                        } else {
                            $key = (int) substr($xaux, 0, 3);
                            if (TRUE === array_key_exists($key, $xarray)){  // busco si la centena es nmero redondo (100, 200, 300, 400, etc..)
                                $xseek = $xarray[$key];
                                $xsub = subfijo($xaux); // devuelve el subfijo correspondiente (Milln, Millones, Mil o nada)
                                if (substr($xaux, 0, 3) == 100)
                                    $xcadena = " " . $xcadena . " CIEN " . $xsub;
                                else
                                    $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                                $xy = 3; // la centena fue redonda, entonces termino el ciclo del for y ya no reviso decenas ni unidades
                            }
                            else { // entra aqu si la centena no fue numero redondo (101, 253, 120, 980, etc.)
                                $key = (int) substr($xaux, 0, 1) * 100;
                                $xseek = $xarray[$key]; // toma el primer caracter de la centena y lo multiplica por cien y lo busca en el arreglo (para que busque 100,200,300, etc)
                                $xcadena = " " . $xcadena . " " . $xseek;
                            } // ENDIF ($xseek)
                        } // ENDIF (substr($xaux, 0, 3) < 100)
                        break;
                    case 2: // checa las decenas (con la misma lgica que las centenas)
                        if (substr($xaux, 1, 2) < 10) {
                            
                        } else {
                            $key = (int) substr($xaux, 1, 2);
                            if (TRUE === array_key_exists($key, $xarray)) {
                                $xseek = $xarray[$key];
                                $xsub = subfijo($xaux);
                                if (substr($xaux, 1, 2) == 20)
                                    $xcadena = " " . $xcadena . " VEINTE " . $xsub;
                                else
                                    $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                                $xy = 3;
                            }
                            else {
                                $key = (int) substr($xaux, 1, 1) * 10;
                                $xseek = $xarray[$key];
                                if (20 == substr($xaux, 1, 1) * 10)
                                    $xcadena = " " . $xcadena . " " . $xseek;
                                else
                                    $xcadena = " " . $xcadena . " " . $xseek . " Y ";
                            } // ENDIF ($xseek)
                        } // ENDIF (substr($xaux, 1, 2) < 10)
                        break;
                    case 3: // checa las unidades
                        if (substr($xaux, 2, 1) < 1) { // si la unidad es cero, ya no hace nada
                            
                        } else {
                            $key = (int) substr($xaux, 2, 1);
                            $xseek = $xarray[$key]; // obtengo directamente el valor de la unidad (del uno al nueve)
                            $xsub = subfijo($xaux);
                            $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                        } // ENDIF (substr($xaux, 2, 1) < 1)
                        break;
                } // END SWITCH
            } // END FOR
            $xi = $xi + 3;
        } // ENDDO

        if (substr(trim($xcadena), -5, 5) == "ILLON") // si la cadena obtenida termina en MILLON o BILLON, entonces le agrega al final la conjuncion DE
            $xcadena.= " DE";

        if (substr(trim($xcadena), -7, 7) == "ILLONES") // si la cadena obtenida en MILLONES o BILLONES, entoncea le agrega al final la conjuncion DE
            $xcadena.= " DE";

        // ----------- esta lnea la puedes cambiar de acuerdo a tus necesidades o a tu pas -------
        if (trim($xaux) != "") {
            switch ($xz) {
                case 0:
                    if (trim(substr($XAUX, $xz * 6, 6)) == "1")
                        $xcadena.= "UN BILLON ";
                    else
                        $xcadena.= " BILLONES ";
                    break;
                case 1:
                    if (trim(substr($XAUX, $xz * 6, 6)) == "1")
                        $xcadena.= "UN MILLON ";
                    else
                        $xcadena.= " MILLONES ";
                    break;
                case 2:
                    if ($xcifra < 1) {
                        //$xcadena = "CERO CON $xdecimales/100";
                        $xcadena = "";
                    }
                    if ($xcifra >= 1 && $xcifra < 2) {
                        //$xcadena = "UN CON $xdecimales/100";
                        $xcadena = "";
                    }
                    if ($xcifra >= 2) {
                        //$xcadena.= " CON $xdecimales/100"; //
                        $xcadena.= ""; //
                    }
                    break;
            } // endswitch ($xz)
        } // ENDIF (trim($xaux) != "")
        // ------------------      en este caso, para Mxico se usa esta leyenda     ----------------
        $xcadena = str_replace("VEINTI ", "VEINTI", $xcadena); // quito el espacio para el VEINTI, para que quede: VEINTICUATRO, VEINTIUN, VEINTIDOS, etc
        $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
        $xcadena = str_replace("UN UN", "UN", $xcadena); // quito la duplicidad
        $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
        $xcadena = str_replace("BILLON DE MILLONES", "BILLON DE", $xcadena); // corrigo la leyenda
        $xcadena = str_replace("BILLONES DE MILLONES", "BILLONES DE", $xcadena); // corrigo la leyenda
        $xcadena = str_replace("DE UN", "UN", $xcadena); // corrigo la leyenda
    } // ENDFOR ($xz)
    return trim($xcadena);
}

// END FUNCTION

function subfijo($xx)
{ // esta funcin regresa un subfijo para la cifra
    $xx = trim($xx);
    $xstrlen = strlen($xx);
    if ($xstrlen == 1 || $xstrlen == 2 || $xstrlen == 3)
        $xsub = "";
    //
    if ($xstrlen == 4 || $xstrlen == 5 || $xstrlen == 6)
        $xsub = "MIL";
    //
    return $xsub;
}

function getSubString($string, $length=NULL)
{
    //Si no se especifica la longitud por defecto es 50
    if ($length == NULL)
        $length = 40;
    //Primero eliminamos las etiquetas html y luego cortamos el string
    $stringDisplay = substr(strip_tags($string), 0, $length);
    //Si el texto es mayor que la longitud se agrega puntos suspensivos
    if (strlen(strip_tags($string)) > $length)
        $stringDisplay .= '.';
    return $stringDisplay;
}

/* 
 *El uso de funciones es ms elegante y prctico, 
 *sobre todo si necesitas llamarlas desde varias partes de tu cdigo
 *La funcin evala cada nmero ($x) de $array y si ste es menor que 0
 *incrementa un contador $i en 1 cada vez. Al final devuelve el total del contador
 */
function get_negativosfor($array)
{ 
    $i = 0; foreach ($array as $x) 
    if ($x < 0) $i++; 
    return $i; 
}

function isDebug()
{
   return (bool)getenv('DEBUG');
}

function contarValoresArray($array)
{
    $contar=array();
    foreach($array as $value)
    {
        if(isset($contar[$value]))
        {
            // si ya existe, le aadimos uno
            $contar[$value]+=1;

        } else {
            // si no existe lo aadimos al array
            $contar[$value]=1;
        }
    }
    return $contar;
}

function hasAcceso(array $accesos): bool
{
   return in_array($_SESSION['acceso'], $accesos);
}

function validarAccesos(array $accesos, $redirect = 'panel'): bool
{
    (new Login)->ExpiraSession();
    $msg = 'NO TIENES PERMISO PARA ACCEDER AL SISTEMA.\nDEBERA DE INICIAR SESION';
    $url = 'logout';
    if (isset($_SESSION['acceso'])) {
        $msg = 'NO TIENES PERMISO PARA ACCEDER A ESTA PAGINA.\nCONSULTA CON EL ADMINISTRADOR PARA QUE TE DE ACCESO';
        $url = $_SERVER['HTTP_REFERER'] ?? $redirect;
        if (empty($accesos)) return true;
        if (hasAcceso($accesos)) {
            return true;
        }
    }
    if (!isAjax()) {
        echo "<script type=\"text/javascript\">alert(\"$msg\");document.location.href=\"$url\";</script>";
    }
    else {
        jsonResponse(['message' => nl2br($msg)], 401);
    }
    return false;
}

function jsonResponse($data, $status = 200): void
{
    header('Content-Type: application/json');
    http_response_code($status);
    die(json_encode($data));
}

function jsonResponseErr(Throwable $ex, $status = 400): void
{
    jsonResponse([
      'message' => $ex->getMessage(),
      'code'    => $ex->getCode(),
      'stack'   => $ex->getTrace(),
    ], $status);
}

function isAjax(): bool
{
    $acceptJson = !empty($_SERVER['HTTP_ACCEPT']) && strpos($_SERVER['HTTP_ACCEPT'], 'application/json') !== false;
    if ($acceptJson && ! empty($_SERVER['HTTP_X_REQUESTED_WITH'])) {
      return strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';
    }
    return false;
}

function jsonPost()
{
    if (isAjax())
      return json_decode(file_get_contents('php://input'), true);
    else
      return filter_input_array(INPUT_POST);
}

function moneda($valor, $simbolo = '', $decimales = 0, $decimal_separador = ',', $decimal_miles = '.', $right = false): string
{
   $formated = number_format($valor, $decimales, $decimal_separador, $decimal_miles);
   if ( ! $right) return $simbolo . $formated;
   return $formated . $simbolo;
}

function fecha($valor, $format = 'd/m/Y')
{
   return date($format, strtotime($valor));
}

/**
* @throws ErrorException
*/
function customErrorHandler($errno, $errstr, $errfile, $errline, array $errcontext): bool
{
    if ( ! (error_reporting() & $errno)) {
      return false;
    }
    \Sentry\captureLastError();
    throw new ErrorException($errstr, 0, $errno, $errfile, $errline);
}

/**
* @throws Throwable
*/
function customExeptionHandler(Throwable $th)
{
    if (isAjax()) {
      jsonResponseErr($th, 500);
    }
    else {
      http_response_code(500);
      throw $th;
    }
}

//set_exception_handler('customExeptionHandler');
//set_error_handler('customErrorHandler');
?>