<?php
session_start();
require_once("classconexion.php");

class conectorDB extends Db
{
	private $dbh;
	public function __construct() {
	    // Correcto: Obtener la única instancia de PDO a través del Singleton
	    try {
	      $this->dbh = Db::getInstance();
	    } catch (Exception $e) {
	      // Manejar el error de conexión si ocurre
	      error_log("Error en Login al obtener conexión DB: " . $e->getMessage());
	      // Podrías lanzar una excepción o simplemente no continuar con la lógica
	      // que requiere la base de datos.
	      die("Error interno del sistema. Intente más tarde."); // O una respuesta más amigable
	    }
	}

	public function EjecutarSentencia($consulta, $valores = array()){
    $resultado = false;
    
	    try {
	        if($statement = $this->dbh->prepare($consulta)){
	            // Ejecutamos la sentencia con el array de valores.
	            // PDO se encarga de enlazar los parámetros de forma segura.
	            if ($statement->execute($valores)) {
	                $resultado = $statement->fetchAll(PDO::FETCH_ASSOC);
	            } else {
	                print_r($statement->errorInfo());
	                return false;
	            }
	        }
	    }
	    catch(PDOException $e){
	        echo "Error de ejecución: \n";
	        print_r($e->getMessage());
	        return false;
	    }    
	    return $resultado;
	}/// Termina funcion EjecutarSentencia

}/// Termina clase conectorDB

class Json
{
	private $json;

	################################ BUSQUEDA DE CIUDADES ################################
	public function BuscaCiudad($filtro){
		$consulta = "SELECT CONCAT(ciudad) as label, id_ciudad FROM ciudades WHERE CONCAT(ciudad) LIKE '%".$filtro."%' ORDER BY id_ciudad ASC LIMIT 0,10";
		$conexion = new conectorDB();
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE CIUDADES ################################

	################################ BUSQUEDA DE COMUNAS ################################
	public function BuscaComuna($filtro){
		$consulta = "SELECT CONCAT(comuna) as label, id_comuna, numero FROM comunas WHERE CONCAT(comuna) LIKE '%".$filtro."%' ORDER BY id_comuna ASC LIMIT 0,10";
		$conexion = new conectorDB();
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE COMUNAS ################################

	################################ BUSQUEDA DE MARCAS ################################
	public function BuscaMarcas($filtro){
    $consulta = "SELECT CONCAT(nommarca) as label, codmarca FROM marcas WHERE CONCAT(nommarca) LIKE '%".$filtro."%' ORDER BY codmarca ASC LIMIT 0,100";
			$conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE MARCAS ################################
	
	################################ BUSQUEDA DE MODELOS ################################
	public function BuscaModelos($filtro){
    $consulta = "SELECT CONCAT(nommodelo) as label, codmodelo FROM modelos WHERE CONCAT(nommodelo) LIKE '%".$filtro."%' ORDER BY codmodelo ASC LIMIT 0,100";
			$conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE MODELOS ################################


	################################ BUSQUEDA DE PRODUCTOS X SUCURSAL ################################
	public function BuscaProductosxSucursal($filtro,$filtro2){

		$consulta = "SELECT
		CONCAT(productos.codproducto, ' | ',productos.producto, ' | MARCA(',if(productos.codmarca='0','***',marcas.nommarca), ') | MODELO(',if(productos.codmodelo='0','***',modelos.nommodelo), ') | IMEI(',if(productos.imei='','***',productos.imei), ')' ) as label, 
	    productos.idproducto, 
	    productos.codproducto, 
	    productos.producto, 
	    productos.descripcion,
	    productos.opcionvendido, 
	    productos.imei, 
	    if(productos.condicion='','0',productos.condicion) condicion,
	    productos.fabricante, 
	    IFNULL(productos.codfamilia,'0') AS codmarca,
	    IFNULL(productos.codsubfamilia,'0') AS codmarca,
	    IFNULL(productos.codmarca,'0') AS codmarca,
	    IFNULL(productos.codmodelo,'0') AS codmodelo,
	    IFNULL(productos.codpresentacion,'0') AS codpresentacion,
	    IFNULL(productos.codcolor,'0') AS codcolor,
	    ROUND(productos.preciocompra, 0) preciocompra, 
	    ROUND(productos.precioxmenor, 0) precioxmenor, 
	    ROUND(productos.precioxmayor, 0) precioxmayor, 
	    ROUND(productos.precioxpublico, 0) precioxpublico, 
	    productos.existencia, 
	    productos.ivaproducto, 
	    ROUND(productos.descproducto, 0) descproducto, 
	    productos.fechaelaboracion, 
	    productos.fechaoptimo, 
	    productos.fechamedio, 
	    productos.fechaminimo, 
	    marcas.nommarca, 
	    modelos.nommodelo, 
	    presentaciones.nompresentacion, 
	    colores.nomcolor 
	    FROM productos LEFT JOIN marcas ON productos.codmarca = marcas.codmarca 
	    LEFT JOIN modelos ON modelos.codmodelo = productos.codmodelo 
	    LEFT JOIN presentaciones ON productos.codpresentacion = presentaciones.codpresentacion
        LEFT JOIN colores ON productos.codcolor = colores.codcolor
        WHERE CONCAT(productos.codproducto, '',productos.producto, '',productos.codigobarra, '',if(productos.codmarca='0','0',marcas.nommarca), if(productos.imei='','0',productos.imei)) LIKE '%".$filtro."%'
        AND productos.codsucursal = '".strip_tags($filtro2)."'
        ORDER BY productos.producto 
        ASC LIMIT 0,1000";
		$conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE PRODUCTOS X SUCURSAL ################################

	################################ BUSQUEDA DE PRODUCTOS ################################
	public function BuscaProductos($filtro){

        $consulta = "SELECT 
        CONCAT(productos.codproducto, ' | ',productos.producto, ' | MARCA(',if(productos.codmarca='0','***',marcas.nommarca), ') | MODELO(',if(productos.codmodelo='0','***',modelos.nommodelo), ') | IMEI(',if(productos.imei='','***',productos.imei), ')' ) as label, 
	    productos.idproducto, 
	    productos.codproducto, 
	    productos.producto, 
	    productos.descripcion,
	    productos.opcionvendido, 
	    productos.imei, 
	    if(productos.condicion='','0',productos.condicion) condicion,
	    productos.fabricante, 
	    IFNULL(productos.codfamilia,'0') AS codmarca,
	    IFNULL(productos.codsubfamilia,'0') AS codmarca,
	    IFNULL(productos.codmarca,'0') AS codmarca,
	    IFNULL(productos.codmodelo,'0') AS codmodelo,
	    IFNULL(productos.codpresentacion,'0') AS codpresentacion,
	    IFNULL(productos.codcolor,'0') AS codcolor,
	    IFNULL(productos.codorigen,'0') AS codorigen, 
	    ROUND(productos.preciocompra, 0) preciocompra, 
	    ROUND(productos.precioxmenor, 0) precioxmenor, 
	    ROUND(productos.precioxmayor, 0) precioxmayor, 
	    ROUND(productos.precioxpublico, 0) precioxpublico, 
	    productos.existencia, 
	    productos.ivaproducto, 
	    ROUND(productos.descproducto, 0) descproducto, 
	    productos.fechaelaboracion, 
	    productos.fechaoptimo, 
	    productos.fechamedio, 
	    productos.fechaminimo, 
	    marcas.nommarca, 
	    modelos.nommodelo, 
	    presentaciones.nompresentacion, 
	    colores.nomcolor 
	    FROM productos LEFT JOIN marcas ON productos.codmarca = marcas.codmarca 
	    LEFT JOIN modelos ON modelos.codmodelo = productos.codmodelo 
	    LEFT JOIN presentaciones ON productos.codpresentacion = presentaciones.codpresentacion
        LEFT JOIN colores ON productos.codcolor = colores.codcolor
        WHERE CONCAT(productos.codproducto, '',productos.producto, '',productos.codigobarra, '',if(productos.codmarca='0','0',marcas.nommarca), if(productos.imei='','0',productos.imei)) LIKE '%".$filtro."%' 
        AND productos.codsucursal= '".strip_tags($_SESSION["codsucursal"])."' 
        ORDER BY productos.producto 
        ASC LIMIT 0,1000";
        $conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE PRODUCTOS ################################

	################################ BUSQUEDA DE PRODUCTOS POR CODIGO DE BARRA ################################
	public function BuscaProductoBarCode($filtro)
	{
	    $consulta = "SELECT 
	    productos.idproducto,
	    productos.codproducto as txtCodigo, 
	    productos.producto,
	    if(productos.descripcion='','0',productos.descripcion) descripcion,
	    productos.opcionvendido,
	    if(productos.imei='','0',productos.imei) imei,
	    if(productos.condicion='','0',productos.condicion) condicion,
	    IFNULL(productos.codmarca,'0') AS codmarca,
	    IFNULL(marcas.nommarca,'0') AS nommarca,
	    IFNULL(productos.codmodelo,'0') AS codmodelo,
	    IFNULL(modelos.nommodelo,'0') AS nommodelo,
	    IFNULL(productos.codpresentacion,'0') AS codpresentacion,
	    IFNULL(presentaciones.nompresentacion,'0') AS nompresentacion,
	    IFNULL(productos.codcolor,'0') AS codcolor,
	    IFNULL(colores.nomcolor,'0') AS nomcolor,
	    ROUND(productos.preciocompra, 0) preciocompra, 
	    ROUND(productos.precioxpublico, 0) precioxpublico,
	    ROUND(productos.descproducto, 2) descproducto,
	    productos.ivaproducto,
	    productos.existencia
	    FROM productos LEFT JOIN marcas ON productos.codmarca = marcas.codmarca 
	    LEFT JOIN modelos ON productos.codmodelo = modelos.codmodelo 
	    LEFT JOIN presentaciones ON productos.codpresentacion = presentaciones.codpresentacion
        LEFT JOIN colores ON productos.codcolor = colores.codcolor  
	    WHERE (productos.codproducto = '$filtro' or productos.codigobarra = '$filtro') 
	    AND productos.codsucursal = '".strip_tags($_SESSION["codsucursal"])."' 
	    ORDER BY productos.codproducto ASC LIMIT 0,1000";
        $conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE PRODUCTOS POR CODIGO DE BARRA ################################

	################################ BUSQUEDA DE PRODUCTOS POR CODIGO DE BARRA DESDE VERIFICADOR ################################
	public function BuscaProductoBarCodeVerificador($filtro,$filtro2)
	{
	    $consulta = "SELECT 
	    p.idproducto, 
	    p.codproducto, 
	    p.producto,
	    p.codmarca,  
	    ma.nommarca, 
	    p.codmodelo,
	    IFNULL(mo.nommodelo,'0') AS nommodelo,
	    p.codpresentacion,
	    IFNULL(pr.nompresentacion,'0') AS nompresentacion,
	    p.codcolor,
	    IFNULL(co.nomcolor,'0') AS nomcolor, 
	    ROUND(p.precioxpublico, 2) precioxpublico,
	    ROUND(p.descproducto, 2) descproducto,
	    p.ivaproducto,
	    p.existencia,
	    p.codsucursal,
	    s.codmoneda,
	    tp.moneda,
	    tp.siglas,
	    tp.simbolo
	    FROM (productos p LEFT JOIN sucursales s ON p.codsucursal = s.codsucursal)
	    LEFT JOIN marcas ma ON p.codmarca = ma.codmarca 
	    LEFT JOIN modelos mo ON p.codmodelo = mo.codmodelo 
	    LEFT JOIN presentaciones pr ON p.codpresentacion = pr.codpresentacion
        LEFT JOIN colores co ON p.codcolor = co.codcolor
	    LEFT JOIN tiposmoneda tp ON s.codmoneda = tp.codmoneda  
	    WHERE (p.codproducto = '$filtro' or p.codigobarra = '$filtro') 
	    AND p.codsucursal = '$filtro2'
	    ORDER BY p.producto ASC LIMIT 0,1000";
        $conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE PRODUCTOS POR CODIGO DE BARRA DESDE VERIFICADOR ################################


	

	################################ BUSQUEDA DE PRODUCTOS ################################
	public function BuscaProductosCompra($filtro){

        $consulta = "SELECT 
        CONCAT(productos.codproducto, ' | ',productos.producto, ' | MARCA(',if(productos.codmarca='0','***',marcas.nommarca), ') | MODELO(',if(productos.codmodelo='0','***',modelos.nommodelo), ') | IMEI(',if(productos.imei='','***',productos.imei), ')' ) as label, 
	    productos.idproducto, 
	    productos.codproducto, 
	    productos.producto, 
	    productos.descripcion,
	    productos.opcionvendido, 
	    productos.imei, 
	    if(productos.condicion='','0',productos.condicion) condicion,
	    productos.fabricante, 
	    IFNULL(productos.codfamilia,'0') AS codmarca,
	    IFNULL(productos.codsubfamilia,'0') AS codmarca,
	    IFNULL(productos.codmarca,'0') AS codmarca,
	    IFNULL(productos.codmodelo,'0') AS codmodelo,
	    IFNULL(productos.codpresentacion,'0') AS codpresentacion,
	    IFNULL(productos.codcolor,'0') AS codcolor,
	    IFNULL(productos.codorigen,'0') AS codorigen,
	    ROUND(productos.preciocompra, 0) preciocompra, 
	    ROUND(productos.precioxmenor, 0) precioxmenor, 
	    ROUND(productos.precioxmayor, 0) precioxmayor, 
	    ROUND(productos.precioxpublico, 0) precioxpublico, 
	    productos.existencia, 
	    productos.ivaproducto, 
	    ROUND(productos.descproducto, 0) descproducto, 
	    productos.fechaelaboracion, 
	    productos.fechaoptimo, 
	    productos.fechamedio, 
	    productos.fechaminimo, 
	    marcas.nommarca, 
	    modelos.nommodelo, 
	    presentaciones.nompresentacion, 
	    colores.nomcolor 
	    FROM productos LEFT JOIN marcas ON productos.codmarca = marcas.codmarca 
	    LEFT JOIN modelos ON modelos.codmodelo = productos.codmodelo 
	    LEFT JOIN presentaciones ON productos.codpresentacion = presentaciones.codpresentacion
        LEFT JOIN colores ON productos.codcolor = colores.codcolor
        WHERE CONCAT(productos.codproducto, '',productos.producto, '',if(productos.codigobarra='','0',productos.codigobarra), '',if(productos.codmarca='0','0',marcas.nommarca), if(productos.imei='','0',productos.imei)) LIKE '%".$filtro."%' 
        AND productos.codsucursal= '".strip_tags($_SESSION["codsucursal"])."' 
        ORDER BY productos.producto 
        ASC LIMIT 0,1000";
        $conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE PRODUCTOS ################################

	################################ BUSQUEDA DE PRODUCTOS POR CODIGO DE BARRA EN COMPRAS ################################
	public function BuscaProductoCompraBarCode($filtro)
	{
	    $consulta = "SELECT 
	    productos.idproducto, 
	    productos.codproducto, 
	    productos.producto,
	    if(productos.descripcion='','0',productos.descripcion) descripcion,
	    productos.opcionvendido,
	    if(productos.imei='','0',productos.imei) imei,
	    if(productos.condicion='','0',productos.condicion) condicion,
	    IFNULL(productos.codmarca,'0') AS codmarca,
	    IFNULL(marcas.nommarca,'0') AS nommarca,
	    IFNULL(productos.codmodelo,'0') AS codmodelo,
	    IFNULL(modelos.nommodelo,'0') AS nommodelo,
	    IFNULL(productos.codpresentacion,'0') AS codpresentacion,
	    IFNULL(presentaciones.nompresentacion,'0') AS nompresentacion,
	    IFNULL(productos.codcolor,'0') AS codcolor,
	    IFNULL(colores.nomcolor,'0') AS nomcolor,
	    ROUND(productos.preciocompra, 2) preciocompra,
	    ROUND(productos.precioxmayor, 2) precioxmayor,
	    ROUND(productos.precioxmenor, 2) precioxmenor, 
	    ROUND(productos.precioxpublico, 2) precioxpublico,
	    '0.00',
	    ROUND(productos.descproducto, 2) descproducto,
	    productos.ivaproducto,
	    productos.existencia,
	    productos.stockoptimo,
	    productos.stockmedio,
	    productos.stockminimo, 
	    productos.fechaelaboracion, 
	    productos.fechaoptimo, 
	    productos.fechamedio, 
	    productos.fechaminimo
	    FROM productos LEFT JOIN marcas ON productos.codmarca = marcas.codmarca 
	    LEFT JOIN modelos ON modelos.codmodelo = productos.codmodelo 
	    LEFT JOIN presentaciones ON productos.codpresentacion = presentaciones.codpresentacion
        LEFT JOIN colores ON productos.codcolor = colores.codcolor
	    WHERE (productos.codproducto = '$filtro' or productos.codigobarra = '$filtro')
	    AND productos.codsucursal = '".strip_tags($_SESSION["codsucursal"])."' 
	    ORDER BY productos.producto ASC LIMIT 0,1000";
        $conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE PRODUCTOS POR CODIGO DE BARRA EN COMPRAS ################################




	################################ BUSQUEDA DE COMBOS X SUCURSAL ################################
	public function BuscaCombosxSucursal($filtro,$filtro2){

		$consulta = "SELECT
		CONCAT(combos.nomcombo) as label, 
        combos.idcombo, 
        combos.codcombo, 
        combos.nomcombo, 
        ROUND(combos.preciocompra, 0) preciocompra, 
        ROUND(combos.precioventa, 0) precioventa, 
        ROUND(combos.existencia, 0) existencia, 
        combos.ivacombo, 
        ROUND(combos.desccombo, 0) desccombo 
        FROM combos 
        WHERE CONCAT(combos.codcombo, '',combos.nomcombo) LIKE '%".$filtro."%'
        AND combos.codsucursal = '".strip_tags($filtro2)."'
        ORDER BY combos.nomcombo 
        ASC LIMIT 0,1000";
		$conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE COMBOS X SUCURSAL ################################

	################################ BUSQUEDA DE COMBOS ################################
	public function BuscaCombos($filtro){

        $consulta = "SELECT 
        CONCAT(combos.nomcombo) as label, 
        combos.idcombo, 
        combos.codcombo, 
        combos.nomcombo, 
        ROUND(combos.preciocompra, 0) preciocompra, 
        ROUND(combos.precioventa, 0) precioventa,
        ROUND(combos.existencia, 0) existencia, 
        combos.ivacombo, 
        ROUND(combos.desccombo, 0) desccombo 
        FROM combos 
        WHERE CONCAT(combos.codcombo, '',combos.nomcombo) LIKE '%".$filtro."%' 
        AND codsucursal= '".strip_tags($_SESSION["codsucursal"])."' 
        ORDER BY combos.nomcombo 
        ASC LIMIT 0,1000";
        $conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE COMBOS ################################



	################################ BUSQUEDA DE CLIENTES X SUCURSAL ################################
	public function BuscaClientesxSucursal($filtro,$filtro2){

		$consulta = "SELECT
		CONCAT(if(clientes.documcliente='0','DOC.',documentos.documento), ': ',clientes.dnicliente, ': ',if(clientes.nomcliente='',clientes.razoncliente,clientes.nomcliente), ' | ',if(clientes.direccliente='','***',clientes.direccliente)) as label,  
		clientes.codcliente, 
		clientes.dnicliente,
		clientes.tipocliente,
		clientes.nomcliente,
		clientes.razoncliente,
		clientes.direccliente, 
		clientes.limitecredito
	    FROM
        clientes 
        LEFT JOIN documentos ON clientes.documcliente = documentos.coddocumento
        WHERE CONCAT(clientes.dnicliente, '',if(clientes.nomcliente='',clientes.razoncliente,clientes.nomcliente), '',clientes.girocliente) LIKE '%".$filtro."%'
        AND clientes.codsucursal = '".strip_tags($filtro2)."'
        ORDER BY clientes.codcliente 
        ASC LIMIT 0,1000";
		$conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE CLIENTES X SUCURSAL ################################

	################################ BUSQUEDA DE CLIENTES ################################
	public function BuscaClientes($filtro){
	$consulta = "SELECT
	CONCAT(if(clientes.documcliente='0','DOC.',documentos.documento), ': ',clientes.dnicliente, ': ',if(clientes.nomcliente='',clientes.razoncliente,clientes.nomcliente)) as label,   
	clientes.codcliente, 
	clientes.dnicliente,
	clientes.tipocliente,
	clientes.nomcliente,
	clientes.razoncliente,
	clientes.limitecredito,
	IFNULL(clientes.limitecredito-pag.montocredito,clientes.limitecredito) AS creditodisponible
    FROM
        clientes 
        LEFT JOIN documentos ON clientes.documcliente = documentos.coddocumento
        LEFT JOIN
        (SELECT
           codcliente, montocredito       
           FROM creditosxclientes WHERE codsucursal = '".strip_tags($_SESSION['codsucursal'])."') pag ON pag.codcliente = clientes.codcliente
           WHERE CONCAT(clientes.dnicliente, '',if(clientes.nomcliente='',clientes.razoncliente,clientes.nomcliente)) LIKE '%".$filtro."%' 
        AND clientes.codsucursal = '".strip_tags($_SESSION['codsucursal'])."'
        GROUP BY 
        clientes.codcliente, 
        clientes.documcliente, 
        clientes.dnicliente,
        clientes.tipocliente,
        clientes.nomcliente,
        clientes.razoncliente,
        clientes.limitecredito,
        documentos.documento
        ORDER BY clientes.codcliente ASC LIMIT 0,1000";
		$conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE CLIENTES ################################

	



	################################ BUSQUEDA DE FACTURAS X SUCURSAL ################################
	public function BuscaFacturas($filtro,$filtro2){

		$consulta = "SELECT
		CONCAT(if(ventas.tipodocumento='FACTURA_A4','FACTURA',ventas.tipodocumento), ' Nº ',ventas.codfactura, ': ',if(ventas.codcliente='0','CONSUMIDOR FINAL',if(clientes.nomcliente='',clientes.razoncliente,clientes.nomcliente))) as label, 
		ventas.idventa, 
		ventas.codventa, 
		ventas.codfactura 
		FROM ventas LEFT JOIN clientes ON ventas.codcliente = clientes.codcliente 
		WHERE CONCAT(ventas.tipodocumento, ventas.codventa, ventas.codfactura, if(ventas.codcliente='0','CONSUMIDOR FINAL',if(clientes.nomcliente='',clientes.razoncliente,clientes.nomcliente))) LIKE '%".$filtro."%'
        AND ventas.codsucursal = '".strip_tags($filtro2)."' 
		AND ventas.notacredito != 1
        ORDER BY ventas.codventa 
        ASC LIMIT 0,1000";
		$conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE FACTURAS X SUCURSAL ################################

}/// TERMINA CLASE  ///
?>