<?php
session_start();
header('Content-Type: application/json');

$response_data = [];

if (isset($_POST['MiCarrito'])) {
    $json_data     = $_POST['MiCarrito'];
    $ObjetoCarrito = json_decode($json_data);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['error' => 'Error al decodificar JSON: ' . json_last_error_msg()]);
        exit;
    }

    if (!is_object($ObjetoCarrito)) {
        echo json_encode(['error' => 'Datos de carrito recibidos no son un objeto válido.']);
        exit;
    }

    if (isset($ObjetoCarrito->Id) && $ObjetoCarrito->Id == "vaciar" ||
        isset($ObjetoCarrito->Codigo) && $ObjetoCarrito->Codigo == "vaciar") {
        unset($_SESSION["CarritoVenta"]);
        $_SESSION["CarritoVenta"] = [];
        $response_data = [];
    } else {
        $carrito = isset($_SESSION['CarritoVenta']) && is_array($_SESSION['CarritoVenta']) ? $_SESSION['CarritoVenta'] : [];
        $found_item_index = -1;

        for ($i = 0; $i < count($carrito); $i++) {
            if (isset($carrito[$i]['tipodetalle']) && isset($ObjetoCarrito->TipoDetalle) && $ObjetoCarrito->TipoDetalle == $carrito[$i]['tipodetalle'] &&
                isset($carrito[$i]['id']) && isset($ObjetoCarrito->Id) && $ObjetoCarrito->Id == $carrito[$i]['id'] &&
                isset($carrito[$i]['txtCodigo']) && isset($ObjetoCarrito->Codigo) && $ObjetoCarrito->Codigo == $carrito[$i]['txtCodigo'] &&
                isset($carrito[$i]['producto']) && isset($ObjetoCarrito->Producto) && $ObjetoCarrito->Producto == $carrito[$i]['producto']) {
                
                $found_item_index = $i;
                break;
            }
        }

        if ($found_item_index != -1) {
            // PRODUCTO ENCONTRADO EN EL CARRITO (ACTUALIZAR)
            $current_quantity = isset($carrito[$found_item_index]['cantidad']) ? (float)$carrito[$found_item_index]['cantidad'] : 0;
            $new_quantity     = (float)$ObjetoCarrito->Cantidad; // Cantidad que viene del cliente

            if (isset($ObjetoCarrito->opCantidad) && $ObjetoCarrito->opCantidad === 'IMEI_SET') {
                // CASO 1: Operación para establecer IMEI (desde DoActionImei)
                if ($current_quantity <= 0) {
                    $carrito[$found_item_index]['cantidad'] = 1; // Fuerza a 1 si la cantidad actual es 0 o menos
                }
                if (isset($ObjetoCarrito->Precio)) $carrito[$found_item_index]['precio'] = (string) (float)$ObjetoCarrito->Precio;
                if (isset($ObjetoCarrito->Precio2)) $carrito[$found_item_index]['precio2'] = (string) (float)$ObjetoCarrito->Precio2;
                if (isset($ObjetoCarrito->Descproducto)) $carrito[$found_item_index]['descproducto'] = (string) (float)$ObjetoCarrito->Descproducto;
                if (isset($ObjetoCarrito->Precioconiva)) $carrito[$found_item_index]['precioconiva'] = (string) (float)$ObjetoCarrito->Precioconiva;
            } else if (isset($ObjetoCarrito->opCantidad) && $ObjetoCarrito->opCantidad === '=') {
                // CASO 2: Operación de establecer cantidad (incluye eliminación si new_quantity es 0)
                $carrito[$found_item_index]['cantidad'] = $new_quantity;
            } else { // Asume '+' si no se especifica o es otro valor (+=)
                // CASO 3: Operación de sumar/restar cantidad
                $carrito[$found_item_index]['cantidad'] = $current_quantity + $new_quantity;
            }
            
            // Actualiza siempre las propiedades como precio, descuento, etc. para el ítem encontrado
            if (isset($ObjetoCarrito->Precio)) $carrito[$found_item_index]['precio'] = (string) (float)$ObjetoCarrito->Precio;
            if (isset($ObjetoCarrito->Precio2)) $carrito[$found_item_index]['precio2'] = (string) (float)$ObjetoCarrito->Precio2;
            if (isset($ObjetoCarrito->Descproducto)) $carrito[$found_item_index]['descproducto'] = (string) (float)$ObjetoCarrito->Descproducto;
            if (isset($ObjetoCarrito->Precioconiva)) $carrito[$found_item_index]['precioconiva'] = (string) (float)$ObjetoCarrito->Precioconiva;
            // Solo actualiza IMEI si no es una operación de establecer IMEI
            /*if (isset($ObjetoCarrito->Imei) && (!isset($ObjetoCarrito->opCantidad) || $ObjetoCarrito->opCantidad !== 'IMEI_SET')) {
                $carrito[$found_item_index]['imei'] = (string)$ObjetoCarrito->Imei;
            }*/

        } else {
            // PRODUCTO NO ENCONTRADO EN EL CARRITO (AÑADIR NUEVO)
            if (isset($ObjetoCarrito->Id) && isset($ObjetoCarrito->Codigo) && isset($ObjetoCarrito->Producto) && isset($ObjetoCarrito->Cantidad)) {
                $item_to_add = array(
                    "id"               => (string) $ObjetoCarrito->Id,
                    "txtCodigo"        => (string) $ObjetoCarrito->Codigo,
                    "producto"         => (string) $ObjetoCarrito->Producto,
                    "descripcion"      => (string) ($ObjetoCarrito->Descripcion ?? ''),
                    "opcionvendido"    => (string) ($ObjetoCarrito->OpcionVendido ?? ''),
                    "imei"             => (string) ($ObjetoCarrito->Imei ?? ''),
                    "condicion"        => (string) ($ObjetoCarrito->Condicion ?? ''),
                    "codmarca"         => (string) ($ObjetoCarrito->Codmarca ?? ''),
                    "marca"            => (string) ($ObjetoCarrito->Marca ?? ''),
                    "codmodelo"        => (string) ($ObjetoCarrito->Codmodelo ?? ''),
                    "modelo"           => (string) ($ObjetoCarrito->Modelo ?? ''),
                    "codpresentacion"  => (string) ($ObjetoCarrito->Codpresentacion ?? ''),
                    "presentacion"     => (string) ($ObjetoCarrito->Presentacion ?? ''),
                    "codcolor"         => (string) ($ObjetoCarrito->Codcolor ?? ''),
                    "color"            => (string) ($ObjetoCarrito->Color ?? ''),
                    "precio"           => (string) (float)($ObjetoCarrito->Precio ?? '0.00'),
                    "precio2"          => (string) (float)($ObjetoCarrito->Precio2 ?? '0.00'),
                    "descproducto"     => (string) (float)($ObjetoCarrito->Descproducto ?? '0.00'),
                    "ivaproducto"      => (string) (float)($ObjetoCarrito->Ivaproducto ?? '0.00'),
                    "existencia"       => (string) (float)($ObjetoCarrito->Existencia ?? '0'),
                    "precioconiva"     => (string) (float)($ObjetoCarrito->Precioconiva ?? '0.00'),
                    "tipodetalle"      => (string) ($ObjetoCarrito->TipoDetalle ?? 'producto'),
                    "cantidad"         => (string) (float)($ObjetoCarrito->Cantidad ?? '1')
                );

                if (isset($ObjetoCarrito->opCantidad) && $ObjetoCarrito->opCantidad === 'IMEI_SET' && (float)$item_to_add['cantidad'] <= 0) {
                    $item_to_add['cantidad'] = 1;
                }

                $carrito[] = $item_to_add;
            }
        }

        // LÓGICA DE FILTRADO FINAL: Esto eliminará cualquier ítem con cantidad <= 0
        // SI Y SOLO SI no tiene la opción IMEI 'SI' o si la tiene pero la cantidad es 0 y no es una operación de establecer IMEI
        $carrito = array_values(
            array_filter($carrito, function($item) use ($ObjetoCarrito) {
                // Si el item tiene opcionimei 'SI', pero su cantidad es 0, y la operación NO es IMEI_SET,
                // significa que el usuario lo eliminó, o se quedó sin cantidad y no se le asignó IMEI.
                // En este caso, lo eliminamos.
                if (isset($item['imei']) && $item['imei'] == 'SI') {
                    if ((float)$item['cantidad'] <= 0 && (!isset($ObjetoCarrito->opCantidad) || $ObjetoCarrito->opCantidad !== 'IMEI_SET')) {
                        return false; // Eliminar el ítem con IMEI si su cantidad es 0 y no es una operación IMEI_SET
                    }
                    return true; // Mantener si es IMEI y cantidad > 0 o si es operación IMEI_SET
                }
                // Para items sin IMEI, solo persisten si su cantidad es > 0
                return (isset($item['cantidad']) && (float)$item['cantidad'] > 0);
            })
        );
        
        $_SESSION['CarritoVenta'] = $carrito;
        $response_data = $_SESSION['CarritoVenta'];
    }

} else {
    // Si no se recibió MiCarrito (e.g., petición GET para obtener el carrito actual)
    $response_data = isset($_SESSION['CarritoVenta']) && is_array($_SESSION['CarritoVenta']) ? $_SESSION['CarritoVenta'] : [];
    
    // Aplicar el mismo filtro al obtener el carrito si la sesión ya existe,
    // para asegurar que nunca se envían al front-end items con cantidad 0
    // que deberían haberse eliminado por lógica.
    $response_data = array_values(
        array_filter($response_data, function($item) {
            return (isset($item['cantidad']) && (float)$item['cantidad'] > 0);
        })
    );
}

echo json_encode($response_data);
exit;
?>