<?php
session_start();
header('Content-Type: application/json');

$response_data = [];

if (isset($_POST['MiCarrito'])) {
    $json_data      = $_POST['MiCarrito'];
    $ObjetoCarrito = json_decode($json_data);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['error' => 'Error al decodificar JSON: ' . json_last_error_msg()]);
        exit;
    }

    if (!is_object($ObjetoCarrito)) {
        echo json_encode(['error' => 'Datos de carrito recibidos no son un objeto válido.']);
        exit;
    }

    // Unifica la condición para vaciar el carrito
    if ( (isset($ObjetoCarrito->Id) && $ObjetoCarrito->Id == "vaciar") ||
         (isset($ObjetoCarrito->Codigo) && $ObjetoCarrito->Codigo == "vaciar") ) {
        unset($_SESSION["CarritoProducto"]);
        $_SESSION["CarritoProducto"] = []; // Asegura que el array esté vacío en la sesión
        $response_data = [];
    } else {
        $carrito = isset($_SESSION['CarritoProducto']) && is_array($_SESSION['CarritoProducto']) ? $_SESSION['CarritoProducto'] : [];
        $found_item_index = -1;

        // Extraer y sanear las variables del ObjetoCarrito recibido
        // Se usan valores por defecto para evitar errores si no existen en el objeto
        $id              = (string)($ObjetoCarrito->Id ?? '');
        $txtCodigo       = (string)($ObjetoCarrito->Codigo ?? '');
        $producto        = (string)($ObjetoCarrito->Producto ?? '');
        $opcionvendido   = (string)($ObjetoCarrito->OpcionVendido ?? '');
        $codmarca        = (string)($ObjetoCarrito->Codmarca ?? '');
        $marca           = (string)($ObjetoCarrito->Marca ?? $ObjetoCarrito->Marca ?? '');
        $codmodelo       = (string)($ObjetoCarrito->Codmodelo ?? '');
        $modelo          = (string)($ObjetoCarrito->Modelo ?? $ObjetoCarrito->Modelo ?? '');
        $codpresentacion = (string)($ObjetoCarrito->Codpresentacion ?? '');
        $presentacion    = (string)($ObjetoCarrito->Presentacion ?? $ObjetoCarrito->Presentacion ?? '');
        $precio          = (float)($ObjetoCarrito->Precio ?? '0.00');
        $precio2         = (float)($ObjetoCarrito->Precio2 ?? '0.00');
        $descproducto    = (float)($ObjetoCarrito->Descproducto ?? '0.00');
        $cantidad        = (float)($ObjetoCarrito->Cantidad ?? '1'); // Default a 1 si no se especifica
        $opCantidad      = (string)($ObjetoCarrito->opCantidad ?? '+'); // Default a '+' si no se especifica

        // Buscar el producto en el carrito existente
        for ($i = 0; $i < count($carrito); $i++) {
            // Asegura que las propiedades existan antes de comparar
            if (isset($carrito[$i]['id']) && $id == $carrito[$i]['id'] &&
                isset($carrito[$i]['txtCodigo']) && $txtCodigo == $carrito[$i]['txtCodigo'] &&
                isset($carrito[$i]['producto']) && $producto == $carrito[$i]['producto']) {
                $found_item_index = $i;
                break;
            }
        }

        if ($found_item_index != -1) {
            // PRODUCTO ENCONTRADO EN EL CARRITO (ACTUALIZAR)
            $current_quantity = isset($carrito[$found_item_index]['cantidad']) ? (float)$carrito[$found_item_index]['cantidad'] : 0;

            if ($opCantidad === '=') {
                // Operación de establecer cantidad (incluye eliminación si cantidad es 0)
                $carrito[$found_item_index]['cantidad'] = $cantidad;
            } else { // Asume '+' si no se especifica o es otro valor (+=)
                // Operación de sumar/restar cantidad
                $carrito[$found_item_index]['cantidad'] = $current_quantity + $cantidad;
            }

            // Actualiza siempre las propiedades del ítem encontrado, excepto para IMEI
            $carrito[$found_item_index]['precio']           = (float)$precio;
            $carrito[$found_item_index]['precio2']          = (float)$precio2;
            $carrito[$found_item_index]['descproducto']     = (float)$descproducto;

        } else {
            // PRODUCTO NO ENCONTRADO EN EL CARRITO (AÑADIR NUEVO)
            // Asegúrate de que los datos mínimos existan antes de añadir
            if (!empty($id) && !empty($txtCodigo) && !empty($producto)) {
                $item_to_add = array(
                    "id"              => $id,
                    "txtCodigo"       => $txtCodigo,
                    "producto"        => $producto,
                    "opcionvendido"   => $opcionvendido,
                    "codmarca"        => $codmarca,
                    "marca"           => $marca,
                    "codmodelo"       => $codmodelo,
                    "modelo"          => $modelo,
                    "codpresentacion" => $codpresentacion,
                    "presentacion"    => $presentacion,
                    "precio"          => (float)$precio,
                    "precio2"         => (float)$precio2,
                    "descproducto"    => (float)$descproducto,
                    "cantidad"        => (float)$cantidad
                );

                $carrito[] = $item_to_add;
            }
        }

        // LÓGICA DE FILTRADO FINAL: Eliminar ítems con cantidad <= 0
        // Esta lógica es más simple sin considerar IMEI
        $carrito = array_values(
            array_filter($carrito, function($item) {
                return (isset($item['cantidad']) && (float)$item['cantidad'] > 0);
            })
        );

        $_SESSION['CarritoProducto'] = $carrito;
        $response_data = $_SESSION['CarritoProducto'];
    }

} else {
    // Si no se recibió MiCarrito (e.g., petición GET para obtener el carrito actual)
    $response_data = isset($_SESSION['CarritoProducto']) && is_array($_SESSION['CarritoProducto']) ? $_SESSION['CarritoProducto'] : [];

    // Aplicar el mismo filtro al obtener el carrito si la sesión ya existe,
    // para asegurar que nunca se envían al front-end items con cantidad 0
    $response_data = array_values(
        array_filter($response_data, function($item) {
            return (isset($item['cantidad']) && (float)$item['cantidad'] > 0);
        })
    );
}

echo json_encode($response_data);
exit;
?>