function Separador(val) {
    return String(val).split("").reverse().join("")
    .replace(/(.{3}\B)/g, "$1.")
    .split("").reverse().join("");
}

function DoAction(idproducto, codproducto, producto, descripcion, opcionvendido, imei, condicion, codmarca, marcas, codmodelo, modelos, codpresentacion, presentacion, codcolor, color, preciocompra, precioventa, descproducto, ivaproducto, existencia, precioconiva, tipodetalle) {
    addItem(idproducto, codproducto, 1, producto, descripcion, opcionvendido, imei, condicion, codmarca, marcas, codmodelo, modelos, codpresentacion, presentacion, codcolor, color, preciocompra, precioventa, descproducto, ivaproducto, existencia, precioconiva, tipodetalle, '+=');
}

// ####################### FUNCION PARA MODAL A GRANEL #######################
function DoActionGranel(idproducto, codproducto, cantidad, producto, descripcion, opcionvendido, imei, condicion, codmarca, marcas, codmodelo, modelos, codpresentacion, presentacion, codcolor, color, preciocompra, precioventa, descproducto, ivaproducto, existencia, precioconiva, tipodetalle) 
{
    addItem(idproducto, codproducto, cantidad, producto, descripcion, opcionvendido, imei, condicion, codmarca, marcas, codmodelo, modelos, codpresentacion, presentacion, codcolor, color, preciocompra, precioventa, descproducto, ivaproducto, existencia, precioconiva, tipodetalle, '+=');
}

function CargaModalGranel(id, codigo)
{
    $("#agregagranel #d_id").val(id);
    $("#agregagranel #d_codigo").val(codigo);
    $("#agregagranel #agrega_detalle_granel").load("detalles_productos?BuscaDetallesProductoxGranel=si&d_id="+id+"&d_codigo="+codigo);
}

function CalcularImporte(){
    var cantidad = $('#agregagranel #cantidad').val();
    var precio   = $('#agregagranel #precio').val();

    //CALCULO DEL TOTAL DE IMPORTE
    var TotalImporte   = cantidad*precio;
    $('#importe').val(Math.round(TotalImporte.toFixed(2)));
} 

function CalcularCantidad(){
    var importe = $('#agregagranel #importe').val();
    var precio  = $('#agregagranel #precio').val();

    //CALCULO DE CANTIDAD
    var Cantidad   = importe/precio;
    $('#cantidad').val(Cantidad.toFixed(3));
} 
// ####################### FUNCION PARA MODAL A GRANEL #######################

function pulsar(e, valor) {
    tecla = (document.all) ? e.keyCode : e.which;
    if (tecla == 13) comprueba(valor)
}

$(document).ready(function() {

    /*############ FUNCION DESACTIVA ENTER EN FORMULARIO ############*/
    $('#savetraspaso').keypress(function(e){
        var keycode = (e.keyCode ? e.keyCode : e.which);   
        if (keycode == 13) {
            return false;
        }
    });
    /*############ FUNCION DESACTIVA ENTER EN FORMULARIO ############*/

    /*############ FUNCION AGREGA POR BOTON ############*/
    $('#AgregaProducto').click(function() {
        AgregaProductos();
    });
    /*############ FUNCION AGREGA POR BOTON ############*/

    /*############ FUNCION AGREGA POR CRITERIO ############*/
    $('#cantidad').keypress(function(e) {
        var keycode = (e.keyCode ? e.keyCode : e.which);
        if (keycode == 13) {
          AgregaProductos();
          e.preventDefault();
          return false;
        }
    });
    /*############ FUNCION AGREGA POR CRITERIO ############*/

    /*############ FUNCION AGREGA POR LECTOR ############*/
    $('#search_producto_barra').on('keypress change', function(e) {
    // Si es keypress y no es Enter, o si es change y el campo está vacío, no hacemos nada.
    if (e.type === 'keypress' && e.which !== 13) {
        return;
    }
    if ($(this).val().trim() === "") {
        return; // No procesar si el campo está vacío
    }
    e.preventDefault(); // Previene el submit de formulario si hay uno

    let codeBar  = $(this).val();
    let Impuesto = $('input#iva').val();

    $.ajax({
        url: "class/busqueda_autocompleto.php?Busqueda_Producto_Barcode=si",
        data: {barcode: codeBar},
        type: 'POST',
        dataType: 'json',
        success: function(json) {
            // Verificamos si la respuesta no está vacía
            if (!json || json.length === 0 || JSON.stringify(json[0]) == null) {
                swal("Oops","PRODUCTO NO ENCONTRADO O DATOS INVÁLIDOS.", "warning");
                LimpiarTexto(); // Limpiar campos si no se encuentra el producto
                return false;
            }

            let producto = json[0];

                // Llamada directa a la función que agrega el producto (addItem o DoAction)
                // Reemplaza 'addItem' por el nombre de tu función si es diferente, y asegúrate de que el orden de los parámetros sea el correcto.
                addItem(
                    producto.idproducto,
                    producto.txtCodigo,
                    (producto.opcionvendido == "1") ? 1 : 1.000, // Cantidad, si es siempre 1 para esta acción
                    producto.producto,
                    (producto.descripcion == "") ? "0" : producto.descripcion,
                    producto.opcionvendido,
                    producto.imei,
                    (producto.condicion == "") ? "0" : producto.condicion,
                    producto.codmarca,
                    (producto.codmarca == "0") ? "*****" : producto.nommarca,
                    producto.codmodelo,
                    (producto.codmodelo == "0") ? "*****" : producto.nommodelo,
                    producto.codpresentacion,
                    (producto.codpresentacion == "0") ? "******" : producto.nompresentacion,
                    producto.codcolor,
                    (producto.codcolor == "0") ? "******" : producto.nomcolor,
                    producto.preciocompra,
                    producto.precioxpublico, // precio de venta
                    producto.descproducto,
                    (producto.ivaproducto == "SI") ? Impuesto : "(E)",
                    producto.existencia,
                    (producto.ivaproducto == "SI") ? producto.precioxpublico : "0.00",
                    "1", // tipodetalle, asumiendo que es "1"
                    '+=' // Acción para agregar el producto
                );

                // Opcional: Si quieres limpiar el campo del código de barras después de agregar.
                $("#search_producto_barra").val("").focus();
            },
            error: function(error) {
                swal("Oops", "Ha Ocurrido un Error en el procesamiento de informacion!", "error");
            }
        });
    });
    /*############ FUNCION AGREGA POR LECTOR ############*/

    function AgregaProductos(){

        var code    = $('input#codproducto').val();
        var prod    = $('input#producto').val();
        var cantp   = $('input#cantidad').val();
        var exist   = $('input#existencia').val();
        var prec    = $('input#preciocompra').val();
        var prec2   = $('select#precioventa').val();
        var descuen = $('input#descproducto').val();
        var ivgprod = $('input#ivaproducto').val();
        var er_num  = /^([0-9])*[.]?[0-9]*$/;
        cantp = parseInt(cantp);
        exist = parseInt(exist);
        cantp = cantp;

        if (code == "") {
            $("#search_traspaso").focus();
            $("#search_traspaso").css('border-color', '#ff7676');
            swal("Oops", "POR FAVOR REALICE LA BÚSQUEDA DEL PRODUCTO CORRECTAMENTE!", "error");
            return false;

        } else if(prec2=="" || prec2=="0" || prec2=="0"){
            $("#precioventa").focus();
            $('#precioventa').css('border-color','#ff7676');
            $("#precioventa").val("");
            swal("Oops", "POR FAVOR INGRESE PRECIO DE VENTA VALIDO PARA PRODUCTO!", "error");  
            return false;

        } else if ($('#cantidad').val() == "" || $('#cantidad').val() == "0") {
            $("#cantidad").focus();
            $("#cantidad").css('border-color', '#ff7676');
            swal("Oops", "POR FAVOR INGRESE UNA CANTIDAD VÁLIDA EN TRASPASOS!", "error");
            return false;

        } else if (isNaN($('#cantidad').val())) {
            $("#cantidad").focus();
            $("#cantidad").css('border-color', '#ff7676');
            swal("Oops", "POR FAVOR INGRESE SOLO DIGITOS EN CANTIDAD DE TRASPASOS!", "error");
            return false;
            
       } else if(cantp > exist){
            $("#cantidad").focus();
            $('#cantidad').css('border-color','#ff7676');
            $("#existencia").focus();
            $('#existencia').css('border-color','#ff7676');
            swal("Oops", "LA CANTIDAD DE PRODUCTOS SOLICITADA NO EXISTE EN ALMACEN, VERIFIQUE NUEVAMENTE POR FAVOR!", "error");
            return false;

        } else {

        var Carrito              = new Object();
        Carrito.Id               = $('input#idproducto').val();
        Carrito.Codigo           = $('input#codproducto').val();
        Carrito.Producto         = $('input#producto').val().replace(/[ '"]+/g, ' ');
        Carrito.Descripcion      = $('input#descripcion').val().replace(/[ '"]+/g, ' ');
        Carrito.OpcionVendido    = $('input#opcionvendido').val();
        Carrito.Imei             = $('input#imei').val();
        Carrito.Condicion        = $('input#condicion').val();
        Carrito.Codmarca         = $('input#codmarca').val();
        Carrito.Marcas           = $('input#marcas').val();
        Carrito.Codmodelo        = $('input#codmodelo').val();
        Carrito.Modelos          = $('input#modelos').val();
        Carrito.Codpresentacion  = $('input#codpresentacion').val();
        Carrito.Presentacion     = $('input#presentacion').val();
        Carrito.Codcolor         = $('input#codcolor').val();
        Carrito.Color            = $('input#codcolor').val();
        Carrito.Precio           = $('input#preciocompra').val();
        Carrito.Precio2          = $('select#precioventa').val();
        Carrito.Descproducto     = $('input#descproducto').val();
        Carrito.Ivaproducto      = ($('input#ivaproducto').val() == "SI" ? $('input#iva').val() : "(E)");
        Carrito.Existencia       = $('input#existencia').val();
        Carrito.Precioconiva     = ($('input#ivaproducto').val() == "SI" ? $('select#precioventa').val() : "0");
        Carrito.TipoDetalle      = $('input#tipodetalle').val();
        Carrito.Cantidad         = $('input#cantidad').val();
        Carrito.opCantidad       = '+=';
        var DatosJson = JSON.stringify(Carrito);
        $.post('carritotraspaso.php', {
                MiCarrito: DatosJson
            },
            function(data, textStatus) {
                $("#carrito tbody").html("");
                var contador = 0;
                var TotalDescuento = 0;
                var SubtotalFact = 0;
                var BaseImpIva = 0;
                var BaseImpIva2 = 0;
                var Descontado = 0;
                var TotalIvaGeneral = 0;
                var TotalCompra = 0;

                $.each(data, function(i, item) {
                    var cantsincero = item.cantidad;
                    cantsincero = parseFloat(cantsincero);
                    if (cantsincero != 0) {
                        contador = contador + 1;

                    //VALOR DE CANTIDAD
                    var CantidadItem = (item.opcionvendido == 1) ? parseInt(cantsincero) : cantsincero.toFixed(3);

                    //CALCULO VALOR COMPRA
                    var OperacionCompra= parseFloat(item.precio) * parseFloat(item.cantidad);
                    TotalCompra = parseFloat(TotalCompra) + parseFloat(OperacionCompra);

                    //CALCULO DEL VALOR TOTAL
                    var PrecioVenta = parseFloat(item.precio2);
                    var ValorTotal= parseFloat(item.precio2) * parseFloat(item.cantidad);

                    //CALCULO DEL TOTAL DEL DESCUENTO %
                    var DetalleDescuento = ValorTotal * item.descproducto / 100;
                    TotalDescuento = parseFloat(TotalDescuento) + parseFloat(DetalleDescuento);

                    //OBTENEMOS DESCUENTO INDIVIDUAL POR PRODUCTOS
                    var descsiniva = item.precio2 * item.descproducto / 100;
                    var descconiva = item.precioconiva * item.descproducto / 100;

                    //CALCULO DE BASE IMPONIBLE IVA SIN PORCENTAJE
                    var Operac= parseFloat(item.precio2) - parseFloat(descsiniva);
                    var Operacion= parseFloat(Operac) * parseFloat(item.cantidad);
                    var Subtotal = Operacion.toFixed(2);

                    //CALCULO DE BASE IMPONIBLE IVA CON PORCENTAJE
                    var Operac3 = parseFloat(item.precioconiva) - parseFloat(descconiva);
                    var Operacion3 = parseFloat(Operac3) * parseFloat(item.cantidad);
                    var Subbaseimponiva = Operacion3.toFixed(2);

                    //CALCULO GENERAL DE IVA CON BASE IVA * IVA %
                    var ivg = $('input#iva').val();
                    ivg2  = ivg;

                    //CALCULO VALOR DISCRIMINADO
                    var ValorImpuesto = (ivg2 <= 9) ? "1.0"+parseInt(ivg2) : "1."+parseInt(ivg2);
                    var Discriminado = parseFloat(Operac3) / ValorImpuesto;
                    var SubtotalDiscriminado = parseFloat(Operac3) - parseFloat(Discriminado);
                    var BaseDiscriminado = parseFloat(SubtotalDiscriminado) * parseFloat(item.cantidad);
                    TotalIvaGeneral = parseFloat(TotalIvaGeneral) + parseFloat(BaseDiscriminado);

                    //BASE IMPONIBLE IVA CON PORCENTAJE
                    BaseImpIva = parseFloat(BaseImpIva) + parseFloat(Subbaseimponiva);
                    BaseImpIva1 = parseFloat(BaseImpIva) - parseFloat(TotalIvaGeneral);
                    
                    //BASE IMPONIBLE IVA SIN PORCENTAJE
                    BaseImpIva2 = (item.ivaproducto != "(E)") ? BaseImpIva2 : parseFloat(BaseImpIva2) + parseFloat(Subtotal);
                    
                    //CALCULAMOS DESCUENTO POR PRODUCTO
                    var desc = $('input#descuento').val();
                    desc2  = desc/100;
                
                    //CALCULO DEL TOTAL DE FACTURA
                    SubTotalTxt = parseFloat(BaseImpIva1) + parseFloat(BaseImpIva2);
                    Total = parseFloat(BaseImpIva1) + parseFloat(BaseImpIva2) + parseFloat(TotalIvaGeneral);
                    TotalDescuentoGeneral   = parseFloat(Total.toFixed(2)) * parseFloat(desc2.toFixed(2));
                    TotalFactura   = parseFloat(Total.toFixed(2)) - parseFloat(TotalDescuentoGeneral.toFixed(2));

                    var nuevaFila =
                    "<tr class='warning-element' style='border-left: 2px solid #ff5050 !important; background: #fce3e3;' align='center'>" +
                    "<td>" +
                    '<button class="btn btn-info btn-xs" style="cursor:pointer;border-radius:5px 0px 0px 5px;" onclick="addItem(' +
                    "'" + item.id + "'," +
                    "'" + item.txtCodigo + "'," +
                    "'-1'," +
                    "'" + item.producto + "'," +
                    "'" + item.descripcion + "'," +
                    "'" + item.opcionvendido + "'," +
                    "'" + item.imei + "'," +
                    "'" + item.condicion + "'," +
                    "'" + item.codmarca + "'," +
                    "'" + item.marcas + "'," +
                    "'" + item.codmodelo + "'," +
                    "'" + item.modelos + "'," +
                    "'" + item.codpresentacion + "'," +
                    "'" + item.presentacion + "'," +
                    "'" + item.codcolor + "'," +
                    "'" + item.color + "'," +
                    "'" + item.precio + "', " +
                    "'" + item.precio2 + "', " +
                    "'" + item.descproducto + "', " +
                    "'" + item.ivaproducto + "', " +
                    "'" + item.existencia + "', " +
                    "'" + item.precioconiva + "', " +
                    "'" + item.tipodetalle + "', " +
                    "'-'" +
                    ')"' +
                    " type='button'><span class='fa fa-minus'></span></button>" +
                    "<input type='text' id='" + CantidadItem + "' class='bold' style='width:50px;height:34px;' value='" + CantidadItem + "'>" +
                    '<button class="btn btn-info btn-xs" style="cursor:pointer;border-radius:0px 5px 5px 0px;" onclick="addItem(' +
                    "'" + item.id + "'," +
                    "'" + item.txtCodigo + "'," +
                    "'+1'," +
                    "'" + item.producto + "'," +
                    "'" + item.descripcion + "'," +
                    "'" + item.opcionvendido + "'," +
                    "'" + item.imei + "'," +
                    "'" + item.condicion + "'," +
                    "'" + item.codmarca + "'," +
                    "'" + item.marcas + "'," +
                    "'" + item.codmodelo + "'," +
                    "'" + item.modelos + "'," +
                    "'" + item.codpresentacion + "'," +
                    "'" + item.presentacion + "'," +
                    "'" + item.codcolor + "'," +
                    "'" + item.color + "'," +
                    "'" + item.precio + "', " +
                    "'" + item.precio2 + "', " +
                    "'" + item.descproducto + "', " +
                    "'" + item.ivaproducto + "', " +
                    "'" + item.existencia + "', " +
                    "'" + item.precioconiva + "', " +
                    "'" + item.tipodetalle + "', " +
                    "'+'" +
                    ')"' +
                    " type='button'><span class='fa fa-plus'></span></button></td>" +
                    "<td><strong>" + item.txtCodigo + "</strong></td>" +
                    "<td class='text-left'><h5><strong>" + item.producto + "</strong></h5><small>MARCA (" + (item.marcas == '' || item.marcas == '0' ? '******' : item.marcas) + ") - MODELO (" + (item.modelos == '' ? '****' : item.modelos) + ")</small></td>" +
                    "<td><strong>" + Separador(Math.round(item.precio2)) + "</strong></td>" +
                    "<td><strong>" + Separador(Math.round(ValorTotal.toFixed(2))) + "</td>" +
                    "<td><strong>" + Separador(Math.round(DetalleDescuento.toFixed(2))) + "<sup>" + Separador(Math.round(item.descproducto)) + "%</sup></strong></td>" +
                    "<td><strong>" + item.ivaproducto + "</td>" +
                    "<td><strong>" + Separador(Math.round(Operacion.toFixed(2))) + "</td>" +
                    "<td>" +
                    '<span class="text-danger" title="Eliminar Detalle" style="cursor:pointer;color:#fff;" ' +
                    'onclick="addItem(' +
                    "'" + item.id + "'," +
                    "'" + item.txtCodigo + "'," +
                    "'0'," +
                    "'" + item.producto + "'," +
                    "'" + item.descripcion + "'," +
                    "'" + item.opcionvendido + "'," +
                    "'" + item.imei + "'," +
                    "'" + item.condicion + "'," +
                    "'" + item.codmarca + "'," +
                    "'" + item.marcas + "'," +
                    "'" + item.codmodelo + "'," +
                    "'" + item.modelos + "'," +
                    "'" + item.codpresentacion + "'," +
                    "'" + item.presentacion + "'," +
                    "'" + item.codcolor + "'," +
                    "'" + item.color + "'," +
                    "'" + item.precio + "', " +
                    "'" + item.precio2 + "', " +
                    "'" + item.descproducto + "', " +
                    "'" + item.ivaproducto + "', " +
                    "'" + item.existencia + "', " +
                    "'" + item.precioconiva + "', " +
                    "'" + item.tipodetalle + "', " +
                    "'='" +
                    ')"' +
                    '><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 icon"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg></span>' +
                    "</td>" +
                    "</tr>";
                    $(nuevaFila).appendTo("#carrito tbody");
                            
                        $("#lblsubtotal").text(Separador(Math.round(BaseImpIva1.toFixed(2))));
                        $("#lblsubtotal2").text(Separador(Math.round(BaseImpIva2.toFixed(2))));
                        $("#lbliva").text(Separador(Math.round(TotalIvaGeneral.toFixed(2))));
                        $("#lbldescontado").text(Separador(Math.round(TotalDescuento.toFixed(2))));
                        $("#lbldescuento").text(Separador(Math.round(TotalDescuentoGeneral.toFixed(2))));
                        $("#lbltotal").text(Separador(Math.round(TotalFactura.toFixed(2))));

                        $("#txtsubtotal").val(Math.round(BaseImpIva1.toFixed(2)));
                        $("#txtsubtotal2").val(Math.round(BaseImpIva2.toFixed(2)));
                        $("#txtIva").val(Math.round(TotalIvaGeneral.toFixed(2)));
                        $("#txtdescontado").val(Math.round(TotalDescuento.toFixed(2)));
                        $("#txtDescuento").val(Math.round(TotalDescuentoGeneral.toFixed(2)));
                        $("#txtTotal").val(Math.round(TotalFactura.toFixed(2)));
                        $("#txtTotalCompra").val(Math.round(TotalCompra.toFixed(2)));
                        $("#agregagranel #agrega_detalle_granel").html("");
                        $("#search_traspaso").val("");
                        $('#precioventa').html("<option value=''>-- SIN RESULTADOS --</option>");
                        $("#existencia").val("0");
                        $("#descproducto").val("0");
                        $("#cantidad").val("1");
                    }
                });

                $("#search_traspaso").focus();
                LimpiarTexto();
            },
            "json"
        );
        return false;
    }
}

/* CANCELAR LOS ITEM AGREGADOS EN REGISTRO */
$("#vaciar").click(function() {
    var Carrito             = new Object();
    Carrito.Id              = "vaciar";
    Carrito.Codigo          = "vaciar";
    Carrito.Producto        = "vaciar";
    Carrito.Descripcion     = "vaciar";
    Carrito.OpcionVendido   = "vaciar";
    Carrito.Imei            = "vaciar";
    Carrito.Condicion       = "vaciar";
    Carrito.Codmarca        = "vaciar";
    Carrito.Marcas          = "vaciar";
    Carrito.Codmodelo       = "vaciar";
    Carrito.Modelos         = "vaciar";
    Carrito.Codpresentacion = "vaciar";
    Carrito.Presentacion    = "vaciar";
    Carrito.Codcolor        = "vaciar";
    Carrito.Color           = "vaciar";
    Carrito.Precio          = "0";
    Carrito.Precio2         = "0";
    Carrito.Descproducto    = "0";
    Carrito.Ivaproducto     = "vaciar";
    Carrito.Existencia      = "vaciar";
    Carrito.Precioconiva    = "0";
    Carrito.TipoDetalle     = "vaciar";
    Carrito.Cantidad        = "0";
    var DatosJson           = JSON.stringify(Carrito);
    $.post('carritotraspaso.php', {
            MiCarrito: DatosJson
        },
        function(data, textStatus) {
            $("#carrito tbody").html("");
            var nuevaFila = "<tr class='warning-element' style='border-left: 2px solid #ff5050 !important; background: #fce3e3;'>"+"<td class='text-center' colspan=9><h4>NO HAY DETALLES AGREGADOS</h4></td>"+"</tr>";
            $(nuevaFila).appendTo("#carrito tbody");
            LimpiarTexto();
        },
        "json"
    );
    return false;
});


$(document).ready(function() {
    $('#vaciar').click(function() {
        $("#carrito tbody").html("");
        var nuevaFila = "<tr class='warning-element' style='border-left: 2px solid #ff5050 !important; background: #fce3e3;'>"+"<td class='text-center' colspan=9><h4>NO HAY DETALLES AGREGADOS</h4></td>"+"</tr>";
        $(nuevaFila).appendTo("#carrito tbody");
        $("#savetraspaso")[0].reset();
        $("#muestra_foto").html("<img src='fotos/ninguna.png' width='160' height='170'>");
        $("#lblsubtotal").text("0");
        $("#lblsubtotal2").text("0");
        $("#lbliva").text("0");
        $("#lbldescontado").text("0");
        $("#lbldescuento").text("0");
        $("#lbltotal").text("0");

        $("#txtsubtotal").val("0.00");
        $("#txtsubtotal2").val("0.00");
        $("#txtIva").val("0.00");
        $("#txtdescontado").val("0.00");
        $("#txtDescuento").val("0.00");
        $("#txtTotal").val("0.00");
    });
});

/* CANCELAR LOS ITEM AGREGADOS EN AGREGAR DETALLES */
$("#vaciar2").click(function() {
    var Carrito             = new Object();
    Carrito.Id              = "vaciar";
    Carrito.Codigo          = "vaciar";
    Carrito.Producto        = "vaciar";
    Carrito.Descripcion     = "vaciar";
    Carrito.OpcionVendido   = "vaciar";
    Carrito.Imei            = "vaciar";
    Carrito.Condicion       = "vaciar";
    Carrito.Codmarca        = "vaciar";
    Carrito.Marcas          = "vaciar";
    Carrito.Codmodelo       = "vaciar";
    Carrito.Modelos         = "vaciar";
    Carrito.Codpresentacion = "vaciar";
    Carrito.Presentacion    = "vaciar";
    Carrito.Codcolor        = "vaciar";
    Carrito.Color           = "vaciar";
    Carrito.Precio          = "0";
    Carrito.Precio2         = "0";
    Carrito.Descproducto    = "0";
    Carrito.Ivaproducto     = "vaciar";
    Carrito.Existencia      = "vaciar";
    Carrito.Precioconiva    = "0";
    Carrito.TipoDetalle     = "vaciar";
    Carrito.Cantidad        = "0";
    var DatosJson           = JSON.stringify(Carrito);
    $.post('carritotraspaso.php', {
            MiCarrito: DatosJson
        },
        function(data, textStatus) {
            $("#carrito tbody").html("");
            var nuevaFila = "<tr class='warning-element' style='border-left: 2px solid #ff5050 !important; background: #fce3e3;'>"+"<td class='text-center' colspan=9><h4>NO HAY DETALLES AGREGADOS</h4></td>"+"</tr>";
            $(nuevaFila).appendTo("#carrito tbody");
            LimpiarTexto();
        },
        "json"
    );
    return false;
});

$(document).ready(function() {
    $('#vaciar2').click(function() {
        $("#carrito tbody").html("");
        var nuevaFila = "<tr class='warning-element' style='border-left: 2px solid #ff5050 !important; background: #fce3e3;'>"+"<td class='text-center' colspan=9><h4>NO HAY DETALLES AGREGADOS</h4></td>"+"</tr>";
        $(nuevaFila).appendTo("#carrito tbody");
        $("#agregatraspaso")[0].reset();
        $("#muestra_foto").html("<img src='fotos/ninguna.png' width='160' height='170'>");
        $("#lblsubtotal").text("0");
        $("#lblsubtotal2").text("0");
        $("#lbliva").text("0");
        $("#lbldescontado").text("0");
        $("#lbldescuento").text("0");
        $("#lbltotal").text("0");

        $("#txtsubtotal").val("0.00");
        $("#txtsubtotal2").val("0.00");
        $("#txtIva").val("0.00");
        $("#txtdescontado").val("0.00");
        $("#txtDescuento").val("0.00");
        $("#txtTotal").val("0.00");
    });
});

//FUNCION PARA ACTUALIZAR DESCUENTO EN DETALLE
$(document).ready(function(){
    $('#descproducto').keyup(function(){
        if ($('input#descproducto').val() > 100) { 
            $("#descproducto").val("0.00");
            swal("Oops", "EL DESCUENTO NO PUEDE SER MAYOR A 100%!", "error");
            return false;
        }
    });
});

//FUNCION PARA ACTUALIZAR CALCULO EN FACTURA DE COMPRAS CON DESCUENTO
$(document).ready(function(){
    $('#descuento').keyup(function(){

    if ($('input#descuento').val() > 100) {
          
        $("#descuento").val("0.00");
        swal("Oops", "EL DESCUENTO GLOBAL NO PUEDE SER MAYOR A 100%!", "error");
        //return false;
    }
    
        var txtsubtotal  = $('input#txtsubtotal').val();
        var txtsubtotal2 = $('input#txtsubtotal2').val();
        var txtIva       = $('input#txtIva').val();
        var desc         = $('input#descuento').val();
        descuento        = (desc > 100 ? "0.00" : desc/100);

        //REALIZO EL CALCULO CON EL DESCUENTO INDICADO
        Subtotal = parseFloat(txtsubtotal) + parseFloat(txtsubtotal2) + parseFloat(txtIva); 
        TotalDescuentoGeneral   = parseFloat(Subtotal.toFixed(2)) * parseFloat(descuento.toFixed(2));
        TotalFactura   = parseFloat(Subtotal.toFixed(2)) - parseFloat(TotalDescuentoGeneral.toFixed(2));        
    
        $("#lbldescuento").text(Separador(Math.round(TotalDescuentoGeneral.toFixed(2))));
        $("#lbltotal").text(Separador(Math.round(TotalFactura.toFixed(2))));
        $("#txtDescuento").val(Math.round(TotalDescuentoGeneral.toFixed(2)));
        $("#txtTotal").val(Math.round(TotalFactura.toFixed(2)));
    });
});


//AGREGA DETALLE DE PRODUCTO CON ENTER
$(document).ready(function(){
    $(document).keydown(function(e) {
        var keycode = (e.keyCode ? e.keyCode : e.which);
        
        // Obtener el ID del elemento que tiene el foco (está activo)
        // e.target es el elemento DOM que disparó el evento.
        var targetId = e.target.id; 

        // Verificar si la tecla presionada es ENTER
        if (keycode === 13) {
            
            // Condición para IGNORAR la ejecución
            // Si el foco está en 'search_producto_barra' O en 'search_busqueda', salimos de la función.
            if (targetId === 'search_producto_barra' || targetId === 'search_traspaso') {
                // Al devolver 'true' o no hacer nada, permitimos que el navegador maneje el Enter por defecto
                // (que en estos campos probablemente significa disparar la búsqueda/agregar).
                return; // O puedes usar return true;
            }
            // Lógica que SÍ queremos ejecutar solo si el foco NO está en los campos anteriores.
            $('#AgregaProducto').trigger("click");
            
            // Previene la acción por defecto del Enter (como enviar un formulario) en el resto del documento.
            return false; 
        }
    });
});

//MUESTRO MODAL DE PAGO CON F2
$(document).ready(function(){
    $(document).keydown(function(e) {        
        var keycode = (e.keyCode ? e.keyCode : e.which);
        if (keycode == '113') {
        $("#btn-submit").trigger("click");
        return false;
        }
    });                    
});


//LIMPIO VALORES DE FORMULARIO CON F4
$(document).ready(function(){
    $(document).keydown(function(e) {        
        var keycode = (e.keyCode ? e.keyCode : e.which);
        var button = $('#buttonpago').is(':disabled'); 
        if (keycode == '115') {
            $('#vaciar').trigger("click");
            return false;
        }
    });                    
});

function LimpiarTexto(){
    $("#search_producto_barra").val("");
    $("#search_traspaso").val("");
    $("#idproducto").val("");
    $("#codproducto").val("");
    $("#producto").val("");
    $("#descripcion").val("");
    $("#opcionvendido").val("");
    $("#imei").val("");
    $("#condicion").val("");
    $("#codmarca").val("");
    $("#marcas").val("");
    $("#codmodelo").val("");
    $("#modelos").val("");
    $("#codpresentacion").val("");
    $("#presentacion").val("");
    $("#codcolor").val("");
    $("#color").val("");
    $("#preciocompra").val("");
    $('#precioventa').html("<option value=''>-- SIN RESULTADOS --</option>");
    $("#descproducto").val("");
    $("#ivaproducto").val("");
    $("#existencia").val("");
    $("#precioconiva").val("");
    $("#tipodetalle").val("1");
    $("#cantidad").val("1");
    $("#agregagranel #agrega_detalle_granel").html("");
    $("#muestra_foto").html("<img src='fotos/ninguna.png' width='160' height='170'>");
}

$("#carrito tbody").on('blur', 'input', function(e) {
    var element = $(this);
    var pvalue = element.val();
    /*var code = e.charCode || e.keyCode;
    var avalue = String.fromCharCode(code);*/
    var regx = /^[A-Za-z0-9 _.-]+$/;
    var action = element.siblings('button').first().attr('onclick');
    var params;
    //if (code !== 16 && /[^\d]/ig.test(avalue)) {
    if (!regx.test(e.charCode) || !regx.test(e.keyCode)){
        e.preventDefault();
        return;
    }
    if (element.attr('data-proc') == '1') {
        return true;
    }
    element.attr('data-proc', '1');
    params = action.match(/\'([^\']+)\'/g).map(function(v) {
        return v.replace(/\'/g, '');
    });
    setTimeout(function() {
        if (element.attr('data-proc') == '1') {
            var value = element.val() || 0;
            addItem(
                params[0],
                params[1],
                value,
                params[3],
                params[4],
                params[5],
                params[6],
                params[7],
                params[8],
                params[9],
                params[10],
                params[11],
                params[12],
                params[13],
                params[14],
                params[15],
                params[16],
                params[17],
                params[18],
                params[19],
                params[20],
                params[21],
                params[22],
                '='
            );
            element.attr('data-proc', '0');
            }
        }, 100);
    });
});

function addItem(id, codigo, cantidad, producto, descripcion, opcionvendido, imei, condicion, codmarca, marcas, codmodelo, modelos, codpresentacion, presentacion, codcolor, color, precio, precio2, descproducto, ivaproducto, existencia, precioconiva, tipodetalle, opCantidad) {

    var Carrito             = new Object();
    Carrito.Id              = id;
    Carrito.Codigo          = codigo;
    Carrito.Producto        = producto;
    Carrito.Descripcion     = descripcion;
    Carrito.OpcionVendido   = opcionvendido;
    Carrito.Imei            = imei;
    Carrito.Condicion       = condicion;
    Carrito.Codmarca        = codmarca;
    Carrito.Marcas          = marcas;
    Carrito.Codmodelo       = codmodelo;
    Carrito.Modelos         = modelos;
    Carrito.Codpresentacion = codpresentacion;
    Carrito.Presentacion    = presentacion;
    Carrito.Codcolor        = codcolor;
    Carrito.Color           = color;
    Carrito.Precio          = precio;
    Carrito.Precio2         = precio2;
    Carrito.Descproducto    = descproducto;
    Carrito.Ivaproducto     = ivaproducto;
    Carrito.Existencia      = existencia;
    Carrito.Precioconiva    = precioconiva;
    Carrito.TipoDetalle     = tipodetalle;
    Carrito.Cantidad        = cantidad;
    Carrito.opCantidad      = opCantidad;
    var DatosJson           = JSON.stringify(Carrito);
    $.post('carritotraspaso.php', {
            MiCarrito: DatosJson
        },
        function(data, textStatus) {
            $("#carrito tbody").html("");
            var contador = 0;
            var TotalDescuento = 0;
            var SubtotalFact = 0;
            var BaseImpIva = 0;
            var BaseImpIva2 = 0;
            var Descontado = 0;
            var TotalIvaGeneral = 0;
            var TotalCompra = 0;

            $.each(data, function(i, item) {
                var cantsincero = item.cantidad;
                cantsincero = parseFloat(cantsincero);
                if (cantsincero != 0) {
                    contador = contador + 1;

                //VALOR DE CANTIDAD
                var CantidadItem = (item.opcionvendido == 1) ? parseInt(cantsincero) : cantsincero.toFixed(3);

                //CALCULO VALOR COMPRA
                var OperacionCompra= parseFloat(item.precio) * parseFloat(item.cantidad);
                TotalCompra = parseFloat(TotalCompra) + parseFloat(OperacionCompra);

                //CALCULO DEL VALOR TOTAL
                var PrecioVenta = parseFloat(item.precio2);
                var ValorTotal= parseFloat(item.precio2) * parseFloat(item.cantidad);

                //CALCULO DEL TOTAL DEL DESCUENTO %
                var DetalleDescuento = ValorTotal * item.descproducto / 100;
                TotalDescuento = parseFloat(TotalDescuento) + parseFloat(DetalleDescuento);

                //OBTENEMOS DESCUENTO INDIVIDUAL POR PRODUCTOS
                var descsiniva = item.precio2 * item.descproducto / 100;
                var descconiva = item.precioconiva * item.descproducto / 100;

                //CALCULO DE BASE IMPONIBLE IVA SIN PORCENTAJE
                var Operac= parseFloat(item.precio2) - parseFloat(descsiniva);
                var Operacion= parseFloat(Operac) * parseFloat(item.cantidad);
                var Subtotal = Operacion.toFixed(2);

                //CALCULO DE BASE IMPONIBLE IVA CON PORCENTAJE
                var Operac3 = parseFloat(item.precioconiva) - parseFloat(descconiva);
                var Operacion3 = parseFloat(Operac3) * parseFloat(item.cantidad);
                var Subbaseimponiva = Operacion3.toFixed(2);

                //CALCULO GENERAL DE IVA CON BASE IVA * IVA %
                var ivg = $('input#iva').val();
                ivg2  = ivg;

                //CALCULO VALOR DISCRIMINADO
                var ValorImpuesto = (ivg2 <= 9) ? "1.0"+parseInt(ivg2) : "1."+parseInt(ivg2);
                var Discriminado = parseFloat(Operac3) / ValorImpuesto;
                var SubtotalDiscriminado = parseFloat(Operac3) - parseFloat(Discriminado);
                var BaseDiscriminado = parseFloat(SubtotalDiscriminado) * parseFloat(item.cantidad);
                TotalIvaGeneral = parseFloat(TotalIvaGeneral) + parseFloat(BaseDiscriminado);

                //BASE IMPONIBLE IVA CON PORCENTAJE
                BaseImpIva = parseFloat(BaseImpIva) + parseFloat(Subbaseimponiva);
                BaseImpIva1 = parseFloat(BaseImpIva) - parseFloat(TotalIvaGeneral);
                
                //BASE IMPONIBLE IVA SIN PORCENTAJE
                BaseImpIva2 = (item.ivaproducto != "(E)") ? BaseImpIva2 : parseFloat(BaseImpIva2) + parseFloat(Subtotal);
                
                //CALCULAMOS DESCUENTO POR PRODUCTO
                var desc = $('input#descuento').val();
                desc2  = desc/100;
            
                //CALCULO DEL TOTAL DE FACTURA
                SubTotalTxt = parseFloat(BaseImpIva1) + parseFloat(BaseImpIva2);
                Total = parseFloat(BaseImpIva1) + parseFloat(BaseImpIva2) + parseFloat(TotalIvaGeneral);
                TotalDescuentoGeneral   = parseFloat(Total.toFixed(2)) * parseFloat(desc2.toFixed(2));
                TotalFactura   = parseFloat(Total.toFixed(2)) - parseFloat(TotalDescuentoGeneral.toFixed(2));

                var nuevaFila =
                "<tr class='warning-element' style='border-left: 2px solid #ff5050 !important; background: #fce3e3;' align='center'>" +
                "<td>" +
                '<button class="btn btn-info btn-xs" style="cursor:pointer;border-radius:5px 0px 0px 5px;" onclick="addItem(' +
                "'" + item.id + "'," +
                "'" + item.txtCodigo + "'," +
                "'-1'," +
                "'" + item.producto + "'," +
                "'" + item.descripcion + "'," +
                "'" + item.opcionvendido + "'," +
                "'" + item.imei + "'," +
                "'" + item.condicion + "'," +
                "'" + item.codmarca + "'," +
                "'" + item.marcas + "'," +
                "'" + item.codmodelo + "'," +
                "'" + item.modelos + "'," +
                "'" + item.codpresentacion + "'," +
                "'" + item.presentacion + "'," +
                "'" + item.codcolor + "'," +
                "'" + item.color + "'," +
                "'" + item.precio + "', " +
                "'" + item.precio2 + "', " +
                "'" + item.descproducto + "', " +
                "'" + item.ivaproducto + "', " +
                "'" + item.existencia + "', " +
                "'" + item.precioconiva + "', " +
                "'" + item.tipodetalle + "', " +
                "'-'" +
                ')"' +
                " type='button'><span class='fa fa-minus'></span></button>" +
                "<input type='text' id='" + CantidadItem + "' class='bold' style='width:50px;height:34px;' value='" + CantidadItem + "'>" +
                '<button class="btn btn-info btn-xs" style="cursor:pointer;border-radius:0px 5px 5px 0px;" onclick="addItem(' +
                "'" + item.id + "'," +
                "'" + item.txtCodigo + "'," +
                "'+1'," +
                "'" + item.producto + "'," +
                "'" + item.descripcion + "'," +
                "'" + item.opcionvendido + "'," +
                "'" + item.imei + "'," +
                "'" + item.condicion + "'," +
                "'" + item.codmarca + "'," +
                "'" + item.marcas + "'," +
                "'" + item.codmodelo + "'," +
                "'" + item.modelos + "'," +
                "'" + item.codpresentacion + "'," +
                "'" + item.presentacion + "'," +
                "'" + item.codcolor + "'," +
                "'" + item.color + "'," +
                "'" + item.precio + "', " +
                "'" + item.precio2 + "', " +
                "'" + item.descproducto + "', " +
                "'" + item.ivaproducto + "', " +
                "'" + item.existencia + "', " +
                "'" + item.precioconiva + "', " +
                "'" + item.tipodetalle + "', " +
                "'+'" +
                ')"' +
                " type='button'><span class='fa fa-plus'></span></button></td>" +
                "<td><strong>" + item.txtCodigo + "</strong></td>" +
                "<td class='text-left'><h5><strong>" + item.producto + "</strong></h5><small>MARCA (" + (item.marcas == '' || item.marcas == '0' ? '******' : item.marcas) + ") - MODELO (" + (item.modelos == '' ? '****' : item.modelos) + ")</small></td>" +
                "<td><strong>" + Separador(Math.round(item.precio2)) + "</strong></td>" +
                "<td><strong>" + Separador(Math.round(ValorTotal.toFixed(2))) + "</strong></td>" +
                "<td><strong>" + Separador(Math.round(DetalleDescuento.toFixed(2))) + "<sup>" + Separador(Math.round(item.descproducto)) + "%</sup></strong></td>" +
                "<td><strong>" + item.ivaproducto + "</strong></td>" +
                "<td><strong>" + Separador(Math.round(Operacion.toFixed(2))) + "</strong></td>" +
                "<td>" +
                '<span class="text-danger" title="Eliminar Detalle" style="cursor:pointer;color:#fff;" ' +
                'onclick="addItem(' +
                "'" + item.id + "'," +
                "'" + item.txtCodigo + "'," +
                "'0'," +
                "'" + item.producto + "'," +
                "'" + item.descripcion + "'," +
                "'" + item.opcionvendido + "'," +
                "'" + item.imei + "'," +
                "'" + item.condicion + "'," +
                "'" + item.codmarca + "'," +
                "'" + item.marcas + "'," +
                "'" + item.codmodelo + "'," +
                "'" + item.modelos + "'," +
                "'" + item.codpresentacion + "'," +
                "'" + item.presentacion + "'," +
                "'" + item.codcolor + "'," +
                "'" + item.color + "'," +
                "'" + item.precio + "', " +
                "'" + item.precio2 + "', " +
                "'" + item.descproducto + "', " +
                "'" + item.ivaproducto + "', " +
                "'" + item.existencia + "', " +
                "'" + item.precioconiva + "', " +
                "'" + item.tipodetalle + "', " +
                "'='" +
                ')"' +
                '><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 icon"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg></span>' +
                "</td>" +
                "</tr>";
                $(nuevaFila).appendTo("#carrito tbody");
                                    
                    $("#lblsubtotal").text(Separador(Math.round(BaseImpIva1.toFixed(2))));
                    $("#lblsubtotal2").text(Separador(Math.round(BaseImpIva2.toFixed(2))));
                    $("#lbliva").text(Separador(Math.round(TotalIvaGeneral.toFixed(2))));
                    $("#lbldescontado").text(Separador(Math.round(TotalDescuento.toFixed(2))));
                    $("#lbldescuento").text(Separador(Math.round(TotalDescuentoGeneral.toFixed(2))));
                    $("#lbltotal").text(Separador(Math.round(TotalFactura.toFixed(2))));

                    $("#txtsubtotal").val(Math.round(BaseImpIva1.toFixed(2)));
                    $("#txtsubtotal2").val(Math.round(BaseImpIva2.toFixed(2)));
                    $("#txtIva").val(Math.round(TotalIvaGeneral.toFixed(2)));
                    $("#txtdescontado").val(Math.round(TotalDescuento.toFixed(2)));
                    $("#txtDescuento").val(Math.round(TotalDescuentoGeneral.toFixed(2)));
                    $("#txtTotal").val(Math.round(TotalFactura.toFixed(2)));
                    $("#txtTotalCompra").val(Math.round(TotalCompra.toFixed(2)));
                    $("#agregagranel #agrega_detalle_granel").html("");
                    $("#search_traspaso").val("");
                    $('#precioventa').html("<option value=''>-- SIN RESULTADOS --</option>");
                    $("#existencia").val("0");
                    $("#descproducto").val("0");
                    $("#cantidad").val("1");
                }
            });
            if (contador == 0) {

                $("#carrito tbody").html("");

                var nuevaFila =
                "<tr class='warning-element' style='border-left: 2px solid #ff5050 !important; background: #fce3e3;'>"+"<td class='text-center' colspan=9><h4>NO HAY DETALLES AGREGADOS</h4></td>"+"</tr>";
                $(nuevaFila).appendTo("#carrito tbody");

                //alert("ELIMINAMOS TODOS LOS SUBTOTAL Y TOTALES");
                $("#savetraspaso")[0].reset();
                $("#lblsubtotal").text("0.00");
                $("#lblsubtotal2").text("0.00");
                $("#lbliva").text("0.00");
                $("#lbldescontado").text("0.00");
                $("#lbldescuento").text("0.00");
                $("#lbltotal").text("0.00");
                
                $("#txtsubtotal").val("0.00");
                $("#txtsubtotal2").val("0.00");
                $("#txtIva").val("0.00");
                $("#txtdescontado").val("0.00");
                $("#txtDescuento").val("0.00");
                $("#txtTotal").val("0.00");
                $("#txtTotalCompra").val("0.00");
            }
        },
        "json"
    );
    return false;
}