/*Author: Ing. Ruben D. Chirinos R. Tlf: +58 0416-3422924, email: elsaiya@gmail.com*/

/*tipos de graficos
    bar
    horizontalBar
    line
    radar
    polarArea
    pie
    doughnut
    bubble
 Con pointRadius podrs establecer el radio del punto.

fill: false, > no aparecer relleno por debajo de la lnea.

showLine: false, > no aparecer la lnea.

Es decir, si ponemos fill y showLine a false, tendremos un grfico de puntos, en lugar de un grfico
de lneas. pointStyle: circle, triangle, rect, rectRounded, rectRot, cross, crossRot, star,
line, and dash Podra ser incluso una imagen.

spanGaps est por defecto a false. Si lo ponemos a true, cuando te falte un valor en la lnea, no se 
romper la lnea.*/

// Variables globales para todas las instancias de grficos
window.myBarChartActividadSucursalesInstance       = null;
window.myBarChartTraspasosMensualesInstance        = null;
window.myBarChartPedidosMensualesInstance          = null;
window.myBarChartComprasMensualesInstance          = null;
window.myBarChartCotizacionesMensualesInstance     = null;
window.myBarChartPreventasMensualesInstance        = null;
window.myBarChartVentasMensualesInstance           = null;
window.myDoughnutChartComprasxProveedorInstance    = null; // Variable global NICA para este grfico
window.myDoughnutChartVentasxUsuariosInstance      = null; 
window.myDoughnutChartProductosMasVendidosInstance = null;
window.myLineChartVentasDiariasInstance            = null; 
// Agrega aqu cualquier otra variable global que necesites para otras graficas


/*############ GRAFICO DE COMPRAS, COTIZACIONES Y VENTAS POR SUCURSAL #############*/
function showGraphBarS() {
    const canvasId           = 'barChart'; // ID del canvas
    const messageContainerId = 'no-data-message-sucursales'; // ID del contenedor del mensaje
    const chartTitle         = 'Actividad por Sucursal (Compras, Cotizaciones, Ventas)';
    const dataParam          = 'ProcesosxSucursales=si'; // Parmetro GET para tu data.php

    const graphTarget       = $("#" + canvasId);
    const messageContainer  = $("#" + messageContainerId);

    graphTarget.show();
    messageContainer.hide().html('');

    const colors = {
        compras: {
            backgroundColor: 'rgba(255, 99, 132, 0.7)', // Rojo suave
            borderColor: 'rgba(255, 99, 132, 1)'
        },
        cotizaciones: {
            backgroundColor: 'rgba(54, 162, 235, 0.7)', // Azul suave
            borderColor: 'rgba(54, 162, 235, 1)'
        },
        ventas: {
            backgroundColor: 'rgba(75, 192, 192, 0.7)', // Verde azulado suave
            borderColor: 'rgba(75, 192, 192, 1)'
        }
    };

    $.post("data.php?" + dataParam, function (data) {
        if (window.myBarChartActividadSucursalesInstance instanceof Chart) {
            window.myBarChartActividadSucursalesInstance.destroy();
            window.myBarChartActividadSucursalesInstance = null;
        }

        let sucursalNames = [];
        let sumCompras = [];
        let sumCotizacion = [];
        let sumVentas = [];
        
        if (data && data.length > 0) {
            for (let i in data) { // Usamos 'let' para 'i' por buenas prcticas en bucles for...in
                sucursalNames.push(data[i].nomsucursal);
                sumCompras.push(parseFloat(data[i].sumcompras) || 0);
                sumCotizacion.push(parseFloat(data[i].sumcotizacion) || 0);
                sumVentas.push(parseFloat(data[i].sumventas) || 0);
            }
        }

        const isDataEffectivelyEmpty = !data || data.length === 0 || 
                                     (sumCompras.every(val => val === 0) &&
                                      sumCotizacion.every(val => val === 0) &&
                                      sumVentas.every(val => val === 0));

        if (isDataEffectivelyEmpty) {
            console.warn(`No se recibieron datos o todos los datos son cero para la grafica de ${chartTitle}. Mostrando mensaje.`);
            graphTarget.hide();
            messageContainer.html(`<br><p class="alert alert-info text-center">NO HAY DATOS DE ACTIVIDAD POR SUCURSAL PARA MOSTRAR.</p>`).show();
            return;
        }

        // Si llegamos aqu, s hay datos significativos, procedemos a dibujar la grafica.
        var chartdata = {
            labels: sucursalNames,
            datasets: [
                {
                    label: "Compras",
                    backgroundColor: colors.compras.backgroundColor,
                    borderColor: colors.compras.borderColor,
                    borderWidth: 1,
                    data: sumCompras
                },
                {
                    label: "Cotizaciones",
                    backgroundColor: colors.cotizaciones.backgroundColor,
                    borderColor: colors.cotizaciones.borderColor,
                    borderWidth: 1,
                    data: sumCotizacion
                },
                {
                    label: "Ventas",
                    backgroundColor: colors.ventas.backgroundColor,
                    borderColor: colors.ventas.borderColor,
                    borderWidth: 1,
                    data: sumVentas
                }
            ]
        };

        // Opciones de Configuracin de Chart.js (sin cambios, ya estn bien)
        var options = {
            responsive: true,
            maintainAspectRatio: false,
            animation: { duration: 1000 },
            plugins: {
                title: { display: true, text: chartTitle, font: { size: 18 } },
                legend: { display: true, position: 'top', labels: { font: { size: 12 } } },
                tooltip: {
                    mode: 'index', intersect: false,
                    callbacks: {
                        label: function(tooltipItem, data) {
                            var label = tooltipItem.dataset.label || '';
                            if (label) { label += ': '; }
                            return label + new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(tooltipItem.raw);
                            //return label + new Intl.NumberFormat('es-VE', { style: 'currency', currency: 'VES' }).format(tooltipItem.raw);
                            //return label + new Intl.NumberFormat('es-GT', { style: 'currency', currency: 'GTQ' }).format(tooltipItem.raw);
                            //return label + new Intl.NumberFormat('es-EC', { style: 'currency', currency: 'USD' }).format(tooltipItem.raw);
                            //return label + new Intl.NumberFormat('es-CO', { style: 'currency', currency: 'COP' }).format(tooltipItem.raw);
                            //return label + new Intl.NumberFormat('es-MX', { style: 'currency', currency: 'MXN' }).format(tooltipItem.raw);
                        }
                    },
                    backgroundColor: 'rgba(0,0,0,0.8)', titleFontColor: '#fff', bodyFontColor: '#fff'
                }
            },
            scales: {
                x: { display: true, title: { display: true, text: 'Sucursal' }, grid: { display: false } },
                y: {
                    display: true, title: { display: true, text: 'Monto Total' },
                    ticks: {
                        beginAtZero: true,
                        callback: function(value, index, values) {
                            return new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(value);
                        }
                    }
                }
                // Si quieres barras apiladas (stacked bars), aade 'stacked: true' aqu y en el eje X:
                // y: { stacked: true, ... },
                // x: { stacked: true, ... }
            }
        };

        // Almacenar la instancia del grfico en su variable global NICA
        window.myBarChartActividadSucursalesInstance = new Chart(graphTarget, {
            type: 'bar',
            data: chartdata,
            options: options
        });

    }).fail(function(jqXHR, textStatus, errorThrown) {
        // Manejo de errores de la llamada AJAX
        console.error(`Error al cargar los datos de ${chartTitle}:`, textStatus, errorThrown);
        // Destruir cualquier instancia de ESTE grfico si hay un error AJAX
        if (window.myBarChartActividadSucursalesInstance instanceof Chart) {
            window.myBarChartActividadSucursalesInstance.destroy();
            window.myBarChartActividadSucursalesInstance = null;
        }
        graphTarget.hide(); // Oculta el canvas
        messageContainer.html(`<p class="text-danger text-center">Error al cargar la grafica por sucursales. Intntelo de nuevo ms tarde.</p>`).show();
    });
}
/*############ GRAFICO DE COMPRAS, COTIZACIONES Y VENTAS POR SUCURSAL #############*/


/*############ GRAFICO DE TRASPASOS POR MESES #############*/
function showGraphBarTraspasosMensuales() {
    const canvasId           = 'bar-chart-traspasos';
    const messageContainerId = 'no-data-message-traspasos';
    const chartTitle         = 'Suma de Traspasos Mensuales';
    const dataParam          = 'TraspasosMensuales=si'; // Asegrate de que tu data.php responda a esto
    const dataLabel          = 'Monto Traspasos';
    const backgroundColors   = ["#ff7676", "#3e95cd", "#808080", "#F38630", "#25AECD", "#008080", "#00FFFF", "#3cba9f", "#2E64FE", "#e8c3b9", "#F7BE81", "#FA5858"];
    const borderColors       = backgroundColors; // Puedes usar los mismos para el borde

    $('#' + canvasId).show();
    $('#' + messageContainerId).hide().html('');

    const monthLabels = ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"];

    $.post("data.php?" + dataParam, function (data) {
        if (window.myBarChartTraspasosMensualesInstance instanceof Chart) {
            window.myBarChartTraspasosMensualesInstance.destroy();
            window.myBarChartTraspasosMensualesInstance = null;
        }

        const isDataEffectivelyEmpty = !data || data.length === 0 || (Array.isArray(data) && data.every(val => parseFloat(val) === 0));

        if (isDataEffectivelyEmpty) {
            console.warn(`No hay datos o todos los datos son cero para ${chartTitle}. Mostrando mensaje.`);
            $('#' + canvasId).hide();
            $('#' + messageContainerId).html(`<br><p class="alert alert-info text-center">NO HAY DATOS DE TRASPASOS PARA MOSTRAR.</p>`).show();
            return;
        }

        let chartDataValues = data.map(value => parseFloat(value) || 0);
        if (chartDataValues.length !== 12) {
            let tempArray = new Array(12).fill(0);
            for(let i = 0; i < Math.min(chartDataValues.length, 12); i++) { tempArray[i] = chartDataValues[i]; }
            chartDataValues = tempArray;
        }

        var chartdata = {
            labels: monthLabels,
            datasets: [{
                label: dataLabel,
                backgroundColor: backgroundColors,
                borderColor: borderColors,
                borderWidth: 1,
                data: chartDataValues
            }]
        };

        var graphTarget = $('#' + canvasId);
        // Opciones de Chart.js (sin cambios, ya que manejan valores cero bien)
        var options = {
            responsive: true, maintainAspectRatio: false, animation: { duration: 1000 },
            plugins: {
                title: { display: true, text: 'Suma de Traspasos Mensuales', font: { size: 18 } },
                legend: { display: false },
                tooltip: {
                    mode: 'index', intersect: false,
                    callbacks: {
                        label: function(tooltipItem, data) {
                            var label = tooltipItem.dataset.label || '';
                            if (label) { label += ': '; }
                            return label + new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(tooltipItem.raw);
                        }
                    },
                    backgroundColor: 'rgba(0,0,0,0.8)', titleFontColor: '#fff', bodyFontColor: '#fff'
                }
            },
            scales: {
                x: { display: true, title: { display: true, text: 'Mes del Year' }, grid: { display: false } },
                y: {
                    display: true, title: { display: true, text: 'Monto de Traspaso' },
                    ticks: {
                        beginAtZero: true,
                        callback: function(value, index, values) {
                            return new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(value);
                        }
                    }
                }
            }
        };
        
        window.myBarChartTraspasosMensualesInstance = new Chart(graphTarget, { type: 'bar', data: chartdata, options: options });
    }).fail(function(jqXHR, textStatus, errorThrown) {
        console.error(`Error al cargar los datos para ${chartTitle}:`, textStatus, errorThrown);
        if (window.myBarChartTraspasosMensualesInstance instanceof Chart) {
            window.myBarChartTraspasosMensualesInstance.destroy();
            window.myBarChartTraspasosMensualesInstance = null;
        }
        $('#' + canvasId).hide();
        $('#' + messageContainerId).html(`<p class="text-danger text-center">Error al cargar la grafica de ${dataLabel}. Intntelo de nuevo ms tarde.</p>`).show();
    });
}
/*############ GRAFICO DE TRASPASOS POR MESES #############*/


/*############ GRAFICO DE PEDIDOS POR MESES #############*/
function showGraphBarPedidosMensuales() {
    const canvasId           = 'bar-chart-pedidos';
    const messageContainerId = 'no-data-message-pedidos';
    const chartTitle         = 'Suma de Pedidos a Proveedores Mensuales';
    const dataParam          = 'PedidosMensuales=si'; // Ajusta esto en tu data.php
    const dataLabel          = 'Monto Pedidos';
    const backgroundColors   = ["#ff7676", "#008080", "#00FFFF", "#3cba9f", "#2E64FE", "#e8c3b9", "#F7BE81", "#FA5858", "#3e95cd", "#808080", "#F38630", "#25AECD"];
    const borderColors       = backgroundColors;

    $('#' + canvasId).show();
    $('#' + messageContainerId).hide().html('');

    const monthLabels = ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"];

    $.post("data.php?" + dataParam, function (data) {
        if (window.myBarChartPedidosMensualesInstance instanceof Chart) {
            window.myBarChartPedidosMensualesInstance.destroy();
            window.myBarChartPedidosMensualesInstance = null;
        }

        const isDataEffectivelyEmpty = !data || data.length === 0 || (Array.isArray(data) && data.every(val => parseFloat(val) === 0));

        if (isDataEffectivelyEmpty) {
            console.warn(`No hay datos o todos los datos son cero para ${chartTitle}. Mostrando mensaje.`);
            $('#' + canvasId).hide();
            $('#' + messageContainerId).html(`<br><p class="alert alert-info text-center">NO HAY DATOS DE PEDIDOS PARA MOSTRAR.</p>`).show();
            return;
        }

        let chartDataValues = data.map(value => parseFloat(value) || 0);
        if (chartDataValues.length !== 12) {
            let tempArray = new Array(12).fill(0);
            for(let i = 0; i < Math.min(chartDataValues.length, 12); i++) { tempArray[i] = chartDataValues[i]; }
            chartDataValues = tempArray;
        }

        var chartdata = { labels: monthLabels, datasets: [{ label: dataLabel, backgroundColor: backgroundColors, borderColor: borderColors, borderWidth: 1, data: chartDataValues }] };
        var graphTarget = $('#' + canvasId);
        // Opciones de Chart.js (sin cambios, ya que manejan valores cero bien)
        var options = {
            responsive: true, maintainAspectRatio: false, animation: { duration: 1000 },
            plugins: {
                title: { display: true, text: 'Suma de Pedidos Mensuales', font: { size: 18 } },
                legend: { display: false },
                tooltip: {
                    mode: 'index', intersect: false,
                    callbacks: {
                        label: function(tooltipItem, data) {
                            var label = tooltipItem.dataset.label || '';
                            if (label) { label += ': '; }
                            return label + new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(tooltipItem.raw);
                        }
                    },
                    backgroundColor: 'rgba(0,0,0,0.8)', titleFontColor: '#fff', bodyFontColor: '#fff'
                }
            },
            scales: {
                x: { display: true, title: { display: true, text: 'Mes del Year' }, grid: { display: false } },
                y: {
                    display: true, title: { display: true, text: 'Monto de Pedido' },
                    ticks: {
                        beginAtZero: true,
                        callback: function(value, index, values) {
                            return new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(value);
                        }
                    }
                }
            }
        };
        
        window.myBarChartPedidosMensualesInstance = new Chart(graphTarget, { type: 'bar', data: chartdata, options: options });
    }).fail(function(jqXHR, textStatus, errorThrown) {
        console.error(`Error al cargar los datos para ${chartTitle}:`, textStatus, errorThrown);
        if (window.myBarChartPedidosMensualesInstance instanceof Chart) {
            window.myBarChartPedidosMensualesInstance.destroy();
            window.myBarChartPedidosMensualesInstance = null;
        }
        $('#' + canvasId).hide();
        $('#' + messageContainerId).html(`<p class="text-danger text-center">Error al cargar la grafica de ${dataLabel}. Intntelo de nuevo ms tarde.</p>`).show();
    });
}
/*############ GRAFICO DE PEDIDOS POR MESES #############*/

/*############ GRAFICO DE COMPRAS POR MESES #############*/
function showGraphBarComprasMensuales() {
    const canvasId           = 'bar-chart-compras';
    const messageContainerId = 'no-data-message-compras';
    const chartTitle         = 'Suma de Compras Mensuales';
    const dataParam          = 'ComprasMensuales=si'; // Ajusta esto en tu data.php
    const dataLabel          = 'Monto Compras';
    const backgroundColors   = ["#ff7676", "#25AECD", "#008080", "#00FFFF", "#3cba9f", "#2E64FE", "#e8c3b9", "#3e95cd", "#808080", "#F38630", "#F7BE81", "#FA5858"];
    const borderColors       = backgroundColors;

    $('#' + canvasId).show();
    $('#' + messageContainerId).hide().html('');

    const monthLabels = ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"];

    $.post("data.php?" + dataParam, function (data) {
        if (window.myBarChartComprasMensualesInstance instanceof Chart) {
            window.myBarChartComprasMensualesInstance.destroy();
            window.myBarChartComprasMensualesInstance = null;
        }

        const isDataEffectivelyEmpty = !data || data.length === 0 || (Array.isArray(data) && data.every(val => parseFloat(val) === 0));

        if (isDataEffectivelyEmpty) {
            console.warn(`No hay datos o todos los datos son cero para ${chartTitle}. Mostrando mensaje.`);
            $('#' + canvasId).hide();
            $('#' + messageContainerId).html(`<br><p class="alert alert-info text-center">NO HAY DATOS DE COMPRAS PARA MOSTRAR.</p>`).show();
            return;
        }

        let chartDataValues = data.map(value => parseFloat(value) || 0);
        if (chartDataValues.length !== 12) {
            let tempArray = new Array(12).fill(0);
            for(let i = 0; i < Math.min(chartDataValues.length, 12); i++) { tempArray[i] = chartDataValues[i]; }
            chartDataValues = tempArray;
        }

        var chartdata = { labels: monthLabels, datasets: [{ label: dataLabel, backgroundColor: backgroundColors, borderColor: borderColors, borderWidth: 1, data: chartDataValues }] };
        var graphTarget = $('#' + canvasId);
        // Opciones de Chart.js (sin cambios, ya que manejan valores cero bien)
        var options = {
            responsive: true, maintainAspectRatio: false, animation: { duration: 1000 },
            plugins: {
                title: { display: true, text: 'Suma de Compras Mensuales', font: { size: 18 } },
                legend: { display: false },
                tooltip: {
                    mode: 'index', intersect: false,
                    callbacks: {
                        label: function(tooltipItem, data) {
                            var label = tooltipItem.dataset.label || '';
                            if (label) { label += ': '; }
                            return label + new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(tooltipItem.raw);
                        }
                    },
                    backgroundColor: 'rgba(0,0,0,0.8)', titleFontColor: '#fff', bodyFontColor: '#fff'
                }
            },
            scales: {
                x: { display: true, title: { display: true, text: 'Mes del Year' }, grid: { display: false } },
                y: {
                    display: true, title: { display: true, text: 'Monto de Compra' },
                    ticks: {
                        beginAtZero: true,
                        callback: function(value, index, values) {
                            return new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(value);
                        }
                    }
                }
            }
        };
        
        window.myBarChartComprasMensualesInstance = new Chart(graphTarget, { type: 'bar', data: chartdata, options: options });
    }).fail(function(jqXHR, textStatus, errorThrown) {
        console.error(`Error al cargar los datos para ${chartTitle}:`, textStatus, errorThrown);
        if (window.myBarChartComprasMensualesInstance instanceof Chart) {
            window.myBarChartComprasMensualesInstance.destroy();
            window.myBarChartComprasMensualesInstance = null;
        }
        $('#' + canvasId).hide();
        $('#' + messageContainerId).html(`<p class="text-danger text-center">Error al cargar la grafica de ${dataLabel}. Intntelo de nuevo ms tarde.</p>`).show();
    });
}
/*############ GRAFICO DE COMPRAS POR MESES #############*/

/*############ GRAFICO DE COTIZACIONES POR MESES #############*/
function showGraphBarCotizacionesMensuales() {
    const canvasId           = 'bar-chart-cotizaciones'; // El ID del canvas que usas en HTML
    const messageContainerId = 'no-data-message-cotizaciones';
    const chartTitle         = 'Suma de Cotizaciones Mensuales';
    const dataParam          = 'CotizacionesMensuales=si'; // Ajusta esto en tu data.php
    const dataLabel          = 'Monto Cotizaciones';
    const backgroundColors   = ["#CACFD8", "#F2D6C4", "#7B82EC", "#ff7676", "#987DDB", "#E8AC9E", "#7DA5EA","#8EE1BC","#D3E37D","#E399DA","#F7BE81","#FA5858"];
    const borderColors       = backgroundColors;

    $('#' + canvasId).show();
    $('#' + messageContainerId).hide().html('');

    const monthLabels = ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"];

    $.post("data.php?" + dataParam, function (data) {
        if (window.myBarChartCotizacionesMensualesInstance instanceof Chart) {
            window.myBarChartCotizacionesMensualesInstance.destroy();
            window.myBarChartCotizacionesMensualesInstance = null;
        }

        const isDataEffectivelyEmpty = !data || data.length === 0 || (Array.isArray(data) && data.every(val => parseFloat(val) === 0));

        if (isDataEffectivelyEmpty) {
            console.warn(`No hay datos o todos los datos son cero para ${chartTitle}. Mostrando mensaje.`);
            $('#' + canvasId).hide();
            $('#' + messageContainerId).html(`<br><p class="alert alert-info text-center">NO HAY DATOS DE COTIZACIONES PARA MOSTRAR</p>`).show();
            return;
        }

        let chartDataValues = data.map(value => parseFloat(value) || 0);
        if (chartDataValues.length !== 12) {
            let tempArray = new Array(12).fill(0);
            for(let i = 0; i < Math.min(chartDataValues.length, 12); i++) { tempArray[i] = chartDataValues[i]; }
            chartDataValues = tempArray;
        }

        var chartdata = { labels: monthLabels, datasets: [{ label: dataLabel, backgroundColor: backgroundColors, borderColor: borderColors, borderWidth: 1, data: chartDataValues }] };
        var graphTarget = $('#' + canvasId);
        // Opciones de Chart.js (sin cambios, ya que manejan valores cero bien)
        var options = {
            responsive: true, maintainAspectRatio: false, animation: { duration: 1000 },
            plugins: {
                title: { display: true, text: 'Suma de Cotizaciones Mensuales', font: { size: 18 } },
                legend: { display: false },
                tooltip: {
                    mode: 'index', intersect: false,
                    callbacks: {
                        label: function(tooltipItem, data) {
                            var label = tooltipItem.dataset.label || '';
                            if (label) { label += ': '; }
                            return label + new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(tooltipItem.raw);
                        }
                    },
                    backgroundColor: 'rgba(0,0,0,0.8)', titleFontColor: '#fff', bodyFontColor: '#fff'
                }
            },
            scales: {
                x: { display: true, title: { display: true, text: 'Mes del Year' }, grid: { display: false } },
                y: {
                    display: true, title: { display: true, text: 'Monto de Cotizacion' },
                    ticks: {
                        beginAtZero: true,
                        callback: function(value, index, values) {
                            return new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(value);
                        }
                    }
                }
            }
        };
        
        window.myBarChartCotizacionesMensualesInstance = new Chart(graphTarget, { type: 'bar', data: chartdata, options: options });
    }).fail(function(jqXHR, textStatus, errorThrown) {
        console.error(`Error al cargar los datos para ${chartTitle}:`, textStatus, errorThrown);
        if (window.myBarChartCotizacionesMensualesInstance instanceof Chart) {
            window.myBarChartCotizacionesMensualesInstance.destroy();
            window.myBarChartCotizacionesMensualesInstance = null;
        }
        $('#' + canvasId).hide();
        $('#' + messageContainerId).html(`<p class="text-danger text-center">Error al cargar la grafica de ${dataLabel}. Intntelo de nuevo ms tarde.</p>`).show();
    });
}
/*############ GRAFICO DE COTIZACIONES POR MESES #############*/


/*############ GRAFICO DE PREVENTAS POR MESES #############*/
function showGraphBarPreventasMensuales() {
    const canvasId           = 'bar-chart-preventas';
    const messageContainerId = 'no-data-message-preventas';
    const chartTitle         = 'Suma de Preventas Mensuales';
    const dataParam          = 'PreventasMensuales=si';
    const dataLabel          = 'Monto Preventas';
    const backgroundColors   = ["#7DA5EA", "#CACFD8", "#E399DA", "#FA5858", "#E8AC9E", "#F2D6C4", "#8EE1BC", "#2b34c4", "#F7BE81", "#ff7676", "#4e2e75", "#D3E37D"];
    const borderColors       = backgroundColors;

    $('#' + canvasId).show();
    $('#' + messageContainerId).hide().html('');

    const monthLabels = ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"];

    $.post("data.php?" + dataParam, function (data) {
        if (window.myBarChartPreventasMensualesInstance instanceof Chart) {
            window.myBarChartPreventasMensualesInstance.destroy();
            window.myBarChartPreventasMensualesInstance = null;
        }

        const isDataEffectivelyEmpty = !data || data.length === 0 || (Array.isArray(data) && data.every(val => parseFloat(val) === 0));

        if (isDataEffectivelyEmpty) {
            console.warn(`No hay datos o todos los datos son cero para ${chartTitle}. Mostrando mensaje.`);
            $('#' + canvasId).hide();
            $('#' + messageContainerId).html(`<br><p class="alert alert-info text-center">NO HAY DATOS DE PREVENTAS PARA MOSTRAR.</p>`).show();
            return;
        }

        let chartDataValues = data.map(value => parseFloat(value) || 0);
        if (chartDataValues.length !== 12) {
            let tempArray = new Array(12).fill(0);
            for(let i = 0; i < Math.min(chartDataValues.length, 12); i++) { tempArray[i] = chartDataValues[i]; }
            chartDataValues = tempArray;
        }

        var chartdata = { labels: monthLabels, datasets: [{ label: dataLabel, backgroundColor: backgroundColors, borderColor: borderColors, borderWidth: 1, data: chartDataValues }] };
        var graphTarget = $('#' + canvasId);
        // Opciones de Chart.js (sin cambios, ya que manejan valores cero bien)
        var options = {
            responsive: true, maintainAspectRatio: false, animation: { duration: 1000 },
            plugins: {
                title: { display: true, text: 'Suma de Preventas Mensuales', font: { size: 18 } },
                legend: { display: false },
                tooltip: {
                    mode: 'index', intersect: false,
                    callbacks: {
                        label: function(tooltipItem, data) {
                            var label = tooltipItem.dataset.label || '';
                            if (label) { label += ': '; }
                            return label + new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(tooltipItem.raw);
                        }
                    },
                    backgroundColor: 'rgba(0,0,0,0.8)', titleFontColor: '#fff', bodyFontColor: '#fff'
                }
            },
            scales: {
                x: { display: true, title: { display: true, text: 'Mes del Year' }, grid: { display: false } },
                y: {
                    display: true, title: { display: true, text: 'Monto de Preventa' },
                    ticks: {
                        beginAtZero: true,
                        callback: function(value, index, values) {
                            return new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(value);
                        }
                    }
                }
            }
        };
        
        window.myBarChartPreventasMensualesInstance = new Chart(graphTarget, { type: 'bar', data: chartdata, options: options });
    }).fail(function(jqXHR, textStatus, errorThrown) {
        console.error(`Error al cargar los datos para ${chartTitle}:`, textStatus, errorThrown);
        if (window.myBarChartPreventasMensualesInstance instanceof Chart) {
            window.myBarChartPreventasMensualesInstance.destroy();
            window.myBarChartPreventasMensualesInstance = null;
        }
        $('#' + canvasId).hide();
        $('#' + messageContainerId).html(`<p class="text-danger text-center">Error al cargar la grafica de ${dataLabel}. Intntelo de nuevo ms tarde.</p>`).show();
    });
}
/*############ GRAFICO DE PREVENTAS POR MESES #############*/


/*############ GRAFICO DE VENTAS POR MESES #############*/
function showGraphBarVentasMensuales() {
    const canvasId           = 'bar-chart-ventas';
    const messageContainerId = 'no-data-message-ventas';
    const chartTitle         = 'Suma de Ventas Mensuales';
    const dataParam          = 'VentasMensuales=si'; // Asegrate de que tu data.php responda a esto
    const dataLabel          = 'Monto Ventas';
    const backgroundColors   = ["#7DA5EA", "#CACFD8", "#E399DA", "#FA5858", "#E8AC9E", "#F2D6C4", "#8EE1BC", "#2b34c4", "#F7BE81", "#ff7676", "#4e2e75", "#D3E37D"];
    const borderColors       = backgroundColors;

    $('#' + canvasId).show();
    $('#' + messageContainerId).hide().html('');

    const monthLabels = ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"];

    $.post("data.php?" + dataParam, function (data) {
        if (window.myBarChartVentasMensualesInstance instanceof Chart) {
            window.myBarChartVentasMensualesInstance.destroy();
            window.myBarChartVentasMensualesInstance = null;
        }

        const isDataEffectivelyEmpty = !data || data.length === 0 || (Array.isArray(data) && data.every(val => parseFloat(val) === 0));

        if (isDataEffectivelyEmpty) {
            console.warn(`No hay datos o todos los datos son cero para ${chartTitle}. Mostrando mensaje.`);
            $('#' + canvasId).hide();
            $('#' + messageContainerId).html(`<br><p class="alert alert-info text-center">NO HAY DATOS DE VENTAS PARA MOSTRAR.</p>`).show();
            return;
        }

        let chartDataValues = data.map(value => parseFloat(value) || 0);
        if (chartDataValues.length !== 12) {
            let tempArray = new Array(12).fill(0);
            for(let i = 0; i < Math.min(chartDataValues.length, 12); i++) { tempArray[i] = chartDataValues[i]; }
            chartDataValues = tempArray;
        }

        var chartdata = { labels: monthLabels, datasets: [{ label: dataLabel, backgroundColor: backgroundColors, borderColor: borderColors, borderWidth: 1, data: chartDataValues }] };
        var graphTarget = $('#' + canvasId);
        // Opciones de Chart.js (sin cambios, ya que manejan valores cero bien)
        var options = {
            responsive: true, maintainAspectRatio: false, animation: { duration: 1000 },
            plugins: {
                title: { display: true, text: 'Suma de Ventas Mensuales', font: { size: 18 } },
                legend: { display: false },
                tooltip: {
                    mode: 'index', intersect: false,
                    callbacks: {
                        label: function(tooltipItem, data) {
                            var label = tooltipItem.dataset.label || '';
                            if (label) { label += ': '; }
                            return label + new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(tooltipItem.raw);
                        }
                    },
                    backgroundColor: 'rgba(0,0,0,0.8)', titleFontColor: '#fff', bodyFontColor: '#fff'
                }
            },
            scales: {
                x: { display: true, title: { display: true, text: 'Mes del Year' }, grid: { display: false } },
                y: {
                    display: true, title: { display: true, text: 'Monto de Venta' },
                    ticks: {
                        beginAtZero: true,
                        callback: function(value, index, values) {
                            return new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(value);
                        }
                    }
                }
            }
        };
        
        window.myBarChartVentasMensualesInstance = new Chart(graphTarget, { type: 'bar', data: chartdata, options: options });
    }).fail(function(jqXHR, textStatus, errorThrown) {
        console.error(`Error al cargar los datos para ${chartTitle}:`, textStatus, errorThrown);
        if (window.myBarChartVentasMensualesInstance instanceof Chart) {
            window.myBarChartVentasMensualesInstance.destroy();
            window.myBarChartVentasMensualesInstance = null;
        }
        $('#' + canvasId).hide();
        $('#' + messageContainerId).html(`<p class="text-danger text-center">Error al cargar la grafica de ${dataLabel}. Intntelo de nuevo ms tarde.</p>`).show();
    });
}
/*############ GRAFICO DE VENTAS POR MESES #############*/


/*############ GRAFICO DE COMPRAS POR PROVEEDOR #############*/
function showGraphDoughnutComprasxProveedor() {
    const canvasId           = "DoughnutChartCP"; // ID del canvas de este grfico
    const messageContainerId = 'no-data-message-compras-proveedor'; // ID del contenedor de mensaje (asegrate de que exista en tu HTML)
    const chartTitle         = 'Total de Compras por Proveedor'; // Ttulo para este grfico
    const dataParam          = "ComprasxProveedor=si"; // Parmetro GET para data.php

    const graphTarget        = $("#" + canvasId);
    const messageContainer   = $("#" + messageContainerId);

    // Asegurarse de que el canvas est visible y el mensaje oculto/limpio al inicio
    graphTarget.show();
    messageContainer.hide().html('');

    if (graphTarget.length === 0) {
        console.error(`El elemento con id '${canvasId}' no se encontr en el DOM.`);
        return;
    }

    $.post("data.php?" + dataParam,
        function (data) {
            // Destruir cualquier instancia anterior de ESTE grfico especfico
            if (window.myDoughnutChartComprasxProveedorInstance instanceof Chart) {
                window.myDoughnutChartComprasxProveedorInstance.destroy();
                window.myDoughnutChartComprasxProveedorInstance = null;
            }

            // Verificar si los datos estn vacos o si todos los valores son cero
            const isDataEffectivelyEmpty = !data || data.length === 0 || (Array.isArray(data) && data.every(item => parseFloat(item.total) === 0));

            if (isDataEffectivelyEmpty) {
                console.warn(`No hay datos o todos los datos son cero para ${chartTitle}. Mostrando mensaje.`);
                graphTarget.hide(); // Ocultar el canvas si no hay datos
                messageContainer.html(`<br><p class='alert alert-info text-center'>NO HAY DATOS DISPONIBLES PARA EL GRAFICO DE ${chartTitle.toUpperCase()}.</p>`).show();
                return;
            }

            var names = []; // Nombres de proveedores
            var totals = []; // Total de compras
            var backgroundColors = []; // Colores dinmicos

            // Array de colores predefinidos (puedes aadir ms si lo necesitas)
            const predefinedColors = [
                "#F38630", "#ff7676", "#fff933", "#3e95cd", "#90ff33", "#987DDB",
                "#E8AC9E", "#69D2E7", "#f0ad4e", "#2b34c4", "#D3E37D", "#E0E4CC",
                "#25AECD", "#ff7676", "#3e95cd", "#969788", "#F82330", "#D3E37D",
                "#00FFFF", "#90EE90", "#ADD8E6", "#FFD700", "#FFC0CB", "#8A2BE2",
                "#7FFF00", "#D2B48C", "#FF4500", "#BDB76B", "#E8AC9E", "#D3E37D"
            ];
            let colorIndex = 0; // Para rotar a travs de los colores

            for (var i = 0; i < data.length; i++) {
                names.push(data[i].nomproveedor);
                // Asegrate de que 'total' sea un nmero
                totals.push(parseFloat(data[i].total) || 0); // Convertir a nmero y default a 0
                
                // Asignacin dinmica de colores
                backgroundColors.push(predefinedColors[colorIndex % predefinedColors.length]);
                colorIndex++;
            }

            var chartdata = {
                labels: names,
                datasets: [
                    {
                        label: 'Total',
                        data: totals,
                        backgroundColor: backgroundColors,
                        borderColor: 'white', // Borde blanco para separar las secciones
                        borderWidth: 1
                    }
                ]
            };
            
            // Crear el nuevo grfico, asignndolo a su variable global NICA
            window.myDoughnutChartComprasxProveedorInstance = new Chart(graphTarget, {
                type: 'doughnut',
                data: chartdata,
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '60%', // IMPORTANTE! Para que la dona sea visible (60% del centro vaco)
                    plugins: {
                        legend: {
                            position: 'top',
                            labels: {
                                font: { size: 12 }
                            }
                        },
                        title: {
                            display: true,
                            text: chartTitle, // Ttulo dinmico
                            font: { size: 16 }
                        },
                        tooltip: { // Configuracin de tooltip para mostrar valores como moneda
                            callbacks: {
                                label: function(context) {
                                    let label = context.label || '';
                                    if (label) { label += ': '; }
                                    if (context.parsed !== null) {
                                        label += new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(context.parsed);
                                    }
                                    return label;
                                }
                            }
                        }
                    },
                    animation: {
                        animateRotate: true,
                        animateScale: true
                    }
                }
            });
        },
        "json" // Importante! Asegrate de que jQuery espere un JSON como respuesta
    ).fail(function(jqXHR, textStatus, errorThrown) {
        // Manejo de errores de la llamada AJAX
        console.error(`Error en la solicitud AJAX para ${chartTitle}:`, textStatus, errorThrown);
        console.error("Respuesta del servidor:", jqXHR.responseText);
        // Destruir cualquier instancia de ESTE grfico si hay un error AJAX
        if (window.myDoughnutChartComprasxProveedorInstance instanceof Chart) {
            window.myDoughnutChartComprasxProveedorInstance.destroy();
            window.myDoughnutChartComprasxProveedorInstance = null;
        }
        graphTarget.hide(); // Ocultar el canvas
        messageContainer.html(`<p class='alert alert-danger text-center'>Error al cargar EL GRAFICO DE ${chartTitle}. Por favor, intntelo de nuevo.</p>`).show();
    });
}
/*############ GRAFICO DE COMPRAS POR PROVEEDOR #############*/

/*############ GRAFICO DE VENTAS POR VENDEDOR #############*/
function showGraphDoughnutVentasxUsuarios() {
    const canvasId           = 'DoughnutChartVU'; // O el ID que uses en tu HTML
    const messageContainerId = 'no-data-message-ventas-usuarios';
    const chartTitle         = 'Total de Ventas por Usuario';
    const dataParam          = 'VentasxUsuarios=si'; // Parmetro GET para data.php

    const graphTarget        = $("#" + canvasId);
    const messageContainer   = $("#" + messageContainerId);

    // Asegurarse de que el canvas est visible y el mensaje oculto/limpio al inicio
    graphTarget.show();
    messageContainer.hide().html('');

    if (graphTarget.length === 0) {
        console.error(`El elemento con id '${canvasId}' no se encontr en el DOM.`);
        return;
    }

    $.post("data.php?" + dataParam,
        function (data) {
            // Destruir cualquier instancia anterior de ESTE grfico especfico
            if (window.myDoughnutChartVentasxUsuariosInstance  instanceof Chart) {
                window.myDoughnutChartVentasxUsuariosInstance .destroy();
                window.myDoughnutChartVentasxUsuariosInstance  = null;
            }

            // Verificar si los datos estn vacos o si todos los valores son cero
            const isDataEffectivelyEmpty = !data || data.length === 0 || (Array.isArray(data) && data.every(item => parseFloat(item.total) === 0));

            if (isDataEffectivelyEmpty) {
                console.warn(`No hay datos o todos los datos son cero para ${chartTitle}. Mostrando mensaje.`);
                graphTarget.hide(); // Ocultar el canvas si no hay datos
                messageContainer.html(`<br><p class='alert alert-info text-center'>NO HAY DATOS DISPONIBLES PARA EL GRAFICO DE ${chartTitle.toUpperCase()}.</p>`).show();
                return;
            }

            var names = []; // Nombres de proveedores
            var totals = []; // Total de compras
            var backgroundColors = []; // Colores dinmicos

            // Array de colores predefinidos (puedes aadir ms si lo necesitas)
            const predefinedColors = [
                "#ff7676", "#3e95cd", "#3cba9f", "#003399", "#f0ad4e", "#987DDB",
                "#90ff33", "#E8AC9E", "#69D2E7", "#169696", "#987DDB", "#E0E4CC",
                "#25AECD", "#ff7676", "#3e95cd", "#969788", "#F82330", "#D3E37D",
                "#00FFFF", "#90EE90", "#ADD8E6", "#FFD700", "#FFC0CB", "#8A2BE2",
                "#7FFF00", "#D2B48C", "#FF4500", "#BDB76B", "#E8AC9E", "#D3E37D"
            ];
            let colorIndex = 0; // Para rotar a travs de los colores

            for (var i = 0; i < data.length; i++) {
                names.push(data[i].nombres);
                // Asegrate de que 'total' sea un nmero
                totals.push(parseFloat(data[i].total) || 0); // Convertir a nmero y default a 0
                
                // Asignacin dinmica de colores
                backgroundColors.push(predefinedColors[colorIndex % predefinedColors.length]);
                colorIndex++;
            }

            var chartdata = {
                labels: names,
                datasets: [
                    {
                        label: 'Total',
                        data: totals,
                        backgroundColor: backgroundColors,
                        borderColor: 'white', // Borde blanco para separar las secciones
                        borderWidth: 1
                    }
                ]
            };
            
            // Crear el nuevo grfico, asignndolo a su variable global NICA
            window.myDoughnutChartVentasxUsuariosInstance  = new Chart(graphTarget, {
                type: 'doughnut',
                data: chartdata,
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '60%', // IMPORTANTE! Para que la dona sea visible (60% del centro vaco)
                    plugins: {
                        legend: {
                            position: 'top',
                            labels: {
                                font: { size: 12 }
                            }
                        },
                        title: {
                            display: true,
                            text: chartTitle, // Ttulo dinmico
                            font: { size: 16 }
                        },
                        tooltip: { // Configuracin de tooltip para mostrar valores como moneda
                            callbacks: {
                                label: function(context) {
                                    let label = context.label || '';
                                    if (label) { label += ': '; }
                                    if (context.parsed !== null) {
                                        label += new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(context.parsed);
                                    }
                                    return label;
                                }
                            }
                        }
                    },
                    animation: {
                        animateRotate: true,
                        animateScale: true
                    }
                }
            });
        },
        "json" // Importante! Asegrate de que jQuery espere un JSON como respuesta
    ).fail(function(jqXHR, textStatus, errorThrown) {
        // Manejo de errores de la llamada AJAX
        console.error(`Error en la solicitud AJAX para ${chartTitle}:`, textStatus, errorThrown);
        console.error("Respuesta del servidor:", jqXHR.responseText);
        // Destruir cualquier instancia de ESTE grfico si hay un error AJAX
        if (window.myDoughnutChartVentasxUsuariosInstance  instanceof Chart) {
            window.myDoughnutChartVentasxUsuariosInstance .destroy();
            window.myDoughnutChartVentasxUsuariosInstance  = null;
        }
        graphTarget.hide(); // Ocultar el canvas
        messageContainer.html(`<p class='alert alert-danger text-center'>Error al cargar EL GRAFICO DE ${chartTitle}. Por favor, intntelo de nuevo.</p>`).show();
    });
}
/*############ GRAFICO DE VENTAS POR VENDEDOR #############*/

/*############ GRAFICO DE PRODUCTOS MAS VENDIDOS #############*/
function showGraphDoughnutProductosVendidos() {
    const canvasId           = 'DoughnutChartPV'; // O el ID que uses en tu HTML
    const messageContainerId = 'no-data-message-productos-vendidos';
    const chartTitle         = 'Productos Mas Vendidos';
    const dataParam          = 'ProductosVendidos=si'; // Parmetro GET para data.php

    const graphTarget        = $("#" + canvasId);
    const messageContainer   = $("#" + messageContainerId);

    // Asegurarse de que el canvas est visible y el mensaje oculto/limpio al inicio
    graphTarget.show();
    messageContainer.hide().html('');

    if (graphTarget.length === 0) {
        console.error(`El elemento con id '${canvasId}' no se encontr en el DOM.`);
        return;
    }

    $.post("data.php?" + dataParam,
        function (data) {
            // Destruir cualquier instancia anterior de ESTE grfico especfico
            if (window.myDoughnutChartProductosMasVendidosInstance instanceof Chart) {
                window.myDoughnutChartProductosMasVendidosInstance.destroy();
                window.myDoughnutChartProductosMasVendidosInstance = null;
            }

            // Verificar si los datos estn vacos o si todos los valores son cero
            const isDataEffectivelyEmpty = !data || data.length === 0 || (Array.isArray(data) && data.every(item => parseFloat(item.total) === 0));

            if (isDataEffectivelyEmpty) {
                console.warn(`No hay datos o todos los datos son cero para ${chartTitle}. Mostrando mensaje.`);
                graphTarget.hide(); // Ocultar el canvas si no hay datos
                messageContainer.html(`<br><p class='alert alert-info text-center'>NO HAY DATOS DISPONIBLES PARA EL GRAFICO DE ${chartTitle.toUpperCase()}.</p>`).show();
                return;
            }

            var names = []; // Nombres de proveedores
            var totals = []; // Total de compras
            var backgroundColors = []; // Colores dinmicos

            // Array de colores predefinidos (puedes aadir ms si lo necesitas)
            const predefinedColors = [
                "#ff7676", "#3e95cd", "#3cba9f", "#003399", "#f0ad4e", "#987DDB",
                "#90ff33", "#E8AC9E", "#69D2E7", "#169696", "#987DDB", "#E0E4CC",
                "#25AECD", "#ff7676", "#3e95cd", "#969788", "#F82330", "#D3E37D",
                "#00FFFF", "#90EE90", "#ADD8E6", "#FFD700", "#FFC0CB", "#8A2BE2",
                "#7FFF00", "#D2B48C", "#FF4500", "#BDB76B", "#E8AC9E", "#D3E37D"
            ];
            let colorIndex = 0; // Para rotar a travs de los colores

            for (var i = 0; i < data.length; i++) {
                names.push(data[i].producto);
                // Asegrate de que 'total' sea un nmero
                totals.push(parseFloat(data[i].cantidad) || 0); // Convertir a nmero y default a 0
                
                // Asignacin dinmica de colores
                backgroundColors.push(predefinedColors[colorIndex % predefinedColors.length]);
                colorIndex++;
            }

            var chartdata = {
                labels: names,
                datasets: [
                    {
                        label: 'Total',
                        data: totals,
                        backgroundColor: backgroundColors,
                        borderColor: 'white', // Borde blanco para separar las secciones
                        borderWidth: 1
                    }
                ]
            };
            
            // Crear el nuevo grfico, asignndolo a su variable global NICA
            window.myDoughnutChartProductosMasVendidosInstance  = new Chart(graphTarget, {
                type: 'doughnut',
                data: chartdata,
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '60%', // IMPORTANTE! Para que la dona sea visible (60% del centro vaco)
                    plugins: {
                        legend: {
                            position: 'top',
                            labels: {
                                font: { size: 12 }
                            }
                        },
                        title: {
                            display: true,
                            text: chartTitle, // Ttulo dinmico
                            font: { size: 16 }
                        },
                        tooltip: { // Configuracin de tooltip para mostrar valores como moneda
                            callbacks: {
                                label: function(context) {
                                    let label = context.label || '';
                                    if (label) { label += ': '; }
                                    if (context.parsed !== null) {
                                        label += new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(context.parsed);
                                    }
                                    return label;
                                }
                            }
                        }
                    },
                    animation: {
                        animateRotate: true,
                        animateScale: true
                    }
                }
            });
        },
        "json" // Importante! Asegrate de que jQuery espere un JSON como respuesta
    ).fail(function(jqXHR, textStatus, errorThrown) {
        // Manejo de errores de la llamada AJAX
        console.error(`Error en la solicitud AJAX para ${chartTitle}:`, textStatus, errorThrown);
        console.error("Respuesta del servidor:", jqXHR.responseText);
        // Destruir cualquier instancia de ESTE grfico si hay un error AJAX
        if (window.myDoughnutChartProductosMasVendidosInstance  instanceof Chart) {
            window.myDoughnutChartProductosMasVendidosInstance .destroy();
            window.myDoughnutChartProductosMasVendidosInstance  = null;
        }
        graphTarget.hide(); // Ocultar el canvas
        messageContainer.html(`<p class='alert alert-danger text-center'>Error al cargar EL GRAFICO DE ${chartTitle}. Por favor, intntelo de nuevo.</p>`).show();
    });
}
/*############ GRAFICO DE PRODUCTOS MAS VENDIDOS #############*/

/*############ GRAFICO DE VENTAS DIARIAS #############*/
function showGraphLineVentasDiarias() {
    const canvasId           = 'lineChart';
    const messageContainerId = 'no-data-message-ventas-diarias';
    const chartTitle         = 'Ventas Diarias (Contado vs Credito)';
    const dataParam          = 'ProcesosxVentasDiarias=si'; // Parmetro GET para tu data.php
    const dataLabelContado   = 'Contado';
    const dataLabelCredito   = 'Credito';

    const graphTarget = $("#" + canvasId);
    const messageContainer = $("#" + messageContainerId);

    graphTarget.show();
    messageContainer.hide().html('');

    $.post("data.php?" + dataParam, function (data) {
        if (window.myLineChartVentasDiariasInstance instanceof Chart) {
            window.myLineChartVentasDiariasInstance.destroy();
            window.myLineChartVentasDiariasInstance = null;
        }

        // Pre-procesar los datos para la verificacin
        let totalContado = [];
        let totalCredito = [];
        let diasVenta = [];
        
        if (data && data.length > 0) {
            for (let i in data) { // Usamos 'let' para 'i' por buenas prcticas en bucles for...in
                diasVenta.push(data[i].dia_venta);
                totalContado.push(parseFloat(data[i].total_dia) || 0);
                totalCredito.push(parseFloat(data[i].total_dia2) || 0);
            }
        }

        const isDataEffectivelyEmpty = !data || data.length === 0 || 
                                     (totalContado.every(val => val === 0) && totalCredito.every(val => val === 0));

        if (isDataEffectivelyEmpty) {
            console.warn(`No se recibieron datos o todos los datos son cero para la grafica de ${chartTitle}. Mostrando mensaje.`);
            graphTarget.hide(); // Oculta el canvas
            messageContainer.html(`<br><p class="alert alert-info text-center">NO HAY DATOS DE VENTAS DIARIAS PARA MOSTRAR.</p>`).show();
            return;
        }

        // Si llegamos aqu, s hay datos significativos, procedemos a dibujar la grafica.
        var chartdata = {
            labels: diasVenta,
            datasets: [
                {
                    label: dataLabelContado,
                    backgroundColor: 'rgba(255, 99, 132, 0.2)',
                    borderColor: 'rgba(255, 99, 132, 1)',
                    pointBackgroundColor: 'rgba(255, 99, 132, 1)',
                    pointBorderColor: '#fff',
                    pointHoverBackgroundColor: 'rgba(255, 99, 132, 0.8)',
                    pointHoverBorderColor: 'rgba(255, 99, 132, 1)',
                    fill: false,
                    lineTension: 0.3,
                    data: totalContado
                },
                {
                    label: dataLabelCredito,
                    backgroundColor: 'rgba(54, 162, 235, 0.2)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    pointBackgroundColor: 'rgba(54, 162, 235, 1)',
                    pointBorderColor: '#fff',
                    pointHoverBackgroundColor: 'rgba(54, 162, 235, 0.8)',
                    pointHoverBorderColor: 'rgba(54, 162, 235, 1)',
                    fill: false,
                    lineTension: 0.3,
                    data: totalCredito
                }
            ]
        };

        // Opciones de Configuracin de Chart.js (sin cambios, ya estn bien)
        var options = {
            responsive: true,
            maintainAspectRatio: false,
            animation: { duration: 1000 },
            plugins: {
                title: { display: true, text: chartTitle, font: { size: 18 } },
                legend: { display: true, position: 'bottom', labels: { font: { size: 12 } } },
                tooltip: {
                    mode: 'index', intersect: false,
                    callbacks: {
                        label: function(tooltipItem, data) {
                            var label = data.datasets[tooltipItem.datasetIndex].label || '';
                            if (label) { label += ': '; }
                            label += new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(tooltipItem.yLabel);
                            return label;
                        }
                    },
                    backgroundColor: 'rgba(0,0,0,0.8)', titleFontColor: '#fff', bodyFontColor: '#fff'
                }
            },
            hover: { mode: 'nearest', intersect: true },
            scales: {
                x: { display: true, title: { display: true, text: 'Dia de Venta' }, grid: { display: false } },
                y: {
                    display: true, title: { display: true, text: 'Monto de Venta' },
                    ticks: {
                        beginAtZero: true,
                        callback: function(value, index, values) {
                            return new Intl.NumberFormat('es-CL', { style: 'currency', currency: 'CLP' }).format(value);
                        }
                    }
                }
            }
        };

        // Almacenar la instancia del grfico en su variable global NICA
        window.myLineChartVentasDiariasInstance = new Chart(graphTarget, {
            type: 'line',
            data: chartdata,
            options: options
        });

    }).fail(function(jqXHR, textStatus, errorThrown) {
        // Manejo de errores de la llamada AJAX
        console.error(`Error al cargar los datos de ${chartTitle}:`, textStatus, errorThrown);
        // Destruir cualquier instancia de ESTE grfico si hay un error AJAX
        if (window.myLineChartVentasDiariasInstance instanceof Chart) {
            window.myLineChartVentasDiariasInstance.destroy();
            window.myLineChartVentasDiariasInstance = null;
        }
        graphTarget.hide(); // Oculta el canvas
        messageContainer.html(`<p class="text-danger text-center">Error al cargar la grafica de ${chartTitle}. Intntelo de nuevo ms tarde.</p>`).show();
    });
}
/*############ GRAFICO DE VENTAS DIARIAS #############*/